// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2019-2022  Realtek Corporation
 */

#include "rtw8852c_rfk_table.h"

static const struct rtw89_reg5_def rtw8852c_dack_reload_defs[] = {
	RTW89_DECL_RFK_WM(0xc004, BIT(17), 0x1),
	RTW89_DECL_RFK_WM(0xc024, BIT(17), 0x1),
	RTW89_DECL_RFK_WM(0xc104, BIT(17), 0x1),
	RTW89_DECL_RFK_WM(0xc124, BIT(17), 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dack_reload_defs);

static const struct rtw89_reg5_def rtw8852c_dack_reset_defs_a[] = {
	RTW89_DECL_RFK_WM(0xc000, BIT(17), 0x0),
	RTW89_DECL_RFK_WM(0xc000, BIT(17), 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dack_reset_defs_a);

static const struct rtw89_reg5_def rtw8852c_dack_reset_defs_b[] = {
	RTW89_DECL_RFK_WM(0xc100, BIT(17), 0x0),
	RTW89_DECL_RFK_WM(0xc100, BIT(17), 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dack_reset_defs_b);

static const struct rtw89_reg5_def rtw8852c_dack_defs_s0[] = {
	RTW89_DECL_RFK_WM(0x12b8, BIT(30), 0x1),
	RTW89_DECL_RFK_WM(0x030c, BIT(28), 0x1),
	RTW89_DECL_RFK_WM(0x032c, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0xc004, 0xfff00000, 0x30),
	RTW89_DECL_RFK_WM(0xc024, 0xfff00000, 0x30),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dack_defs_s0);

static const struct rtw89_reg5_def rtw8852c_dack_defs_s1[] = {
	RTW89_DECL_RFK_WM(0x32b8, BIT(30), 0x1),
	RTW89_DECL_RFK_WM(0x030c, BIT(28), 0x1),
	RTW89_DECL_RFK_WM(0x032c, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0xc104, 0xfff00000, 0x30),
	RTW89_DECL_RFK_WM(0xc124, 0xfff00000, 0x30),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dack_defs_s1);

static const struct rtw89_reg5_def rtw8852c_drck_defs[] = {
	RTW89_DECL_RFK_WM(0xc0c4, BIT(6), 0x0),
	RTW89_DECL_RFK_WM(0xc094, BIT(9), 0x1),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0xc094, BIT(9), 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_drck_defs);

static const struct rtw89_reg5_def rtw8852c_iqk_rxk_cfg_defs[] = {
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x0f),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x03),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x0001),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x0041),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_iqk_rxk_cfg_defs);

static const struct rtw89_reg5_def rtw8852c_iqk_afebb_restore_defs_a[] = {
	RTW89_DECL_RFK_WM(0x12b8, 0x40000000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x00010000, 0x1),
	RTW89_DECL_RFK_WM(0x20fc, 0x00100000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x01000000, 0x1),
	RTW89_DECL_RFK_WM(0x20fc, 0x10000000, 0x0),
	RTW89_DECL_RFK_WM(0x5670, MASKDWORD, 0x00000000),
	RTW89_DECL_RFK_WM(0x12a0, 0x000ff000, 0x00),
	RTW89_DECL_RFK_WM(0x20fc, 0x00010000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x01000000, 0x0),
	RTW89_DECL_RFK_WRF(RF_PATH_A, 0x10005, 0x00001, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_iqk_afebb_restore_defs_a);

static const struct rtw89_reg5_def rtw8852c_iqk_afebb_restore_defs_b[] = {
	RTW89_DECL_RFK_WM(0x32b8, 0x40000000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x00020000, 0x1),
	RTW89_DECL_RFK_WM(0x20fc, 0x00200000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x02000000, 0x1),
	RTW89_DECL_RFK_WM(0x20fc, 0x20000000, 0x0),
	RTW89_DECL_RFK_WM(0x7670, MASKDWORD, 0x00000000),
	RTW89_DECL_RFK_WM(0x32a0, 0x000ff000, 0x00),
	RTW89_DECL_RFK_WM(0x20fc, 0x00020000, 0x0),
	RTW89_DECL_RFK_WM(0x20fc, 0x02000000, 0x0),
	RTW89_DECL_RFK_WRF(RF_PATH_B, 0x10005, 0x00001, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_iqk_afebb_restore_defs_b);

static const struct rtw89_reg5_def rtw8852c_read_rxsram_pre_defs[] = {
	RTW89_DECL_RFK_WM(0x80e8, BIT(7), 0x1),
	RTW89_DECL_RFK_WM(0x8074, BIT(31), 0x1),
	RTW89_DECL_RFK_WM(0x80d4, MASKDWORD, 0x00020000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_read_rxsram_pre_defs);

static const struct rtw89_reg5_def rtw8852c_read_rxsram_post_defs[] = {
	RTW89_DECL_RFK_WM(0x80e8, BIT(7), 0x0),
	RTW89_DECL_RFK_WM(0x8074, BIT(31), 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_read_rxsram_post_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_mdpd_order0_defs[] = {
	RTW89_DECL_RFK_WM(0x80a0, BIT(1) | BIT(0), 0x0),
	RTW89_DECL_RFK_WM(0x809c, BIT(10) | BIT(9), 0x2),
	RTW89_DECL_RFK_WM(0x80a0, 0x00001F00, 0x4),
	RTW89_DECL_RFK_WM(0x8070, 0x70000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_mdpd_order0_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_mdpd_order1_defs[] = {
	RTW89_DECL_RFK_WM(0x80a0, BIT(1) | BIT(0), 0x1),
	RTW89_DECL_RFK_WM(0x809c, BIT(10) | BIT(9), 0x1),
	RTW89_DECL_RFK_WM(0x80a0, 0x00001F00, 0x0),
	RTW89_DECL_RFK_WM(0x8070, 0x70000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_mdpd_order1_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_mdpd_order2_defs[] = {
	RTW89_DECL_RFK_WM(0x80a0, BIT(1) | BIT(0), 0x2),
	RTW89_DECL_RFK_WM(0x809c, BIT(10) | BIT(9), 0x0),
	RTW89_DECL_RFK_WM(0x80a0, 0x00001F00, 0x0),
	RTW89_DECL_RFK_WM(0x8070, 0x70000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_mdpd_order2_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_mdpd_order3_defs[] = {
	RTW89_DECL_RFK_WM(0x80a0, BIT(1) | BIT(0), 0x3),
	RTW89_DECL_RFK_WM(0x809c, BIT(10) | BIT(9), 0x3),
	RTW89_DECL_RFK_WM(0x80a0, 0x00001F00, 0x4),
	RTW89_DECL_RFK_WM(0x8070, 0x70000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_mdpd_order3_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_kip_pwr_clk_on_defs[] = {
	RTW89_DECL_RFK_WM(0x8008, MASKDWORD, 0x00000080),
	RTW89_DECL_RFK_WM(0x8088, MASKDWORD, 0x807f030a),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_kip_pwr_clk_on_defs);

static const struct rtw89_reg5_def rtw8852c_dpk_kip_pwr_clk_off_defs[] = {
	RTW89_DECL_RFK_WM(0x8008, MASKDWORD, 0x00000000),
	RTW89_DECL_RFK_WM(0x8088, MASKDWORD, 0x80000000),
	RTW89_DECL_RFK_WM(0x80f4, BIT(18), 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_dpk_kip_pwr_clk_off_defs);

static const struct rtw89_reg5_def rtw8852c_tssi_sys_defs[] = {
	RTW89_DECL_RFK_WM(0x12bc, 0x000ffff0, 0xb5b5),
	RTW89_DECL_RFK_WM(0x32bc, 0x000ffff0, 0xb5b5),
	RTW89_DECL_RFK_WM(0x0300, 0xff000000, 0x16),
	RTW89_DECL_RFK_WM(0x0304, 0x0000ffff, 0x1f19),
	RTW89_DECL_RFK_WM(0x0308, 0xff000000, 0x1c),
	RTW89_DECL_RFK_WM(0x0314, 0xffff0000, 0x2041),
	RTW89_DECL_RFK_WM(0x0318, 0xffffffff, 0x20012041),
	RTW89_DECL_RFK_WM(0x0324, 0xffff0000, 0x2001),
	RTW89_DECL_RFK_WM(0x0020, 0x00006000, 0x3),
	RTW89_DECL_RFK_WM(0x0024, 0x00006000, 0x3),
	RTW89_DECL_RFK_WM(0x0704, 0xffff0000, 0x601e),
	RTW89_DECL_RFK_WM(0x2704, 0xffff0000, 0x601e),
	RTW89_DECL_RFK_WM(0x0700, 0xf0000000, 0x4),
	RTW89_DECL_RFK_WM(0x2700, 0xf0000000, 0x4),
	RTW89_DECL_RFK_WM(0x0650, 0x3c000000, 0x0),
	RTW89_DECL_RFK_WM(0x2650, 0x3c000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_sys_defs);

static const struct rtw89_reg5_def rtw8852c_tssi_sys_defs_2g_a[] = {
	RTW89_DECL_RFK_WM(0x120c, 0x000000ff, 0x33),
	RTW89_DECL_RFK_WM(0x12c0, 0x0ff00000, 0x33),
	RTW89_DECL_RFK_WM(0x58f8, 0x40000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_sys_defs_2g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_sys_defs_2g_b[] = {
	RTW89_DECL_RFK_WM(0x320c, 0x000000ff, 0x33),
	RTW89_DECL_RFK_WM(0x32c0, 0x0ff00000, 0x33),
	RTW89_DECL_RFK_WM(0x78f8, 0x40000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_sys_defs_2g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_sys_defs_5g_a[] = {
	RTW89_DECL_RFK_WM(0x120c, 0x000000ff, 0x44),
	RTW89_DECL_RFK_WM(0x12c0, 0x0ff00000, 0x44),
	RTW89_DECL_RFK_WM(0x58f8, 0x40000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_sys_defs_5g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_sys_defs_5g_b[] = {
	RTW89_DECL_RFK_WM(0x320c, 0x000000ff, 0x44),
	RTW89_DECL_RFK_WM(0x32c0, 0x0ff00000, 0x44),
	RTW89_DECL_RFK_WM(0x78f8, 0x40000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_sys_defs_5g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_txpwr_ctrl_bb_defs_a[] = {
	RTW89_DECL_RFK_WM(0x566c, 0x00001000, 0x0),
	RTW89_DECL_RFK_WM(0x5800, 0xffffffff, 0x003f807f),
	RTW89_DECL_RFK_WM(0x580c, 0x0000007f, 0x40),
	RTW89_DECL_RFK_WM(0x580c, 0x0fffff00, 0x00040),
	RTW89_DECL_RFK_WM(0x5810, 0xffffffff, 0x59010000),
	RTW89_DECL_RFK_WM(0x5814, 0x01ffffff, 0x026d000),
	RTW89_DECL_RFK_WM(0x5814, 0xf8000000, 0x00),
	RTW89_DECL_RFK_WM(0x5818, 0xffffffff, 0x002c1800),
	RTW89_DECL_RFK_WM(0x581c, 0x3fffffff, 0x3dc80280),
	RTW89_DECL_RFK_WM(0x5820, 0xffffffff, 0x00000080),
	RTW89_DECL_RFK_WM(0x58e8, 0x0000003f, 0x03),
	RTW89_DECL_RFK_WM(0x580c, 0x10000000, 0x1),
	RTW89_DECL_RFK_WM(0x580c, 0x40000000, 0x1),
	RTW89_DECL_RFK_WM(0x5834, 0x3fffffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5838, 0x7fffffff, 0x0000121),
	RTW89_DECL_RFK_WM(0x5854, 0x3fffffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5858, 0x7fffffff, 0x0000121),
	RTW89_DECL_RFK_WM(0x5860, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5864, 0x07ffffff, 0x00801ff),
	RTW89_DECL_RFK_WM(0x5898, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x589c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x000000ff, 0x16),
	RTW89_DECL_RFK_WM(0x58b4, 0x7fffffff, 0x0a002000),
	RTW89_DECL_RFK_WM(0x58b8, 0x7fffffff, 0x00007628),
	RTW89_DECL_RFK_WM(0x58bc, 0x07ffffff, 0x7a7807f),
	RTW89_DECL_RFK_WM(0x58c0, 0xfffe0000, 0x003f),
	RTW89_DECL_RFK_WM(0x58c4, 0xffffffff, 0x0003ffff),
	RTW89_DECL_RFK_WM(0x58c8, 0x00ffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x58c8, 0xf0000000, 0x0),
	RTW89_DECL_RFK_WM(0x58cc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58d0, 0x07ffffff, 0x2008101),
	RTW89_DECL_RFK_WM(0x58d4, 0x000000ff, 0x00),
	RTW89_DECL_RFK_WM(0x58d4, 0x0003fe00, 0x0ff),
	RTW89_DECL_RFK_WM(0x58d4, 0x07fc0000, 0x100),
	RTW89_DECL_RFK_WM(0x58d8, 0xffffffff, 0x8008016c),
	RTW89_DECL_RFK_WM(0x58dc, 0x0001ffff, 0x0807f),
	RTW89_DECL_RFK_WM(0x58dc, 0xfff00000, 0x800),
	RTW89_DECL_RFK_WM(0x58f0, 0x0003ffff, 0x001ff),
	RTW89_DECL_RFK_WM(0x58f4, 0x000fffff, 0x000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000fffff, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txpwr_ctrl_bb_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_txpwr_ctrl_bb_defs_b[] = {
	RTW89_DECL_RFK_WM(0x566c, 0x00001000, 0x0),
	RTW89_DECL_RFK_WM(0x7800, 0xffffffff, 0x003f807f),
	RTW89_DECL_RFK_WM(0x780c, 0x0000007f, 0x40),
	RTW89_DECL_RFK_WM(0x780c, 0x0fffff00, 0x00040),
	RTW89_DECL_RFK_WM(0x7810, 0xffffffff, 0x59010000),
	RTW89_DECL_RFK_WM(0x7814, 0x01ffffff, 0x026d000),
	RTW89_DECL_RFK_WM(0x7814, 0xf8000000, 0x00),
	RTW89_DECL_RFK_WM(0x7818, 0xffffffff, 0x002c1800),
	RTW89_DECL_RFK_WM(0x781c, 0x3fffffff, 0x3dc80280),
	RTW89_DECL_RFK_WM(0x7820, 0xffffffff, 0x00000080),
	RTW89_DECL_RFK_WM(0x78e8, 0x0000003f, 0x03),
	RTW89_DECL_RFK_WM(0x780c, 0x10000000, 0x1),
	RTW89_DECL_RFK_WM(0x780c, 0x40000000, 0x1),
	RTW89_DECL_RFK_WM(0x7834, 0x3fffffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7838, 0x7fffffff, 0x0000121),
	RTW89_DECL_RFK_WM(0x7854, 0x3fffffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7858, 0x7fffffff, 0x0000121),
	RTW89_DECL_RFK_WM(0x7860, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7864, 0x07ffffff, 0x00801ff),
	RTW89_DECL_RFK_WM(0x7898, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x789c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x000000ff, 0x16),
	RTW89_DECL_RFK_WM(0x78b4, 0x7fffffff, 0x0a002000),
	RTW89_DECL_RFK_WM(0x78b8, 0x7fffffff, 0x00007628),
	RTW89_DECL_RFK_WM(0x78bc, 0x07ffffff, 0x7a7807f),
	RTW89_DECL_RFK_WM(0x78c0, 0xfffe0000, 0x003f),
	RTW89_DECL_RFK_WM(0x78c4, 0xffffffff, 0x0003ffff),
	RTW89_DECL_RFK_WM(0x78c8, 0x00ffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x78c8, 0xf0000000, 0x0),
	RTW89_DECL_RFK_WM(0x78cc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78d0, 0x07ffffff, 0x2008101),
	RTW89_DECL_RFK_WM(0x78d4, 0x000000ff, 0x00),
	RTW89_DECL_RFK_WM(0x78d4, 0x0003fe00, 0x0ff),
	RTW89_DECL_RFK_WM(0x78d4, 0x07fc0000, 0x100),
	RTW89_DECL_RFK_WM(0x78d8, 0xffffffff, 0x8008016c),
	RTW89_DECL_RFK_WM(0x78dc, 0x0001ffff, 0x0807f),
	RTW89_DECL_RFK_WM(0x78dc, 0xfff00000, 0x800),
	RTW89_DECL_RFK_WM(0x78f0, 0x0003ffff, 0x001ff),
	RTW89_DECL_RFK_WM(0x78f4, 0x000fffff, 0x000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000fffff, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txpwr_ctrl_bb_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_txpwr_ctrl_bb_he_tb_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58a0, 0xffffffff, 0x000000fe),
	RTW89_DECL_RFK_WM(0x58e4, 0x0000007f, 0x1f),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txpwr_ctrl_bb_he_tb_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_txpwr_ctrl_bb_he_tb_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78a0, 0xffffffff, 0x000000fe),
	RTW89_DECL_RFK_WM(0x78e4, 0x0000007f, 0x1f),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txpwr_ctrl_bb_he_tb_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58c4, 0x3ffc0000, 0x0),
	RTW89_DECL_RFK_WM(0x58c8, 0x00000fff, 0x0),
	RTW89_DECL_RFK_WM(0x58c8, 0x00fff000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78c4, 0x3ffc0000, 0x0),
	RTW89_DECL_RFK_WM(0x78c8, 0x00000fff, 0x0),
	RTW89_DECL_RFK_WM(0x78c8, 0x00fff000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_2g_a[] = {
	RTW89_DECL_RFK_WM(0x580c, 0x0fff0000, 0x000),
	RTW89_DECL_RFK_WM(0x5814, 0x003ff000, 0x1af),
	RTW89_DECL_RFK_WM(0x5814, 0x18000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_2g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_2g_b[] = {
	RTW89_DECL_RFK_WM(0x780c, 0x0fff0000, 0x000),
	RTW89_DECL_RFK_WM(0x7814, 0x003ff000, 0x1af),
	RTW89_DECL_RFK_WM(0x7814, 0x18000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_2g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_5g_a[] = {
	RTW89_DECL_RFK_WM(0x580c, 0x0fff0000, 0x000),
	RTW89_DECL_RFK_WM(0x5814, 0x00001000, 0x1),
	RTW89_DECL_RFK_WM(0x5814, 0x0003c000, 0xb),
	RTW89_DECL_RFK_WM(0x5814, 0x00002000, 0x1),
	RTW89_DECL_RFK_WM(0x5814, 0x003c0000, 0x6),
	RTW89_DECL_RFK_WM(0x5814, 0x18000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_5g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_dck_defs_5g_b[] = {
	RTW89_DECL_RFK_WM(0x780c, 0x0fff0000, 0x000),
	RTW89_DECL_RFK_WM(0x7814, 0x00001000, 0x1),
	RTW89_DECL_RFK_WM(0x7814, 0x0003c000, 0xb),
	RTW89_DECL_RFK_WM(0x7814, 0x00002000, 0x1),
	RTW89_DECL_RFK_WM(0x7814, 0x003c0000, 0x6),
	RTW89_DECL_RFK_WM(0x7814, 0x18000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_dck_defs_5g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_set_bbgain_split_a[] = {
	RTW89_DECL_RFK_WM(0x5818, 0x08000000, 0x1),
	RTW89_DECL_RFK_WM(0x58d4, 0xf0000000, 0x7),
	RTW89_DECL_RFK_WM(0x58f0, 0x000c0000, 0x1),
	RTW89_DECL_RFK_WM(0x58f0, 0xfff00000, 0x400),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_bbgain_split_a);

static const struct rtw89_reg5_def rtw8852c_tssi_set_bbgain_split_b[] = {
	RTW89_DECL_RFK_WM(0x7818, 0x08000000, 0x1),
	RTW89_DECL_RFK_WM(0x78d4, 0xf0000000, 0x7),
	RTW89_DECL_RFK_WM(0x78f0, 0x000c0000, 0x1),
	RTW89_DECL_RFK_WM(0x78f0, 0xfff00000, 0x400),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_bbgain_split_b);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_cal_org_defs_2g_a[] = {
	RTW89_DECL_RFK_WM(0x5608, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x560c, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x5610, 0x07ffffff, 0x0201020),
	RTW89_DECL_RFK_WM(0x5614, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x5618, 0x07ffffff, 0x0801008),
	RTW89_DECL_RFK_WM(0x561c, 0x000001ff, 0x008),
	RTW89_DECL_RFK_WM(0x561c, 0xffff0000, 0x0808),
	RTW89_DECL_RFK_WM(0x5620, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x5624, 0xffffffff, 0x0808081e),
	RTW89_DECL_RFK_WM(0x5628, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x562c, 0x0000ffff, 0x081d),
	RTW89_DECL_RFK_WM(0x581c, 0x00100000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_cal_org_defs_2g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_cal_org_defs_2g_b[] = {
	RTW89_DECL_RFK_WM(0x7608, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x760c, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x7610, 0x07ffffff, 0x0204020),
	RTW89_DECL_RFK_WM(0x7614, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x7618, 0x07ffffff, 0x0801008),
	RTW89_DECL_RFK_WM(0x761c, 0x000001ff, 0x020),
	RTW89_DECL_RFK_WM(0x761c, 0xffff0000, 0x0808),
	RTW89_DECL_RFK_WM(0x7620, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x7624, 0xffffffff, 0x08081e21),
	RTW89_DECL_RFK_WM(0x7628, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x762c, 0x0000ffff, 0x1d23),
	RTW89_DECL_RFK_WM(0x781c, 0x00100000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_cal_org_defs_2g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_cal_org_defs_5g_a[] = {
	RTW89_DECL_RFK_WM(0x5608, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x560c, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x5610, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x5614, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x5618, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x561c, 0x000001ff, 0x008),
	RTW89_DECL_RFK_WM(0x561c, 0xffff0000, 0x0808),
	RTW89_DECL_RFK_WM(0x5620, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x5624, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x5628, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x562c, 0x0000ffff, 0x0808),
	RTW89_DECL_RFK_WM(0x581c, 0x00100000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_cal_org_defs_5g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_cal_org_defs_5g_b[] = {
	RTW89_DECL_RFK_WM(0x7608, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x760c, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x7610, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x7614, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x7618, 0x07ffffff, 0x0201008),
	RTW89_DECL_RFK_WM(0x761c, 0x000001ff, 0x008),
	RTW89_DECL_RFK_WM(0x761c, 0xffff0000, 0x0808),
	RTW89_DECL_RFK_WM(0x7620, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x7624, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x7628, 0xffffffff, 0x08080808),
	RTW89_DECL_RFK_WM(0x762c, 0x0000ffff, 0x0808),
	RTW89_DECL_RFK_WM(0x781c, 0x00100000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_cal_org_defs_5g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_2g_a[] = {
	RTW89_DECL_RFK_WM(0x5604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x5600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x5604, 0x003fffff, 0x2d2721),
	RTW89_DECL_RFK_WM(0x5630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5634, 0x000ffc00, 0x3b8),
	RTW89_DECL_RFK_WM(0x5634, 0x3ff00000, 0x3d2),
	RTW89_DECL_RFK_WM(0x5638, 0x000003ff, 0x042),
	RTW89_DECL_RFK_WM(0x5638, 0x000ffc00, 0x06b),
	RTW89_DECL_RFK_WM(0x563c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5640, 0x000ffc00, 0x3bc),
	RTW89_DECL_RFK_WM(0x5640, 0x3ff00000, 0x3d6),
	RTW89_DECL_RFK_WM(0x5644, 0x000003ff, 0x03e),
	RTW89_DECL_RFK_WM(0x5644, 0x000ffc00, 0x06b),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_2g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_2g_b[] = {
	RTW89_DECL_RFK_WM(0x7604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x7600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x7604, 0x003fffff, 0x2d2721),
	RTW89_DECL_RFK_WM(0x7630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7634, 0x000ffc00, 0x3c0),
	RTW89_DECL_RFK_WM(0x7634, 0x3ff00000, 0x3da),
	RTW89_DECL_RFK_WM(0x7638, 0x000003ff, 0x002),
	RTW89_DECL_RFK_WM(0x7638, 0x000ffc00, 0x071),
	RTW89_DECL_RFK_WM(0x763c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7640, 0x000ffc00, 0x3c8),
	RTW89_DECL_RFK_WM(0x7640, 0x3ff00000, 0x3e2),
	RTW89_DECL_RFK_WM(0x7644, 0x000003ff, 0x00c),
	RTW89_DECL_RFK_WM(0x7644, 0x000ffc00, 0x071),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_2g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_5g_a[] = {
	RTW89_DECL_RFK_WM(0x5604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x5600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x5604, 0x003fffff, 0x312600),
	RTW89_DECL_RFK_WM(0x5630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5634, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x5634, 0x3ff00000, 0x3e9),
	RTW89_DECL_RFK_WM(0x5638, 0x000003ff, 0x039),
	RTW89_DECL_RFK_WM(0x5638, 0x000ffc00, 0x07d),
	RTW89_DECL_RFK_WM(0x563c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5640, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x5640, 0x3ff00000, 0x000),
	RTW89_DECL_RFK_WM(0x5644, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5644, 0x000ffc00, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_5g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_5g_b[] = {
	RTW89_DECL_RFK_WM(0x7604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x7600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x7604, 0x003fffff, 0x312600),
	RTW89_DECL_RFK_WM(0x7630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7634, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x7634, 0x3ff00000, 0x3e9),
	RTW89_DECL_RFK_WM(0x7638, 0x000003ff, 0x039),
	RTW89_DECL_RFK_WM(0x7638, 0x000ffc00, 0x07d),
	RTW89_DECL_RFK_WM(0x763c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7640, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x7640, 0x3ff00000, 0x000),
	RTW89_DECL_RFK_WM(0x7644, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7644, 0x000ffc00, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_5g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_6g_a[] = {
	RTW89_DECL_RFK_WM(0x5604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x5600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x5604, 0x003fffff, 0x312600),
	RTW89_DECL_RFK_WM(0x5630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5634, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x5634, 0x3ff00000, 0x3e9),
	RTW89_DECL_RFK_WM(0x5638, 0x000003ff, 0x039),
	RTW89_DECL_RFK_WM(0x5638, 0x000ffc00, 0x080),
	RTW89_DECL_RFK_WM(0x563c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5640, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x5640, 0x3ff00000, 0x000),
	RTW89_DECL_RFK_WM(0x5644, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x5644, 0x000ffc00, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_6g_a);

static const struct rtw89_reg5_def rtw8852c_tssi_set_aligk_default_defs_6g_b[] = {
	RTW89_DECL_RFK_WM(0x7604, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x7600, 0x3fffffff, 0x000000),
	RTW89_DECL_RFK_WM(0x7604, 0x003fffff, 0x312600),
	RTW89_DECL_RFK_WM(0x7630, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7634, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7634, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x7634, 0x3ff00000, 0x3e9),
	RTW89_DECL_RFK_WM(0x7638, 0x000003ff, 0x039),
	RTW89_DECL_RFK_WM(0x7638, 0x000ffc00, 0x080),
	RTW89_DECL_RFK_WM(0x763c, 0x3fffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7640, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7640, 0x000ffc00, 0x000),
	RTW89_DECL_RFK_WM(0x7640, 0x3ff00000, 0x000),
	RTW89_DECL_RFK_WM(0x7644, 0x000003ff, 0x000),
	RTW89_DECL_RFK_WM(0x7644, 0x000ffc00, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_set_aligk_default_defs_6g_b);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x0),
	RTW89_DECL_RFK_WM(0x5814, 0x00000800, 0x1),
	RTW89_DECL_RFK_WM(0x581c, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x58e8, 0x0000003f, 0x0f),
	RTW89_DECL_RFK_WM(0x581c, 0x000003ff, 0x280),
	RTW89_DECL_RFK_WM(0x581c, 0x000ffc00, 0x200),
	RTW89_DECL_RFK_WM(0x58b8, 0x007f0000, 0x00),
	RTW89_DECL_RFK_WM(0x58b8, 0x7f000000, 0x00),
	RTW89_DECL_RFK_WM(0x58b4, 0x7f000000, 0x0a),
	RTW89_DECL_RFK_WM(0x58b8, 0x0000007f, 0x28),
	RTW89_DECL_RFK_WM(0x58b8, 0x00007f00, 0x76),
	RTW89_DECL_RFK_WM(0x5810, 0x20000000, 0x0),
	RTW89_DECL_RFK_WM(0x5814, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x580c, 0x10000000, 0x1),
	RTW89_DECL_RFK_WM(0x580c, 0x40000000, 0x1),
	RTW89_DECL_RFK_WM(0x5834, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x5834, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5838, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5838, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x5854, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x5854, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5858, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5858, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x5824, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x5824, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5828, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5828, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x582c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x582c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5830, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5830, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x583c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x583c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5840, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5840, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x5844, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x5844, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5848, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5848, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x584c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x584c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5850, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5850, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x585c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x585c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x5860, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x5860, 0x003ff000, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_slope_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x0),
	RTW89_DECL_RFK_WM(0x7814, 0x00000800, 0x1),
	RTW89_DECL_RFK_WM(0x781c, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x78e8, 0x0000003f, 0x0f),
	RTW89_DECL_RFK_WM(0x781c, 0x000003ff, 0x280),
	RTW89_DECL_RFK_WM(0x781c, 0x000ffc00, 0x200),
	RTW89_DECL_RFK_WM(0x78b8, 0x007f0000, 0x00),
	RTW89_DECL_RFK_WM(0x78b8, 0x7f000000, 0x00),
	RTW89_DECL_RFK_WM(0x78b4, 0x7f000000, 0x0a),
	RTW89_DECL_RFK_WM(0x78b8, 0x0000007f, 0x28),
	RTW89_DECL_RFK_WM(0x78b8, 0x00007f00, 0x76),
	RTW89_DECL_RFK_WM(0x7810, 0x20000000, 0x0),
	RTW89_DECL_RFK_WM(0x7814, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x780c, 0x10000000, 0x1),
	RTW89_DECL_RFK_WM(0x780c, 0x40000000, 0x1),
	RTW89_DECL_RFK_WM(0x7834, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x7834, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7838, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7838, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x7854, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x7854, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7858, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7858, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x7824, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x7824, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7828, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7828, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x782c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x782c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7830, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7830, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x783c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x783c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7840, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7840, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x7844, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x7844, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7848, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7848, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x784c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x784c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7850, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7850, 0x003ff000, 0x000),
	RTW89_DECL_RFK_WM(0x785c, 0x0003ffff, 0x115f2),
	RTW89_DECL_RFK_WM(0x785c, 0x3ffc0000, 0x000),
	RTW89_DECL_RFK_WM(0x7860, 0x00000fff, 0x121),
	RTW89_DECL_RFK_WM(0x7860, 0x003ff000, 0x000),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_slope_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_run_slope_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_run_slope_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_run_slope_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_run_slope_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_track_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x0),
	RTW89_DECL_RFK_WM(0x5814, 0x00000800, 0x0),
	RTW89_DECL_RFK_WM(0x581c, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x5864, 0x000003ff, 0x1ff),
	RTW89_DECL_RFK_WM(0x5864, 0x000ffc00, 0x200),
	RTW89_DECL_RFK_WM(0x5820, 0x00000fff, 0x080),
	RTW89_DECL_RFK_WM(0x5814, 0x01000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_track_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_track_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x0),
	RTW89_DECL_RFK_WM(0x7814, 0x00000800, 0x0),
	RTW89_DECL_RFK_WM(0x781c, 0x20000000, 0x1),
	RTW89_DECL_RFK_WM(0x7864, 0x000003ff, 0x1ff),
	RTW89_DECL_RFK_WM(0x7864, 0x000ffc00, 0x200),
	RTW89_DECL_RFK_WM(0x7820, 0x00000fff, 0x080),
	RTW89_DECL_RFK_WM(0x7814, 0x01000000, 0x0),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_track_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_txagc_ofst_mv_avg_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58e4, 0x00003800, 0x1),
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x0),
	RTW89_DECL_RFK_WM(0x58e4, 0x00008000, 0x1),
	RTW89_DECL_RFK_WM(0x58e4, 0x000f0000, 0x0),
	RTW89_DECL_RFK_WM(0x58e8, 0x0000003f, 0x03),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txagc_ofst_mv_avg_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_txagc_ofst_mv_avg_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78e4, 0x00003800, 0x1),
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x0),
	RTW89_DECL_RFK_WM(0x78e4, 0x00008000, 0x1),
	RTW89_DECL_RFK_WM(0x78e4, 0x000f0000, 0x0),
	RTW89_DECL_RFK_WM(0x78e8, 0x0000003f, 0x03),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_txagc_ofst_mv_avg_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_enable_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x0),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x1),
	RTW89_DECL_RFK_WRF(0x0, 0x10055, 0x00080, 0x1),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_enable_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_enable_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x0),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x1),
	RTW89_DECL_RFK_WRF(0x1, 0x10055, 0x00080, 0x1),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x1),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_enable_defs_b);

static const struct rtw89_reg5_def rtw8852c_tssi_disable_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_disable_defs_a);

static const struct rtw89_reg5_def rtw8852c_tssi_disable_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852c_tssi_disable_defs_b);
