/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2014-2021 Intel Corporation
 */

#ifndef _ABI_GUC_ERRORS_ABI_H
#define _ABI_GUC_ERRORS_ABI_H

enum intel_guc_response_status {
	INTEL_GUC_RESPONSE_STATUS_SUCCESS = 0x0,
	INTEL_GUC_RESPONSE_STATUS_GENERIC_FAIL = 0xF000,
};

enum intel_guc_load_status {
	INTEL_GUC_LOAD_STATUS_DEFAULT                          = 0x00,
	INTEL_GUC_LOAD_STATUS_START                            = 0x01,
	INTEL_GUC_LOAD_STATUS_ERROR_DEVID_BUILD_MISMATCH       = 0x02,
	INTEL_GUC_LOAD_STATUS_GUC_PREPROD_BUILD_MISMATCH       = 0x03,
	INTEL_GUC_LOAD_STATUS_ERROR_DEVID_INVALID_GUCTYPE      = 0x04,
	INTEL_GUC_LOAD_STATUS_GDT_DONE                         = 0x10,
	INTEL_GUC_LOAD_STATUS_IDT_DONE                         = 0x20,
	INTEL_GUC_LOAD_STATUS_LAPIC_DONE                       = 0x30,
	INTEL_GUC_LOAD_STATUS_GUCINT_DONE                      = 0x40,
	INTEL_GUC_LOAD_STATUS_DPC_READY                        = 0x50,
	INTEL_GUC_LOAD_STATUS_DPC_ERROR                        = 0x60,
	INTEL_GUC_LOAD_STATUS_EXCEPTION                        = 0x70,
	INTEL_GUC_LOAD_STATUS_INIT_DATA_INVALID                = 0x71,
	INTEL_GUC_LOAD_STATUS_PXP_TEARDOWN_CTRL_ENABLED        = 0x72,
	INTEL_GUC_LOAD_STATUS_INVALID_INIT_DATA_RANGE_START,
	INTEL_GUC_LOAD_STATUS_MPU_DATA_INVALID                 = 0x73,
	INTEL_GUC_LOAD_STATUS_INIT_MMIO_SAVE_RESTORE_INVALID   = 0x74,
	INTEL_GUC_LOAD_STATUS_INVALID_INIT_DATA_RANGE_END,

	INTEL_GUC_LOAD_STATUS_READY                            = 0xF0,
};

#endif /* _ABI_GUC_ERRORS_ABI_H */
