/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * exynos-nocp.h - Exynos NoC (Network on Chip) Probe header file
 *
 * Copyright (c) 2016 Samsung Electronics Co., Ltd.
 * Author : Chanwoo Choi <cw00.choi@samsung.com>
 */

#ifndef __EXYNOS_NOCP_H__
#define __EXYNOS_NOCP_H__

enum nocp_reg {
	NOCP_ID_REVISION_ID		= 0x04,
	NOCP_MAIN_CTL			= 0x08,
	NOCP_CFG_CTL			= 0x0C,

	NOCP_STAT_PERIOD		= 0x24,
	NOCP_STAT_GO			= 0x28,
	NOCP_STAT_ALARM_MIN		= 0x2C,
	NOCP_STAT_ALARM_MAX		= 0x30,
	NOCP_STAT_ALARM_STATUS		= 0x34,
	NOCP_STAT_ALARM_CLR		= 0x38,

	NOCP_COUNTERS_0_SRC		= 0x138,
	NOCP_COUNTERS_0_ALARM_MODE	= 0x13C,
	NOCP_COUNTERS_0_VAL		= 0x140,

	NOCP_COUNTERS_1_SRC		= 0x14C,
	NOCP_COUNTERS_1_ALARM_MODE	= 0x150,
	NOCP_COUNTERS_1_VAL		= 0x154,

	NOCP_COUNTERS_2_SRC		= 0x160,
	NOCP_COUNTERS_2_ALARM_MODE	= 0x164,
	NOCP_COUNTERS_2_VAL		= 0x168,

	NOCP_COUNTERS_3_SRC		= 0x174,
	NOCP_COUNTERS_3_ALARM_MODE	= 0x178,
	NOCP_COUNTERS_3_VAL		= 0x17C,
};

/* NOCP_MAIN_CTL register */
#define NOCP_MAIN_CTL_ERREN_MASK		BIT(0)
#define NOCP_MAIN_CTL_TRACEEN_MASK		BIT(1)
#define NOCP_MAIN_CTL_PAYLOADEN_MASK		BIT(2)
#define NOCP_MAIN_CTL_STATEN_MASK		BIT(3)
#define NOCP_MAIN_CTL_ALARMEN_MASK		BIT(4)
#define NOCP_MAIN_CTL_STATCONDDUMP_MASK	BIT(5)
#define NOCP_MAIN_CTL_INTRUSIVEMODE_MASK	BIT(6)

/* NOCP_CFG_CTL register */
#define NOCP_CFG_CTL_GLOBALEN_MASK		BIT(0)
#define NOCP_CFG_CTL_ACTIVE_MASK		BIT(1)

/* NOCP_COUNTERS_x_SRC register */
#define NOCP_CNT_SRC_INTEVENT_SHIFT		0
#define NOCP_CNT_SRC_INTEVENT_MASK		(0x1F << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_OFF_MASK		(0x0 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_CYCLE_MASK	(0x1 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_IDLE_MASK		(0x2 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_XFER_MASK		(0x3 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_BUSY_MASK		(0x4 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_WAIT_MASK		(0x5 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_PKT_MASK		(0x6 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_BYTE_MASK		(0x8 << NOCP_CNT_SRC_INTEVENT_SHIFT)
#define NOCP_CNT_SRC_INTEVENT_CHAIN_MASK	(0x10 << NOCP_CNT_SRC_INTEVENT_SHIFT)

/* NOCP_COUNTERS_x_ALARM_MODE register */
#define NOCP_CNT_ALARM_MODE_SHIFT		0
#define NOCP_CNT_ALARM_MODE_MASK		(0x3 << NOCP_CNT_ALARM_MODE_SHIFT)
#define NOCP_CNT_ALARM_MODE_OFF_MASK		(0x0 << NOCP_CNT_ALARM_MODE_SHIFT)
#define NOCP_CNT_ALARM_MODE_MIN_MASK		(0x1 << NOCP_CNT_ALARM_MODE_SHIFT)
#define NOCP_CNT_ALARM_MODE_MAX_MASK		(0x2 << NOCP_CNT_ALARM_MODE_SHIFT)
#define NOCP_CNT_ALARM_MODE_MIN_MAX_MASK	(0x3 << NOCP_CNT_ALARM_MODE_SHIFT)

#endif /* __EXYNOS_NOCP_H__ */
