/*
 *  cx231xx-dif.h - driver for Conexant Cx23100/101/102 USB video capture devices
 *
 *  Copyright {C} 2009 <Bill.Liu@conexant.com>
 *
 *  This program is free software, you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY, without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#ifndef _CX231XX_DIF_H
#define _CX231XX_DIF_H

#include "cx231xx-reg.h"

struct dif_settings{
	u32 if_freq;
	u32 register_address;
	u32 value;
};

static struct dif_settings Dif_set_array[] = {

/*case 3000000:*/
/* BEGIN - DIF BPF register values from 30_quant.dat*/
{3000000, DIF_BPF_COEFF01,    0x00000002},
{3000000, DIF_BPF_COEFF23,    0x00080012},
{3000000, DIF_BPF_COEFF45,    0x001e0024},
{3000000, DIF_BPF_COEFF67,    0x001bfff8},
{3000000, DIF_BPF_COEFF89,    0xffb4ff50},
{3000000, DIF_BPF_COEFF1011,  0xfed8fe68},
{3000000, DIF_BPF_COEFF1213,  0xfe24fe34},
{3000000, DIF_BPF_COEFF1415,  0xfebaffc7},
{3000000, DIF_BPF_COEFF1617,  0x014d031f},
{3000000, DIF_BPF_COEFF1819,  0x04f0065d},
{3000000, DIF_BPF_COEFF2021,  0x07010688},
{3000000, DIF_BPF_COEFF2223,  0x04c901d6},
{3000000, DIF_BPF_COEFF2425,  0xfe00f9d3},
{3000000, DIF_BPF_COEFF2627,  0xf600f342},
{3000000, DIF_BPF_COEFF2829,  0xf235f337},
{3000000, DIF_BPF_COEFF3031,  0xf64efb22},
{3000000, DIF_BPF_COEFF3233,  0x0105070f},
{3000000, DIF_BPF_COEFF3435,  0x0c460fce},
{3000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 30_quant.dat*/


/*case 3100000:*/
/* BEGIN - DIF BPF register values from 31_quant.dat*/
{3100000, DIF_BPF_COEFF01,    0x00000001},
{3100000, DIF_BPF_COEFF23,    0x00070012},
{3100000, DIF_BPF_COEFF45,    0x00220032},
{3100000, DIF_BPF_COEFF67,    0x00370026},
{3100000, DIF_BPF_COEFF89,    0xfff0ff91},
{3100000, DIF_BPF_COEFF1011,  0xff0efe7c},
{3100000, DIF_BPF_COEFF1213,  0xfe01fdcc},
{3100000, DIF_BPF_COEFF1415,  0xfe0afedb},
{3100000, DIF_BPF_COEFF1617,  0x00440224},
{3100000, DIF_BPF_COEFF1819,  0x0434060c},
{3100000, DIF_BPF_COEFF2021,  0x0738074e},
{3100000, DIF_BPF_COEFF2223,  0x06090361},
{3100000, DIF_BPF_COEFF2425,  0xff99fb39},
{3100000, DIF_BPF_COEFF2627,  0xf6fef3b6},
{3100000, DIF_BPF_COEFF2829,  0xf21af2a5},
{3100000, DIF_BPF_COEFF3031,  0xf573fa33},
{3100000, DIF_BPF_COEFF3233,  0x0034067d},
{3100000, DIF_BPF_COEFF3435,  0x0bfb0fb9},
{3100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 31_quant.dat*/


/*case 3200000:*/
/* BEGIN - DIF BPF register values from 32_quant.dat*/
{3200000, DIF_BPF_COEFF01,    0x00000000},
{3200000, DIF_BPF_COEFF23,    0x0004000e},
{3200000, DIF_BPF_COEFF45,    0x00200038},
{3200000, DIF_BPF_COEFF67,    0x004c004f},
{3200000, DIF_BPF_COEFF89,    0x002fffdf},
{3200000, DIF_BPF_COEFF1011,  0xff5cfeb6},
{3200000, DIF_BPF_COEFF1213,  0xfe0dfd92},
{3200000, DIF_BPF_COEFF1415,  0xfd7ffe03},
{3200000, DIF_BPF_COEFF1617,  0xff36010a},
{3200000, DIF_BPF_COEFF1819,  0x03410575},
{3200000, DIF_BPF_COEFF2021,  0x072607d2},
{3200000, DIF_BPF_COEFF2223,  0x071804d5},
{3200000, DIF_BPF_COEFF2425,  0x0134fcb7},
{3200000, DIF_BPF_COEFF2627,  0xf81ff451},
{3200000, DIF_BPF_COEFF2829,  0xf223f22e},
{3200000, DIF_BPF_COEFF3031,  0xf4a7f94b},
{3200000, DIF_BPF_COEFF3233,  0xff6405e8},
{3200000, DIF_BPF_COEFF3435,  0x0bae0fa4},
{3200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 32_quant.dat*/


/*case 3300000:*/
/* BEGIN - DIF BPF register values from 33_quant.dat*/
{3300000, DIF_BPF_COEFF01,    0x0000ffff},
{3300000, DIF_BPF_COEFF23,    0x00000008},
{3300000, DIF_BPF_COEFF45,    0x001a0036},
{3300000, DIF_BPF_COEFF67,    0x0056006d},
{3300000, DIF_BPF_COEFF89,    0x00670030},
{3300000, DIF_BPF_COEFF1011,  0xffbdff10},
{3300000, DIF_BPF_COEFF1213,  0xfe46fd8d},
{3300000, DIF_BPF_COEFF1415,  0xfd25fd4f},
{3300000, DIF_BPF_COEFF1617,  0xfe35ffe0},
{3300000, DIF_BPF_COEFF1819,  0x0224049f},
{3300000, DIF_BPF_COEFF2021,  0x06c9080e},
{3300000, DIF_BPF_COEFF2223,  0x07ef0627},
{3300000, DIF_BPF_COEFF2425,  0x02c9fe45},
{3300000, DIF_BPF_COEFF2627,  0xf961f513},
{3300000, DIF_BPF_COEFF2829,  0xf250f1d2},
{3300000, DIF_BPF_COEFF3031,  0xf3ecf869},
{3300000, DIF_BPF_COEFF3233,  0xfe930552},
{3300000, DIF_BPF_COEFF3435,  0x0b5f0f8f},
{3300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 33_quant.dat*/


/*case 3400000:*/
/* BEGIN - DIF BPF register values from 34_quant.dat*/
{3400000, DIF_BPF_COEFF01,    0xfffffffe},
{3400000, DIF_BPF_COEFF23,    0xfffd0001},
{3400000, DIF_BPF_COEFF45,    0x000f002c},
{3400000, DIF_BPF_COEFF67,    0x0054007d},
{3400000, DIF_BPF_COEFF89,    0x0093007c},
{3400000, DIF_BPF_COEFF1011,  0x0024ff82},
{3400000, DIF_BPF_COEFF1213,  0xfea6fdbb},
{3400000, DIF_BPF_COEFF1415,  0xfd03fcca},
{3400000, DIF_BPF_COEFF1617,  0xfd51feb9},
{3400000, DIF_BPF_COEFF1819,  0x00eb0392},
{3400000, DIF_BPF_COEFF2021,  0x06270802},
{3400000, DIF_BPF_COEFF2223,  0x08880750},
{3400000, DIF_BPF_COEFF2425,  0x044dffdb},
{3400000, DIF_BPF_COEFF2627,  0xfabdf5f8},
{3400000, DIF_BPF_COEFF2829,  0xf2a0f193},
{3400000, DIF_BPF_COEFF3031,  0xf342f78f},
{3400000, DIF_BPF_COEFF3233,  0xfdc404b9},
{3400000, DIF_BPF_COEFF3435,  0x0b0e0f78},
{3400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 34_quant.dat*/


/*case 3500000:*/
/* BEGIN - DIF BPF register values from 35_quant.dat*/
{3500000, DIF_BPF_COEFF01,    0xfffffffd},
{3500000, DIF_BPF_COEFF23,    0xfffafff9},
{3500000, DIF_BPF_COEFF45,    0x0002001b},
{3500000, DIF_BPF_COEFF67,    0x0046007d},
{3500000, DIF_BPF_COEFF89,    0x00ad00ba},
{3500000, DIF_BPF_COEFF1011,  0x00870000},
{3500000, DIF_BPF_COEFF1213,  0xff26fe1a},
{3500000, DIF_BPF_COEFF1415,  0xfd1bfc7e},
{3500000, DIF_BPF_COEFF1617,  0xfc99fda4},
{3500000, DIF_BPF_COEFF1819,  0xffa5025c},
{3500000, DIF_BPF_COEFF2021,  0x054507ad},
{3500000, DIF_BPF_COEFF2223,  0x08dd0847},
{3500000, DIF_BPF_COEFF2425,  0x05b80172},
{3500000, DIF_BPF_COEFF2627,  0xfc2ef6ff},
{3500000, DIF_BPF_COEFF2829,  0xf313f170},
{3500000, DIF_BPF_COEFF3031,  0xf2abf6bd},
{3500000, DIF_BPF_COEFF3233,  0xfcf6041f},
{3500000, DIF_BPF_COEFF3435,  0x0abc0f61},
{3500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 35_quant.dat*/


/*case 3600000:*/
/* BEGIN - DIF BPF register values from 36_quant.dat*/
{3600000, DIF_BPF_COEFF01,    0xfffffffd},
{3600000, DIF_BPF_COEFF23,    0xfff8fff3},
{3600000, DIF_BPF_COEFF45,    0xfff50006},
{3600000, DIF_BPF_COEFF67,    0x002f006c},
{3600000, DIF_BPF_COEFF89,    0x00b200e3},
{3600000, DIF_BPF_COEFF1011,  0x00dc007e},
{3600000, DIF_BPF_COEFF1213,  0xffb9fea0},
{3600000, DIF_BPF_COEFF1415,  0xfd6bfc71},
{3600000, DIF_BPF_COEFF1617,  0xfc17fcb1},
{3600000, DIF_BPF_COEFF1819,  0xfe65010b},
{3600000, DIF_BPF_COEFF2021,  0x042d0713},
{3600000, DIF_BPF_COEFF2223,  0x08ec0906},
{3600000, DIF_BPF_COEFF2425,  0x07020302},
{3600000, DIF_BPF_COEFF2627,  0xfdaff823},
{3600000, DIF_BPF_COEFF2829,  0xf3a7f16a},
{3600000, DIF_BPF_COEFF3031,  0xf228f5f5},
{3600000, DIF_BPF_COEFF3233,  0xfc2a0384},
{3600000, DIF_BPF_COEFF3435,  0x0a670f4a},
{3600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 36_quant.dat*/


/*case 3700000:*/
/* BEGIN - DIF BPF register values from 37_quant.dat*/
{3700000, DIF_BPF_COEFF01,    0x0000fffd},
{3700000, DIF_BPF_COEFF23,    0xfff7ffef},
{3700000, DIF_BPF_COEFF45,    0xffe9fff1},
{3700000, DIF_BPF_COEFF67,    0x0010004d},
{3700000, DIF_BPF_COEFF89,    0x00a100f2},
{3700000, DIF_BPF_COEFF1011,  0x011a00f0},
{3700000, DIF_BPF_COEFF1213,  0x0053ff44},
{3700000, DIF_BPF_COEFF1415,  0xfdedfca2},
{3700000, DIF_BPF_COEFF1617,  0xfbd3fbef},
{3700000, DIF_BPF_COEFF1819,  0xfd39ffae},
{3700000, DIF_BPF_COEFF2021,  0x02ea0638},
{3700000, DIF_BPF_COEFF2223,  0x08b50987},
{3700000, DIF_BPF_COEFF2425,  0x08230483},
{3700000, DIF_BPF_COEFF2627,  0xff39f960},
{3700000, DIF_BPF_COEFF2829,  0xf45bf180},
{3700000, DIF_BPF_COEFF3031,  0xf1b8f537},
{3700000, DIF_BPF_COEFF3233,  0xfb6102e7},
{3700000, DIF_BPF_COEFF3435,  0x0a110f32},
{3700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 37_quant.dat*/


/*case 3800000:*/
/* BEGIN - DIF BPF register values from 38_quant.dat*/
{3800000, DIF_BPF_COEFF01,    0x0000fffe},
{3800000, DIF_BPF_COEFF23,    0xfff9ffee},
{3800000, DIF_BPF_COEFF45,    0xffe1ffdd},
{3800000, DIF_BPF_COEFF67,    0xfff00024},
{3800000, DIF_BPF_COEFF89,    0x007c00e5},
{3800000, DIF_BPF_COEFF1011,  0x013a014a},
{3800000, DIF_BPF_COEFF1213,  0x00e6fff8},
{3800000, DIF_BPF_COEFF1415,  0xfe98fd0f},
{3800000, DIF_BPF_COEFF1617,  0xfbd3fb67},
{3800000, DIF_BPF_COEFF1819,  0xfc32fe54},
{3800000, DIF_BPF_COEFF2021,  0x01880525},
{3800000, DIF_BPF_COEFF2223,  0x083909c7},
{3800000, DIF_BPF_COEFF2425,  0x091505ee},
{3800000, DIF_BPF_COEFF2627,  0x00c7fab3},
{3800000, DIF_BPF_COEFF2829,  0xf52df1b4},
{3800000, DIF_BPF_COEFF3031,  0xf15df484},
{3800000, DIF_BPF_COEFF3233,  0xfa9b0249},
{3800000, DIF_BPF_COEFF3435,  0x09ba0f19},
{3800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 38_quant.dat*/


/*case 3900000:*/
/* BEGIN - DIF BPF register values from 39_quant.dat*/
{3900000, DIF_BPF_COEFF01,    0x00000000},
{3900000, DIF_BPF_COEFF23,    0xfffbfff0},
{3900000, DIF_BPF_COEFF45,    0xffdeffcf},
{3900000, DIF_BPF_COEFF67,    0xffd1fff6},
{3900000, DIF_BPF_COEFF89,    0x004800be},
{3900000, DIF_BPF_COEFF1011,  0x01390184},
{3900000, DIF_BPF_COEFF1213,  0x016300ac},
{3900000, DIF_BPF_COEFF1415,  0xff5efdb1},
{3900000, DIF_BPF_COEFF1617,  0xfc17fb23},
{3900000, DIF_BPF_COEFF1819,  0xfb5cfd0d},
{3900000, DIF_BPF_COEFF2021,  0x001703e4},
{3900000, DIF_BPF_COEFF2223,  0x077b09c4},
{3900000, DIF_BPF_COEFF2425,  0x09d2073c},
{3900000, DIF_BPF_COEFF2627,  0x0251fc18},
{3900000, DIF_BPF_COEFF2829,  0xf61cf203},
{3900000, DIF_BPF_COEFF3031,  0xf118f3dc},
{3900000, DIF_BPF_COEFF3233,  0xf9d801aa},
{3900000, DIF_BPF_COEFF3435,  0x09600eff},
{3900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 39_quant.dat*/


/*case 4000000:*/
/* BEGIN - DIF BPF register values from 40_quant.dat*/
{4000000, DIF_BPF_COEFF01,    0x00000001},
{4000000, DIF_BPF_COEFF23,    0xfffefff4},
{4000000, DIF_BPF_COEFF45,    0xffe1ffc8},
{4000000, DIF_BPF_COEFF67,    0xffbaffca},
{4000000, DIF_BPF_COEFF89,    0x000b0082},
{4000000, DIF_BPF_COEFF1011,  0x01170198},
{4000000, DIF_BPF_COEFF1213,  0x01c10152},
{4000000, DIF_BPF_COEFF1415,  0x0030fe7b},
{4000000, DIF_BPF_COEFF1617,  0xfc99fb24},
{4000000, DIF_BPF_COEFF1819,  0xfac3fbe9},
{4000000, DIF_BPF_COEFF2021,  0xfea5027f},
{4000000, DIF_BPF_COEFF2223,  0x0683097f},
{4000000, DIF_BPF_COEFF2425,  0x0a560867},
{4000000, DIF_BPF_COEFF2627,  0x03d2fd89},
{4000000, DIF_BPF_COEFF2829,  0xf723f26f},
{4000000, DIF_BPF_COEFF3031,  0xf0e8f341},
{4000000, DIF_BPF_COEFF3233,  0xf919010a},
{4000000, DIF_BPF_COEFF3435,  0x09060ee5},
{4000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 40_quant.dat*/


/*case 4100000:*/
/* BEGIN - DIF BPF register values from 41_quant.dat*/
{4100000, DIF_BPF_COEFF01,    0x00010002},
{4100000, DIF_BPF_COEFF23,    0x0002fffb},
{4100000, DIF_BPF_COEFF45,    0xffe8ffca},
{4100000, DIF_BPF_COEFF67,    0xffacffa4},
{4100000, DIF_BPF_COEFF89,    0xffcd0036},
{4100000, DIF_BPF_COEFF1011,  0x00d70184},
{4100000, DIF_BPF_COEFF1213,  0x01f601dc},
{4100000, DIF_BPF_COEFF1415,  0x00ffff60},
{4100000, DIF_BPF_COEFF1617,  0xfd51fb6d},
{4100000, DIF_BPF_COEFF1819,  0xfa6efaf5},
{4100000, DIF_BPF_COEFF2021,  0xfd410103},
{4100000, DIF_BPF_COEFF2223,  0x055708f9},
{4100000, DIF_BPF_COEFF2425,  0x0a9e0969},
{4100000, DIF_BPF_COEFF2627,  0x0543ff02},
{4100000, DIF_BPF_COEFF2829,  0xf842f2f5},
{4100000, DIF_BPF_COEFF3031,  0xf0cef2b2},
{4100000, DIF_BPF_COEFF3233,  0xf85e006b},
{4100000, DIF_BPF_COEFF3435,  0x08aa0ecb},
{4100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 41_quant.dat*/


/*case 4200000:*/
/* BEGIN - DIF BPF register values from 42_quant.dat*/
{4200000, DIF_BPF_COEFF01,    0x00010003},
{4200000, DIF_BPF_COEFF23,    0x00050003},
{4200000, DIF_BPF_COEFF45,    0xfff3ffd3},
{4200000, DIF_BPF_COEFF67,    0xffaaff8b},
{4200000, DIF_BPF_COEFF89,    0xff95ffe5},
{4200000, DIF_BPF_COEFF1011,  0x0080014a},
{4200000, DIF_BPF_COEFF1213,  0x01fe023f},
{4200000, DIF_BPF_COEFF1415,  0x01ba0050},
{4200000, DIF_BPF_COEFF1617,  0xfe35fbf8},
{4200000, DIF_BPF_COEFF1819,  0xfa62fa3b},
{4200000, DIF_BPF_COEFF2021,  0xfbf9ff7e},
{4200000, DIF_BPF_COEFF2223,  0x04010836},
{4200000, DIF_BPF_COEFF2425,  0x0aa90a3d},
{4200000, DIF_BPF_COEFF2627,  0x069f007f},
{4200000, DIF_BPF_COEFF2829,  0xf975f395},
{4200000, DIF_BPF_COEFF3031,  0xf0cbf231},
{4200000, DIF_BPF_COEFF3233,  0xf7a9ffcb},
{4200000, DIF_BPF_COEFF3435,  0x084c0eaf},
{4200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 42_quant.dat*/


/*case 4300000:*/
/* BEGIN - DIF BPF register values from 43_quant.dat*/
{4300000, DIF_BPF_COEFF01,    0x00010003},
{4300000, DIF_BPF_COEFF23,    0x0008000a},
{4300000, DIF_BPF_COEFF45,    0x0000ffe4},
{4300000, DIF_BPF_COEFF67,    0xffb4ff81},
{4300000, DIF_BPF_COEFF89,    0xff6aff96},
{4300000, DIF_BPF_COEFF1011,  0x001c00f0},
{4300000, DIF_BPF_COEFF1213,  0x01d70271},
{4300000, DIF_BPF_COEFF1415,  0x0254013b},
{4300000, DIF_BPF_COEFF1617,  0xff36fcbd},
{4300000, DIF_BPF_COEFF1819,  0xfa9ff9c5},
{4300000, DIF_BPF_COEFF2021,  0xfadbfdfe},
{4300000, DIF_BPF_COEFF2223,  0x028c073b},
{4300000, DIF_BPF_COEFF2425,  0x0a750adf},
{4300000, DIF_BPF_COEFF2627,  0x07e101fa},
{4300000, DIF_BPF_COEFF2829,  0xfab8f44e},
{4300000, DIF_BPF_COEFF3031,  0xf0ddf1be},
{4300000, DIF_BPF_COEFF3233,  0xf6f9ff2b},
{4300000, DIF_BPF_COEFF3435,  0x07ed0e94},
{4300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 43_quant.dat*/


/*case 4400000:*/
/* BEGIN - DIF BPF register values from 44_quant.dat*/
{4400000, DIF_BPF_COEFF01,    0x00000003},
{4400000, DIF_BPF_COEFF23,    0x0009000f},
{4400000, DIF_BPF_COEFF45,    0x000efff8},
{4400000, DIF_BPF_COEFF67,    0xffc9ff87},
{4400000, DIF_BPF_COEFF89,    0xff52ff54},
{4400000, DIF_BPF_COEFF1011,  0xffb5007e},
{4400000, DIF_BPF_COEFF1213,  0x01860270},
{4400000, DIF_BPF_COEFF1415,  0x02c00210},
{4400000, DIF_BPF_COEFF1617,  0x0044fdb2},
{4400000, DIF_BPF_COEFF1819,  0xfb22f997},
{4400000, DIF_BPF_COEFF2021,  0xf9f2fc90},
{4400000, DIF_BPF_COEFF2223,  0x0102060f},
{4400000, DIF_BPF_COEFF2425,  0x0a050b4c},
{4400000, DIF_BPF_COEFF2627,  0x0902036e},
{4400000, DIF_BPF_COEFF2829,  0xfc0af51e},
{4400000, DIF_BPF_COEFF3031,  0xf106f15a},
{4400000, DIF_BPF_COEFF3233,  0xf64efe8b},
{4400000, DIF_BPF_COEFF3435,  0x078d0e77},
{4400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 44_quant.dat*/


/*case 4500000:*/
/* BEGIN - DIF BPF register values from 45_quant.dat*/
{4500000, DIF_BPF_COEFF01,    0x00000002},
{4500000, DIF_BPF_COEFF23,    0x00080012},
{4500000, DIF_BPF_COEFF45,    0x0019000e},
{4500000, DIF_BPF_COEFF67,    0xffe5ff9e},
{4500000, DIF_BPF_COEFF89,    0xff4fff25},
{4500000, DIF_BPF_COEFF1011,  0xff560000},
{4500000, DIF_BPF_COEFF1213,  0x0112023b},
{4500000, DIF_BPF_COEFF1415,  0x02f702c0},
{4500000, DIF_BPF_COEFF1617,  0x014dfec8},
{4500000, DIF_BPF_COEFF1819,  0xfbe5f9b3},
{4500000, DIF_BPF_COEFF2021,  0xf947fb41},
{4500000, DIF_BPF_COEFF2223,  0xff7004b9},
{4500000, DIF_BPF_COEFF2425,  0x095a0b81},
{4500000, DIF_BPF_COEFF2627,  0x0a0004d8},
{4500000, DIF_BPF_COEFF2829,  0xfd65f603},
{4500000, DIF_BPF_COEFF3031,  0xf144f104},
{4500000, DIF_BPF_COEFF3233,  0xf5aafdec},
{4500000, DIF_BPF_COEFF3435,  0x072b0e5a},
{4500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 45_quant.dat*/


/*case 4600000:*/
/* BEGIN - DIF BPF register values from 46_quant.dat*/
{4600000, DIF_BPF_COEFF01,    0x00000001},
{4600000, DIF_BPF_COEFF23,    0x00060012},
{4600000, DIF_BPF_COEFF45,    0x00200022},
{4600000, DIF_BPF_COEFF67,    0x0005ffc1},
{4600000, DIF_BPF_COEFF89,    0xff61ff10},
{4600000, DIF_BPF_COEFF1011,  0xff09ff82},
{4600000, DIF_BPF_COEFF1213,  0x008601d7},
{4600000, DIF_BPF_COEFF1415,  0x02f50340},
{4600000, DIF_BPF_COEFF1617,  0x0241fff0},
{4600000, DIF_BPF_COEFF1819,  0xfcddfa19},
{4600000, DIF_BPF_COEFF2021,  0xf8e2fa1e},
{4600000, DIF_BPF_COEFF2223,  0xfde30343},
{4600000, DIF_BPF_COEFF2425,  0x08790b7f},
{4600000, DIF_BPF_COEFF2627,  0x0ad50631},
{4600000, DIF_BPF_COEFF2829,  0xfec7f6fc},
{4600000, DIF_BPF_COEFF3031,  0xf198f0bd},
{4600000, DIF_BPF_COEFF3233,  0xf50dfd4e},
{4600000, DIF_BPF_COEFF3435,  0x06c90e3d},
{4600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 46_quant.dat*/


/*case 4700000:*/
/* BEGIN - DIF BPF register values from 47_quant.dat*/
{4700000, DIF_BPF_COEFF01,    0x0000ffff},
{4700000, DIF_BPF_COEFF23,    0x0003000f},
{4700000, DIF_BPF_COEFF45,    0x00220030},
{4700000, DIF_BPF_COEFF67,    0x0025ffed},
{4700000, DIF_BPF_COEFF89,    0xff87ff15},
{4700000, DIF_BPF_COEFF1011,  0xfed6ff10},
{4700000, DIF_BPF_COEFF1213,  0xffed014c},
{4700000, DIF_BPF_COEFF1415,  0x02b90386},
{4700000, DIF_BPF_COEFF1617,  0x03110119},
{4700000, DIF_BPF_COEFF1819,  0xfdfefac4},
{4700000, DIF_BPF_COEFF2021,  0xf8c6f92f},
{4700000, DIF_BPF_COEFF2223,  0xfc6701b7},
{4700000, DIF_BPF_COEFF2425,  0x07670b44},
{4700000, DIF_BPF_COEFF2627,  0x0b7e0776},
{4700000, DIF_BPF_COEFF2829,  0x002df807},
{4700000, DIF_BPF_COEFF3031,  0xf200f086},
{4700000, DIF_BPF_COEFF3233,  0xf477fcb1},
{4700000, DIF_BPF_COEFF3435,  0x06650e1e},
{4700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 47_quant.dat*/


/*case 4800000:*/
/* BEGIN - DIF BPF register values from 48_quant.dat*/
{4800000, DIF_BPF_COEFF01,    0xfffffffe},
{4800000, DIF_BPF_COEFF23,    0xffff0009},
{4800000, DIF_BPF_COEFF45,    0x001e0038},
{4800000, DIF_BPF_COEFF67,    0x003f001b},
{4800000, DIF_BPF_COEFF89,    0xffbcff36},
{4800000, DIF_BPF_COEFF1011,  0xfec2feb6},
{4800000, DIF_BPF_COEFF1213,  0xff5600a5},
{4800000, DIF_BPF_COEFF1415,  0x0248038d},
{4800000, DIF_BPF_COEFF1617,  0x03b00232},
{4800000, DIF_BPF_COEFF1819,  0xff39fbab},
{4800000, DIF_BPF_COEFF2021,  0xf8f4f87f},
{4800000, DIF_BPF_COEFF2223,  0xfb060020},
{4800000, DIF_BPF_COEFF2425,  0x062a0ad2},
{4800000, DIF_BPF_COEFF2627,  0x0bf908a3},
{4800000, DIF_BPF_COEFF2829,  0x0192f922},
{4800000, DIF_BPF_COEFF3031,  0xf27df05e},
{4800000, DIF_BPF_COEFF3233,  0xf3e8fc14},
{4800000, DIF_BPF_COEFF3435,  0x06000e00},
{4800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 48_quant.dat*/


/*case 4900000:*/
/* BEGIN - DIF BPF register values from 49_quant.dat*/
{4900000, DIF_BPF_COEFF01,    0xfffffffd},
{4900000, DIF_BPF_COEFF23,    0xfffc0002},
{4900000, DIF_BPF_COEFF45,    0x00160037},
{4900000, DIF_BPF_COEFF67,    0x00510046},
{4900000, DIF_BPF_COEFF89,    0xfff9ff6d},
{4900000, DIF_BPF_COEFF1011,  0xfed0fe7c},
{4900000, DIF_BPF_COEFF1213,  0xfecefff0},
{4900000, DIF_BPF_COEFF1415,  0x01aa0356},
{4900000, DIF_BPF_COEFF1617,  0x0413032b},
{4900000, DIF_BPF_COEFF1819,  0x007ffcc5},
{4900000, DIF_BPF_COEFF2021,  0xf96cf812},
{4900000, DIF_BPF_COEFF2223,  0xf9cefe87},
{4900000, DIF_BPF_COEFF2425,  0x04c90a2c},
{4900000, DIF_BPF_COEFF2627,  0x0c4309b4},
{4900000, DIF_BPF_COEFF2829,  0x02f3fa4a},
{4900000, DIF_BPF_COEFF3031,  0xf30ef046},
{4900000, DIF_BPF_COEFF3233,  0xf361fb7a},
{4900000, DIF_BPF_COEFF3435,  0x059b0de0},
{4900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 49_quant.dat*/


/*case 5000000:*/
/* BEGIN - DIF BPF register values from 50_quant.dat*/
{5000000, DIF_BPF_COEFF01,    0xfffffffd},
{5000000, DIF_BPF_COEFF23,    0xfff9fffa},
{5000000, DIF_BPF_COEFF45,    0x000a002d},
{5000000, DIF_BPF_COEFF67,    0x00570067},
{5000000, DIF_BPF_COEFF89,    0x0037ffb5},
{5000000, DIF_BPF_COEFF1011,  0xfefffe68},
{5000000, DIF_BPF_COEFF1213,  0xfe62ff3d},
{5000000, DIF_BPF_COEFF1415,  0x00ec02e3},
{5000000, DIF_BPF_COEFF1617,  0x043503f6},
{5000000, DIF_BPF_COEFF1819,  0x01befe05},
{5000000, DIF_BPF_COEFF2021,  0xfa27f7ee},
{5000000, DIF_BPF_COEFF2223,  0xf8c6fcf8},
{5000000, DIF_BPF_COEFF2425,  0x034c0954},
{5000000, DIF_BPF_COEFF2627,  0x0c5c0aa4},
{5000000, DIF_BPF_COEFF2829,  0x044cfb7e},
{5000000, DIF_BPF_COEFF3031,  0xf3b1f03f},
{5000000, DIF_BPF_COEFF3233,  0xf2e2fae1},
{5000000, DIF_BPF_COEFF3435,  0x05340dc0},
{5000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 50_quant.dat*/


/*case 5100000:*/
/* BEGIN - DIF BPF register values from 51_quant.dat*/
{5100000, DIF_BPF_COEFF01,    0x0000fffd},
{5100000, DIF_BPF_COEFF23,    0xfff8fff4},
{5100000, DIF_BPF_COEFF45,    0xfffd001e},
{5100000, DIF_BPF_COEFF67,    0x0051007b},
{5100000, DIF_BPF_COEFF89,    0x006e0006},
{5100000, DIF_BPF_COEFF1011,  0xff48fe7c},
{5100000, DIF_BPF_COEFF1213,  0xfe1bfe9a},
{5100000, DIF_BPF_COEFF1415,  0x001d023e},
{5100000, DIF_BPF_COEFF1617,  0x04130488},
{5100000, DIF_BPF_COEFF1819,  0x02e6ff5b},
{5100000, DIF_BPF_COEFF2021,  0xfb1ef812},
{5100000, DIF_BPF_COEFF2223,  0xf7f7fb7f},
{5100000, DIF_BPF_COEFF2425,  0x01bc084e},
{5100000, DIF_BPF_COEFF2627,  0x0c430b72},
{5100000, DIF_BPF_COEFF2829,  0x059afcba},
{5100000, DIF_BPF_COEFF3031,  0xf467f046},
{5100000, DIF_BPF_COEFF3233,  0xf26cfa4a},
{5100000, DIF_BPF_COEFF3435,  0x04cd0da0},
{5100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 51_quant.dat*/


/*case 5200000:*/
/* BEGIN - DIF BPF register values from 52_quant.dat*/
{5200000, DIF_BPF_COEFF01,    0x0000fffe},
{5200000, DIF_BPF_COEFF23,    0xfff8ffef},
{5200000, DIF_BPF_COEFF45,    0xfff00009},
{5200000, DIF_BPF_COEFF67,    0x003f007f},
{5200000, DIF_BPF_COEFF89,    0x00980056},
{5200000, DIF_BPF_COEFF1011,  0xffa5feb6},
{5200000, DIF_BPF_COEFF1213,  0xfe00fe15},
{5200000, DIF_BPF_COEFF1415,  0xff4b0170},
{5200000, DIF_BPF_COEFF1617,  0x03b004d7},
{5200000, DIF_BPF_COEFF1819,  0x03e800b9},
{5200000, DIF_BPF_COEFF2021,  0xfc48f87f},
{5200000, DIF_BPF_COEFF2223,  0xf768fa23},
{5200000, DIF_BPF_COEFF2425,  0x0022071f},
{5200000, DIF_BPF_COEFF2627,  0x0bf90c1b},
{5200000, DIF_BPF_COEFF2829,  0x06dafdfd},
{5200000, DIF_BPF_COEFF3031,  0xf52df05e},
{5200000, DIF_BPF_COEFF3233,  0xf1fef9b5},
{5200000, DIF_BPF_COEFF3435,  0x04640d7f},
{5200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 52_quant.dat*/


/*case 5300000:*/
/* BEGIN - DIF BPF register values from 53_quant.dat*/
{5300000, DIF_BPF_COEFF01,    0x0000ffff},
{5300000, DIF_BPF_COEFF23,    0xfff9ffee},
{5300000, DIF_BPF_COEFF45,    0xffe6fff3},
{5300000, DIF_BPF_COEFF67,    0x00250072},
{5300000, DIF_BPF_COEFF89,    0x00af009c},
{5300000, DIF_BPF_COEFF1011,  0x000cff10},
{5300000, DIF_BPF_COEFF1213,  0xfe13fdb8},
{5300000, DIF_BPF_COEFF1415,  0xfe870089},
{5300000, DIF_BPF_COEFF1617,  0x031104e1},
{5300000, DIF_BPF_COEFF1819,  0x04b8020f},
{5300000, DIF_BPF_COEFF2021,  0xfd98f92f},
{5300000, DIF_BPF_COEFF2223,  0xf71df8f0},
{5300000, DIF_BPF_COEFF2425,  0xfe8805ce},
{5300000, DIF_BPF_COEFF2627,  0x0b7e0c9c},
{5300000, DIF_BPF_COEFF2829,  0x0808ff44},
{5300000, DIF_BPF_COEFF3031,  0xf603f086},
{5300000, DIF_BPF_COEFF3233,  0xf19af922},
{5300000, DIF_BPF_COEFF3435,  0x03fb0d5e},
{5300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 53_quant.dat*/


/*case 5400000:*/
/* BEGIN - DIF BPF register values from 54_quant.dat*/
{5400000, DIF_BPF_COEFF01,    0x00000001},
{5400000, DIF_BPF_COEFF23,    0xfffcffef},
{5400000, DIF_BPF_COEFF45,    0xffe0ffe0},
{5400000, DIF_BPF_COEFF67,    0x00050056},
{5400000, DIF_BPF_COEFF89,    0x00b000d1},
{5400000, DIF_BPF_COEFF1011,  0x0071ff82},
{5400000, DIF_BPF_COEFF1213,  0xfe53fd8c},
{5400000, DIF_BPF_COEFF1415,  0xfddfff99},
{5400000, DIF_BPF_COEFF1617,  0x024104a3},
{5400000, DIF_BPF_COEFF1819,  0x054a034d},
{5400000, DIF_BPF_COEFF2021,  0xff01fa1e},
{5400000, DIF_BPF_COEFF2223,  0xf717f7ed},
{5400000, DIF_BPF_COEFF2425,  0xfcf50461},
{5400000, DIF_BPF_COEFF2627,  0x0ad50cf4},
{5400000, DIF_BPF_COEFF2829,  0x0921008d},
{5400000, DIF_BPF_COEFF3031,  0xf6e7f0bd},
{5400000, DIF_BPF_COEFF3233,  0xf13ff891},
{5400000, DIF_BPF_COEFF3435,  0x03920d3b},
{5400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 54_quant.dat*/


/*case 5500000:*/
/* BEGIN - DIF BPF register values from 55_quant.dat*/
{5500000, DIF_BPF_COEFF01,    0x00010002},
{5500000, DIF_BPF_COEFF23,    0xfffffff3},
{5500000, DIF_BPF_COEFF45,    0xffdeffd1},
{5500000, DIF_BPF_COEFF67,    0xffe5002f},
{5500000, DIF_BPF_COEFF89,    0x009c00ed},
{5500000, DIF_BPF_COEFF1011,  0x00cb0000},
{5500000, DIF_BPF_COEFF1213,  0xfebafd94},
{5500000, DIF_BPF_COEFF1415,  0xfd61feb0},
{5500000, DIF_BPF_COEFF1617,  0x014d0422},
{5500000, DIF_BPF_COEFF1819,  0x05970464},
{5500000, DIF_BPF_COEFF2021,  0x0074fb41},
{5500000, DIF_BPF_COEFF2223,  0xf759f721},
{5500000, DIF_BPF_COEFF2425,  0xfb7502de},
{5500000, DIF_BPF_COEFF2627,  0x0a000d21},
{5500000, DIF_BPF_COEFF2829,  0x0a2201d4},
{5500000, DIF_BPF_COEFF3031,  0xf7d9f104},
{5500000, DIF_BPF_COEFF3233,  0xf0edf804},
{5500000, DIF_BPF_COEFF3435,  0x03280d19},
{5500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 55_quant.dat*/


/*case 5600000:*/
/* BEGIN - DIF BPF register values from 56_quant.dat*/
{5600000, DIF_BPF_COEFF01,    0x00010003},
{5600000, DIF_BPF_COEFF23,    0x0003fffa},
{5600000, DIF_BPF_COEFF45,    0xffe3ffc9},
{5600000, DIF_BPF_COEFF67,    0xffc90002},
{5600000, DIF_BPF_COEFF89,    0x007500ef},
{5600000, DIF_BPF_COEFF1011,  0x010e007e},
{5600000, DIF_BPF_COEFF1213,  0xff3dfdcf},
{5600000, DIF_BPF_COEFF1415,  0xfd16fddd},
{5600000, DIF_BPF_COEFF1617,  0x00440365},
{5600000, DIF_BPF_COEFF1819,  0x059b0548},
{5600000, DIF_BPF_COEFF2021,  0x01e3fc90},
{5600000, DIF_BPF_COEFF2223,  0xf7dff691},
{5600000, DIF_BPF_COEFF2425,  0xfa0f014d},
{5600000, DIF_BPF_COEFF2627,  0x09020d23},
{5600000, DIF_BPF_COEFF2829,  0x0b0a0318},
{5600000, DIF_BPF_COEFF3031,  0xf8d7f15a},
{5600000, DIF_BPF_COEFF3233,  0xf0a5f779},
{5600000, DIF_BPF_COEFF3435,  0x02bd0cf6},
{5600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 56_quant.dat*/


/*case 5700000:*/
/* BEGIN - DIF BPF register values from 57_quant.dat*/
{5700000, DIF_BPF_COEFF01,    0x00010003},
{5700000, DIF_BPF_COEFF23,    0x00060001},
{5700000, DIF_BPF_COEFF45,    0xffecffc9},
{5700000, DIF_BPF_COEFF67,    0xffb4ffd4},
{5700000, DIF_BPF_COEFF89,    0x004000d5},
{5700000, DIF_BPF_COEFF1011,  0x013600f0},
{5700000, DIF_BPF_COEFF1213,  0xffd3fe39},
{5700000, DIF_BPF_COEFF1415,  0xfd04fd31},
{5700000, DIF_BPF_COEFF1617,  0xff360277},
{5700000, DIF_BPF_COEFF1819,  0x055605ef},
{5700000, DIF_BPF_COEFF2021,  0x033efdfe},
{5700000, DIF_BPF_COEFF2223,  0xf8a5f642},
{5700000, DIF_BPF_COEFF2425,  0xf8cbffb6},
{5700000, DIF_BPF_COEFF2627,  0x07e10cfb},
{5700000, DIF_BPF_COEFF2829,  0x0bd50456},
{5700000, DIF_BPF_COEFF3031,  0xf9dff1be},
{5700000, DIF_BPF_COEFF3233,  0xf067f6f2},
{5700000, DIF_BPF_COEFF3435,  0x02520cd2},
{5700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 57_quant.dat*/


/*case 5800000:*/
/* BEGIN - DIF BPF register values from 58_quant.dat*/
{5800000, DIF_BPF_COEFF01,    0x00000003},
{5800000, DIF_BPF_COEFF23,    0x00080009},
{5800000, DIF_BPF_COEFF45,    0xfff8ffd2},
{5800000, DIF_BPF_COEFF67,    0xffaaffac},
{5800000, DIF_BPF_COEFF89,    0x000200a3},
{5800000, DIF_BPF_COEFF1011,  0x013c014a},
{5800000, DIF_BPF_COEFF1213,  0x006dfec9},
{5800000, DIF_BPF_COEFF1415,  0xfd2bfcb7},
{5800000, DIF_BPF_COEFF1617,  0xfe350165},
{5800000, DIF_BPF_COEFF1819,  0x04cb0651},
{5800000, DIF_BPF_COEFF2021,  0x0477ff7e},
{5800000, DIF_BPF_COEFF2223,  0xf9a5f635},
{5800000, DIF_BPF_COEFF2425,  0xf7b1fe20},
{5800000, DIF_BPF_COEFF2627,  0x069f0ca8},
{5800000, DIF_BPF_COEFF2829,  0x0c81058b},
{5800000, DIF_BPF_COEFF3031,  0xfaf0f231},
{5800000, DIF_BPF_COEFF3233,  0xf033f66d},
{5800000, DIF_BPF_COEFF3435,  0x01e60cae},
{5800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 58_quant.dat*/


/*case 5900000:*/
/* BEGIN - DIF BPF register values from 59_quant.dat*/
{5900000, DIF_BPF_COEFF01,    0x00000002},
{5900000, DIF_BPF_COEFF23,    0x0009000e},
{5900000, DIF_BPF_COEFF45,    0x0005ffe1},
{5900000, DIF_BPF_COEFF67,    0xffacff90},
{5900000, DIF_BPF_COEFF89,    0xffc5005f},
{5900000, DIF_BPF_COEFF1011,  0x01210184},
{5900000, DIF_BPF_COEFF1213,  0x00fcff72},
{5900000, DIF_BPF_COEFF1415,  0xfd8afc77},
{5900000, DIF_BPF_COEFF1617,  0xfd51003f},
{5900000, DIF_BPF_COEFF1819,  0x04020669},
{5900000, DIF_BPF_COEFF2021,  0x05830103},
{5900000, DIF_BPF_COEFF2223,  0xfad7f66b},
{5900000, DIF_BPF_COEFF2425,  0xf6c8fc93},
{5900000, DIF_BPF_COEFF2627,  0x05430c2b},
{5900000, DIF_BPF_COEFF2829,  0x0d0d06b5},
{5900000, DIF_BPF_COEFF3031,  0xfc08f2b2},
{5900000, DIF_BPF_COEFF3233,  0xf00af5ec},
{5900000, DIF_BPF_COEFF3435,  0x017b0c89},
{5900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 59_quant.dat*/


/*case 6000000:*/
/* BEGIN - DIF BPF register values from 60_quant.dat*/
{6000000, DIF_BPF_COEFF01,    0x00000001},
{6000000, DIF_BPF_COEFF23,    0x00070012},
{6000000, DIF_BPF_COEFF45,    0x0012fff5},
{6000000, DIF_BPF_COEFF67,    0xffbaff82},
{6000000, DIF_BPF_COEFF89,    0xff8e000f},
{6000000, DIF_BPF_COEFF1011,  0x00e80198},
{6000000, DIF_BPF_COEFF1213,  0x01750028},
{6000000, DIF_BPF_COEFF1415,  0xfe18fc75},
{6000000, DIF_BPF_COEFF1617,  0xfc99ff15},
{6000000, DIF_BPF_COEFF1819,  0x03050636},
{6000000, DIF_BPF_COEFF2021,  0x0656027f},
{6000000, DIF_BPF_COEFF2223,  0xfc32f6e2},
{6000000, DIF_BPF_COEFF2425,  0xf614fb17},
{6000000, DIF_BPF_COEFF2627,  0x03d20b87},
{6000000, DIF_BPF_COEFF2829,  0x0d7707d2},
{6000000, DIF_BPF_COEFF3031,  0xfd26f341},
{6000000, DIF_BPF_COEFF3233,  0xefeaf56f},
{6000000, DIF_BPF_COEFF3435,  0x010f0c64},
{6000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 60_quant.dat*/


/*case 6100000:*/
/* BEGIN - DIF BPF register values from 61_quant.dat*/
{6100000, DIF_BPF_COEFF01,    0xffff0000},
{6100000, DIF_BPF_COEFF23,    0x00050012},
{6100000, DIF_BPF_COEFF45,    0x001c000b},
{6100000, DIF_BPF_COEFF67,    0xffd1ff84},
{6100000, DIF_BPF_COEFF89,    0xff66ffbe},
{6100000, DIF_BPF_COEFF1011,  0x00960184},
{6100000, DIF_BPF_COEFF1213,  0x01cd00da},
{6100000, DIF_BPF_COEFF1415,  0xfeccfcb2},
{6100000, DIF_BPF_COEFF1617,  0xfc17fdf9},
{6100000, DIF_BPF_COEFF1819,  0x01e005bc},
{6100000, DIF_BPF_COEFF2021,  0x06e703e4},
{6100000, DIF_BPF_COEFF2223,  0xfdabf798},
{6100000, DIF_BPF_COEFF2425,  0xf599f9b3},
{6100000, DIF_BPF_COEFF2627,  0x02510abd},
{6100000, DIF_BPF_COEFF2829,  0x0dbf08df},
{6100000, DIF_BPF_COEFF3031,  0xfe48f3dc},
{6100000, DIF_BPF_COEFF3233,  0xefd5f4f6},
{6100000, DIF_BPF_COEFF3435,  0x00a20c3e},
{6100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 61_quant.dat*/


/*case 6200000:*/
/* BEGIN - DIF BPF register values from 62_quant.dat*/
{6200000, DIF_BPF_COEFF01,    0xfffffffe},
{6200000, DIF_BPF_COEFF23,    0x0002000f},
{6200000, DIF_BPF_COEFF45,    0x0021001f},
{6200000, DIF_BPF_COEFF67,    0xfff0ff97},
{6200000, DIF_BPF_COEFF89,    0xff50ff74},
{6200000, DIF_BPF_COEFF1011,  0x0034014a},
{6200000, DIF_BPF_COEFF1213,  0x01fa0179},
{6200000, DIF_BPF_COEFF1415,  0xff97fd2a},
{6200000, DIF_BPF_COEFF1617,  0xfbd3fcfa},
{6200000, DIF_BPF_COEFF1819,  0x00a304fe},
{6200000, DIF_BPF_COEFF2021,  0x07310525},
{6200000, DIF_BPF_COEFF2223,  0xff37f886},
{6200000, DIF_BPF_COEFF2425,  0xf55cf86e},
{6200000, DIF_BPF_COEFF2627,  0x00c709d0},
{6200000, DIF_BPF_COEFF2829,  0x0de209db},
{6200000, DIF_BPF_COEFF3031,  0xff6df484},
{6200000, DIF_BPF_COEFF3233,  0xefcbf481},
{6200000, DIF_BPF_COEFF3435,  0x00360c18},
{6200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 62_quant.dat*/


/*case 6300000:*/
/* BEGIN - DIF BPF register values from 63_quant.dat*/
{6300000, DIF_BPF_COEFF01,    0xfffffffd},
{6300000, DIF_BPF_COEFF23,    0xfffe000a},
{6300000, DIF_BPF_COEFF45,    0x0021002f},
{6300000, DIF_BPF_COEFF67,    0x0010ffb8},
{6300000, DIF_BPF_COEFF89,    0xff50ff3b},
{6300000, DIF_BPF_COEFF1011,  0xffcc00f0},
{6300000, DIF_BPF_COEFF1213,  0x01fa01fa},
{6300000, DIF_BPF_COEFF1415,  0x0069fdd4},
{6300000, DIF_BPF_COEFF1617,  0xfbd3fc26},
{6300000, DIF_BPF_COEFF1819,  0xff5d0407},
{6300000, DIF_BPF_COEFF2021,  0x07310638},
{6300000, DIF_BPF_COEFF2223,  0x00c9f9a8},
{6300000, DIF_BPF_COEFF2425,  0xf55cf74e},
{6300000, DIF_BPF_COEFF2627,  0xff3908c3},
{6300000, DIF_BPF_COEFF2829,  0x0de20ac3},
{6300000, DIF_BPF_COEFF3031,  0x0093f537},
{6300000, DIF_BPF_COEFF3233,  0xefcbf410},
{6300000, DIF_BPF_COEFF3435,  0xffca0bf2},
{6300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 63_quant.dat*/


/*case 6400000:*/
/* BEGIN - DIF BPF register values from 64_quant.dat*/
{6400000, DIF_BPF_COEFF01,    0xfffffffd},
{6400000, DIF_BPF_COEFF23,    0xfffb0003},
{6400000, DIF_BPF_COEFF45,    0x001c0037},
{6400000, DIF_BPF_COEFF67,    0x002fffe2},
{6400000, DIF_BPF_COEFF89,    0xff66ff17},
{6400000, DIF_BPF_COEFF1011,  0xff6a007e},
{6400000, DIF_BPF_COEFF1213,  0x01cd0251},
{6400000, DIF_BPF_COEFF1415,  0x0134fea5},
{6400000, DIF_BPF_COEFF1617,  0xfc17fb8b},
{6400000, DIF_BPF_COEFF1819,  0xfe2002e0},
{6400000, DIF_BPF_COEFF2021,  0x06e70713},
{6400000, DIF_BPF_COEFF2223,  0x0255faf5},
{6400000, DIF_BPF_COEFF2425,  0xf599f658},
{6400000, DIF_BPF_COEFF2627,  0xfdaf0799},
{6400000, DIF_BPF_COEFF2829,  0x0dbf0b96},
{6400000, DIF_BPF_COEFF3031,  0x01b8f5f5},
{6400000, DIF_BPF_COEFF3233,  0xefd5f3a3},
{6400000, DIF_BPF_COEFF3435,  0xff5e0bca},
{6400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 64_quant.dat*/


/*case 6500000:*/
/* BEGIN - DIF BPF register values from 65_quant.dat*/
{6500000, DIF_BPF_COEFF01,    0x0000fffd},
{6500000, DIF_BPF_COEFF23,    0xfff9fffb},
{6500000, DIF_BPF_COEFF45,    0x00120037},
{6500000, DIF_BPF_COEFF67,    0x00460010},
{6500000, DIF_BPF_COEFF89,    0xff8eff0f},
{6500000, DIF_BPF_COEFF1011,  0xff180000},
{6500000, DIF_BPF_COEFF1213,  0x01750276},
{6500000, DIF_BPF_COEFF1415,  0x01e8ff8d},
{6500000, DIF_BPF_COEFF1617,  0xfc99fb31},
{6500000, DIF_BPF_COEFF1819,  0xfcfb0198},
{6500000, DIF_BPF_COEFF2021,  0x065607ad},
{6500000, DIF_BPF_COEFF2223,  0x03cefc64},
{6500000, DIF_BPF_COEFF2425,  0xf614f592},
{6500000, DIF_BPF_COEFF2627,  0xfc2e0656},
{6500000, DIF_BPF_COEFF2829,  0x0d770c52},
{6500000, DIF_BPF_COEFF3031,  0x02daf6bd},
{6500000, DIF_BPF_COEFF3233,  0xefeaf33b},
{6500000, DIF_BPF_COEFF3435,  0xfef10ba3},
{6500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 65_quant.dat*/


/*case 6600000:*/
/* BEGIN - DIF BPF register values from 66_quant.dat*/
{6600000, DIF_BPF_COEFF01,    0x0000fffe},
{6600000, DIF_BPF_COEFF23,    0xfff7fff5},
{6600000, DIF_BPF_COEFF45,    0x0005002f},
{6600000, DIF_BPF_COEFF67,    0x0054003c},
{6600000, DIF_BPF_COEFF89,    0xffc5ff22},
{6600000, DIF_BPF_COEFF1011,  0xfedfff82},
{6600000, DIF_BPF_COEFF1213,  0x00fc0267},
{6600000, DIF_BPF_COEFF1415,  0x0276007e},
{6600000, DIF_BPF_COEFF1617,  0xfd51fb1c},
{6600000, DIF_BPF_COEFF1819,  0xfbfe003e},
{6600000, DIF_BPF_COEFF2021,  0x05830802},
{6600000, DIF_BPF_COEFF2223,  0x0529fdec},
{6600000, DIF_BPF_COEFF2425,  0xf6c8f4fe},
{6600000, DIF_BPF_COEFF2627,  0xfabd04ff},
{6600000, DIF_BPF_COEFF2829,  0x0d0d0cf6},
{6600000, DIF_BPF_COEFF3031,  0x03f8f78f},
{6600000, DIF_BPF_COEFF3233,  0xf00af2d7},
{6600000, DIF_BPF_COEFF3435,  0xfe850b7b},
{6600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 66_quant.dat*/


/*case 6700000:*/
/* BEGIN - DIF BPF register values from 67_quant.dat*/
{6700000, DIF_BPF_COEFF01,    0x0000ffff},
{6700000, DIF_BPF_COEFF23,    0xfff8fff0},
{6700000, DIF_BPF_COEFF45,    0xfff80020},
{6700000, DIF_BPF_COEFF67,    0x00560060},
{6700000, DIF_BPF_COEFF89,    0x0002ff4e},
{6700000, DIF_BPF_COEFF1011,  0xfec4ff10},
{6700000, DIF_BPF_COEFF1213,  0x006d0225},
{6700000, DIF_BPF_COEFF1415,  0x02d50166},
{6700000, DIF_BPF_COEFF1617,  0xfe35fb4e},
{6700000, DIF_BPF_COEFF1819,  0xfb35fee1},
{6700000, DIF_BPF_COEFF2021,  0x0477080e},
{6700000, DIF_BPF_COEFF2223,  0x065bff82},
{6700000, DIF_BPF_COEFF2425,  0xf7b1f4a0},
{6700000, DIF_BPF_COEFF2627,  0xf9610397},
{6700000, DIF_BPF_COEFF2829,  0x0c810d80},
{6700000, DIF_BPF_COEFF3031,  0x0510f869},
{6700000, DIF_BPF_COEFF3233,  0xf033f278},
{6700000, DIF_BPF_COEFF3435,  0xfe1a0b52},
{6700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 67_quant.dat*/


/*case 6800000:*/
/* BEGIN - DIF BPF register values from 68_quant.dat*/
{6800000, DIF_BPF_COEFF01,    0x00010000},
{6800000, DIF_BPF_COEFF23,    0xfffaffee},
{6800000, DIF_BPF_COEFF45,    0xffec000c},
{6800000, DIF_BPF_COEFF67,    0x004c0078},
{6800000, DIF_BPF_COEFF89,    0x0040ff8e},
{6800000, DIF_BPF_COEFF1011,  0xfecafeb6},
{6800000, DIF_BPF_COEFF1213,  0xffd301b6},
{6800000, DIF_BPF_COEFF1415,  0x02fc0235},
{6800000, DIF_BPF_COEFF1617,  0xff36fbc5},
{6800000, DIF_BPF_COEFF1819,  0xfaaafd90},
{6800000, DIF_BPF_COEFF2021,  0x033e07d2},
{6800000, DIF_BPF_COEFF2223,  0x075b011b},
{6800000, DIF_BPF_COEFF2425,  0xf8cbf47a},
{6800000, DIF_BPF_COEFF2627,  0xf81f0224},
{6800000, DIF_BPF_COEFF2829,  0x0bd50def},
{6800000, DIF_BPF_COEFF3031,  0x0621f94b},
{6800000, DIF_BPF_COEFF3233,  0xf067f21e},
{6800000, DIF_BPF_COEFF3435,  0xfdae0b29},
{6800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 68_quant.dat*/


/*case 6900000:*/
/* BEGIN - DIF BPF register values from 69_quant.dat*/
{6900000, DIF_BPF_COEFF01,    0x00010001},
{6900000, DIF_BPF_COEFF23,    0xfffdffef},
{6900000, DIF_BPF_COEFF45,    0xffe3fff6},
{6900000, DIF_BPF_COEFF67,    0x0037007f},
{6900000, DIF_BPF_COEFF89,    0x0075ffdc},
{6900000, DIF_BPF_COEFF1011,  0xfef2fe7c},
{6900000, DIF_BPF_COEFF1213,  0xff3d0122},
{6900000, DIF_BPF_COEFF1415,  0x02ea02dd},
{6900000, DIF_BPF_COEFF1617,  0x0044fc79},
{6900000, DIF_BPF_COEFF1819,  0xfa65fc5d},
{6900000, DIF_BPF_COEFF2021,  0x01e3074e},
{6900000, DIF_BPF_COEFF2223,  0x082102ad},
{6900000, DIF_BPF_COEFF2425,  0xfa0ff48c},
{6900000, DIF_BPF_COEFF2627,  0xf6fe00a9},
{6900000, DIF_BPF_COEFF2829,  0x0b0a0e43},
{6900000, DIF_BPF_COEFF3031,  0x0729fa33},
{6900000, DIF_BPF_COEFF3233,  0xf0a5f1c9},
{6900000, DIF_BPF_COEFF3435,  0xfd430b00},
{6900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 69_quant.dat*/


/*case 7000000:*/
/* BEGIN - DIF BPF register values from 70_quant.dat*/
{7000000, DIF_BPF_COEFF01,    0x00010002},
{7000000, DIF_BPF_COEFF23,    0x0001fff3},
{7000000, DIF_BPF_COEFF45,    0xffdeffe2},
{7000000, DIF_BPF_COEFF67,    0x001b0076},
{7000000, DIF_BPF_COEFF89,    0x009c002d},
{7000000, DIF_BPF_COEFF1011,  0xff35fe68},
{7000000, DIF_BPF_COEFF1213,  0xfeba0076},
{7000000, DIF_BPF_COEFF1415,  0x029f0352},
{7000000, DIF_BPF_COEFF1617,  0x014dfd60},
{7000000, DIF_BPF_COEFF1819,  0xfa69fb53},
{7000000, DIF_BPF_COEFF2021,  0x00740688},
{7000000, DIF_BPF_COEFF2223,  0x08a7042d},
{7000000, DIF_BPF_COEFF2425,  0xfb75f4d6},
{7000000, DIF_BPF_COEFF2627,  0xf600ff2d},
{7000000, DIF_BPF_COEFF2829,  0x0a220e7a},
{7000000, DIF_BPF_COEFF3031,  0x0827fb22},
{7000000, DIF_BPF_COEFF3233,  0xf0edf17a},
{7000000, DIF_BPF_COEFF3435,  0xfcd80ad6},
{7000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 70_quant.dat*/


/*case 7100000:*/
/* BEGIN - DIF BPF register values from 71_quant.dat*/
{7100000, DIF_BPF_COEFF01,    0x00000003},
{7100000, DIF_BPF_COEFF23,    0x0004fff9},
{7100000, DIF_BPF_COEFF45,    0xffe0ffd2},
{7100000, DIF_BPF_COEFF67,    0xfffb005e},
{7100000, DIF_BPF_COEFF89,    0x00b0007a},
{7100000, DIF_BPF_COEFF1011,  0xff8ffe7c},
{7100000, DIF_BPF_COEFF1213,  0xfe53ffc1},
{7100000, DIF_BPF_COEFF1415,  0x0221038c},
{7100000, DIF_BPF_COEFF1617,  0x0241fe6e},
{7100000, DIF_BPF_COEFF1819,  0xfab6fa80},
{7100000, DIF_BPF_COEFF2021,  0xff010587},
{7100000, DIF_BPF_COEFF2223,  0x08e90590},
{7100000, DIF_BPF_COEFF2425,  0xfcf5f556},
{7100000, DIF_BPF_COEFF2627,  0xf52bfdb3},
{7100000, DIF_BPF_COEFF2829,  0x09210e95},
{7100000, DIF_BPF_COEFF3031,  0x0919fc15},
{7100000, DIF_BPF_COEFF3233,  0xf13ff12f},
{7100000, DIF_BPF_COEFF3435,  0xfc6e0aab},
{7100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 71_quant.dat*/


/*case 7200000:*/
/* BEGIN - DIF BPF register values from 72_quant.dat*/
{7200000, DIF_BPF_COEFF01,    0x00000003},
{7200000, DIF_BPF_COEFF23,    0x00070000},
{7200000, DIF_BPF_COEFF45,    0xffe6ffc9},
{7200000, DIF_BPF_COEFF67,    0xffdb0039},
{7200000, DIF_BPF_COEFF89,    0x00af00b8},
{7200000, DIF_BPF_COEFF1011,  0xfff4feb6},
{7200000, DIF_BPF_COEFF1213,  0xfe13ff10},
{7200000, DIF_BPF_COEFF1415,  0x01790388},
{7200000, DIF_BPF_COEFF1617,  0x0311ff92},
{7200000, DIF_BPF_COEFF1819,  0xfb48f9ed},
{7200000, DIF_BPF_COEFF2021,  0xfd980453},
{7200000, DIF_BPF_COEFF2223,  0x08e306cd},
{7200000, DIF_BPF_COEFF2425,  0xfe88f60a},
{7200000, DIF_BPF_COEFF2627,  0xf482fc40},
{7200000, DIF_BPF_COEFF2829,  0x08080e93},
{7200000, DIF_BPF_COEFF3031,  0x09fdfd0c},
{7200000, DIF_BPF_COEFF3233,  0xf19af0ea},
{7200000, DIF_BPF_COEFF3435,  0xfc050a81},
{7200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 72_quant.dat*/


/*case 7300000:*/
/* BEGIN - DIF BPF register values from 73_quant.dat*/
{7300000, DIF_BPF_COEFF01,    0x00000002},
{7300000, DIF_BPF_COEFF23,    0x00080008},
{7300000, DIF_BPF_COEFF45,    0xfff0ffc9},
{7300000, DIF_BPF_COEFF67,    0xffc1000d},
{7300000, DIF_BPF_COEFF89,    0x009800e2},
{7300000, DIF_BPF_COEFF1011,  0x005bff10},
{7300000, DIF_BPF_COEFF1213,  0xfe00fe74},
{7300000, DIF_BPF_COEFF1415,  0x00b50345},
{7300000, DIF_BPF_COEFF1617,  0x03b000bc},
{7300000, DIF_BPF_COEFF1819,  0xfc18f9a1},
{7300000, DIF_BPF_COEFF2021,  0xfc4802f9},
{7300000, DIF_BPF_COEFF2223,  0x089807dc},
{7300000, DIF_BPF_COEFF2425,  0x0022f6f0},
{7300000, DIF_BPF_COEFF2627,  0xf407fada},
{7300000, DIF_BPF_COEFF2829,  0x06da0e74},
{7300000, DIF_BPF_COEFF3031,  0x0ad3fe06},
{7300000, DIF_BPF_COEFF3233,  0xf1fef0ab},
{7300000, DIF_BPF_COEFF3435,  0xfb9c0a55},
{7300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 73_quant.dat*/


/*case 7400000:*/
/* BEGIN - DIF BPF register values from 74_quant.dat*/
{7400000, DIF_BPF_COEFF01,    0x00000001},
{7400000, DIF_BPF_COEFF23,    0x0008000e},
{7400000, DIF_BPF_COEFF45,    0xfffdffd0},
{7400000, DIF_BPF_COEFF67,    0xffafffdf},
{7400000, DIF_BPF_COEFF89,    0x006e00f2},
{7400000, DIF_BPF_COEFF1011,  0x00b8ff82},
{7400000, DIF_BPF_COEFF1213,  0xfe1bfdf8},
{7400000, DIF_BPF_COEFF1415,  0xffe302c8},
{7400000, DIF_BPF_COEFF1617,  0x041301dc},
{7400000, DIF_BPF_COEFF1819,  0xfd1af99e},
{7400000, DIF_BPF_COEFF2021,  0xfb1e0183},
{7400000, DIF_BPF_COEFF2223,  0x080908b5},
{7400000, DIF_BPF_COEFF2425,  0x01bcf801},
{7400000, DIF_BPF_COEFF2627,  0xf3bdf985},
{7400000, DIF_BPF_COEFF2829,  0x059a0e38},
{7400000, DIF_BPF_COEFF3031,  0x0b99ff03},
{7400000, DIF_BPF_COEFF3233,  0xf26cf071},
{7400000, DIF_BPF_COEFF3435,  0xfb330a2a},
{7400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 74_quant.dat*/


/*case 7500000:*/
/* BEGIN - DIF BPF register values from 75_quant.dat*/
{7500000, DIF_BPF_COEFF01,    0xffff0000},
{7500000, DIF_BPF_COEFF23,    0x00070011},
{7500000, DIF_BPF_COEFF45,    0x000affdf},
{7500000, DIF_BPF_COEFF67,    0xffa9ffb5},
{7500000, DIF_BPF_COEFF89,    0x003700e6},
{7500000, DIF_BPF_COEFF1011,  0x01010000},
{7500000, DIF_BPF_COEFF1213,  0xfe62fda8},
{7500000, DIF_BPF_COEFF1415,  0xff140219},
{7500000, DIF_BPF_COEFF1617,  0x043502e1},
{7500000, DIF_BPF_COEFF1819,  0xfe42f9e6},
{7500000, DIF_BPF_COEFF2021,  0xfa270000},
{7500000, DIF_BPF_COEFF2223,  0x073a0953},
{7500000, DIF_BPF_COEFF2425,  0x034cf939},
{7500000, DIF_BPF_COEFF2627,  0xf3a4f845},
{7500000, DIF_BPF_COEFF2829,  0x044c0de1},
{7500000, DIF_BPF_COEFF3031,  0x0c4f0000},
{7500000, DIF_BPF_COEFF3233,  0xf2e2f03c},
{7500000, DIF_BPF_COEFF3435,  0xfacc09fe},
{7500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 75_quant.dat*/


/*case 7600000:*/
/* BEGIN - DIF BPF register values from 76_quant.dat*/
{7600000, DIF_BPF_COEFF01,    0xffffffff},
{7600000, DIF_BPF_COEFF23,    0x00040012},
{7600000, DIF_BPF_COEFF45,    0x0016fff3},
{7600000, DIF_BPF_COEFF67,    0xffafff95},
{7600000, DIF_BPF_COEFF89,    0xfff900c0},
{7600000, DIF_BPF_COEFF1011,  0x0130007e},
{7600000, DIF_BPF_COEFF1213,  0xfecefd89},
{7600000, DIF_BPF_COEFF1415,  0xfe560146},
{7600000, DIF_BPF_COEFF1617,  0x041303bc},
{7600000, DIF_BPF_COEFF1819,  0xff81fa76},
{7600000, DIF_BPF_COEFF2021,  0xf96cfe7d},
{7600000, DIF_BPF_COEFF2223,  0x063209b1},
{7600000, DIF_BPF_COEFF2425,  0x04c9fa93},
{7600000, DIF_BPF_COEFF2627,  0xf3bdf71e},
{7600000, DIF_BPF_COEFF2829,  0x02f30d6e},
{7600000, DIF_BPF_COEFF3031,  0x0cf200fd},
{7600000, DIF_BPF_COEFF3233,  0xf361f00e},
{7600000, DIF_BPF_COEFF3435,  0xfa6509d1},
{7600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 76_quant.dat*/


/*case 7700000:*/
/* BEGIN - DIF BPF register values from 77_quant.dat*/
{7700000, DIF_BPF_COEFF01,    0xfffffffe},
{7700000, DIF_BPF_COEFF23,    0x00010010},
{7700000, DIF_BPF_COEFF45,    0x001e0008},
{7700000, DIF_BPF_COEFF67,    0xffc1ff84},
{7700000, DIF_BPF_COEFF89,    0xffbc0084},
{7700000, DIF_BPF_COEFF1011,  0x013e00f0},
{7700000, DIF_BPF_COEFF1213,  0xff56fd9f},
{7700000, DIF_BPF_COEFF1415,  0xfdb8005c},
{7700000, DIF_BPF_COEFF1617,  0x03b00460},
{7700000, DIF_BPF_COEFF1819,  0x00c7fb45},
{7700000, DIF_BPF_COEFF2021,  0xf8f4fd07},
{7700000, DIF_BPF_COEFF2223,  0x04fa09ce},
{7700000, DIF_BPF_COEFF2425,  0x062afc07},
{7700000, DIF_BPF_COEFF2627,  0xf407f614},
{7700000, DIF_BPF_COEFF2829,  0x01920ce0},
{7700000, DIF_BPF_COEFF3031,  0x0d8301fa},
{7700000, DIF_BPF_COEFF3233,  0xf3e8efe5},
{7700000, DIF_BPF_COEFF3435,  0xfa0009a4},
{7700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 77_quant.dat*/


/*case 7800000:*/
/* BEGIN - DIF BPF register values from 78_quant.dat*/
{7800000, DIF_BPF_COEFF01,    0x0000fffd},
{7800000, DIF_BPF_COEFF23,    0xfffd000b},
{7800000, DIF_BPF_COEFF45,    0x0022001d},
{7800000, DIF_BPF_COEFF67,    0xffdbff82},
{7800000, DIF_BPF_COEFF89,    0xff870039},
{7800000, DIF_BPF_COEFF1011,  0x012a014a},
{7800000, DIF_BPF_COEFF1213,  0xffedfde7},
{7800000, DIF_BPF_COEFF1415,  0xfd47ff6b},
{7800000, DIF_BPF_COEFF1617,  0x031104c6},
{7800000, DIF_BPF_COEFF1819,  0x0202fc4c},
{7800000, DIF_BPF_COEFF2021,  0xf8c6fbad},
{7800000, DIF_BPF_COEFF2223,  0x039909a7},
{7800000, DIF_BPF_COEFF2425,  0x0767fd8e},
{7800000, DIF_BPF_COEFF2627,  0xf482f52b},
{7800000, DIF_BPF_COEFF2829,  0x002d0c39},
{7800000, DIF_BPF_COEFF3031,  0x0e0002f4},
{7800000, DIF_BPF_COEFF3233,  0xf477efc2},
{7800000, DIF_BPF_COEFF3435,  0xf99b0977},
{7800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 78_quant.dat*/


/*case 7900000:*/
/* BEGIN - DIF BPF register values from 79_quant.dat*/
{7900000, DIF_BPF_COEFF01,    0x0000fffd},
{7900000, DIF_BPF_COEFF23,    0xfffa0004},
{7900000, DIF_BPF_COEFF45,    0x0020002d},
{7900000, DIF_BPF_COEFF67,    0xfffbff91},
{7900000, DIF_BPF_COEFF89,    0xff61ffe8},
{7900000, DIF_BPF_COEFF1011,  0x00f70184},
{7900000, DIF_BPF_COEFF1213,  0x0086fe5c},
{7900000, DIF_BPF_COEFF1415,  0xfd0bfe85},
{7900000, DIF_BPF_COEFF1617,  0x024104e5},
{7900000, DIF_BPF_COEFF1819,  0x0323fd7d},
{7900000, DIF_BPF_COEFF2021,  0xf8e2fa79},
{7900000, DIF_BPF_COEFF2223,  0x021d093f},
{7900000, DIF_BPF_COEFF2425,  0x0879ff22},
{7900000, DIF_BPF_COEFF2627,  0xf52bf465},
{7900000, DIF_BPF_COEFF2829,  0xfec70b79},
{7900000, DIF_BPF_COEFF3031,  0x0e6803eb},
{7900000, DIF_BPF_COEFF3233,  0xf50defa5},
{7900000, DIF_BPF_COEFF3435,  0xf937094a},
{7900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 79_quant.dat*/


/*case 8000000:*/
/* BEGIN - DIF BPF register values from 80_quant.dat*/
{8000000, DIF_BPF_COEFF01,    0x0000fffe},
{8000000, DIF_BPF_COEFF23,    0xfff8fffd},
{8000000, DIF_BPF_COEFF45,    0x00190036},
{8000000, DIF_BPF_COEFF67,    0x001bffaf},
{8000000, DIF_BPF_COEFF89,    0xff4fff99},
{8000000, DIF_BPF_COEFF1011,  0x00aa0198},
{8000000, DIF_BPF_COEFF1213,  0x0112fef3},
{8000000, DIF_BPF_COEFF1415,  0xfd09fdb9},
{8000000, DIF_BPF_COEFF1617,  0x014d04be},
{8000000, DIF_BPF_COEFF1819,  0x041bfecc},
{8000000, DIF_BPF_COEFF2021,  0xf947f978},
{8000000, DIF_BPF_COEFF2223,  0x00900897},
{8000000, DIF_BPF_COEFF2425,  0x095a00b9},
{8000000, DIF_BPF_COEFF2627,  0xf600f3c5},
{8000000, DIF_BPF_COEFF2829,  0xfd650aa3},
{8000000, DIF_BPF_COEFF3031,  0x0ebc04de},
{8000000, DIF_BPF_COEFF3233,  0xf5aaef8e},
{8000000, DIF_BPF_COEFF3435,  0xf8d5091c},
{8000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 80_quant.dat*/


/*case 8100000:*/
/* BEGIN - DIF BPF register values from 81_quant.dat*/
{8100000, DIF_BPF_COEFF01,    0x0000ffff},
{8100000, DIF_BPF_COEFF23,    0xfff7fff6},
{8100000, DIF_BPF_COEFF45,    0x000e0038},
{8100000, DIF_BPF_COEFF67,    0x0037ffd7},
{8100000, DIF_BPF_COEFF89,    0xff52ff56},
{8100000, DIF_BPF_COEFF1011,  0x004b0184},
{8100000, DIF_BPF_COEFF1213,  0x0186ffa1},
{8100000, DIF_BPF_COEFF1415,  0xfd40fd16},
{8100000, DIF_BPF_COEFF1617,  0x00440452},
{8100000, DIF_BPF_COEFF1819,  0x04de0029},
{8100000, DIF_BPF_COEFF2021,  0xf9f2f8b2},
{8100000, DIF_BPF_COEFF2223,  0xfefe07b5},
{8100000, DIF_BPF_COEFF2425,  0x0a05024d},
{8100000, DIF_BPF_COEFF2627,  0xf6fef34d},
{8100000, DIF_BPF_COEFF2829,  0xfc0a09b8},
{8100000, DIF_BPF_COEFF3031,  0x0efa05cd},
{8100000, DIF_BPF_COEFF3233,  0xf64eef7d},
{8100000, DIF_BPF_COEFF3435,  0xf87308ed},
{8100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 81_quant.dat*/


/*case 8200000:*/
/* BEGIN - DIF BPF register values from 82_quant.dat*/
{8200000, DIF_BPF_COEFF01,    0x00010000},
{8200000, DIF_BPF_COEFF23,    0xfff8fff0},
{8200000, DIF_BPF_COEFF45,    0x00000031},
{8200000, DIF_BPF_COEFF67,    0x004c0005},
{8200000, DIF_BPF_COEFF89,    0xff6aff27},
{8200000, DIF_BPF_COEFF1011,  0xffe4014a},
{8200000, DIF_BPF_COEFF1213,  0x01d70057},
{8200000, DIF_BPF_COEFF1415,  0xfdacfca6},
{8200000, DIF_BPF_COEFF1617,  0xff3603a7},
{8200000, DIF_BPF_COEFF1819,  0x05610184},
{8200000, DIF_BPF_COEFF2021,  0xfadbf82e},
{8200000, DIF_BPF_COEFF2223,  0xfd74069f},
{8200000, DIF_BPF_COEFF2425,  0x0a7503d6},
{8200000, DIF_BPF_COEFF2627,  0xf81ff2ff},
{8200000, DIF_BPF_COEFF2829,  0xfab808b9},
{8200000, DIF_BPF_COEFF3031,  0x0f2306b5},
{8200000, DIF_BPF_COEFF3233,  0xf6f9ef72},
{8200000, DIF_BPF_COEFF3435,  0xf81308bf},
{8200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 82_quant.dat*/


/*case 8300000:*/
/* BEGIN - DIF BPF register values from 83_quant.dat*/
{8300000, DIF_BPF_COEFF01,    0x00010001},
{8300000, DIF_BPF_COEFF23,    0xfffbffee},
{8300000, DIF_BPF_COEFF45,    0xfff30022},
{8300000, DIF_BPF_COEFF67,    0x00560032},
{8300000, DIF_BPF_COEFF89,    0xff95ff10},
{8300000, DIF_BPF_COEFF1011,  0xff8000f0},
{8300000, DIF_BPF_COEFF1213,  0x01fe0106},
{8300000, DIF_BPF_COEFF1415,  0xfe46fc71},
{8300000, DIF_BPF_COEFF1617,  0xfe3502c7},
{8300000, DIF_BPF_COEFF1819,  0x059e02ce},
{8300000, DIF_BPF_COEFF2021,  0xfbf9f7f2},
{8300000, DIF_BPF_COEFF2223,  0xfbff055b},
{8300000, DIF_BPF_COEFF2425,  0x0aa9054c},
{8300000, DIF_BPF_COEFF2627,  0xf961f2db},
{8300000, DIF_BPF_COEFF2829,  0xf97507aa},
{8300000, DIF_BPF_COEFF3031,  0x0f350797},
{8300000, DIF_BPF_COEFF3233,  0xf7a9ef6d},
{8300000, DIF_BPF_COEFF3435,  0xf7b40890},
{8300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 83_quant.dat*/


/*case 8400000:*/
/* BEGIN - DIF BPF register values from 84_quant.dat*/
{8400000, DIF_BPF_COEFF01,    0x00010002},
{8400000, DIF_BPF_COEFF23,    0xfffeffee},
{8400000, DIF_BPF_COEFF45,    0xffe8000f},
{8400000, DIF_BPF_COEFF67,    0x00540058},
{8400000, DIF_BPF_COEFF89,    0xffcdff14},
{8400000, DIF_BPF_COEFF1011,  0xff29007e},
{8400000, DIF_BPF_COEFF1213,  0x01f6019e},
{8400000, DIF_BPF_COEFF1415,  0xff01fc7c},
{8400000, DIF_BPF_COEFF1617,  0xfd5101bf},
{8400000, DIF_BPF_COEFF1819,  0x059203f6},
{8400000, DIF_BPF_COEFF2021,  0xfd41f7fe},
{8400000, DIF_BPF_COEFF2223,  0xfaa903f3},
{8400000, DIF_BPF_COEFF2425,  0x0a9e06a9},
{8400000, DIF_BPF_COEFF2627,  0xfabdf2e2},
{8400000, DIF_BPF_COEFF2829,  0xf842068b},
{8400000, DIF_BPF_COEFF3031,  0x0f320871},
{8400000, DIF_BPF_COEFF3233,  0xf85eef6e},
{8400000, DIF_BPF_COEFF3435,  0xf7560860},
{8400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 84_quant.dat*/


/*case 8500000:*/
/* BEGIN - DIF BPF register values from 85_quant.dat*/
{8500000, DIF_BPF_COEFF01,    0x00000003},
{8500000, DIF_BPF_COEFF23,    0x0002fff2},
{8500000, DIF_BPF_COEFF45,    0xffe1fff9},
{8500000, DIF_BPF_COEFF67,    0x00460073},
{8500000, DIF_BPF_COEFF89,    0x000bff34},
{8500000, DIF_BPF_COEFF1011,  0xfee90000},
{8500000, DIF_BPF_COEFF1213,  0x01c10215},
{8500000, DIF_BPF_COEFF1415,  0xffd0fcc5},
{8500000, DIF_BPF_COEFF1617,  0xfc99009d},
{8500000, DIF_BPF_COEFF1819,  0x053d04f1},
{8500000, DIF_BPF_COEFF2021,  0xfea5f853},
{8500000, DIF_BPF_COEFF2223,  0xf97d0270},
{8500000, DIF_BPF_COEFF2425,  0x0a5607e4},
{8500000, DIF_BPF_COEFF2627,  0xfc2ef314},
{8500000, DIF_BPF_COEFF2829,  0xf723055f},
{8500000, DIF_BPF_COEFF3031,  0x0f180943},
{8500000, DIF_BPF_COEFF3233,  0xf919ef75},
{8500000, DIF_BPF_COEFF3435,  0xf6fa0830},
{8500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 85_quant.dat*/


/*case 8600000:*/
/* BEGIN - DIF BPF register values from 86_quant.dat*/
{8600000, DIF_BPF_COEFF01,    0x00000003},
{8600000, DIF_BPF_COEFF23,    0x0005fff8},
{8600000, DIF_BPF_COEFF45,    0xffdeffe4},
{8600000, DIF_BPF_COEFF67,    0x002f007f},
{8600000, DIF_BPF_COEFF89,    0x0048ff6b},
{8600000, DIF_BPF_COEFF1011,  0xfec7ff82},
{8600000, DIF_BPF_COEFF1213,  0x0163025f},
{8600000, DIF_BPF_COEFF1415,  0x00a2fd47},
{8600000, DIF_BPF_COEFF1617,  0xfc17ff73},
{8600000, DIF_BPF_COEFF1819,  0x04a405b2},
{8600000, DIF_BPF_COEFF2021,  0x0017f8ed},
{8600000, DIF_BPF_COEFF2223,  0xf88500dc},
{8600000, DIF_BPF_COEFF2425,  0x09d208f9},
{8600000, DIF_BPF_COEFF2627,  0xfdaff370},
{8600000, DIF_BPF_COEFF2829,  0xf61c0429},
{8600000, DIF_BPF_COEFF3031,  0x0ee80a0b},
{8600000, DIF_BPF_COEFF3233,  0xf9d8ef82},
{8600000, DIF_BPF_COEFF3435,  0xf6a00800},
{8600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 86_quant.dat*/


/*case 8700000:*/
/* BEGIN - DIF BPF register values from 87_quant.dat*/
{8700000, DIF_BPF_COEFF01,    0x00000003},
{8700000, DIF_BPF_COEFF23,    0x0007ffff},
{8700000, DIF_BPF_COEFF45,    0xffe1ffd4},
{8700000, DIF_BPF_COEFF67,    0x0010007a},
{8700000, DIF_BPF_COEFF89,    0x007cffb2},
{8700000, DIF_BPF_COEFF1011,  0xfec6ff10},
{8700000, DIF_BPF_COEFF1213,  0x00e60277},
{8700000, DIF_BPF_COEFF1415,  0x0168fdf9},
{8700000, DIF_BPF_COEFF1617,  0xfbd3fe50},
{8700000, DIF_BPF_COEFF1819,  0x03ce0631},
{8700000, DIF_BPF_COEFF2021,  0x0188f9c8},
{8700000, DIF_BPF_COEFF2223,  0xf7c7ff43},
{8700000, DIF_BPF_COEFF2425,  0x091509e3},
{8700000, DIF_BPF_COEFF2627,  0xff39f3f6},
{8700000, DIF_BPF_COEFF2829,  0xf52d02ea},
{8700000, DIF_BPF_COEFF3031,  0x0ea30ac9},
{8700000, DIF_BPF_COEFF3233,  0xfa9bef95},
{8700000, DIF_BPF_COEFF3435,  0xf64607d0},
{8700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 87_quant.dat*/


/*case 8800000:*/
/* BEGIN - DIF BPF register values from 88_quant.dat*/
{8800000, DIF_BPF_COEFF01,    0x00000002},
{8800000, DIF_BPF_COEFF23,    0x00090007},
{8800000, DIF_BPF_COEFF45,    0xffe9ffca},
{8800000, DIF_BPF_COEFF67,    0xfff00065},
{8800000, DIF_BPF_COEFF89,    0x00a10003},
{8800000, DIF_BPF_COEFF1011,  0xfee6feb6},
{8800000, DIF_BPF_COEFF1213,  0x0053025b},
{8800000, DIF_BPF_COEFF1415,  0x0213fed0},
{8800000, DIF_BPF_COEFF1617,  0xfbd3fd46},
{8800000, DIF_BPF_COEFF1819,  0x02c70668},
{8800000, DIF_BPF_COEFF2021,  0x02eafadb},
{8800000, DIF_BPF_COEFF2223,  0xf74bfdae},
{8800000, DIF_BPF_COEFF2425,  0x08230a9c},
{8800000, DIF_BPF_COEFF2627,  0x00c7f4a3},
{8800000, DIF_BPF_COEFF2829,  0xf45b01a6},
{8800000, DIF_BPF_COEFF3031,  0x0e480b7c},
{8800000, DIF_BPF_COEFF3233,  0xfb61efae},
{8800000, DIF_BPF_COEFF3435,  0xf5ef079f},
{8800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 88_quant.dat*/


/*case 8900000:*/
/* BEGIN - DIF BPF register values from 89_quant.dat*/
{8900000, DIF_BPF_COEFF01,    0xffff0000},
{8900000, DIF_BPF_COEFF23,    0x0008000d},
{8900000, DIF_BPF_COEFF45,    0xfff5ffc8},
{8900000, DIF_BPF_COEFF67,    0xffd10043},
{8900000, DIF_BPF_COEFF89,    0x00b20053},
{8900000, DIF_BPF_COEFF1011,  0xff24fe7c},
{8900000, DIF_BPF_COEFF1213,  0xffb9020c},
{8900000, DIF_BPF_COEFF1415,  0x0295ffbb},
{8900000, DIF_BPF_COEFF1617,  0xfc17fc64},
{8900000, DIF_BPF_COEFF1819,  0x019b0654},
{8900000, DIF_BPF_COEFF2021,  0x042dfc1c},
{8900000, DIF_BPF_COEFF2223,  0xf714fc2a},
{8900000, DIF_BPF_COEFF2425,  0x07020b21},
{8900000, DIF_BPF_COEFF2627,  0x0251f575},
{8900000, DIF_BPF_COEFF2829,  0xf3a7005e},
{8900000, DIF_BPF_COEFF3031,  0x0dd80c24},
{8900000, DIF_BPF_COEFF3233,  0xfc2aefcd},
{8900000, DIF_BPF_COEFF3435,  0xf599076e},
{8900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 89_quant.dat*/


/*case 9000000:*/
/* BEGIN - DIF BPF register values from 90_quant.dat*/
{9000000, DIF_BPF_COEFF01,    0xffffffff},
{9000000, DIF_BPF_COEFF23,    0x00060011},
{9000000, DIF_BPF_COEFF45,    0x0002ffcf},
{9000000, DIF_BPF_COEFF67,    0xffba0018},
{9000000, DIF_BPF_COEFF89,    0x00ad009a},
{9000000, DIF_BPF_COEFF1011,  0xff79fe68},
{9000000, DIF_BPF_COEFF1213,  0xff260192},
{9000000, DIF_BPF_COEFF1415,  0x02e500ab},
{9000000, DIF_BPF_COEFF1617,  0xfc99fbb6},
{9000000, DIF_BPF_COEFF1819,  0x005b05f7},
{9000000, DIF_BPF_COEFF2021,  0x0545fd81},
{9000000, DIF_BPF_COEFF2223,  0xf723fabf},
{9000000, DIF_BPF_COEFF2425,  0x05b80b70},
{9000000, DIF_BPF_COEFF2627,  0x03d2f669},
{9000000, DIF_BPF_COEFF2829,  0xf313ff15},
{9000000, DIF_BPF_COEFF3031,  0x0d550cbf},
{9000000, DIF_BPF_COEFF3233,  0xfcf6eff2},
{9000000, DIF_BPF_COEFF3435,  0xf544073d},
{9000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 90_quant.dat*/


/*case 9100000:*/
/* BEGIN - DIF BPF register values from 91_quant.dat*/
{9100000, DIF_BPF_COEFF01,    0xfffffffe},
{9100000, DIF_BPF_COEFF23,    0x00030012},
{9100000, DIF_BPF_COEFF45,    0x000fffdd},
{9100000, DIF_BPF_COEFF67,    0xffacffea},
{9100000, DIF_BPF_COEFF89,    0x009300cf},
{9100000, DIF_BPF_COEFF1011,  0xffdcfe7c},
{9100000, DIF_BPF_COEFF1213,  0xfea600f7},
{9100000, DIF_BPF_COEFF1415,  0x02fd0190},
{9100000, DIF_BPF_COEFF1617,  0xfd51fb46},
{9100000, DIF_BPF_COEFF1819,  0xff150554},
{9100000, DIF_BPF_COEFF2021,  0x0627fefd},
{9100000, DIF_BPF_COEFF2223,  0xf778f978},
{9100000, DIF_BPF_COEFF2425,  0x044d0b87},
{9100000, DIF_BPF_COEFF2627,  0x0543f77d},
{9100000, DIF_BPF_COEFF2829,  0xf2a0fdcf},
{9100000, DIF_BPF_COEFF3031,  0x0cbe0d4e},
{9100000, DIF_BPF_COEFF3233,  0xfdc4f01d},
{9100000, DIF_BPF_COEFF3435,  0xf4f2070b},
{9100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 91_quant.dat*/


/*case 9200000:*/
/* BEGIN - DIF BPF register values from 92_quant.dat*/
{9200000, DIF_BPF_COEFF01,    0x0000fffd},
{9200000, DIF_BPF_COEFF23,    0x00000010},
{9200000, DIF_BPF_COEFF45,    0x001afff0},
{9200000, DIF_BPF_COEFF67,    0xffaaffbf},
{9200000, DIF_BPF_COEFF89,    0x006700ed},
{9200000, DIF_BPF_COEFF1011,  0x0043feb6},
{9200000, DIF_BPF_COEFF1213,  0xfe460047},
{9200000, DIF_BPF_COEFF1415,  0x02db0258},
{9200000, DIF_BPF_COEFF1617,  0xfe35fb1b},
{9200000, DIF_BPF_COEFF1819,  0xfddc0473},
{9200000, DIF_BPF_COEFF2021,  0x06c90082},
{9200000, DIF_BPF_COEFF2223,  0xf811f85e},
{9200000, DIF_BPF_COEFF2425,  0x02c90b66},
{9200000, DIF_BPF_COEFF2627,  0x069ff8ad},
{9200000, DIF_BPF_COEFF2829,  0xf250fc8d},
{9200000, DIF_BPF_COEFF3031,  0x0c140dcf},
{9200000, DIF_BPF_COEFF3233,  0xfe93f04d},
{9200000, DIF_BPF_COEFF3435,  0xf4a106d9},
{9200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 92_quant.dat*/


/*case 9300000:*/
/* BEGIN - DIF BPF register values from 93_quant.dat*/
{9300000, DIF_BPF_COEFF01,    0x0000fffd},
{9300000, DIF_BPF_COEFF23,    0xfffc000c},
{9300000, DIF_BPF_COEFF45,    0x00200006},
{9300000, DIF_BPF_COEFF67,    0xffb4ff9c},
{9300000, DIF_BPF_COEFF89,    0x002f00ef},
{9300000, DIF_BPF_COEFF1011,  0x00a4ff10},
{9300000, DIF_BPF_COEFF1213,  0xfe0dff92},
{9300000, DIF_BPF_COEFF1415,  0x028102f7},
{9300000, DIF_BPF_COEFF1617,  0xff36fb37},
{9300000, DIF_BPF_COEFF1819,  0xfcbf035e},
{9300000, DIF_BPF_COEFF2021,  0x07260202},
{9300000, DIF_BPF_COEFF2223,  0xf8e8f778},
{9300000, DIF_BPF_COEFF2425,  0x01340b0d},
{9300000, DIF_BPF_COEFF2627,  0x07e1f9f4},
{9300000, DIF_BPF_COEFF2829,  0xf223fb51},
{9300000, DIF_BPF_COEFF3031,  0x0b590e42},
{9300000, DIF_BPF_COEFF3233,  0xff64f083},
{9300000, DIF_BPF_COEFF3435,  0xf45206a7},
{9300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 93_quant.dat*/


/*case 9400000:*/
/* BEGIN - DIF BPF register values from 94_quant.dat*/
{9400000, DIF_BPF_COEFF01,    0x0000fffd},
{9400000, DIF_BPF_COEFF23,    0xfff90005},
{9400000, DIF_BPF_COEFF45,    0x0022001a},
{9400000, DIF_BPF_COEFF67,    0xffc9ff86},
{9400000, DIF_BPF_COEFF89,    0xfff000d7},
{9400000, DIF_BPF_COEFF1011,  0x00f2ff82},
{9400000, DIF_BPF_COEFF1213,  0xfe01fee5},
{9400000, DIF_BPF_COEFF1415,  0x01f60362},
{9400000, DIF_BPF_COEFF1617,  0x0044fb99},
{9400000, DIF_BPF_COEFF1819,  0xfbcc0222},
{9400000, DIF_BPF_COEFF2021,  0x07380370},
{9400000, DIF_BPF_COEFF2223,  0xf9f7f6cc},
{9400000, DIF_BPF_COEFF2425,  0xff990a7e},
{9400000, DIF_BPF_COEFF2627,  0x0902fb50},
{9400000, DIF_BPF_COEFF2829,  0xf21afa1f},
{9400000, DIF_BPF_COEFF3031,  0x0a8d0ea6},
{9400000, DIF_BPF_COEFF3233,  0x0034f0bf},
{9400000, DIF_BPF_COEFF3435,  0xf4050675},
{9400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 94_quant.dat*/


/*case 9500000:*/
/* BEGIN - DIF BPF register values from 95_quant.dat*/
{9500000, DIF_BPF_COEFF01,    0x0000fffe},
{9500000, DIF_BPF_COEFF23,    0xfff8fffe},
{9500000, DIF_BPF_COEFF45,    0x001e002b},
{9500000, DIF_BPF_COEFF67,    0xffe5ff81},
{9500000, DIF_BPF_COEFF89,    0xffb400a5},
{9500000, DIF_BPF_COEFF1011,  0x01280000},
{9500000, DIF_BPF_COEFF1213,  0xfe24fe50},
{9500000, DIF_BPF_COEFF1415,  0x01460390},
{9500000, DIF_BPF_COEFF1617,  0x014dfc3a},
{9500000, DIF_BPF_COEFF1819,  0xfb1000ce},
{9500000, DIF_BPF_COEFF2021,  0x070104bf},
{9500000, DIF_BPF_COEFF2223,  0xfb37f65f},
{9500000, DIF_BPF_COEFF2425,  0xfe0009bc},
{9500000, DIF_BPF_COEFF2627,  0x0a00fcbb},
{9500000, DIF_BPF_COEFF2829,  0xf235f8f8},
{9500000, DIF_BPF_COEFF3031,  0x09b20efc},
{9500000, DIF_BPF_COEFF3233,  0x0105f101},
{9500000, DIF_BPF_COEFF3435,  0xf3ba0642},
{9500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 95_quant.dat*/


/*case 9600000:*/
/* BEGIN - DIF BPF register values from 96_quant.dat*/
{9600000, DIF_BPF_COEFF01,    0x0001ffff},
{9600000, DIF_BPF_COEFF23,    0xfff8fff7},
{9600000, DIF_BPF_COEFF45,    0x00150036},
{9600000, DIF_BPF_COEFF67,    0x0005ff8c},
{9600000, DIF_BPF_COEFF89,    0xff810061},
{9600000, DIF_BPF_COEFF1011,  0x013d007e},
{9600000, DIF_BPF_COEFF1213,  0xfe71fddf},
{9600000, DIF_BPF_COEFF1415,  0x007c0380},
{9600000, DIF_BPF_COEFF1617,  0x0241fd13},
{9600000, DIF_BPF_COEFF1819,  0xfa94ff70},
{9600000, DIF_BPF_COEFF2021,  0x068005e2},
{9600000, DIF_BPF_COEFF2223,  0xfc9bf633},
{9600000, DIF_BPF_COEFF2425,  0xfc7308ca},
{9600000, DIF_BPF_COEFF2627,  0x0ad5fe30},
{9600000, DIF_BPF_COEFF2829,  0xf274f7e0},
{9600000, DIF_BPF_COEFF3031,  0x08c90f43},
{9600000, DIF_BPF_COEFF3233,  0x01d4f147},
{9600000, DIF_BPF_COEFF3435,  0xf371060f},
{9600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 96_quant.dat*/


/*case 9700000:*/
/* BEGIN - DIF BPF register values from 97_quant.dat*/
{9700000, DIF_BPF_COEFF01,    0x00010001},
{9700000, DIF_BPF_COEFF23,    0xfff9fff1},
{9700000, DIF_BPF_COEFF45,    0x00090038},
{9700000, DIF_BPF_COEFF67,    0x0025ffa7},
{9700000, DIF_BPF_COEFF89,    0xff5e0012},
{9700000, DIF_BPF_COEFF1011,  0x013200f0},
{9700000, DIF_BPF_COEFF1213,  0xfee3fd9b},
{9700000, DIF_BPF_COEFF1415,  0xffaa0331},
{9700000, DIF_BPF_COEFF1617,  0x0311fe15},
{9700000, DIF_BPF_COEFF1819,  0xfa60fe18},
{9700000, DIF_BPF_COEFF2021,  0x05bd06d1},
{9700000, DIF_BPF_COEFF2223,  0xfe1bf64a},
{9700000, DIF_BPF_COEFF2425,  0xfafa07ae},
{9700000, DIF_BPF_COEFF2627,  0x0b7effab},
{9700000, DIF_BPF_COEFF2829,  0xf2d5f6d7},
{9700000, DIF_BPF_COEFF3031,  0x07d30f7a},
{9700000, DIF_BPF_COEFF3233,  0x02a3f194},
{9700000, DIF_BPF_COEFF3435,  0xf32905dc},
{9700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 97_quant.dat*/


/*case 9800000:*/
/* BEGIN - DIF BPF register values from 98_quant.dat*/
{9800000, DIF_BPF_COEFF01,    0x00010002},
{9800000, DIF_BPF_COEFF23,    0xfffcffee},
{9800000, DIF_BPF_COEFF45,    0xfffb0032},
{9800000, DIF_BPF_COEFF67,    0x003fffcd},
{9800000, DIF_BPF_COEFF89,    0xff4effc1},
{9800000, DIF_BPF_COEFF1011,  0x0106014a},
{9800000, DIF_BPF_COEFF1213,  0xff6efd8a},
{9800000, DIF_BPF_COEFF1415,  0xfedd02aa},
{9800000, DIF_BPF_COEFF1617,  0x03b0ff34},
{9800000, DIF_BPF_COEFF1819,  0xfa74fcd7},
{9800000, DIF_BPF_COEFF2021,  0x04bf0781},
{9800000, DIF_BPF_COEFF2223,  0xffaaf6a3},
{9800000, DIF_BPF_COEFF2425,  0xf99e066b},
{9800000, DIF_BPF_COEFF2627,  0x0bf90128},
{9800000, DIF_BPF_COEFF2829,  0xf359f5e1},
{9800000, DIF_BPF_COEFF3031,  0x06d20fa2},
{9800000, DIF_BPF_COEFF3233,  0x0370f1e5},
{9800000, DIF_BPF_COEFF3435,  0xf2e405a8},
{9800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 98_quant.dat*/


/*case 9900000:*/
/* BEGIN - DIF BPF register values from 99_quant.dat*/
{9900000, DIF_BPF_COEFF01,    0x00000003},
{9900000, DIF_BPF_COEFF23,    0xffffffee},
{9900000, DIF_BPF_COEFF45,    0xffef0024},
{9900000, DIF_BPF_COEFF67,    0x0051fffa},
{9900000, DIF_BPF_COEFF89,    0xff54ff77},
{9900000, DIF_BPF_COEFF1011,  0x00be0184},
{9900000, DIF_BPF_COEFF1213,  0x0006fdad},
{9900000, DIF_BPF_COEFF1415,  0xfe2701f3},
{9900000, DIF_BPF_COEFF1617,  0x0413005e},
{9900000, DIF_BPF_COEFF1819,  0xfad1fbba},
{9900000, DIF_BPF_COEFF2021,  0x039007ee},
{9900000, DIF_BPF_COEFF2223,  0x013bf73d},
{9900000, DIF_BPF_COEFF2425,  0xf868050a},
{9900000, DIF_BPF_COEFF2627,  0x0c4302a1},
{9900000, DIF_BPF_COEFF2829,  0xf3fdf4fe},
{9900000, DIF_BPF_COEFF3031,  0x05c70fba},
{9900000, DIF_BPF_COEFF3233,  0x043bf23c},
{9900000, DIF_BPF_COEFF3435,  0xf2a10575},
{9900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 99_quant.dat*/


/*case 10000000:*/
/* BEGIN - DIF BPF register values from 100_quant.dat*/
{10000000, DIF_BPF_COEFF01,    0x00000003},
{10000000, DIF_BPF_COEFF23,    0x0003fff1},
{10000000, DIF_BPF_COEFF45,    0xffe50011},
{10000000, DIF_BPF_COEFF67,    0x00570027},
{10000000, DIF_BPF_COEFF89,    0xff70ff3c},
{10000000, DIF_BPF_COEFF1011,  0x00620198},
{10000000, DIF_BPF_COEFF1213,  0x009efe01},
{10000000, DIF_BPF_COEFF1415,  0xfd95011a},
{10000000, DIF_BPF_COEFF1617,  0x04350183},
{10000000, DIF_BPF_COEFF1819,  0xfb71fad0},
{10000000, DIF_BPF_COEFF2021,  0x023c0812},
{10000000, DIF_BPF_COEFF2223,  0x02c3f811},
{10000000, DIF_BPF_COEFF2425,  0xf75e0390},
{10000000, DIF_BPF_COEFF2627,  0x0c5c0411},
{10000000, DIF_BPF_COEFF2829,  0xf4c1f432},
{10000000, DIF_BPF_COEFF3031,  0x04b30fc1},
{10000000, DIF_BPF_COEFF3233,  0x0503f297},
{10000000, DIF_BPF_COEFF3435,  0xf2610541},
{10000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 100_quant.dat*/


/*case 10100000:*/
/* BEGIN - DIF BPF register values from 101_quant.dat*/
{10100000, DIF_BPF_COEFF01,    0x00000003},
{10100000, DIF_BPF_COEFF23,    0x0006fff7},
{10100000, DIF_BPF_COEFF45,    0xffdffffc},
{10100000, DIF_BPF_COEFF67,    0x00510050},
{10100000, DIF_BPF_COEFF89,    0xff9dff18},
{10100000, DIF_BPF_COEFF1011,  0xfffc0184},
{10100000, DIF_BPF_COEFF1213,  0x0128fe80},
{10100000, DIF_BPF_COEFF1415,  0xfd32002e},
{10100000, DIF_BPF_COEFF1617,  0x04130292},
{10100000, DIF_BPF_COEFF1819,  0xfc4dfa21},
{10100000, DIF_BPF_COEFF2021,  0x00d107ee},
{10100000, DIF_BPF_COEFF2223,  0x0435f91c},
{10100000, DIF_BPF_COEFF2425,  0xf6850205},
{10100000, DIF_BPF_COEFF2627,  0x0c430573},
{10100000, DIF_BPF_COEFF2829,  0xf5a1f37d},
{10100000, DIF_BPF_COEFF3031,  0x03990fba},
{10100000, DIF_BPF_COEFF3233,  0x05c7f2f8},
{10100000, DIF_BPF_COEFF3435,  0xf222050d},
{10100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 101_quant.dat*/


/*case 10200000:*/
/* BEGIN - DIF BPF register values from 102_quant.dat*/
{10200000, DIF_BPF_COEFF01,    0x00000002},
{10200000, DIF_BPF_COEFF23,    0x0008fffe},
{10200000, DIF_BPF_COEFF45,    0xffdfffe7},
{10200000, DIF_BPF_COEFF67,    0x003f006e},
{10200000, DIF_BPF_COEFF89,    0xffd6ff0f},
{10200000, DIF_BPF_COEFF1011,  0xff96014a},
{10200000, DIF_BPF_COEFF1213,  0x0197ff1f},
{10200000, DIF_BPF_COEFF1415,  0xfd05ff3e},
{10200000, DIF_BPF_COEFF1617,  0x03b0037c},
{10200000, DIF_BPF_COEFF1819,  0xfd59f9b7},
{10200000, DIF_BPF_COEFF2021,  0xff5d0781},
{10200000, DIF_BPF_COEFF2223,  0x0585fa56},
{10200000, DIF_BPF_COEFF2425,  0xf5e4006f},
{10200000, DIF_BPF_COEFF2627,  0x0bf906c4},
{10200000, DIF_BPF_COEFF2829,  0xf69df2e0},
{10200000, DIF_BPF_COEFF3031,  0x02790fa2},
{10200000, DIF_BPF_COEFF3233,  0x0688f35d},
{10200000, DIF_BPF_COEFF3435,  0xf1e604d8},
{10200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 102_quant.dat*/


/*case 10300000:*/
/* BEGIN - DIF BPF register values from 103_quant.dat*/
{10300000, DIF_BPF_COEFF01,    0xffff0001},
{10300000, DIF_BPF_COEFF23,    0x00090005},
{10300000, DIF_BPF_COEFF45,    0xffe4ffd6},
{10300000, DIF_BPF_COEFF67,    0x0025007e},
{10300000, DIF_BPF_COEFF89,    0x0014ff20},
{10300000, DIF_BPF_COEFF1011,  0xff3c00f0},
{10300000, DIF_BPF_COEFF1213,  0x01e1ffd0},
{10300000, DIF_BPF_COEFF1415,  0xfd12fe5c},
{10300000, DIF_BPF_COEFF1617,  0x03110433},
{10300000, DIF_BPF_COEFF1819,  0xfe88f996},
{10300000, DIF_BPF_COEFF2021,  0xfdf106d1},
{10300000, DIF_BPF_COEFF2223,  0x06aafbb7},
{10300000, DIF_BPF_COEFF2425,  0xf57efed8},
{10300000, DIF_BPF_COEFF2627,  0x0b7e07ff},
{10300000, DIF_BPF_COEFF2829,  0xf7b0f25e},
{10300000, DIF_BPF_COEFF3031,  0x01560f7a},
{10300000, DIF_BPF_COEFF3233,  0x0745f3c7},
{10300000, DIF_BPF_COEFF3435,  0xf1ac04a4},
{10300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 103_quant.dat*/


/*case 10400000:*/
/* BEGIN - DIF BPF register values from 104_quant.dat*/
{10400000, DIF_BPF_COEFF01,    0xffffffff},
{10400000, DIF_BPF_COEFF23,    0x0008000c},
{10400000, DIF_BPF_COEFF45,    0xffedffcb},
{10400000, DIF_BPF_COEFF67,    0x0005007d},
{10400000, DIF_BPF_COEFF89,    0x0050ff4c},
{10400000, DIF_BPF_COEFF1011,  0xfef6007e},
{10400000, DIF_BPF_COEFF1213,  0x01ff0086},
{10400000, DIF_BPF_COEFF1415,  0xfd58fd97},
{10400000, DIF_BPF_COEFF1617,  0x024104ad},
{10400000, DIF_BPF_COEFF1819,  0xffcaf9c0},
{10400000, DIF_BPF_COEFF2021,  0xfc9905e2},
{10400000, DIF_BPF_COEFF2223,  0x079afd35},
{10400000, DIF_BPF_COEFF2425,  0xf555fd46},
{10400000, DIF_BPF_COEFF2627,  0x0ad50920},
{10400000, DIF_BPF_COEFF2829,  0xf8d9f1f6},
{10400000, DIF_BPF_COEFF3031,  0x00310f43},
{10400000, DIF_BPF_COEFF3233,  0x07fdf435},
{10400000, DIF_BPF_COEFF3435,  0xf174046f},
{10400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 104_quant.dat*/


/*case 10500000:*/
/* BEGIN - DIF BPF register values from 105_quant.dat*/
{10500000, DIF_BPF_COEFF01,    0xfffffffe},
{10500000, DIF_BPF_COEFF23,    0x00050011},
{10500000, DIF_BPF_COEFF45,    0xfffaffc8},
{10500000, DIF_BPF_COEFF67,    0xffe5006b},
{10500000, DIF_BPF_COEFF89,    0x0082ff8c},
{10500000, DIF_BPF_COEFF1011,  0xfecc0000},
{10500000, DIF_BPF_COEFF1213,  0x01f00130},
{10500000, DIF_BPF_COEFF1415,  0xfdd2fcfc},
{10500000, DIF_BPF_COEFF1617,  0x014d04e3},
{10500000, DIF_BPF_COEFF1819,  0x010efa32},
{10500000, DIF_BPF_COEFF2021,  0xfb6404bf},
{10500000, DIF_BPF_COEFF2223,  0x084efec5},
{10500000, DIF_BPF_COEFF2425,  0xf569fbc2},
{10500000, DIF_BPF_COEFF2627,  0x0a000a23},
{10500000, DIF_BPF_COEFF2829,  0xfa15f1ab},
{10500000, DIF_BPF_COEFF3031,  0xff0b0efc},
{10500000, DIF_BPF_COEFF3233,  0x08b0f4a7},
{10500000, DIF_BPF_COEFF3435,  0xf13f043a},
{10500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 105_quant.dat*/


/*case 10600000:*/
/* BEGIN - DIF BPF register values from 106_quant.dat*/
{10600000, DIF_BPF_COEFF01,    0x0000fffd},
{10600000, DIF_BPF_COEFF23,    0x00020012},
{10600000, DIF_BPF_COEFF45,    0x0007ffcd},
{10600000, DIF_BPF_COEFF67,    0xffc9004c},
{10600000, DIF_BPF_COEFF89,    0x00a4ffd9},
{10600000, DIF_BPF_COEFF1011,  0xfec3ff82},
{10600000, DIF_BPF_COEFF1213,  0x01b401c1},
{10600000, DIF_BPF_COEFF1415,  0xfe76fc97},
{10600000, DIF_BPF_COEFF1617,  0x004404d2},
{10600000, DIF_BPF_COEFF1819,  0x0245fae8},
{10600000, DIF_BPF_COEFF2021,  0xfa5f0370},
{10600000, DIF_BPF_COEFF2223,  0x08c1005f},
{10600000, DIF_BPF_COEFF2425,  0xf5bcfa52},
{10600000, DIF_BPF_COEFF2627,  0x09020b04},
{10600000, DIF_BPF_COEFF2829,  0xfb60f17b},
{10600000, DIF_BPF_COEFF3031,  0xfde70ea6},
{10600000, DIF_BPF_COEFF3233,  0x095df51e},
{10600000, DIF_BPF_COEFF3435,  0xf10c0405},
{10600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 106_quant.dat*/


/*case 10700000:*/
/* BEGIN - DIF BPF register values from 107_quant.dat*/
{10700000, DIF_BPF_COEFF01,    0x0000fffd},
{10700000, DIF_BPF_COEFF23,    0xffff0011},
{10700000, DIF_BPF_COEFF45,    0x0014ffdb},
{10700000, DIF_BPF_COEFF67,    0xffb40023},
{10700000, DIF_BPF_COEFF89,    0x00b2002a},
{10700000, DIF_BPF_COEFF1011,  0xfedbff10},
{10700000, DIF_BPF_COEFF1213,  0x0150022d},
{10700000, DIF_BPF_COEFF1415,  0xff38fc6f},
{10700000, DIF_BPF_COEFF1617,  0xff36047b},
{10700000, DIF_BPF_COEFF1819,  0x035efbda},
{10700000, DIF_BPF_COEFF2021,  0xf9940202},
{10700000, DIF_BPF_COEFF2223,  0x08ee01f5},
{10700000, DIF_BPF_COEFF2425,  0xf649f8fe},
{10700000, DIF_BPF_COEFF2627,  0x07e10bc2},
{10700000, DIF_BPF_COEFF2829,  0xfcb6f169},
{10700000, DIF_BPF_COEFF3031,  0xfcc60e42},
{10700000, DIF_BPF_COEFF3233,  0x0a04f599},
{10700000, DIF_BPF_COEFF3435,  0xf0db03d0},
{10700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 107_quant.dat*/


/*case 10800000:*/
/* BEGIN - DIF BPF register values from 108_quant.dat*/
{10800000, DIF_BPF_COEFF01,    0x0000fffd},
{10800000, DIF_BPF_COEFF23,    0xfffb000d},
{10800000, DIF_BPF_COEFF45,    0x001dffed},
{10800000, DIF_BPF_COEFF67,    0xffaafff5},
{10800000, DIF_BPF_COEFF89,    0x00aa0077},
{10800000, DIF_BPF_COEFF1011,  0xff13feb6},
{10800000, DIF_BPF_COEFF1213,  0x00ce026b},
{10800000, DIF_BPF_COEFF1415,  0x000afc85},
{10800000, DIF_BPF_COEFF1617,  0xfe3503e3},
{10800000, DIF_BPF_COEFF1819,  0x044cfcfb},
{10800000, DIF_BPF_COEFF2021,  0xf90c0082},
{10800000, DIF_BPF_COEFF2223,  0x08d5037f},
{10800000, DIF_BPF_COEFF2425,  0xf710f7cc},
{10800000, DIF_BPF_COEFF2627,  0x069f0c59},
{10800000, DIF_BPF_COEFF2829,  0xfe16f173},
{10800000, DIF_BPF_COEFF3031,  0xfbaa0dcf},
{10800000, DIF_BPF_COEFF3233,  0x0aa5f617},
{10800000, DIF_BPF_COEFF3435,  0xf0ad039b},
{10800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 108_quant.dat*/


/*case 10900000:*/
/* BEGIN - DIF BPF register values from 109_quant.dat*/
{10900000, DIF_BPF_COEFF01,    0x0000fffe},
{10900000, DIF_BPF_COEFF23,    0xfff90006},
{10900000, DIF_BPF_COEFF45,    0x00210003},
{10900000, DIF_BPF_COEFF67,    0xffacffc8},
{10900000, DIF_BPF_COEFF89,    0x008e00b6},
{10900000, DIF_BPF_COEFF1011,  0xff63fe7c},
{10900000, DIF_BPF_COEFF1213,  0x003a0275},
{10900000, DIF_BPF_COEFF1415,  0x00dafcda},
{10900000, DIF_BPF_COEFF1617,  0xfd510313},
{10900000, DIF_BPF_COEFF1819,  0x0501fe40},
{10900000, DIF_BPF_COEFF2021,  0xf8cbfefd},
{10900000, DIF_BPF_COEFF2223,  0x087604f0},
{10900000, DIF_BPF_COEFF2425,  0xf80af6c2},
{10900000, DIF_BPF_COEFF2627,  0x05430cc8},
{10900000, DIF_BPF_COEFF2829,  0xff7af19a},
{10900000, DIF_BPF_COEFF3031,  0xfa940d4e},
{10900000, DIF_BPF_COEFF3233,  0x0b3ff699},
{10900000, DIF_BPF_COEFF3435,  0xf0810365},
{10900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 109_quant.dat*/


/*case 11000000:*/
/* BEGIN - DIF BPF register values from 110_quant.dat*/
{11000000, DIF_BPF_COEFF01,    0x0001ffff},
{11000000, DIF_BPF_COEFF23,    0xfff8ffff},
{11000000, DIF_BPF_COEFF45,    0x00210018},
{11000000, DIF_BPF_COEFF67,    0xffbaffa3},
{11000000, DIF_BPF_COEFF89,    0x006000e1},
{11000000, DIF_BPF_COEFF1011,  0xffc4fe68},
{11000000, DIF_BPF_COEFF1213,  0xffa0024b},
{11000000, DIF_BPF_COEFF1415,  0x019afd66},
{11000000, DIF_BPF_COEFF1617,  0xfc990216},
{11000000, DIF_BPF_COEFF1819,  0x0575ff99},
{11000000, DIF_BPF_COEFF2021,  0xf8d4fd81},
{11000000, DIF_BPF_COEFF2223,  0x07d40640},
{11000000, DIF_BPF_COEFF2425,  0xf932f5e6},
{11000000, DIF_BPF_COEFF2627,  0x03d20d0d},
{11000000, DIF_BPF_COEFF2829,  0x00dff1de},
{11000000, DIF_BPF_COEFF3031,  0xf9860cbf},
{11000000, DIF_BPF_COEFF3233,  0x0bd1f71e},
{11000000, DIF_BPF_COEFF3435,  0xf058032f},
{11000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 110_quant.dat*/


/*case 11100000:*/
/* BEGIN - DIF BPF register values from 111_quant.dat*/
{11100000, DIF_BPF_COEFF01,    0x00010000},
{11100000, DIF_BPF_COEFF23,    0xfff8fff8},
{11100000, DIF_BPF_COEFF45,    0x001b0029},
{11100000, DIF_BPF_COEFF67,    0xffd1ff8a},
{11100000, DIF_BPF_COEFF89,    0x002600f2},
{11100000, DIF_BPF_COEFF1011,  0x002cfe7c},
{11100000, DIF_BPF_COEFF1213,  0xff0f01f0},
{11100000, DIF_BPF_COEFF1415,  0x023bfe20},
{11100000, DIF_BPF_COEFF1617,  0xfc1700fa},
{11100000, DIF_BPF_COEFF1819,  0x05a200f7},
{11100000, DIF_BPF_COEFF2021,  0xf927fc1c},
{11100000, DIF_BPF_COEFF2223,  0x06f40765},
{11100000, DIF_BPF_COEFF2425,  0xfa82f53b},
{11100000, DIF_BPF_COEFF2627,  0x02510d27},
{11100000, DIF_BPF_COEFF2829,  0x0243f23d},
{11100000, DIF_BPF_COEFF3031,  0xf8810c24},
{11100000, DIF_BPF_COEFF3233,  0x0c5cf7a7},
{11100000, DIF_BPF_COEFF3435,  0xf03102fa},
{11100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 111_quant.dat*/


/*case 11200000:*/
/* BEGIN - DIF BPF register values from 112_quant.dat*/
{11200000, DIF_BPF_COEFF01,    0x00010002},
{11200000, DIF_BPF_COEFF23,    0xfffafff2},
{11200000, DIF_BPF_COEFF45,    0x00110035},
{11200000, DIF_BPF_COEFF67,    0xfff0ff81},
{11200000, DIF_BPF_COEFF89,    0xffe700e7},
{11200000, DIF_BPF_COEFF1011,  0x008ffeb6},
{11200000, DIF_BPF_COEFF1213,  0xfe94016d},
{11200000, DIF_BPF_COEFF1415,  0x02b0fefb},
{11200000, DIF_BPF_COEFF1617,  0xfbd3ffd1},
{11200000, DIF_BPF_COEFF1819,  0x05850249},
{11200000, DIF_BPF_COEFF2021,  0xf9c1fadb},
{11200000, DIF_BPF_COEFF2223,  0x05de0858},
{11200000, DIF_BPF_COEFF2425,  0xfbf2f4c4},
{11200000, DIF_BPF_COEFF2627,  0x00c70d17},
{11200000, DIF_BPF_COEFF2829,  0x03a0f2b8},
{11200000, DIF_BPF_COEFF3031,  0xf7870b7c},
{11200000, DIF_BPF_COEFF3233,  0x0cdff833},
{11200000, DIF_BPF_COEFF3435,  0xf00d02c4},
{11200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 112_quant.dat*/


/*case 11300000:*/
/* BEGIN - DIF BPF register values from 113_quant.dat*/
{11300000, DIF_BPF_COEFF01,    0x00000003},
{11300000, DIF_BPF_COEFF23,    0xfffdffee},
{11300000, DIF_BPF_COEFF45,    0x00040038},
{11300000, DIF_BPF_COEFF67,    0x0010ff88},
{11300000, DIF_BPF_COEFF89,    0xffac00c2},
{11300000, DIF_BPF_COEFF1011,  0x00e2ff10},
{11300000, DIF_BPF_COEFF1213,  0xfe3900cb},
{11300000, DIF_BPF_COEFF1415,  0x02f1ffe9},
{11300000, DIF_BPF_COEFF1617,  0xfbd3feaa},
{11300000, DIF_BPF_COEFF1819,  0x05210381},
{11300000, DIF_BPF_COEFF2021,  0xfa9cf9c8},
{11300000, DIF_BPF_COEFF2223,  0x04990912},
{11300000, DIF_BPF_COEFF2425,  0xfd7af484},
{11300000, DIF_BPF_COEFF2627,  0xff390cdb},
{11300000, DIF_BPF_COEFF2829,  0x04f4f34d},
{11300000, DIF_BPF_COEFF3031,  0xf69a0ac9},
{11300000, DIF_BPF_COEFF3233,  0x0d5af8c1},
{11300000, DIF_BPF_COEFF3435,  0xefec028e},
{11300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 113_quant.dat*/


/*case 11400000:*/
/* BEGIN - DIF BPF register values from 114_quant.dat*/
{11400000, DIF_BPF_COEFF01,    0x00000003},
{11400000, DIF_BPF_COEFF23,    0x0000ffee},
{11400000, DIF_BPF_COEFF45,    0xfff60033},
{11400000, DIF_BPF_COEFF67,    0x002fff9f},
{11400000, DIF_BPF_COEFF89,    0xff7b0087},
{11400000, DIF_BPF_COEFF1011,  0x011eff82},
{11400000, DIF_BPF_COEFF1213,  0xfe080018},
{11400000, DIF_BPF_COEFF1415,  0x02f900d8},
{11400000, DIF_BPF_COEFF1617,  0xfc17fd96},
{11400000, DIF_BPF_COEFF1819,  0x04790490},
{11400000, DIF_BPF_COEFF2021,  0xfbadf8ed},
{11400000, DIF_BPF_COEFF2223,  0x032f098e},
{11400000, DIF_BPF_COEFF2425,  0xff10f47d},
{11400000, DIF_BPF_COEFF2627,  0xfdaf0c75},
{11400000, DIF_BPF_COEFF2829,  0x063cf3fc},
{11400000, DIF_BPF_COEFF3031,  0xf5ba0a0b},
{11400000, DIF_BPF_COEFF3233,  0x0dccf952},
{11400000, DIF_BPF_COEFF3435,  0xefcd0258},
{11400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 114_quant.dat*/


/*case 11500000:*/
/* BEGIN - DIF BPF register values from 115_quant.dat*/
{11500000, DIF_BPF_COEFF01,    0x00000003},
{11500000, DIF_BPF_COEFF23,    0x0004fff1},
{11500000, DIF_BPF_COEFF45,    0xffea0026},
{11500000, DIF_BPF_COEFF67,    0x0046ffc3},
{11500000, DIF_BPF_COEFF89,    0xff5a003c},
{11500000, DIF_BPF_COEFF1011,  0x013b0000},
{11500000, DIF_BPF_COEFF1213,  0xfe04ff63},
{11500000, DIF_BPF_COEFF1415,  0x02c801b8},
{11500000, DIF_BPF_COEFF1617,  0xfc99fca6},
{11500000, DIF_BPF_COEFF1819,  0x0397056a},
{11500000, DIF_BPF_COEFF2021,  0xfcecf853},
{11500000, DIF_BPF_COEFF2223,  0x01ad09c9},
{11500000, DIF_BPF_COEFF2425,  0x00acf4ad},
{11500000, DIF_BPF_COEFF2627,  0xfc2e0be7},
{11500000, DIF_BPF_COEFF2829,  0x0773f4c2},
{11500000, DIF_BPF_COEFF3031,  0xf4e90943},
{11500000, DIF_BPF_COEFF3233,  0x0e35f9e6},
{11500000, DIF_BPF_COEFF3435,  0xefb10221},
{11500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 115_quant.dat*/


/*case 11600000:*/
/* BEGIN - DIF BPF register values from 116_quant.dat*/
{11600000, DIF_BPF_COEFF01,    0x00000002},
{11600000, DIF_BPF_COEFF23,    0x0007fff6},
{11600000, DIF_BPF_COEFF45,    0xffe20014},
{11600000, DIF_BPF_COEFF67,    0x0054ffee},
{11600000, DIF_BPF_COEFF89,    0xff4effeb},
{11600000, DIF_BPF_COEFF1011,  0x0137007e},
{11600000, DIF_BPF_COEFF1213,  0xfe2efebb},
{11600000, DIF_BPF_COEFF1415,  0x0260027a},
{11600000, DIF_BPF_COEFF1617,  0xfd51fbe6},
{11600000, DIF_BPF_COEFF1819,  0x02870605},
{11600000, DIF_BPF_COEFF2021,  0xfe4af7fe},
{11600000, DIF_BPF_COEFF2223,  0x001d09c1},
{11600000, DIF_BPF_COEFF2425,  0x0243f515},
{11600000, DIF_BPF_COEFF2627,  0xfabd0b32},
{11600000, DIF_BPF_COEFF2829,  0x0897f59e},
{11600000, DIF_BPF_COEFF3031,  0xf4280871},
{11600000, DIF_BPF_COEFF3233,  0x0e95fa7c},
{11600000, DIF_BPF_COEFF3435,  0xef9701eb},
{11600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 116_quant.dat*/


/*case 11700000:*/
/* BEGIN - DIF BPF register values from 117_quant.dat*/
{11700000, DIF_BPF_COEFF01,    0xffff0001},
{11700000, DIF_BPF_COEFF23,    0x0008fffd},
{11700000, DIF_BPF_COEFF45,    0xffdeffff},
{11700000, DIF_BPF_COEFF67,    0x0056001d},
{11700000, DIF_BPF_COEFF89,    0xff57ff9c},
{11700000, DIF_BPF_COEFF1011,  0x011300f0},
{11700000, DIF_BPF_COEFF1213,  0xfe82fe2e},
{11700000, DIF_BPF_COEFF1415,  0x01ca0310},
{11700000, DIF_BPF_COEFF1617,  0xfe35fb62},
{11700000, DIF_BPF_COEFF1819,  0x0155065a},
{11700000, DIF_BPF_COEFF2021,  0xffbaf7f2},
{11700000, DIF_BPF_COEFF2223,  0xfe8c0977},
{11700000, DIF_BPF_COEFF2425,  0x03cef5b2},
{11700000, DIF_BPF_COEFF2627,  0xf9610a58},
{11700000, DIF_BPF_COEFF2829,  0x09a5f68f},
{11700000, DIF_BPF_COEFF3031,  0xf3790797},
{11700000, DIF_BPF_COEFF3233,  0x0eebfb14},
{11700000, DIF_BPF_COEFF3435,  0xef8001b5},
{11700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 117_quant.dat*/


/*case 11800000:*/
/* BEGIN - DIF BPF register values from 118_quant.dat*/
{11800000, DIF_BPF_COEFF01,    0xffff0000},
{11800000, DIF_BPF_COEFF23,    0x00080004},
{11800000, DIF_BPF_COEFF45,    0xffe0ffe9},
{11800000, DIF_BPF_COEFF67,    0x004c0047},
{11800000, DIF_BPF_COEFF89,    0xff75ff58},
{11800000, DIF_BPF_COEFF1011,  0x00d1014a},
{11800000, DIF_BPF_COEFF1213,  0xfef9fdc8},
{11800000, DIF_BPF_COEFF1415,  0x0111036f},
{11800000, DIF_BPF_COEFF1617,  0xff36fb21},
{11800000, DIF_BPF_COEFF1819,  0x00120665},
{11800000, DIF_BPF_COEFF2021,  0x012df82e},
{11800000, DIF_BPF_COEFF2223,  0xfd0708ec},
{11800000, DIF_BPF_COEFF2425,  0x0542f682},
{11800000, DIF_BPF_COEFF2627,  0xf81f095c},
{11800000, DIF_BPF_COEFF2829,  0x0a9af792},
{11800000, DIF_BPF_COEFF3031,  0xf2db06b5},
{11800000, DIF_BPF_COEFF3233,  0x0f38fbad},
{11800000, DIF_BPF_COEFF3435,  0xef6c017e},
{11800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 118_quant.dat*/


/*case 11900000:*/
/* BEGIN - DIF BPF register values from 119_quant.dat*/
{11900000, DIF_BPF_COEFF01,    0xffffffff},
{11900000, DIF_BPF_COEFF23,    0x0007000b},
{11900000, DIF_BPF_COEFF45,    0xffe7ffd8},
{11900000, DIF_BPF_COEFF67,    0x00370068},
{11900000, DIF_BPF_COEFF89,    0xffa4ff28},
{11900000, DIF_BPF_COEFF1011,  0x00790184},
{11900000, DIF_BPF_COEFF1213,  0xff87fd91},
{11900000, DIF_BPF_COEFF1415,  0x00430392},
{11900000, DIF_BPF_COEFF1617,  0x0044fb26},
{11900000, DIF_BPF_COEFF1819,  0xfece0626},
{11900000, DIF_BPF_COEFF2021,  0x0294f8b2},
{11900000, DIF_BPF_COEFF2223,  0xfb990825},
{11900000, DIF_BPF_COEFF2425,  0x0698f77f},
{11900000, DIF_BPF_COEFF2627,  0xf6fe0842},
{11900000, DIF_BPF_COEFF2829,  0x0b73f8a7},
{11900000, DIF_BPF_COEFF3031,  0xf25105cd},
{11900000, DIF_BPF_COEFF3233,  0x0f7bfc48},
{11900000, DIF_BPF_COEFF3435,  0xef5a0148},
{11900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 119_quant.dat*/


/*case 12000000:*/
/* BEGIN - DIF BPF register values from 120_quant.dat*/
{12000000, DIF_BPF_COEFF01,    0x0000fffe},
{12000000, DIF_BPF_COEFF23,    0x00050010},
{12000000, DIF_BPF_COEFF45,    0xfff2ffcc},
{12000000, DIF_BPF_COEFF67,    0x001b007b},
{12000000, DIF_BPF_COEFF89,    0xffdfff10},
{12000000, DIF_BPF_COEFF1011,  0x00140198},
{12000000, DIF_BPF_COEFF1213,  0x0020fd8e},
{12000000, DIF_BPF_COEFF1415,  0xff710375},
{12000000, DIF_BPF_COEFF1617,  0x014dfb73},
{12000000, DIF_BPF_COEFF1819,  0xfd9a059f},
{12000000, DIF_BPF_COEFF2021,  0x03e0f978},
{12000000, DIF_BPF_COEFF2223,  0xfa4e0726},
{12000000, DIF_BPF_COEFF2425,  0x07c8f8a7},
{12000000, DIF_BPF_COEFF2627,  0xf600070c},
{12000000, DIF_BPF_COEFF2829,  0x0c2ff9c9},
{12000000, DIF_BPF_COEFF3031,  0xf1db04de},
{12000000, DIF_BPF_COEFF3233,  0x0fb4fce5},
{12000000, DIF_BPF_COEFF3435,  0xef4b0111},
{12000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 120_quant.dat*/


/*case 12100000:*/
/* BEGIN - DIF BPF register values from 121_quant.dat*/
{12100000, DIF_BPF_COEFF01,    0x0000fffd},
{12100000, DIF_BPF_COEFF23,    0x00010012},
{12100000, DIF_BPF_COEFF45,    0xffffffc8},
{12100000, DIF_BPF_COEFF67,    0xfffb007e},
{12100000, DIF_BPF_COEFF89,    0x001dff14},
{12100000, DIF_BPF_COEFF1011,  0xffad0184},
{12100000, DIF_BPF_COEFF1213,  0x00b7fdbe},
{12100000, DIF_BPF_COEFF1415,  0xfea9031b},
{12100000, DIF_BPF_COEFF1617,  0x0241fc01},
{12100000, DIF_BPF_COEFF1819,  0xfc8504d6},
{12100000, DIF_BPF_COEFF2021,  0x0504fa79},
{12100000, DIF_BPF_COEFF2223,  0xf93005f6},
{12100000, DIF_BPF_COEFF2425,  0x08caf9f2},
{12100000, DIF_BPF_COEFF2627,  0xf52b05c0},
{12100000, DIF_BPF_COEFF2829,  0x0ccbfaf9},
{12100000, DIF_BPF_COEFF3031,  0xf17903eb},
{12100000, DIF_BPF_COEFF3233,  0x0fe3fd83},
{12100000, DIF_BPF_COEFF3435,  0xef3f00db},
{12100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 121_quant.dat*/


/*case 12200000:*/
/* BEGIN - DIF BPF register values from 122_quant.dat*/
{12200000, DIF_BPF_COEFF01,    0x0000fffd},
{12200000, DIF_BPF_COEFF23,    0xfffe0011},
{12200000, DIF_BPF_COEFF45,    0x000cffcc},
{12200000, DIF_BPF_COEFF67,    0xffdb0071},
{12200000, DIF_BPF_COEFF89,    0x0058ff32},
{12200000, DIF_BPF_COEFF1011,  0xff4f014a},
{12200000, DIF_BPF_COEFF1213,  0x013cfe1f},
{12200000, DIF_BPF_COEFF1415,  0xfdfb028a},
{12200000, DIF_BPF_COEFF1617,  0x0311fcc9},
{12200000, DIF_BPF_COEFF1819,  0xfb9d03d6},
{12200000, DIF_BPF_COEFF2021,  0x05f4fbad},
{12200000, DIF_BPF_COEFF2223,  0xf848049d},
{12200000, DIF_BPF_COEFF2425,  0x0999fb5b},
{12200000, DIF_BPF_COEFF2627,  0xf4820461},
{12200000, DIF_BPF_COEFF2829,  0x0d46fc32},
{12200000, DIF_BPF_COEFF3031,  0xf12d02f4},
{12200000, DIF_BPF_COEFF3233,  0x1007fe21},
{12200000, DIF_BPF_COEFF3435,  0xef3600a4},
{12200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 122_quant.dat*/


/*case 12300000:*/
/* BEGIN - DIF BPF register values from 123_quant.dat*/
{12300000, DIF_BPF_COEFF01,    0x0000fffe},
{12300000, DIF_BPF_COEFF23,    0xfffa000e},
{12300000, DIF_BPF_COEFF45,    0x0017ffd9},
{12300000, DIF_BPF_COEFF67,    0xffc10055},
{12300000, DIF_BPF_COEFF89,    0x0088ff68},
{12300000, DIF_BPF_COEFF1011,  0xff0400f0},
{12300000, DIF_BPF_COEFF1213,  0x01a6fea7},
{12300000, DIF_BPF_COEFF1415,  0xfd7501cc},
{12300000, DIF_BPF_COEFF1617,  0x03b0fdc0},
{12300000, DIF_BPF_COEFF1819,  0xfaef02a8},
{12300000, DIF_BPF_COEFF2021,  0x06a7fd07},
{12300000, DIF_BPF_COEFF2223,  0xf79d0326},
{12300000, DIF_BPF_COEFF2425,  0x0a31fcda},
{12300000, DIF_BPF_COEFF2627,  0xf40702f3},
{12300000, DIF_BPF_COEFF2829,  0x0d9ffd72},
{12300000, DIF_BPF_COEFF3031,  0xf0f601fa},
{12300000, DIF_BPF_COEFF3233,  0x1021fec0},
{12300000, DIF_BPF_COEFF3435,  0xef2f006d},
{12300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 123_quant.dat*/


/*case 12400000:*/
/* BEGIN - DIF BPF register values from 124_quant.dat*/
{12400000, DIF_BPF_COEFF01,    0x0001ffff},
{12400000, DIF_BPF_COEFF23,    0xfff80007},
{12400000, DIF_BPF_COEFF45,    0x001fffeb},
{12400000, DIF_BPF_COEFF67,    0xffaf002d},
{12400000, DIF_BPF_COEFF89,    0x00a8ffb0},
{12400000, DIF_BPF_COEFF1011,  0xfed3007e},
{12400000, DIF_BPF_COEFF1213,  0x01e9ff4c},
{12400000, DIF_BPF_COEFF1415,  0xfd2000ee},
{12400000, DIF_BPF_COEFF1617,  0x0413fed8},
{12400000, DIF_BPF_COEFF1819,  0xfa82015c},
{12400000, DIF_BPF_COEFF2021,  0x0715fe7d},
{12400000, DIF_BPF_COEFF2223,  0xf7340198},
{12400000, DIF_BPF_COEFF2425,  0x0a8dfe69},
{12400000, DIF_BPF_COEFF2627,  0xf3bd017c},
{12400000, DIF_BPF_COEFF2829,  0x0dd5feb8},
{12400000, DIF_BPF_COEFF3031,  0xf0d500fd},
{12400000, DIF_BPF_COEFF3233,  0x1031ff60},
{12400000, DIF_BPF_COEFF3435,  0xef2b0037},
{12400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 124_quant.dat*/


/*case 12500000:*/
/* BEGIN - DIF BPF register values from 125_quant.dat*/
{12500000, DIF_BPF_COEFF01,    0x00010000},
{12500000, DIF_BPF_COEFF23,    0xfff70000},
{12500000, DIF_BPF_COEFF45,    0x00220000},
{12500000, DIF_BPF_COEFF67,    0xffa90000},
{12500000, DIF_BPF_COEFF89,    0x00b30000},
{12500000, DIF_BPF_COEFF1011,  0xfec20000},
{12500000, DIF_BPF_COEFF1213,  0x02000000},
{12500000, DIF_BPF_COEFF1415,  0xfd030000},
{12500000, DIF_BPF_COEFF1617,  0x04350000},
{12500000, DIF_BPF_COEFF1819,  0xfa5e0000},
{12500000, DIF_BPF_COEFF2021,  0x073b0000},
{12500000, DIF_BPF_COEFF2223,  0xf7110000},
{12500000, DIF_BPF_COEFF2425,  0x0aac0000},
{12500000, DIF_BPF_COEFF2627,  0xf3a40000},
{12500000, DIF_BPF_COEFF2829,  0x0de70000},
{12500000, DIF_BPF_COEFF3031,  0xf0c90000},
{12500000, DIF_BPF_COEFF3233,  0x10360000},
{12500000, DIF_BPF_COEFF3435,  0xef290000},
{12500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 125_quant.dat*/


/*case 12600000:*/
/* BEGIN - DIF BPF register values from 126_quant.dat*/
{12600000, DIF_BPF_COEFF01,    0x00010001},
{12600000, DIF_BPF_COEFF23,    0xfff8fff9},
{12600000, DIF_BPF_COEFF45,    0x001f0015},
{12600000, DIF_BPF_COEFF67,    0xffafffd3},
{12600000, DIF_BPF_COEFF89,    0x00a80050},
{12600000, DIF_BPF_COEFF1011,  0xfed3ff82},
{12600000, DIF_BPF_COEFF1213,  0x01e900b4},
{12600000, DIF_BPF_COEFF1415,  0xfd20ff12},
{12600000, DIF_BPF_COEFF1617,  0x04130128},
{12600000, DIF_BPF_COEFF1819,  0xfa82fea4},
{12600000, DIF_BPF_COEFF2021,  0x07150183},
{12600000, DIF_BPF_COEFF2223,  0xf734fe68},
{12600000, DIF_BPF_COEFF2425,  0x0a8d0197},
{12600000, DIF_BPF_COEFF2627,  0xf3bdfe84},
{12600000, DIF_BPF_COEFF2829,  0x0dd50148},
{12600000, DIF_BPF_COEFF3031,  0xf0d5ff03},
{12600000, DIF_BPF_COEFF3233,  0x103100a0},
{12600000, DIF_BPF_COEFF3435,  0xef2bffc9},
{12600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 126_quant.dat*/


/*case 12700000:*/
/* BEGIN - DIF BPF register values from 127_quant.dat*/
{12700000, DIF_BPF_COEFF01,    0x00000002},
{12700000, DIF_BPF_COEFF23,    0xfffafff2},
{12700000, DIF_BPF_COEFF45,    0x00170027},
{12700000, DIF_BPF_COEFF67,    0xffc1ffab},
{12700000, DIF_BPF_COEFF89,    0x00880098},
{12700000, DIF_BPF_COEFF1011,  0xff04ff10},
{12700000, DIF_BPF_COEFF1213,  0x01a60159},
{12700000, DIF_BPF_COEFF1415,  0xfd75fe34},
{12700000, DIF_BPF_COEFF1617,  0x03b00240},
{12700000, DIF_BPF_COEFF1819,  0xfaeffd58},
{12700000, DIF_BPF_COEFF2021,  0x06a702f9},
{12700000, DIF_BPF_COEFF2223,  0xf79dfcda},
{12700000, DIF_BPF_COEFF2425,  0x0a310326},
{12700000, DIF_BPF_COEFF2627,  0xf407fd0d},
{12700000, DIF_BPF_COEFF2829,  0x0d9f028e},
{12700000, DIF_BPF_COEFF3031,  0xf0f6fe06},
{12700000, DIF_BPF_COEFF3233,  0x10210140},
{12700000, DIF_BPF_COEFF3435,  0xef2fff93},
{12700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 127_quant.dat*/


/*case 12800000:*/
/* BEGIN - DIF BPF register values from 128_quant.dat*/
{12800000, DIF_BPF_COEFF01,    0x00000003},
{12800000, DIF_BPF_COEFF23,    0xfffeffef},
{12800000, DIF_BPF_COEFF45,    0x000c0034},
{12800000, DIF_BPF_COEFF67,    0xffdbff8f},
{12800000, DIF_BPF_COEFF89,    0x005800ce},
{12800000, DIF_BPF_COEFF1011,  0xff4ffeb6},
{12800000, DIF_BPF_COEFF1213,  0x013c01e1},
{12800000, DIF_BPF_COEFF1415,  0xfdfbfd76},
{12800000, DIF_BPF_COEFF1617,  0x03110337},
{12800000, DIF_BPF_COEFF1819,  0xfb9dfc2a},
{12800000, DIF_BPF_COEFF2021,  0x05f40453},
{12800000, DIF_BPF_COEFF2223,  0xf848fb63},
{12800000, DIF_BPF_COEFF2425,  0x099904a5},
{12800000, DIF_BPF_COEFF2627,  0xf482fb9f},
{12800000, DIF_BPF_COEFF2829,  0x0d4603ce},
{12800000, DIF_BPF_COEFF3031,  0xf12dfd0c},
{12800000, DIF_BPF_COEFF3233,  0x100701df},
{12800000, DIF_BPF_COEFF3435,  0xef36ff5c},
{12800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 128_quant.dat*/


/*case 12900000:*/
/* BEGIN - DIF BPF register values from 129_quant.dat*/
{12900000, DIF_BPF_COEFF01,    0x00000003},
{12900000, DIF_BPF_COEFF23,    0x0001ffee},
{12900000, DIF_BPF_COEFF45,    0xffff0038},
{12900000, DIF_BPF_COEFF67,    0xfffbff82},
{12900000, DIF_BPF_COEFF89,    0x001d00ec},
{12900000, DIF_BPF_COEFF1011,  0xffadfe7c},
{12900000, DIF_BPF_COEFF1213,  0x00b70242},
{12900000, DIF_BPF_COEFF1415,  0xfea9fce5},
{12900000, DIF_BPF_COEFF1617,  0x024103ff},
{12900000, DIF_BPF_COEFF1819,  0xfc85fb2a},
{12900000, DIF_BPF_COEFF2021,  0x05040587},
{12900000, DIF_BPF_COEFF2223,  0xf930fa0a},
{12900000, DIF_BPF_COEFF2425,  0x08ca060e},
{12900000, DIF_BPF_COEFF2627,  0xf52bfa40},
{12900000, DIF_BPF_COEFF2829,  0x0ccb0507},
{12900000, DIF_BPF_COEFF3031,  0xf179fc15},
{12900000, DIF_BPF_COEFF3233,  0x0fe3027d},
{12900000, DIF_BPF_COEFF3435,  0xef3fff25},
{12900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 129_quant.dat*/


/*case 113000000:*/
/* BEGIN - DIF BPF register values from 130_quant.dat*/
{13000000, DIF_BPF_COEFF01,    0x00000002},
{13000000, DIF_BPF_COEFF23,    0x0005fff0},
{13000000, DIF_BPF_COEFF45,    0xfff20034},
{13000000, DIF_BPF_COEFF67,    0x001bff85},
{13000000, DIF_BPF_COEFF89,    0xffdf00f0},
{13000000, DIF_BPF_COEFF1011,  0x0014fe68},
{13000000, DIF_BPF_COEFF1213,  0x00200272},
{13000000, DIF_BPF_COEFF1415,  0xff71fc8b},
{13000000, DIF_BPF_COEFF1617,  0x014d048d},
{13000000, DIF_BPF_COEFF1819,  0xfd9afa61},
{13000000, DIF_BPF_COEFF2021,  0x03e00688},
{13000000, DIF_BPF_COEFF2223,  0xfa4ef8da},
{13000000, DIF_BPF_COEFF2425,  0x07c80759},
{13000000, DIF_BPF_COEFF2627,  0xf600f8f4},
{13000000, DIF_BPF_COEFF2829,  0x0c2f0637},
{13000000, DIF_BPF_COEFF3031,  0xf1dbfb22},
{13000000, DIF_BPF_COEFF3233,  0x0fb4031b},
{13000000, DIF_BPF_COEFF3435,  0xef4bfeef},
{13000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 130_quant.dat*/


/*case 13100000:*/
/* BEGIN - DIF BPF register values from 131_quant.dat*/
{13100000, DIF_BPF_COEFF01,    0xffff0001},
{13100000, DIF_BPF_COEFF23,    0x0007fff5},
{13100000, DIF_BPF_COEFF45,    0xffe70028},
{13100000, DIF_BPF_COEFF67,    0x0037ff98},
{13100000, DIF_BPF_COEFF89,    0xffa400d8},
{13100000, DIF_BPF_COEFF1011,  0x0079fe7c},
{13100000, DIF_BPF_COEFF1213,  0xff87026f},
{13100000, DIF_BPF_COEFF1415,  0x0043fc6e},
{13100000, DIF_BPF_COEFF1617,  0x004404da},
{13100000, DIF_BPF_COEFF1819,  0xfecef9da},
{13100000, DIF_BPF_COEFF2021,  0x0294074e},
{13100000, DIF_BPF_COEFF2223,  0xfb99f7db},
{13100000, DIF_BPF_COEFF2425,  0x06980881},
{13100000, DIF_BPF_COEFF2627,  0xf6fef7be},
{13100000, DIF_BPF_COEFF2829,  0x0b730759},
{13100000, DIF_BPF_COEFF3031,  0xf251fa33},
{13100000, DIF_BPF_COEFF3233,  0x0f7b03b8},
{13100000, DIF_BPF_COEFF3435,  0xef5afeb8},
{13100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 131_quant.dat*/


/*case 13200000:*/
/* BEGIN - DIF BPF register values from 132_quant.dat*/
{13200000, DIF_BPF_COEFF01,    0xffff0000},
{13200000, DIF_BPF_COEFF23,    0x0008fffc},
{13200000, DIF_BPF_COEFF45,    0xffe00017},
{13200000, DIF_BPF_COEFF67,    0x004cffb9},
{13200000, DIF_BPF_COEFF89,    0xff7500a8},
{13200000, DIF_BPF_COEFF1011,  0x00d1feb6},
{13200000, DIF_BPF_COEFF1213,  0xfef90238},
{13200000, DIF_BPF_COEFF1415,  0x0111fc91},
{13200000, DIF_BPF_COEFF1617,  0xff3604df},
{13200000, DIF_BPF_COEFF1819,  0x0012f99b},
{13200000, DIF_BPF_COEFF2021,  0x012d07d2},
{13200000, DIF_BPF_COEFF2223,  0xfd07f714},
{13200000, DIF_BPF_COEFF2425,  0x0542097e},
{13200000, DIF_BPF_COEFF2627,  0xf81ff6a4},
{13200000, DIF_BPF_COEFF2829,  0x0a9a086e},
{13200000, DIF_BPF_COEFF3031,  0xf2dbf94b},
{13200000, DIF_BPF_COEFF3233,  0x0f380453},
{13200000, DIF_BPF_COEFF3435,  0xef6cfe82},
{13200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 132_quant.dat*/


/*case 13300000:*/
/* BEGIN - DIF BPF register values from 133_quant.dat*/
{13300000, DIF_BPF_COEFF01,    0xffffffff},
{13300000, DIF_BPF_COEFF23,    0x00080003},
{13300000, DIF_BPF_COEFF45,    0xffde0001},
{13300000, DIF_BPF_COEFF67,    0x0056ffe3},
{13300000, DIF_BPF_COEFF89,    0xff570064},
{13300000, DIF_BPF_COEFF1011,  0x0113ff10},
{13300000, DIF_BPF_COEFF1213,  0xfe8201d2},
{13300000, DIF_BPF_COEFF1415,  0x01cafcf0},
{13300000, DIF_BPF_COEFF1617,  0xfe35049e},
{13300000, DIF_BPF_COEFF1819,  0x0155f9a6},
{13300000, DIF_BPF_COEFF2021,  0xffba080e},
{13300000, DIF_BPF_COEFF2223,  0xfe8cf689},
{13300000, DIF_BPF_COEFF2425,  0x03ce0a4e},
{13300000, DIF_BPF_COEFF2627,  0xf961f5a8},
{13300000, DIF_BPF_COEFF2829,  0x09a50971},
{13300000, DIF_BPF_COEFF3031,  0xf379f869},
{13300000, DIF_BPF_COEFF3233,  0x0eeb04ec},
{13300000, DIF_BPF_COEFF3435,  0xef80fe4b},
{13300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 133_quant.dat*/


/*case 13400000:*/
/* BEGIN - DIF BPF register values from 134_quant.dat*/
{13400000, DIF_BPF_COEFF01,    0x0000fffe},
{13400000, DIF_BPF_COEFF23,    0x0007000a},
{13400000, DIF_BPF_COEFF45,    0xffe2ffec},
{13400000, DIF_BPF_COEFF67,    0x00540012},
{13400000, DIF_BPF_COEFF89,    0xff4e0015},
{13400000, DIF_BPF_COEFF1011,  0x0137ff82},
{13400000, DIF_BPF_COEFF1213,  0xfe2e0145},
{13400000, DIF_BPF_COEFF1415,  0x0260fd86},
{13400000, DIF_BPF_COEFF1617,  0xfd51041a},
{13400000, DIF_BPF_COEFF1819,  0x0287f9fb},
{13400000, DIF_BPF_COEFF2021,  0xfe4a0802},
{13400000, DIF_BPF_COEFF2223,  0x001df63f},
{13400000, DIF_BPF_COEFF2425,  0x02430aeb},
{13400000, DIF_BPF_COEFF2627,  0xfabdf4ce},
{13400000, DIF_BPF_COEFF2829,  0x08970a62},
{13400000, DIF_BPF_COEFF3031,  0xf428f78f},
{13400000, DIF_BPF_COEFF3233,  0x0e950584},
{13400000, DIF_BPF_COEFF3435,  0xef97fe15},
{13400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 134_quant.dat*/


/*case 13500000:*/
/* BEGIN - DIF BPF register values from 135_quant.dat*/
{13500000, DIF_BPF_COEFF01,    0x0000fffd},
{13500000, DIF_BPF_COEFF23,    0x0004000f},
{13500000, DIF_BPF_COEFF45,    0xffeaffda},
{13500000, DIF_BPF_COEFF67,    0x0046003d},
{13500000, DIF_BPF_COEFF89,    0xff5affc4},
{13500000, DIF_BPF_COEFF1011,  0x013b0000},
{13500000, DIF_BPF_COEFF1213,  0xfe04009d},
{13500000, DIF_BPF_COEFF1415,  0x02c8fe48},
{13500000, DIF_BPF_COEFF1617,  0xfc99035a},
{13500000, DIF_BPF_COEFF1819,  0x0397fa96},
{13500000, DIF_BPF_COEFF2021,  0xfcec07ad},
{13500000, DIF_BPF_COEFF2223,  0x01adf637},
{13500000, DIF_BPF_COEFF2425,  0x00ac0b53},
{13500000, DIF_BPF_COEFF2627,  0xfc2ef419},
{13500000, DIF_BPF_COEFF2829,  0x07730b3e},
{13500000, DIF_BPF_COEFF3031,  0xf4e9f6bd},
{13500000, DIF_BPF_COEFF3233,  0x0e35061a},
{13500000, DIF_BPF_COEFF3435,  0xefb1fddf},
{13500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 135_quant.dat*/


/*case 13600000:*/
/* BEGIN - DIF BPF register values from 136_quant.dat*/
{13600000, DIF_BPF_COEFF01,    0x0000fffd},
{13600000, DIF_BPF_COEFF23,    0x00000012},
{13600000, DIF_BPF_COEFF45,    0xfff6ffcd},
{13600000, DIF_BPF_COEFF67,    0x002f0061},
{13600000, DIF_BPF_COEFF89,    0xff7bff79},
{13600000, DIF_BPF_COEFF1011,  0x011e007e},
{13600000, DIF_BPF_COEFF1213,  0xfe08ffe8},
{13600000, DIF_BPF_COEFF1415,  0x02f9ff28},
{13600000, DIF_BPF_COEFF1617,  0xfc17026a},
{13600000, DIF_BPF_COEFF1819,  0x0479fb70},
{13600000, DIF_BPF_COEFF2021,  0xfbad0713},
{13600000, DIF_BPF_COEFF2223,  0x032ff672},
{13600000, DIF_BPF_COEFF2425,  0xff100b83},
{13600000, DIF_BPF_COEFF2627,  0xfdaff38b},
{13600000, DIF_BPF_COEFF2829,  0x063c0c04},
{13600000, DIF_BPF_COEFF3031,  0xf5baf5f5},
{13600000, DIF_BPF_COEFF3233,  0x0dcc06ae},
{13600000, DIF_BPF_COEFF3435,  0xefcdfda8},
{13600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 136_quant.dat*/


/*case 13700000:*/
/* BEGIN - DIF BPF register values from 137_quant.dat*/
{13700000, DIF_BPF_COEFF01,    0x0000fffd},
{13700000, DIF_BPF_COEFF23,    0xfffd0012},
{13700000, DIF_BPF_COEFF45,    0x0004ffc8},
{13700000, DIF_BPF_COEFF67,    0x00100078},
{13700000, DIF_BPF_COEFF89,    0xffacff3e},
{13700000, DIF_BPF_COEFF1011,  0x00e200f0},
{13700000, DIF_BPF_COEFF1213,  0xfe39ff35},
{13700000, DIF_BPF_COEFF1415,  0x02f10017},
{13700000, DIF_BPF_COEFF1617,  0xfbd30156},
{13700000, DIF_BPF_COEFF1819,  0x0521fc7f},
{13700000, DIF_BPF_COEFF2021,  0xfa9c0638},
{13700000, DIF_BPF_COEFF2223,  0x0499f6ee},
{13700000, DIF_BPF_COEFF2425,  0xfd7a0b7c},
{13700000, DIF_BPF_COEFF2627,  0xff39f325},
{13700000, DIF_BPF_COEFF2829,  0x04f40cb3},
{13700000, DIF_BPF_COEFF3031,  0xf69af537},
{13700000, DIF_BPF_COEFF3233,  0x0d5a073f},
{13700000, DIF_BPF_COEFF3435,  0xefecfd72},
{13700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 137_quant.dat*/


/*case 13800000:*/
/* BEGIN - DIF BPF register values from 138_quant.dat*/
{13800000, DIF_BPF_COEFF01,    0x0001fffe},
{13800000, DIF_BPF_COEFF23,    0xfffa000e},
{13800000, DIF_BPF_COEFF45,    0x0011ffcb},
{13800000, DIF_BPF_COEFF67,    0xfff0007f},
{13800000, DIF_BPF_COEFF89,    0xffe7ff19},
{13800000, DIF_BPF_COEFF1011,  0x008f014a},
{13800000, DIF_BPF_COEFF1213,  0xfe94fe93},
{13800000, DIF_BPF_COEFF1415,  0x02b00105},
{13800000, DIF_BPF_COEFF1617,  0xfbd3002f},
{13800000, DIF_BPF_COEFF1819,  0x0585fdb7},
{13800000, DIF_BPF_COEFF2021,  0xf9c10525},
{13800000, DIF_BPF_COEFF2223,  0x05def7a8},
{13800000, DIF_BPF_COEFF2425,  0xfbf20b3c},
{13800000, DIF_BPF_COEFF2627,  0x00c7f2e9},
{13800000, DIF_BPF_COEFF2829,  0x03a00d48},
{13800000, DIF_BPF_COEFF3031,  0xf787f484},
{13800000, DIF_BPF_COEFF3233,  0x0cdf07cd},
{13800000, DIF_BPF_COEFF3435,  0xf00dfd3c},
{13800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 138_quant.dat*/


/*case 13900000:*/
/* BEGIN - DIF BPF register values from 139_quant.dat*/
{13900000, DIF_BPF_COEFF01,    0x00010000},
{13900000, DIF_BPF_COEFF23,    0xfff80008},
{13900000, DIF_BPF_COEFF45,    0x001bffd7},
{13900000, DIF_BPF_COEFF67,    0xffd10076},
{13900000, DIF_BPF_COEFF89,    0x0026ff0e},
{13900000, DIF_BPF_COEFF1011,  0x002c0184},
{13900000, DIF_BPF_COEFF1213,  0xff0ffe10},
{13900000, DIF_BPF_COEFF1415,  0x023b01e0},
{13900000, DIF_BPF_COEFF1617,  0xfc17ff06},
{13900000, DIF_BPF_COEFF1819,  0x05a2ff09},
{13900000, DIF_BPF_COEFF2021,  0xf92703e4},
{13900000, DIF_BPF_COEFF2223,  0x06f4f89b},
{13900000, DIF_BPF_COEFF2425,  0xfa820ac5},
{13900000, DIF_BPF_COEFF2627,  0x0251f2d9},
{13900000, DIF_BPF_COEFF2829,  0x02430dc3},
{13900000, DIF_BPF_COEFF3031,  0xf881f3dc},
{13900000, DIF_BPF_COEFF3233,  0x0c5c0859},
{13900000, DIF_BPF_COEFF3435,  0xf031fd06},
{13900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 139_quant.dat*/


/*case 14000000:*/
/* BEGIN - DIF BPF register values from 140_quant.dat*/
{14000000, DIF_BPF_COEFF01,    0x00010001},
{14000000, DIF_BPF_COEFF23,    0xfff80001},
{14000000, DIF_BPF_COEFF45,    0x0021ffe8},
{14000000, DIF_BPF_COEFF67,    0xffba005d},
{14000000, DIF_BPF_COEFF89,    0x0060ff1f},
{14000000, DIF_BPF_COEFF1011,  0xffc40198},
{14000000, DIF_BPF_COEFF1213,  0xffa0fdb5},
{14000000, DIF_BPF_COEFF1415,  0x019a029a},
{14000000, DIF_BPF_COEFF1617,  0xfc99fdea},
{14000000, DIF_BPF_COEFF1819,  0x05750067},
{14000000, DIF_BPF_COEFF2021,  0xf8d4027f},
{14000000, DIF_BPF_COEFF2223,  0x07d4f9c0},
{14000000, DIF_BPF_COEFF2425,  0xf9320a1a},
{14000000, DIF_BPF_COEFF2627,  0x03d2f2f3},
{14000000, DIF_BPF_COEFF2829,  0x00df0e22},
{14000000, DIF_BPF_COEFF3031,  0xf986f341},
{14000000, DIF_BPF_COEFF3233,  0x0bd108e2},
{14000000, DIF_BPF_COEFF3435,  0xf058fcd1},
{14000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 140_quant.dat*/


/*case 14100000:*/
/* BEGIN - DIF BPF register values from 141_quant.dat*/
{14100000, DIF_BPF_COEFF01,    0x00000002},
{14100000, DIF_BPF_COEFF23,    0xfff9fffa},
{14100000, DIF_BPF_COEFF45,    0x0021fffd},
{14100000, DIF_BPF_COEFF67,    0xffac0038},
{14100000, DIF_BPF_COEFF89,    0x008eff4a},
{14100000, DIF_BPF_COEFF1011,  0xff630184},
{14100000, DIF_BPF_COEFF1213,  0x003afd8b},
{14100000, DIF_BPF_COEFF1415,  0x00da0326},
{14100000, DIF_BPF_COEFF1617,  0xfd51fced},
{14100000, DIF_BPF_COEFF1819,  0x050101c0},
{14100000, DIF_BPF_COEFF2021,  0xf8cb0103},
{14100000, DIF_BPF_COEFF2223,  0x0876fb10},
{14100000, DIF_BPF_COEFF2425,  0xf80a093e},
{14100000, DIF_BPF_COEFF2627,  0x0543f338},
{14100000, DIF_BPF_COEFF2829,  0xff7a0e66},
{14100000, DIF_BPF_COEFF3031,  0xfa94f2b2},
{14100000, DIF_BPF_COEFF3233,  0x0b3f0967},
{14100000, DIF_BPF_COEFF3435,  0xf081fc9b},
{14100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 141_quant.dat*/


/*case 14200000:*/
/* BEGIN - DIF BPF register values from 142_quant.dat*/
{14200000, DIF_BPF_COEFF01,    0x00000003},
{14200000, DIF_BPF_COEFF23,    0xfffbfff3},
{14200000, DIF_BPF_COEFF45,    0x001d0013},
{14200000, DIF_BPF_COEFF67,    0xffaa000b},
{14200000, DIF_BPF_COEFF89,    0x00aaff89},
{14200000, DIF_BPF_COEFF1011,  0xff13014a},
{14200000, DIF_BPF_COEFF1213,  0x00cefd95},
{14200000, DIF_BPF_COEFF1415,  0x000a037b},
{14200000, DIF_BPF_COEFF1617,  0xfe35fc1d},
{14200000, DIF_BPF_COEFF1819,  0x044c0305},
{14200000, DIF_BPF_COEFF2021,  0xf90cff7e},
{14200000, DIF_BPF_COEFF2223,  0x08d5fc81},
{14200000, DIF_BPF_COEFF2425,  0xf7100834},
{14200000, DIF_BPF_COEFF2627,  0x069ff3a7},
{14200000, DIF_BPF_COEFF2829,  0xfe160e8d},
{14200000, DIF_BPF_COEFF3031,  0xfbaaf231},
{14200000, DIF_BPF_COEFF3233,  0x0aa509e9},
{14200000, DIF_BPF_COEFF3435,  0xf0adfc65},
{14200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 142_quant.dat*/


/*case 14300000:*/
/* BEGIN - DIF BPF register values from 143_quant.dat*/
{14300000, DIF_BPF_COEFF01,    0x00000003},
{14300000, DIF_BPF_COEFF23,    0xffffffef},
{14300000, DIF_BPF_COEFF45,    0x00140025},
{14300000, DIF_BPF_COEFF67,    0xffb4ffdd},
{14300000, DIF_BPF_COEFF89,    0x00b2ffd6},
{14300000, DIF_BPF_COEFF1011,  0xfedb00f0},
{14300000, DIF_BPF_COEFF1213,  0x0150fdd3},
{14300000, DIF_BPF_COEFF1415,  0xff380391},
{14300000, DIF_BPF_COEFF1617,  0xff36fb85},
{14300000, DIF_BPF_COEFF1819,  0x035e0426},
{14300000, DIF_BPF_COEFF2021,  0xf994fdfe},
{14300000, DIF_BPF_COEFF2223,  0x08eefe0b},
{14300000, DIF_BPF_COEFF2425,  0xf6490702},
{14300000, DIF_BPF_COEFF2627,  0x07e1f43e},
{14300000, DIF_BPF_COEFF2829,  0xfcb60e97},
{14300000, DIF_BPF_COEFF3031,  0xfcc6f1be},
{14300000, DIF_BPF_COEFF3233,  0x0a040a67},
{14300000, DIF_BPF_COEFF3435,  0xf0dbfc30},
{14300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 143_quant.dat*/


/*case 14400000:*/
/* BEGIN - DIF BPF register values from 144_quant.dat*/
{14400000, DIF_BPF_COEFF01,    0x00000003},
{14400000, DIF_BPF_COEFF23,    0x0002ffee},
{14400000, DIF_BPF_COEFF45,    0x00070033},
{14400000, DIF_BPF_COEFF67,    0xffc9ffb4},
{14400000, DIF_BPF_COEFF89,    0x00a40027},
{14400000, DIF_BPF_COEFF1011,  0xfec3007e},
{14400000, DIF_BPF_COEFF1213,  0x01b4fe3f},
{14400000, DIF_BPF_COEFF1415,  0xfe760369},
{14400000, DIF_BPF_COEFF1617,  0x0044fb2e},
{14400000, DIF_BPF_COEFF1819,  0x02450518},
{14400000, DIF_BPF_COEFF2021,  0xfa5ffc90},
{14400000, DIF_BPF_COEFF2223,  0x08c1ffa1},
{14400000, DIF_BPF_COEFF2425,  0xf5bc05ae},
{14400000, DIF_BPF_COEFF2627,  0x0902f4fc},
{14400000, DIF_BPF_COEFF2829,  0xfb600e85},
{14400000, DIF_BPF_COEFF3031,  0xfde7f15a},
{14400000, DIF_BPF_COEFF3233,  0x095d0ae2},
{14400000, DIF_BPF_COEFF3435,  0xf10cfbfb},
{14400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 144_quant.dat*/


/*case 14500000:*/
/* BEGIN - DIF BPF register values from 145_quant.dat*/
{14500000, DIF_BPF_COEFF01,    0xffff0002},
{14500000, DIF_BPF_COEFF23,    0x0005ffef},
{14500000, DIF_BPF_COEFF45,    0xfffa0038},
{14500000, DIF_BPF_COEFF67,    0xffe5ff95},
{14500000, DIF_BPF_COEFF89,    0x00820074},
{14500000, DIF_BPF_COEFF1011,  0xfecc0000},
{14500000, DIF_BPF_COEFF1213,  0x01f0fed0},
{14500000, DIF_BPF_COEFF1415,  0xfdd20304},
{14500000, DIF_BPF_COEFF1617,  0x014dfb1d},
{14500000, DIF_BPF_COEFF1819,  0x010e05ce},
{14500000, DIF_BPF_COEFF2021,  0xfb64fb41},
{14500000, DIF_BPF_COEFF2223,  0x084e013b},
{14500000, DIF_BPF_COEFF2425,  0xf569043e},
{14500000, DIF_BPF_COEFF2627,  0x0a00f5dd},
{14500000, DIF_BPF_COEFF2829,  0xfa150e55},
{14500000, DIF_BPF_COEFF3031,  0xff0bf104},
{14500000, DIF_BPF_COEFF3233,  0x08b00b59},
{14500000, DIF_BPF_COEFF3435,  0xf13ffbc6},
{14500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 145_quant.dat*/


/*case 14600000:*/
/* BEGIN - DIF BPF register values from 146_quant.dat*/
{14600000, DIF_BPF_COEFF01,    0xffff0001},
{14600000, DIF_BPF_COEFF23,    0x0008fff4},
{14600000, DIF_BPF_COEFF45,    0xffed0035},
{14600000, DIF_BPF_COEFF67,    0x0005ff83},
{14600000, DIF_BPF_COEFF89,    0x005000b4},
{14600000, DIF_BPF_COEFF1011,  0xfef6ff82},
{14600000, DIF_BPF_COEFF1213,  0x01ffff7a},
{14600000, DIF_BPF_COEFF1415,  0xfd580269},
{14600000, DIF_BPF_COEFF1617,  0x0241fb53},
{14600000, DIF_BPF_COEFF1819,  0xffca0640},
{14600000, DIF_BPF_COEFF2021,  0xfc99fa1e},
{14600000, DIF_BPF_COEFF2223,  0x079a02cb},
{14600000, DIF_BPF_COEFF2425,  0xf55502ba},
{14600000, DIF_BPF_COEFF2627,  0x0ad5f6e0},
{14600000, DIF_BPF_COEFF2829,  0xf8d90e0a},
{14600000, DIF_BPF_COEFF3031,  0x0031f0bd},
{14600000, DIF_BPF_COEFF3233,  0x07fd0bcb},
{14600000, DIF_BPF_COEFF3435,  0xf174fb91},
{14600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 146_quant.dat*/


/*case 14700000:*/
/* BEGIN - DIF BPF register values from 147_quant.dat*/
{14700000, DIF_BPF_COEFF01,    0xffffffff},
{14700000, DIF_BPF_COEFF23,    0x0009fffb},
{14700000, DIF_BPF_COEFF45,    0xffe4002a},
{14700000, DIF_BPF_COEFF67,    0x0025ff82},
{14700000, DIF_BPF_COEFF89,    0x001400e0},
{14700000, DIF_BPF_COEFF1011,  0xff3cff10},
{14700000, DIF_BPF_COEFF1213,  0x01e10030},
{14700000, DIF_BPF_COEFF1415,  0xfd1201a4},
{14700000, DIF_BPF_COEFF1617,  0x0311fbcd},
{14700000, DIF_BPF_COEFF1819,  0xfe88066a},
{14700000, DIF_BPF_COEFF2021,  0xfdf1f92f},
{14700000, DIF_BPF_COEFF2223,  0x06aa0449},
{14700000, DIF_BPF_COEFF2425,  0xf57e0128},
{14700000, DIF_BPF_COEFF2627,  0x0b7ef801},
{14700000, DIF_BPF_COEFF2829,  0xf7b00da2},
{14700000, DIF_BPF_COEFF3031,  0x0156f086},
{14700000, DIF_BPF_COEFF3233,  0x07450c39},
{14700000, DIF_BPF_COEFF3435,  0xf1acfb5c},
{14700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 147_quant.dat*/


/*case 14800000:*/
/* BEGIN - DIF BPF register values from 148_quant.dat*/
{14800000, DIF_BPF_COEFF01,    0x0000fffe},
{14800000, DIF_BPF_COEFF23,    0x00080002},
{14800000, DIF_BPF_COEFF45,    0xffdf0019},
{14800000, DIF_BPF_COEFF67,    0x003fff92},
{14800000, DIF_BPF_COEFF89,    0xffd600f1},
{14800000, DIF_BPF_COEFF1011,  0xff96feb6},
{14800000, DIF_BPF_COEFF1213,  0x019700e1},
{14800000, DIF_BPF_COEFF1415,  0xfd0500c2},
{14800000, DIF_BPF_COEFF1617,  0x03b0fc84},
{14800000, DIF_BPF_COEFF1819,  0xfd590649},
{14800000, DIF_BPF_COEFF2021,  0xff5df87f},
{14800000, DIF_BPF_COEFF2223,  0x058505aa},
{14800000, DIF_BPF_COEFF2425,  0xf5e4ff91},
{14800000, DIF_BPF_COEFF2627,  0x0bf9f93c},
{14800000, DIF_BPF_COEFF2829,  0xf69d0d20},
{14800000, DIF_BPF_COEFF3031,  0x0279f05e},
{14800000, DIF_BPF_COEFF3233,  0x06880ca3},
{14800000, DIF_BPF_COEFF3435,  0xf1e6fb28},
{14800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 148_quant.dat*/


/*case 14900000:*/
/* BEGIN - DIF BPF register values from 149_quant.dat*/
{14900000, DIF_BPF_COEFF01,    0x0000fffd},
{14900000, DIF_BPF_COEFF23,    0x00060009},
{14900000, DIF_BPF_COEFF45,    0xffdf0004},
{14900000, DIF_BPF_COEFF67,    0x0051ffb0},
{14900000, DIF_BPF_COEFF89,    0xff9d00e8},
{14900000, DIF_BPF_COEFF1011,  0xfffcfe7c},
{14900000, DIF_BPF_COEFF1213,  0x01280180},
{14900000, DIF_BPF_COEFF1415,  0xfd32ffd2},
{14900000, DIF_BPF_COEFF1617,  0x0413fd6e},
{14900000, DIF_BPF_COEFF1819,  0xfc4d05df},
{14900000, DIF_BPF_COEFF2021,  0x00d1f812},
{14900000, DIF_BPF_COEFF2223,  0x043506e4},
{14900000, DIF_BPF_COEFF2425,  0xf685fdfb},
{14900000, DIF_BPF_COEFF2627,  0x0c43fa8d},
{14900000, DIF_BPF_COEFF2829,  0xf5a10c83},
{14900000, DIF_BPF_COEFF3031,  0x0399f046},
{14900000, DIF_BPF_COEFF3233,  0x05c70d08},
{14900000, DIF_BPF_COEFF3435,  0xf222faf3},
{14900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 149_quant.dat*/


/*case 15000000:*/
/* BEGIN - DIF BPF register values from 150_quant.dat*/
{15000000, DIF_BPF_COEFF01,    0x0000fffd},
{15000000, DIF_BPF_COEFF23,    0x0003000f},
{15000000, DIF_BPF_COEFF45,    0xffe5ffef},
{15000000, DIF_BPF_COEFF67,    0x0057ffd9},
{15000000, DIF_BPF_COEFF89,    0xff7000c4},
{15000000, DIF_BPF_COEFF1011,  0x0062fe68},
{15000000, DIF_BPF_COEFF1213,  0x009e01ff},
{15000000, DIF_BPF_COEFF1415,  0xfd95fee6},
{15000000, DIF_BPF_COEFF1617,  0x0435fe7d},
{15000000, DIF_BPF_COEFF1819,  0xfb710530},
{15000000, DIF_BPF_COEFF2021,  0x023cf7ee},
{15000000, DIF_BPF_COEFF2223,  0x02c307ef},
{15000000, DIF_BPF_COEFF2425,  0xf75efc70},
{15000000, DIF_BPF_COEFF2627,  0x0c5cfbef},
{15000000, DIF_BPF_COEFF2829,  0xf4c10bce},
{15000000, DIF_BPF_COEFF3031,  0x04b3f03f},
{15000000, DIF_BPF_COEFF3233,  0x05030d69},
{15000000, DIF_BPF_COEFF3435,  0xf261fabf},
{15000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 150_quant.dat*/


/*case 15100000:*/
/* BEGIN - DIF BPF register values from 151_quant.dat*/
{15100000, DIF_BPF_COEFF01,    0x0000fffd},
{15100000, DIF_BPF_COEFF23,    0xffff0012},
{15100000, DIF_BPF_COEFF45,    0xffefffdc},
{15100000, DIF_BPF_COEFF67,    0x00510006},
{15100000, DIF_BPF_COEFF89,    0xff540089},
{15100000, DIF_BPF_COEFF1011,  0x00befe7c},
{15100000, DIF_BPF_COEFF1213,  0x00060253},
{15100000, DIF_BPF_COEFF1415,  0xfe27fe0d},
{15100000, DIF_BPF_COEFF1617,  0x0413ffa2},
{15100000, DIF_BPF_COEFF1819,  0xfad10446},
{15100000, DIF_BPF_COEFF2021,  0x0390f812},
{15100000, DIF_BPF_COEFF2223,  0x013b08c3},
{15100000, DIF_BPF_COEFF2425,  0xf868faf6},
{15100000, DIF_BPF_COEFF2627,  0x0c43fd5f},
{15100000, DIF_BPF_COEFF2829,  0xf3fd0b02},
{15100000, DIF_BPF_COEFF3031,  0x05c7f046},
{15100000, DIF_BPF_COEFF3233,  0x043b0dc4},
{15100000, DIF_BPF_COEFF3435,  0xf2a1fa8b},
{15100000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 151_quant.dat*/


/*case 15200000:*/
/* BEGIN - DIF BPF register values from 152_quant.dat*/
{15200000, DIF_BPF_COEFF01,    0x0001fffe},
{15200000, DIF_BPF_COEFF23,    0xfffc0012},
{15200000, DIF_BPF_COEFF45,    0xfffbffce},
{15200000, DIF_BPF_COEFF67,    0x003f0033},
{15200000, DIF_BPF_COEFF89,    0xff4e003f},
{15200000, DIF_BPF_COEFF1011,  0x0106feb6},
{15200000, DIF_BPF_COEFF1213,  0xff6e0276},
{15200000, DIF_BPF_COEFF1415,  0xfeddfd56},
{15200000, DIF_BPF_COEFF1617,  0x03b000cc},
{15200000, DIF_BPF_COEFF1819,  0xfa740329},
{15200000, DIF_BPF_COEFF2021,  0x04bff87f},
{15200000, DIF_BPF_COEFF2223,  0xffaa095d},
{15200000, DIF_BPF_COEFF2425,  0xf99ef995},
{15200000, DIF_BPF_COEFF2627,  0x0bf9fed8},
{15200000, DIF_BPF_COEFF2829,  0xf3590a1f},
{15200000, DIF_BPF_COEFF3031,  0x06d2f05e},
{15200000, DIF_BPF_COEFF3233,  0x03700e1b},
{15200000, DIF_BPF_COEFF3435,  0xf2e4fa58},
{15200000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 152_quant.dat*/


/*case 115300000:*/
/* BEGIN - DIF BPF register values from 153_quant.dat*/
{15300000, DIF_BPF_COEFF01,    0x0001ffff},
{15300000, DIF_BPF_COEFF23,    0xfff9000f},
{15300000, DIF_BPF_COEFF45,    0x0009ffc8},
{15300000, DIF_BPF_COEFF67,    0x00250059},
{15300000, DIF_BPF_COEFF89,    0xff5effee},
{15300000, DIF_BPF_COEFF1011,  0x0132ff10},
{15300000, DIF_BPF_COEFF1213,  0xfee30265},
{15300000, DIF_BPF_COEFF1415,  0xffaafccf},
{15300000, DIF_BPF_COEFF1617,  0x031101eb},
{15300000, DIF_BPF_COEFF1819,  0xfa6001e8},
{15300000, DIF_BPF_COEFF2021,  0x05bdf92f},
{15300000, DIF_BPF_COEFF2223,  0xfe1b09b6},
{15300000, DIF_BPF_COEFF2425,  0xfafaf852},
{15300000, DIF_BPF_COEFF2627,  0x0b7e0055},
{15300000, DIF_BPF_COEFF2829,  0xf2d50929},
{15300000, DIF_BPF_COEFF3031,  0x07d3f086},
{15300000, DIF_BPF_COEFF3233,  0x02a30e6c},
{15300000, DIF_BPF_COEFF3435,  0xf329fa24},
{15300000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 153_quant.dat*/


/*case 115400000:*/
/* BEGIN - DIF BPF register values from 154_quant.dat*/
{15400000, DIF_BPF_COEFF01,    0x00010001},
{15400000, DIF_BPF_COEFF23,    0xfff80009},
{15400000, DIF_BPF_COEFF45,    0x0015ffca},
{15400000, DIF_BPF_COEFF67,    0x00050074},
{15400000, DIF_BPF_COEFF89,    0xff81ff9f},
{15400000, DIF_BPF_COEFF1011,  0x013dff82},
{15400000, DIF_BPF_COEFF1213,  0xfe710221},
{15400000, DIF_BPF_COEFF1415,  0x007cfc80},
{15400000, DIF_BPF_COEFF1617,  0x024102ed},
{15400000, DIF_BPF_COEFF1819,  0xfa940090},
{15400000, DIF_BPF_COEFF2021,  0x0680fa1e},
{15400000, DIF_BPF_COEFF2223,  0xfc9b09cd},
{15400000, DIF_BPF_COEFF2425,  0xfc73f736},
{15400000, DIF_BPF_COEFF2627,  0x0ad501d0},
{15400000, DIF_BPF_COEFF2829,  0xf2740820},
{15400000, DIF_BPF_COEFF3031,  0x08c9f0bd},
{15400000, DIF_BPF_COEFF3233,  0x01d40eb9},
{15400000, DIF_BPF_COEFF3435,  0xf371f9f1},
{15400000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 154_quant.dat*/


/*case 115500000:*/
/* BEGIN - DIF BPF register values from 155_quant.dat*/
{15500000, DIF_BPF_COEFF01,    0x00000002},
{15500000, DIF_BPF_COEFF23,    0xfff80002},
{15500000, DIF_BPF_COEFF45,    0x001effd5},
{15500000, DIF_BPF_COEFF67,    0xffe5007f},
{15500000, DIF_BPF_COEFF89,    0xffb4ff5b},
{15500000, DIF_BPF_COEFF1011,  0x01280000},
{15500000, DIF_BPF_COEFF1213,  0xfe2401b0},
{15500000, DIF_BPF_COEFF1415,  0x0146fc70},
{15500000, DIF_BPF_COEFF1617,  0x014d03c6},
{15500000, DIF_BPF_COEFF1819,  0xfb10ff32},
{15500000, DIF_BPF_COEFF2021,  0x0701fb41},
{15500000, DIF_BPF_COEFF2223,  0xfb3709a1},
{15500000, DIF_BPF_COEFF2425,  0xfe00f644},
{15500000, DIF_BPF_COEFF2627,  0x0a000345},
{15500000, DIF_BPF_COEFF2829,  0xf2350708},
{15500000, DIF_BPF_COEFF3031,  0x09b2f104},
{15500000, DIF_BPF_COEFF3233,  0x01050eff},
{15500000, DIF_BPF_COEFF3435,  0xf3baf9be},
{15500000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 155_quant.dat*/


/*case 115600000:*/
/* BEGIN - DIF BPF register values from 156_quant.dat*/
{15600000, DIF_BPF_COEFF01,    0x00000003},
{15600000, DIF_BPF_COEFF23,    0xfff9fffb},
{15600000, DIF_BPF_COEFF45,    0x0022ffe6},
{15600000, DIF_BPF_COEFF67,    0xffc9007a},
{15600000, DIF_BPF_COEFF89,    0xfff0ff29},
{15600000, DIF_BPF_COEFF1011,  0x00f2007e},
{15600000, DIF_BPF_COEFF1213,  0xfe01011b},
{15600000, DIF_BPF_COEFF1415,  0x01f6fc9e},
{15600000, DIF_BPF_COEFF1617,  0x00440467},
{15600000, DIF_BPF_COEFF1819,  0xfbccfdde},
{15600000, DIF_BPF_COEFF2021,  0x0738fc90},
{15600000, DIF_BPF_COEFF2223,  0xf9f70934},
{15600000, DIF_BPF_COEFF2425,  0xff99f582},
{15600000, DIF_BPF_COEFF2627,  0x090204b0},
{15600000, DIF_BPF_COEFF2829,  0xf21a05e1},
{15600000, DIF_BPF_COEFF3031,  0x0a8df15a},
{15600000, DIF_BPF_COEFF3233,  0x00340f41},
{15600000, DIF_BPF_COEFF3435,  0xf405f98b},
{15600000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 156_quant.dat*/


/*case 115700000:*/
/* BEGIN - DIF BPF register values from 157_quant.dat*/
{15700000, DIF_BPF_COEFF01,    0x00000003},
{15700000, DIF_BPF_COEFF23,    0xfffcfff4},
{15700000, DIF_BPF_COEFF45,    0x0020fffa},
{15700000, DIF_BPF_COEFF67,    0xffb40064},
{15700000, DIF_BPF_COEFF89,    0x002fff11},
{15700000, DIF_BPF_COEFF1011,  0x00a400f0},
{15700000, DIF_BPF_COEFF1213,  0xfe0d006e},
{15700000, DIF_BPF_COEFF1415,  0x0281fd09},
{15700000, DIF_BPF_COEFF1617,  0xff3604c9},
{15700000, DIF_BPF_COEFF1819,  0xfcbffca2},
{15700000, DIF_BPF_COEFF2021,  0x0726fdfe},
{15700000, DIF_BPF_COEFF2223,  0xf8e80888},
{15700000, DIF_BPF_COEFF2425,  0x0134f4f3},
{15700000, DIF_BPF_COEFF2627,  0x07e1060c},
{15700000, DIF_BPF_COEFF2829,  0xf22304af},
{15700000, DIF_BPF_COEFF3031,  0x0b59f1be},
{15700000, DIF_BPF_COEFF3233,  0xff640f7d},
{15700000, DIF_BPF_COEFF3435,  0xf452f959},
{15700000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 157_quant.dat*/


/*case 115800000:*/
/* BEGIN - DIF BPF register values from 158_quant.dat*/
{15800000, DIF_BPF_COEFF01,    0x00000003},
{15800000, DIF_BPF_COEFF23,    0x0000fff0},
{15800000, DIF_BPF_COEFF45,    0x001a0010},
{15800000, DIF_BPF_COEFF67,    0xffaa0041},
{15800000, DIF_BPF_COEFF89,    0x0067ff13},
{15800000, DIF_BPF_COEFF1011,  0x0043014a},
{15800000, DIF_BPF_COEFF1213,  0xfe46ffb9},
{15800000, DIF_BPF_COEFF1415,  0x02dbfda8},
{15800000, DIF_BPF_COEFF1617,  0xfe3504e5},
{15800000, DIF_BPF_COEFF1819,  0xfddcfb8d},
{15800000, DIF_BPF_COEFF2021,  0x06c9ff7e},
{15800000, DIF_BPF_COEFF2223,  0xf81107a2},
{15800000, DIF_BPF_COEFF2425,  0x02c9f49a},
{15800000, DIF_BPF_COEFF2627,  0x069f0753},
{15800000, DIF_BPF_COEFF2829,  0xf2500373},
{15800000, DIF_BPF_COEFF3031,  0x0c14f231},
{15800000, DIF_BPF_COEFF3233,  0xfe930fb3},
{15800000, DIF_BPF_COEFF3435,  0xf4a1f927},
{15800000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 158_quant.dat*/


/*case 115900000:*/
/* BEGIN - DIF BPF register values from 159_quant.dat*/
{15900000, DIF_BPF_COEFF01,    0xffff0002},
{15900000, DIF_BPF_COEFF23,    0x0003ffee},
{15900000, DIF_BPF_COEFF45,    0x000f0023},
{15900000, DIF_BPF_COEFF67,    0xffac0016},
{15900000, DIF_BPF_COEFF89,    0x0093ff31},
{15900000, DIF_BPF_COEFF1011,  0xffdc0184},
{15900000, DIF_BPF_COEFF1213,  0xfea6ff09},
{15900000, DIF_BPF_COEFF1415,  0x02fdfe70},
{15900000, DIF_BPF_COEFF1617,  0xfd5104ba},
{15900000, DIF_BPF_COEFF1819,  0xff15faac},
{15900000, DIF_BPF_COEFF2021,  0x06270103},
{15900000, DIF_BPF_COEFF2223,  0xf7780688},
{15900000, DIF_BPF_COEFF2425,  0x044df479},
{15900000, DIF_BPF_COEFF2627,  0x05430883},
{15900000, DIF_BPF_COEFF2829,  0xf2a00231},
{15900000, DIF_BPF_COEFF3031,  0x0cbef2b2},
{15900000, DIF_BPF_COEFF3233,  0xfdc40fe3},
{15900000, DIF_BPF_COEFF3435,  0xf4f2f8f5},
{15900000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 159_quant.dat*/


/*case 116000000:*/
/* BEGIN - DIF BPF register values from 160_quant.dat*/
{16000000, DIF_BPF_COEFF01,    0xffff0001},
{16000000, DIF_BPF_COEFF23,    0x0006ffef},
{16000000, DIF_BPF_COEFF45,    0x00020031},
{16000000, DIF_BPF_COEFF67,    0xffbaffe8},
{16000000, DIF_BPF_COEFF89,    0x00adff66},
{16000000, DIF_BPF_COEFF1011,  0xff790198},
{16000000, DIF_BPF_COEFF1213,  0xff26fe6e},
{16000000, DIF_BPF_COEFF1415,  0x02e5ff55},
{16000000, DIF_BPF_COEFF1617,  0xfc99044a},
{16000000, DIF_BPF_COEFF1819,  0x005bfa09},
{16000000, DIF_BPF_COEFF2021,  0x0545027f},
{16000000, DIF_BPF_COEFF2223,  0xf7230541},
{16000000, DIF_BPF_COEFF2425,  0x05b8f490},
{16000000, DIF_BPF_COEFF2627,  0x03d20997},
{16000000, DIF_BPF_COEFF2829,  0xf31300eb},
{16000000, DIF_BPF_COEFF3031,  0x0d55f341},
{16000000, DIF_BPF_COEFF3233,  0xfcf6100e},
{16000000, DIF_BPF_COEFF3435,  0xf544f8c3},
{16000000, DIF_BPF_COEFF36,    0x110d0000},
/* END - DIF BPF register values from 160_quant.dat*/
};

#endif
