/*
 * GPL HEADER START
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License version 2 for more details (a copy is included
 * in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; If not, see
 * http://www.gnu.org/licenses/gpl-2.0.html
 *
 * GPL HEADER END
 */
/*
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 * Use is subject to license terms.
 *
 * Copyright (c) 2011, 2015, Intel Corporation.
 */
/*
 * This file is part of Lustre, http://www.lustre.org/
 * Lustre is a trademark of Sun Microsystems, Inc.
 *
 * libcfs/libcfs/linux/linux-curproc.c
 *
 * Lustre curproc API implementation for Linux kernel
 *
 * Author: Nikita Danilov <nikita@clusterfs.com>
 */

#include <linux/sched.h>
#include <linux/fs_struct.h>

#include <linux/compat.h>
#include <linux/thread_info.h>

#define DEBUG_SUBSYSTEM S_LNET

#include <linux/libcfs/libcfs.h>

/*
 * Implementation of cfs_curproc API (see portals/include/libcfs/curproc.h)
 * for Linux kernel.
 */

void cfs_cap_raise(cfs_cap_t cap)
{
	struct cred *cred;

	cred = prepare_creds();
	if (cred) {
		cap_raise(cred->cap_effective, cap);
		commit_creds(cred);
	}
}
EXPORT_SYMBOL(cfs_cap_raise);

void cfs_cap_lower(cfs_cap_t cap)
{
	struct cred *cred;

	cred = prepare_creds();
	if (cred) {
		cap_lower(cred->cap_effective, cap);
		commit_creds(cred);
	}
}
EXPORT_SYMBOL(cfs_cap_lower);

int cfs_cap_raised(cfs_cap_t cap)
{
	return cap_raised(current_cap(), cap);
}
EXPORT_SYMBOL(cfs_cap_raised);

static void cfs_kernel_cap_pack(kernel_cap_t kcap, cfs_cap_t *cap)
{
	/* XXX lost high byte */
	*cap = kcap.cap[0];
}

cfs_cap_t cfs_curproc_cap_pack(void)
{
	cfs_cap_t cap;

	cfs_kernel_cap_pack(current_cap(), &cap);
	return cap;
}
EXPORT_SYMBOL(cfs_curproc_cap_pack);

/*
 * Local variables:
 * c-indentation-style: "K&R"
 * c-basic-offset: 8
 * tab-width: 8
 * fill-column: 80
 * scroll-step: 1
 * End:
 */
