#ifndef A4XX_XML
#define A4XX_XML

/* Autogenerated file, DO NOT EDIT manually!

This file was generated by the rules-ng-ng headergen tool in this git repository:
http://github.com/freedreno/envytools/
git clone https://github.com/freedreno/envytools.git

The rules-ng-ng source files this header was generated from are:
- /home/robclark/src/freedreno/envytools/rnndb/adreno.xml               (    364 bytes, from 2013-11-30 14:47:15)
- /home/robclark/src/freedreno/envytools/rnndb/freedreno_copyright.xml  (   1453 bytes, from 2013-03-31 16:51:27)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a2xx.xml          (  32901 bytes, from 2014-06-02 15:21:30)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_common.xml (  10551 bytes, from 2014-11-13 22:44:30)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_pm4.xml    (  15085 bytes, from 2014-12-20 21:49:41)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a3xx.xml          (  64344 bytes, from 2014-12-12 20:22:26)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a4xx.xml          (  51069 bytes, from 2014-12-21 15:51:54)

Copyright (C) 2013-2014 by the following authors:
- Rob Clark <robdclark@gmail.com> (robclark)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


enum a4xx_color_fmt {
	RB4_A8_UNORM = 1,
	RB4_R5G6R5_UNORM = 14,
	RB4_Z16_UNORM = 15,
	RB4_R8G8B8_UNORM = 25,
	RB4_R8G8B8A8_UNORM = 26,
};

enum a4xx_tile_mode {
	TILE4_LINEAR = 0,
	TILE4_3 = 3,
};

enum a4xx_rb_blend_opcode {
	BLEND_DST_PLUS_SRC = 0,
	BLEND_SRC_MINUS_DST = 1,
	BLEND_DST_MINUS_SRC = 2,
	BLEND_MIN_DST_SRC = 3,
	BLEND_MAX_DST_SRC = 4,
};

enum a4xx_vtx_fmt {
	VFMT4_32_FLOAT = 1,
	VFMT4_32_32_FLOAT = 2,
	VFMT4_32_32_32_FLOAT = 3,
	VFMT4_32_32_32_32_FLOAT = 4,
	VFMT4_16_FLOAT = 5,
	VFMT4_16_16_FLOAT = 6,
	VFMT4_16_16_16_FLOAT = 7,
	VFMT4_16_16_16_16_FLOAT = 8,
	VFMT4_32_FIXED = 9,
	VFMT4_32_32_FIXED = 10,
	VFMT4_32_32_32_FIXED = 11,
	VFMT4_32_32_32_32_FIXED = 12,
	VFMT4_16_SINT = 16,
	VFMT4_16_16_SINT = 17,
	VFMT4_16_16_16_SINT = 18,
	VFMT4_16_16_16_16_SINT = 19,
	VFMT4_16_UINT = 20,
	VFMT4_16_16_UINT = 21,
	VFMT4_16_16_16_UINT = 22,
	VFMT4_16_16_16_16_UINT = 23,
	VFMT4_16_SNORM = 24,
	VFMT4_16_16_SNORM = 25,
	VFMT4_16_16_16_SNORM = 26,
	VFMT4_16_16_16_16_SNORM = 27,
	VFMT4_16_UNORM = 28,
	VFMT4_16_16_UNORM = 29,
	VFMT4_16_16_16_UNORM = 30,
	VFMT4_16_16_16_16_UNORM = 31,
	VFMT4_32_32_SINT = 37,
	VFMT4_8_UINT = 40,
	VFMT4_8_8_UINT = 41,
	VFMT4_8_8_8_UINT = 42,
	VFMT4_8_8_8_8_UINT = 43,
	VFMT4_8_UNORM = 44,
	VFMT4_8_8_UNORM = 45,
	VFMT4_8_8_8_UNORM = 46,
	VFMT4_8_8_8_8_UNORM = 47,
	VFMT4_8_SINT = 48,
	VFMT4_8_8_SINT = 49,
	VFMT4_8_8_8_SINT = 50,
	VFMT4_8_8_8_8_SINT = 51,
	VFMT4_8_SNORM = 52,
	VFMT4_8_8_SNORM = 53,
	VFMT4_8_8_8_SNORM = 54,
	VFMT4_8_8_8_8_SNORM = 55,
	VFMT4_10_10_10_2_UINT = 60,
	VFMT4_10_10_10_2_UNORM = 61,
	VFMT4_10_10_10_2_SINT = 62,
	VFMT4_10_10_10_2_SNORM = 63,
};

enum a4xx_tex_fmt {
	TFMT4_5_6_5_UNORM = 11,
	TFMT4_5_5_5_1_UNORM = 10,
	TFMT4_4_4_4_4_UNORM = 8,
	TFMT4_X8Z24_UNORM = 71,
	TFMT4_10_10_10_2_UNORM = 33,
	TFMT4_A8_UNORM = 3,
	TFMT4_L8_A8_UNORM = 13,
	TFMT4_8_UNORM = 4,
	TFMT4_8_8_UNORM = 14,
	TFMT4_8_8_8_8_UNORM = 28,
	TFMT4_16_FLOAT = 20,
	TFMT4_16_16_FLOAT = 40,
	TFMT4_16_16_16_16_FLOAT = 53,
	TFMT4_32_FLOAT = 43,
	TFMT4_32_32_FLOAT = 56,
	TFMT4_32_32_32_32_FLOAT = 63,
};

enum a4xx_tex_fetchsize {
	TFETCH4_1_BYTE = 0,
	TFETCH4_2_BYTE = 1,
	TFETCH4_4_BYTE = 2,
	TFETCH4_8_BYTE = 3,
	TFETCH4_16_BYTE = 4,
};

enum a4xx_depth_format {
	DEPTH4_NONE = 0,
	DEPTH4_16 = 1,
	DEPTH4_24_8 = 2,
};

enum a4xx_tex_filter {
	A4XX_TEX_NEAREST = 0,
	A4XX_TEX_LINEAR = 1,
};

enum a4xx_tex_clamp {
	A4XX_TEX_REPEAT = 0,
	A4XX_TEX_CLAMP_TO_EDGE = 1,
	A4XX_TEX_MIRROR_REPEAT = 2,
	A4XX_TEX_CLAMP_NONE = 3,
};

enum a4xx_tex_swiz {
	A4XX_TEX_X = 0,
	A4XX_TEX_Y = 1,
	A4XX_TEX_Z = 2,
	A4XX_TEX_W = 3,
	A4XX_TEX_ZERO = 4,
	A4XX_TEX_ONE = 5,
};

enum a4xx_tex_type {
	A4XX_TEX_1D = 0,
	A4XX_TEX_2D = 1,
	A4XX_TEX_CUBE = 2,
	A4XX_TEX_3D = 3,
};

#define A4XX_CGC_HLSQ_EARLY_CYC__MASK				0x00700000
#define A4XX_CGC_HLSQ_EARLY_CYC__SHIFT				20
static inline uint32_t A4XX_CGC_HLSQ_EARLY_CYC(uint32_t val)
{
	return ((val) << A4XX_CGC_HLSQ_EARLY_CYC__SHIFT) & A4XX_CGC_HLSQ_EARLY_CYC__MASK;
}
#define A4XX_INT0_RBBM_GPU_IDLE					0x00000001
#define A4XX_INT0_RBBM_AHB_ERROR				0x00000002
#define A4XX_INT0_RBBM_REG_TIMEOUT				0x00000004
#define A4XX_INT0_RBBM_ME_MS_TIMEOUT				0x00000008
#define A4XX_INT0_RBBM_PFP_MS_TIMEOUT				0x00000010
#define A4XX_INT0_RBBM_ATB_BUS_OVERFLOW				0x00000020
#define A4XX_INT0_VFD_ERROR					0x00000040
#define A4XX_INT0_CP_SW_INT					0x00000080
#define A4XX_INT0_CP_T0_PACKET_IN_IB				0x00000100
#define A4XX_INT0_CP_OPCODE_ERROR				0x00000200
#define A4XX_INT0_CP_RESERVED_BIT_ERROR				0x00000400
#define A4XX_INT0_CP_HW_FAULT					0x00000800
#define A4XX_INT0_CP_DMA					0x00001000
#define A4XX_INT0_CP_IB2_INT					0x00002000
#define A4XX_INT0_CP_IB1_INT					0x00004000
#define A4XX_INT0_CP_RB_INT					0x00008000
#define A4XX_INT0_CP_REG_PROTECT_FAULT				0x00010000
#define A4XX_INT0_CP_RB_DONE_TS					0x00020000
#define A4XX_INT0_CP_VS_DONE_TS					0x00040000
#define A4XX_INT0_CP_PS_DONE_TS					0x00080000
#define A4XX_INT0_CACHE_FLUSH_TS				0x00100000
#define A4XX_INT0_CP_AHB_ERROR_HALT				0x00200000
#define A4XX_INT0_MISC_HANG_DETECT				0x01000000
#define A4XX_INT0_UCHE_OOB_ACCESS				0x02000000
#define REG_A4XX_RB_GMEM_BASE_ADDR				0x00000cc0

#define REG_A4XX_RB_PERFCTR_RB_SEL_0				0x00000cc7

#define REG_A4XX_RB_PERFCTR_RB_SEL_1				0x00000cc8

#define REG_A4XX_RB_PERFCTR_RB_SEL_2				0x00000cc9

#define REG_A4XX_RB_PERFCTR_RB_SEL_3				0x00000cca

#define REG_A4XX_RB_PERFCTR_RB_SEL_4				0x00000ccb

#define REG_A4XX_RB_PERFCTR_RB_SEL_5				0x00000ccc

#define REG_A4XX_RB_PERFCTR_RB_SEL_6				0x00000ccd

#define REG_A4XX_RB_PERFCTR_RB_SEL_7				0x00000cce

#define REG_A4XX_RB_PERFCTR_CCU_SEL_3				0x00000cd2

#define REG_A4XX_RB_FRAME_BUFFER_DIMENSION			0x00000ce0
#define A4XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__MASK		0x00003fff
#define A4XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__SHIFT		0
static inline uint32_t A4XX_RB_FRAME_BUFFER_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A4XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__SHIFT) & A4XX_RB_FRAME_BUFFER_DIMENSION_WIDTH__MASK;
}
#define A4XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__MASK		0x3fff0000
#define A4XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__SHIFT		16
static inline uint32_t A4XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A4XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__SHIFT) & A4XX_RB_FRAME_BUFFER_DIMENSION_HEIGHT__MASK;
}

#define REG_A4XX_RB_CLEAR_COLOR_DW0				0x000020cc

#define REG_A4XX_RB_CLEAR_COLOR_DW1				0x000020cd

#define REG_A4XX_RB_CLEAR_COLOR_DW2				0x000020ce

#define REG_A4XX_RB_CLEAR_COLOR_DW3				0x000020cf

#define REG_A4XX_RB_MODE_CONTROL				0x000020a0
#define A4XX_RB_MODE_CONTROL_WIDTH__MASK			0x0000003f
#define A4XX_RB_MODE_CONTROL_WIDTH__SHIFT			0
static inline uint32_t A4XX_RB_MODE_CONTROL_WIDTH(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_MODE_CONTROL_WIDTH__SHIFT) & A4XX_RB_MODE_CONTROL_WIDTH__MASK;
}
#define A4XX_RB_MODE_CONTROL_HEIGHT__MASK			0x00003f00
#define A4XX_RB_MODE_CONTROL_HEIGHT__SHIFT			8
static inline uint32_t A4XX_RB_MODE_CONTROL_HEIGHT(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_MODE_CONTROL_HEIGHT__SHIFT) & A4XX_RB_MODE_CONTROL_HEIGHT__MASK;
}

#define REG_A4XX_RB_RENDER_CONTROL				0x000020a1
#define A4XX_RB_RENDER_CONTROL_BINNING_PASS			0x00000001
#define A4XX_RB_RENDER_CONTROL_DISABLE_COLOR_PIPE		0x00000020

#define REG_A4XX_RB_MSAA_CONTROL				0x000020a2
#define A4XX_RB_MSAA_CONTROL_DISABLE				0x00001000
#define A4XX_RB_MSAA_CONTROL_SAMPLES__MASK			0x0000e000
#define A4XX_RB_MSAA_CONTROL_SAMPLES__SHIFT			13
static inline uint32_t A4XX_RB_MSAA_CONTROL_SAMPLES(uint32_t val)
{
	return ((val) << A4XX_RB_MSAA_CONTROL_SAMPLES__SHIFT) & A4XX_RB_MSAA_CONTROL_SAMPLES__MASK;
}

#define REG_A4XX_RB_RENDER_CONTROL2				0x000020a3
#define A4XX_RB_RENDER_CONTROL2_XCOORD				0x00000001
#define A4XX_RB_RENDER_CONTROL2_YCOORD				0x00000002
#define A4XX_RB_RENDER_CONTROL2_ZCOORD				0x00000004
#define A4XX_RB_RENDER_CONTROL2_WCOORD				0x00000008
#define A4XX_RB_RENDER_CONTROL2_FACENESS			0x00000020
#define A4XX_RB_RENDER_CONTROL2_MSAA_SAMPLES__MASK		0x00000380
#define A4XX_RB_RENDER_CONTROL2_MSAA_SAMPLES__SHIFT		7
static inline uint32_t A4XX_RB_RENDER_CONTROL2_MSAA_SAMPLES(uint32_t val)
{
	return ((val) << A4XX_RB_RENDER_CONTROL2_MSAA_SAMPLES__SHIFT) & A4XX_RB_RENDER_CONTROL2_MSAA_SAMPLES__MASK;
}
#define A4XX_RB_RENDER_CONTROL2_VARYING				0x00001000

static inline uint32_t REG_A4XX_RB_MRT(uint32_t i0) { return 0x000020a4 + 0x5*i0; }

static inline uint32_t REG_A4XX_RB_MRT_CONTROL(uint32_t i0) { return 0x000020a4 + 0x5*i0; }
#define A4XX_RB_MRT_CONTROL_READ_DEST_ENABLE			0x00000008
#define A4XX_RB_MRT_CONTROL_BLEND				0x00000010
#define A4XX_RB_MRT_CONTROL_BLEND2				0x00000020
#define A4XX_RB_MRT_CONTROL_FASTCLEAR				0x00000400
#define A4XX_RB_MRT_CONTROL_B11					0x00000800
#define A4XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK		0x0f000000
#define A4XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT		24
static inline uint32_t A4XX_RB_MRT_CONTROL_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A4XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT) & A4XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK;
}

static inline uint32_t REG_A4XX_RB_MRT_BUF_INFO(uint32_t i0) { return 0x000020a5 + 0x5*i0; }
#define A4XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK			0x0000003f
#define A4XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT		0
static inline uint32_t A4XX_RB_MRT_BUF_INFO_COLOR_FORMAT(enum a4xx_color_fmt val)
{
	return ((val) << A4XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT) & A4XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK;
}
#define A4XX_RB_MRT_BUF_INFO_DITHER_MODE__MASK			0x00000600
#define A4XX_RB_MRT_BUF_INFO_DITHER_MODE__SHIFT			9
static inline uint32_t A4XX_RB_MRT_BUF_INFO_DITHER_MODE(enum adreno_rb_dither_mode val)
{
	return ((val) << A4XX_RB_MRT_BUF_INFO_DITHER_MODE__SHIFT) & A4XX_RB_MRT_BUF_INFO_DITHER_MODE__MASK;
}
#define A4XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK			0x00001800
#define A4XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT			11
static inline uint32_t A4XX_RB_MRT_BUF_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A4XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT) & A4XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK;
}
#define A4XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__MASK		0x007fc000
#define A4XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__SHIFT		14
static inline uint32_t A4XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH(uint32_t val)
{
	return ((val >> 4) << A4XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__SHIFT) & A4XX_RB_MRT_BUF_INFO_COLOR_BUF_PITCH__MASK;
}

static inline uint32_t REG_A4XX_RB_MRT_BASE(uint32_t i0) { return 0x000020a6 + 0x5*i0; }

static inline uint32_t REG_A4XX_RB_MRT_CONTROL3(uint32_t i0) { return 0x000020a7 + 0x5*i0; }
#define A4XX_RB_MRT_CONTROL3_STRIDE__MASK			0x0001fff8
#define A4XX_RB_MRT_CONTROL3_STRIDE__SHIFT			3
static inline uint32_t A4XX_RB_MRT_CONTROL3_STRIDE(uint32_t val)
{
	return ((val) << A4XX_RB_MRT_CONTROL3_STRIDE__SHIFT) & A4XX_RB_MRT_CONTROL3_STRIDE__MASK;
}

static inline uint32_t REG_A4XX_RB_MRT_BLEND_CONTROL(uint32_t i0) { return 0x000020a8 + 0x5*i0; }
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK		0x0000001f
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT		0
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK;
}
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK	0x000000e0
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT	5
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE(enum a4xx_rb_blend_opcode val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK;
}
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK		0x00001f00
#define A4XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT	8
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK;
}
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK	0x001f0000
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT	16
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK;
}
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK	0x00e00000
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT	21
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE(enum a4xx_rb_blend_opcode val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK;
}
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK	0x1f000000
#define A4XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT	24
static inline uint32_t A4XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A4XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT) & A4XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK;
}

#define REG_A4XX_RB_BLEND_RED					0x000020f3
#define A4XX_RB_BLEND_RED_UINT__MASK				0x00007fff
#define A4XX_RB_BLEND_RED_UINT__SHIFT				0
static inline uint32_t A4XX_RB_BLEND_RED_UINT(uint32_t val)
{
	return ((val) << A4XX_RB_BLEND_RED_UINT__SHIFT) & A4XX_RB_BLEND_RED_UINT__MASK;
}
#define A4XX_RB_BLEND_RED_FLOAT__MASK				0xffff0000
#define A4XX_RB_BLEND_RED_FLOAT__SHIFT				16
static inline uint32_t A4XX_RB_BLEND_RED_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A4XX_RB_BLEND_RED_FLOAT__SHIFT) & A4XX_RB_BLEND_RED_FLOAT__MASK;
}

#define REG_A4XX_RB_BLEND_GREEN					0x000020f4
#define A4XX_RB_BLEND_GREEN_UINT__MASK				0x00007fff
#define A4XX_RB_BLEND_GREEN_UINT__SHIFT				0
static inline uint32_t A4XX_RB_BLEND_GREEN_UINT(uint32_t val)
{
	return ((val) << A4XX_RB_BLEND_GREEN_UINT__SHIFT) & A4XX_RB_BLEND_GREEN_UINT__MASK;
}
#define A4XX_RB_BLEND_GREEN_FLOAT__MASK				0xffff0000
#define A4XX_RB_BLEND_GREEN_FLOAT__SHIFT			16
static inline uint32_t A4XX_RB_BLEND_GREEN_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A4XX_RB_BLEND_GREEN_FLOAT__SHIFT) & A4XX_RB_BLEND_GREEN_FLOAT__MASK;
}

#define REG_A4XX_RB_BLEND_BLUE					0x000020f5
#define A4XX_RB_BLEND_BLUE_UINT__MASK				0x00007fff
#define A4XX_RB_BLEND_BLUE_UINT__SHIFT				0
static inline uint32_t A4XX_RB_BLEND_BLUE_UINT(uint32_t val)
{
	return ((val) << A4XX_RB_BLEND_BLUE_UINT__SHIFT) & A4XX_RB_BLEND_BLUE_UINT__MASK;
}
#define A4XX_RB_BLEND_BLUE_FLOAT__MASK				0xffff0000
#define A4XX_RB_BLEND_BLUE_FLOAT__SHIFT				16
static inline uint32_t A4XX_RB_BLEND_BLUE_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A4XX_RB_BLEND_BLUE_FLOAT__SHIFT) & A4XX_RB_BLEND_BLUE_FLOAT__MASK;
}

#define REG_A4XX_RB_BLEND_ALPHA					0x000020f6
#define A4XX_RB_BLEND_ALPHA_UINT__MASK				0x00007fff
#define A4XX_RB_BLEND_ALPHA_UINT__SHIFT				0
static inline uint32_t A4XX_RB_BLEND_ALPHA_UINT(uint32_t val)
{
	return ((val) << A4XX_RB_BLEND_ALPHA_UINT__SHIFT) & A4XX_RB_BLEND_ALPHA_UINT__MASK;
}
#define A4XX_RB_BLEND_ALPHA_FLOAT__MASK				0xffff0000
#define A4XX_RB_BLEND_ALPHA_FLOAT__SHIFT			16
static inline uint32_t A4XX_RB_BLEND_ALPHA_FLOAT(float val)
{
	return ((util_float_to_half(val)) << A4XX_RB_BLEND_ALPHA_FLOAT__SHIFT) & A4XX_RB_BLEND_ALPHA_FLOAT__MASK;
}

#define REG_A4XX_RB_ALPHA_CONTROL				0x000020f8
#define A4XX_RB_ALPHA_CONTROL_ALPHA_REF__MASK			0x000000ff
#define A4XX_RB_ALPHA_CONTROL_ALPHA_REF__SHIFT			0
static inline uint32_t A4XX_RB_ALPHA_CONTROL_ALPHA_REF(uint32_t val)
{
	return ((val) << A4XX_RB_ALPHA_CONTROL_ALPHA_REF__SHIFT) & A4XX_RB_ALPHA_CONTROL_ALPHA_REF__MASK;
}
#define A4XX_RB_ALPHA_CONTROL_ALPHA_TEST			0x00000100
#define A4XX_RB_ALPHA_CONTROL_ALPHA_TEST_FUNC__MASK		0x00000e00
#define A4XX_RB_ALPHA_CONTROL_ALPHA_TEST_FUNC__SHIFT		9
static inline uint32_t A4XX_RB_ALPHA_CONTROL_ALPHA_TEST_FUNC(enum adreno_compare_func val)
{
	return ((val) << A4XX_RB_ALPHA_CONTROL_ALPHA_TEST_FUNC__SHIFT) & A4XX_RB_ALPHA_CONTROL_ALPHA_TEST_FUNC__MASK;
}

#define REG_A4XX_RB_FS_OUTPUT					0x000020f9
#define A4XX_RB_FS_OUTPUT_ENABLE_BLEND				0x00000001
#define A4XX_RB_FS_OUTPUT_FAST_CLEAR				0x00000100
#define A4XX_RB_FS_OUTPUT_SAMPLE_MASK__MASK			0xffff0000
#define A4XX_RB_FS_OUTPUT_SAMPLE_MASK__SHIFT			16
static inline uint32_t A4XX_RB_FS_OUTPUT_SAMPLE_MASK(uint32_t val)
{
	return ((val) << A4XX_RB_FS_OUTPUT_SAMPLE_MASK__SHIFT) & A4XX_RB_FS_OUTPUT_SAMPLE_MASK__MASK;
}

#define REG_A4XX_RB_RENDER_CONTROL3				0x000020fb
#define A4XX_RB_RENDER_CONTROL3_COMPONENT_ENABLE__MASK		0x0000001f
#define A4XX_RB_RENDER_CONTROL3_COMPONENT_ENABLE__SHIFT		0
static inline uint32_t A4XX_RB_RENDER_CONTROL3_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A4XX_RB_RENDER_CONTROL3_COMPONENT_ENABLE__SHIFT) & A4XX_RB_RENDER_CONTROL3_COMPONENT_ENABLE__MASK;
}

#define REG_A4XX_RB_COPY_CONTROL				0x000020fc
#define A4XX_RB_COPY_CONTROL_MSAA_RESOLVE__MASK			0x00000003
#define A4XX_RB_COPY_CONTROL_MSAA_RESOLVE__SHIFT		0
static inline uint32_t A4XX_RB_COPY_CONTROL_MSAA_RESOLVE(enum a3xx_msaa_samples val)
{
	return ((val) << A4XX_RB_COPY_CONTROL_MSAA_RESOLVE__SHIFT) & A4XX_RB_COPY_CONTROL_MSAA_RESOLVE__MASK;
}
#define A4XX_RB_COPY_CONTROL_MODE__MASK				0x00000070
#define A4XX_RB_COPY_CONTROL_MODE__SHIFT			4
static inline uint32_t A4XX_RB_COPY_CONTROL_MODE(enum adreno_rb_copy_control_mode val)
{
	return ((val) << A4XX_RB_COPY_CONTROL_MODE__SHIFT) & A4XX_RB_COPY_CONTROL_MODE__MASK;
}
#define A4XX_RB_COPY_CONTROL_FASTCLEAR__MASK			0x00000f00
#define A4XX_RB_COPY_CONTROL_FASTCLEAR__SHIFT			8
static inline uint32_t A4XX_RB_COPY_CONTROL_FASTCLEAR(uint32_t val)
{
	return ((val) << A4XX_RB_COPY_CONTROL_FASTCLEAR__SHIFT) & A4XX_RB_COPY_CONTROL_FASTCLEAR__MASK;
}
#define A4XX_RB_COPY_CONTROL_GMEM_BASE__MASK			0xffffc000
#define A4XX_RB_COPY_CONTROL_GMEM_BASE__SHIFT			14
static inline uint32_t A4XX_RB_COPY_CONTROL_GMEM_BASE(uint32_t val)
{
	return ((val >> 14) << A4XX_RB_COPY_CONTROL_GMEM_BASE__SHIFT) & A4XX_RB_COPY_CONTROL_GMEM_BASE__MASK;
}

#define REG_A4XX_RB_COPY_DEST_BASE				0x000020fd
#define A4XX_RB_COPY_DEST_BASE_BASE__MASK			0xffffffe0
#define A4XX_RB_COPY_DEST_BASE_BASE__SHIFT			5
static inline uint32_t A4XX_RB_COPY_DEST_BASE_BASE(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_COPY_DEST_BASE_BASE__SHIFT) & A4XX_RB_COPY_DEST_BASE_BASE__MASK;
}

#define REG_A4XX_RB_COPY_DEST_PITCH				0x000020fe
#define A4XX_RB_COPY_DEST_PITCH_PITCH__MASK			0xffffffff
#define A4XX_RB_COPY_DEST_PITCH_PITCH__SHIFT			0
static inline uint32_t A4XX_RB_COPY_DEST_PITCH_PITCH(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_COPY_DEST_PITCH_PITCH__SHIFT) & A4XX_RB_COPY_DEST_PITCH_PITCH__MASK;
}

#define REG_A4XX_RB_COPY_DEST_INFO				0x000020ff
#define A4XX_RB_COPY_DEST_INFO_FORMAT__MASK			0x000000fc
#define A4XX_RB_COPY_DEST_INFO_FORMAT__SHIFT			2
static inline uint32_t A4XX_RB_COPY_DEST_INFO_FORMAT(enum a4xx_color_fmt val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_FORMAT__SHIFT) & A4XX_RB_COPY_DEST_INFO_FORMAT__MASK;
}
#define A4XX_RB_COPY_DEST_INFO_SWAP__MASK			0x00000300
#define A4XX_RB_COPY_DEST_INFO_SWAP__SHIFT			8
static inline uint32_t A4XX_RB_COPY_DEST_INFO_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_SWAP__SHIFT) & A4XX_RB_COPY_DEST_INFO_SWAP__MASK;
}
#define A4XX_RB_COPY_DEST_INFO_DITHER_MODE__MASK		0x00000c00
#define A4XX_RB_COPY_DEST_INFO_DITHER_MODE__SHIFT		10
static inline uint32_t A4XX_RB_COPY_DEST_INFO_DITHER_MODE(enum adreno_rb_dither_mode val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_DITHER_MODE__SHIFT) & A4XX_RB_COPY_DEST_INFO_DITHER_MODE__MASK;
}
#define A4XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__MASK		0x0003c000
#define A4XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__SHIFT		14
static inline uint32_t A4XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__SHIFT) & A4XX_RB_COPY_DEST_INFO_COMPONENT_ENABLE__MASK;
}
#define A4XX_RB_COPY_DEST_INFO_ENDIAN__MASK			0x001c0000
#define A4XX_RB_COPY_DEST_INFO_ENDIAN__SHIFT			18
static inline uint32_t A4XX_RB_COPY_DEST_INFO_ENDIAN(enum adreno_rb_surface_endian val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_ENDIAN__SHIFT) & A4XX_RB_COPY_DEST_INFO_ENDIAN__MASK;
}
#define A4XX_RB_COPY_DEST_INFO_TILE__MASK			0x03000000
#define A4XX_RB_COPY_DEST_INFO_TILE__SHIFT			24
static inline uint32_t A4XX_RB_COPY_DEST_INFO_TILE(enum a4xx_tile_mode val)
{
	return ((val) << A4XX_RB_COPY_DEST_INFO_TILE__SHIFT) & A4XX_RB_COPY_DEST_INFO_TILE__MASK;
}

#define REG_A4XX_RB_FS_OUTPUT_REG				0x00002100
#define A4XX_RB_FS_OUTPUT_REG_COLOR_PIPE_ENABLE			0x00000001
#define A4XX_RB_FS_OUTPUT_REG_FRAG_WRITES_Z			0x00000020

#define REG_A4XX_RB_DEPTH_CONTROL				0x00002101
#define A4XX_RB_DEPTH_CONTROL_FRAG_WRITES_Z			0x00000001
#define A4XX_RB_DEPTH_CONTROL_Z_ENABLE				0x00000002
#define A4XX_RB_DEPTH_CONTROL_Z_WRITE_ENABLE			0x00000004
#define A4XX_RB_DEPTH_CONTROL_ZFUNC__MASK			0x00000070
#define A4XX_RB_DEPTH_CONTROL_ZFUNC__SHIFT			4
static inline uint32_t A4XX_RB_DEPTH_CONTROL_ZFUNC(enum adreno_compare_func val)
{
	return ((val) << A4XX_RB_DEPTH_CONTROL_ZFUNC__SHIFT) & A4XX_RB_DEPTH_CONTROL_ZFUNC__MASK;
}
#define A4XX_RB_DEPTH_CONTROL_BF_ENABLE				0x00000080
#define A4XX_RB_DEPTH_CONTROL_EARLY_Z_DISABLE			0x00010000
#define A4XX_RB_DEPTH_CONTROL_Z_TEST_ENABLE			0x80000000

#define REG_A4XX_RB_DEPTH_CLEAR					0x00002102

#define REG_A4XX_RB_DEPTH_INFO					0x00002103
#define A4XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK			0x00000003
#define A4XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT			0
static inline uint32_t A4XX_RB_DEPTH_INFO_DEPTH_FORMAT(enum a4xx_depth_format val)
{
	return ((val) << A4XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT) & A4XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK;
}
#define A4XX_RB_DEPTH_INFO_DEPTH_BASE__MASK			0xfffff000
#define A4XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT			12
static inline uint32_t A4XX_RB_DEPTH_INFO_DEPTH_BASE(uint32_t val)
{
	return ((val >> 12) << A4XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT) & A4XX_RB_DEPTH_INFO_DEPTH_BASE__MASK;
}

#define REG_A4XX_RB_DEPTH_PITCH					0x00002104
#define A4XX_RB_DEPTH_PITCH__MASK				0xffffffff
#define A4XX_RB_DEPTH_PITCH__SHIFT				0
static inline uint32_t A4XX_RB_DEPTH_PITCH(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_DEPTH_PITCH__SHIFT) & A4XX_RB_DEPTH_PITCH__MASK;
}

#define REG_A4XX_RB_DEPTH_PITCH2				0x00002105
#define A4XX_RB_DEPTH_PITCH2__MASK				0xffffffff
#define A4XX_RB_DEPTH_PITCH2__SHIFT				0
static inline uint32_t A4XX_RB_DEPTH_PITCH2(uint32_t val)
{
	return ((val >> 5) << A4XX_RB_DEPTH_PITCH2__SHIFT) & A4XX_RB_DEPTH_PITCH2__MASK;
}

#define REG_A4XX_RB_STENCIL_CONTROL				0x00002106
#define A4XX_RB_STENCIL_CONTROL_STENCIL_ENABLE			0x00000001
#define A4XX_RB_STENCIL_CONTROL_STENCIL_ENABLE_BF		0x00000002
#define A4XX_RB_STENCIL_CONTROL_STENCIL_READ			0x00000004
#define A4XX_RB_STENCIL_CONTROL_FUNC__MASK			0x00000700
#define A4XX_RB_STENCIL_CONTROL_FUNC__SHIFT			8
static inline uint32_t A4XX_RB_STENCIL_CONTROL_FUNC(enum adreno_compare_func val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_FUNC__SHIFT) & A4XX_RB_STENCIL_CONTROL_FUNC__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_FAIL__MASK			0x00003800
#define A4XX_RB_STENCIL_CONTROL_FAIL__SHIFT			11
static inline uint32_t A4XX_RB_STENCIL_CONTROL_FAIL(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_FAIL__SHIFT) & A4XX_RB_STENCIL_CONTROL_FAIL__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_ZPASS__MASK			0x0001c000
#define A4XX_RB_STENCIL_CONTROL_ZPASS__SHIFT			14
static inline uint32_t A4XX_RB_STENCIL_CONTROL_ZPASS(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_ZPASS__SHIFT) & A4XX_RB_STENCIL_CONTROL_ZPASS__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_ZFAIL__MASK			0x000e0000
#define A4XX_RB_STENCIL_CONTROL_ZFAIL__SHIFT			17
static inline uint32_t A4XX_RB_STENCIL_CONTROL_ZFAIL(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_ZFAIL__SHIFT) & A4XX_RB_STENCIL_CONTROL_ZFAIL__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_FUNC_BF__MASK			0x00700000
#define A4XX_RB_STENCIL_CONTROL_FUNC_BF__SHIFT			20
static inline uint32_t A4XX_RB_STENCIL_CONTROL_FUNC_BF(enum adreno_compare_func val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_FUNC_BF__SHIFT) & A4XX_RB_STENCIL_CONTROL_FUNC_BF__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_FAIL_BF__MASK			0x03800000
#define A4XX_RB_STENCIL_CONTROL_FAIL_BF__SHIFT			23
static inline uint32_t A4XX_RB_STENCIL_CONTROL_FAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_FAIL_BF__SHIFT) & A4XX_RB_STENCIL_CONTROL_FAIL_BF__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_ZPASS_BF__MASK			0x1c000000
#define A4XX_RB_STENCIL_CONTROL_ZPASS_BF__SHIFT			26
static inline uint32_t A4XX_RB_STENCIL_CONTROL_ZPASS_BF(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_ZPASS_BF__SHIFT) & A4XX_RB_STENCIL_CONTROL_ZPASS_BF__MASK;
}
#define A4XX_RB_STENCIL_CONTROL_ZFAIL_BF__MASK			0xe0000000
#define A4XX_RB_STENCIL_CONTROL_ZFAIL_BF__SHIFT			29
static inline uint32_t A4XX_RB_STENCIL_CONTROL_ZFAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A4XX_RB_STENCIL_CONTROL_ZFAIL_BF__SHIFT) & A4XX_RB_STENCIL_CONTROL_ZFAIL_BF__MASK;
}

#define REG_A4XX_RB_STENCIL_CONTROL2				0x00002107
#define A4XX_RB_STENCIL_CONTROL2_STENCIL_BUFFER			0x00000001

#define REG_A4XX_RB_STENCILREFMASK				0x0000210b
#define A4XX_RB_STENCILREFMASK_STENCILREF__MASK			0x000000ff
#define A4XX_RB_STENCILREFMASK_STENCILREF__SHIFT		0
static inline uint32_t A4XX_RB_STENCILREFMASK_STENCILREF(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_STENCILREF__SHIFT) & A4XX_RB_STENCILREFMASK_STENCILREF__MASK;
}
#define A4XX_RB_STENCILREFMASK_STENCILMASK__MASK		0x0000ff00
#define A4XX_RB_STENCILREFMASK_STENCILMASK__SHIFT		8
static inline uint32_t A4XX_RB_STENCILREFMASK_STENCILMASK(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_STENCILMASK__SHIFT) & A4XX_RB_STENCILREFMASK_STENCILMASK__MASK;
}
#define A4XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK		0x00ff0000
#define A4XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT		16
static inline uint32_t A4XX_RB_STENCILREFMASK_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT) & A4XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK;
}

#define REG_A4XX_RB_STENCILREFMASK_BF				0x0000210c
#define A4XX_RB_STENCILREFMASK_BF_STENCILREF__MASK		0x000000ff
#define A4XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT		0
static inline uint32_t A4XX_RB_STENCILREFMASK_BF_STENCILREF(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT) & A4XX_RB_STENCILREFMASK_BF_STENCILREF__MASK;
}
#define A4XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK		0x0000ff00
#define A4XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT		8
static inline uint32_t A4XX_RB_STENCILREFMASK_BF_STENCILMASK(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT) & A4XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK;
}
#define A4XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK	0x00ff0000
#define A4XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT	16
static inline uint32_t A4XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A4XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT) & A4XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK;
}

#define REG_A4XX_RB_BIN_OFFSET					0x0000210d
#define A4XX_RB_BIN_OFFSET_WINDOW_OFFSET_DISABLE		0x80000000
#define A4XX_RB_BIN_OFFSET_X__MASK				0x00007fff
#define A4XX_RB_BIN_OFFSET_X__SHIFT				0
static inline uint32_t A4XX_RB_BIN_OFFSET_X(uint32_t val)
{
	return ((val) << A4XX_RB_BIN_OFFSET_X__SHIFT) & A4XX_RB_BIN_OFFSET_X__MASK;
}
#define A4XX_RB_BIN_OFFSET_Y__MASK				0x7fff0000
#define A4XX_RB_BIN_OFFSET_Y__SHIFT				16
static inline uint32_t A4XX_RB_BIN_OFFSET_Y(uint32_t val)
{
	return ((val) << A4XX_RB_BIN_OFFSET_Y__SHIFT) & A4XX_RB_BIN_OFFSET_Y__MASK;
}

static inline uint32_t REG_A4XX_RB_VPORT_Z_CLAMP(uint32_t i0) { return 0x00002120 + 0x2*i0; }

static inline uint32_t REG_A4XX_RB_VPORT_Z_CLAMP_MIN(uint32_t i0) { return 0x00002120 + 0x2*i0; }

static inline uint32_t REG_A4XX_RB_VPORT_Z_CLAMP_MAX(uint32_t i0) { return 0x00002121 + 0x2*i0; }

#define REG_A4XX_RBBM_HW_VERSION				0x00000000

#define REG_A4XX_RBBM_HW_CONFIGURATION				0x00000002

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_TP(uint32_t i0) { return 0x00000004 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_TP_REG(uint32_t i0) { return 0x00000004 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_TP(uint32_t i0) { return 0x00000008 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_TP_REG(uint32_t i0) { return 0x00000008 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_TP(uint32_t i0) { return 0x0000000c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_TP_REG(uint32_t i0) { return 0x0000000c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_TP(uint32_t i0) { return 0x00000010 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_TP_REG(uint32_t i0) { return 0x00000010 + 0x1*i0; }

#define REG_A4XX_RBBM_CLOCK_CTL_UCHE 				0x00000014

#define REG_A4XX_RBBM_CLOCK_CTL2_UCHE				0x00000015

#define REG_A4XX_RBBM_CLOCK_CTL3_UCHE				0x00000016

#define REG_A4XX_RBBM_CLOCK_CTL4_UCHE				0x00000017

#define REG_A4XX_RBBM_CLOCK_HYST_UCHE				0x00000018

#define REG_A4XX_RBBM_CLOCK_DELAY_UCHE				0x00000019

#define REG_A4XX_RBBM_CLOCK_MODE_GPC				0x0000001a

#define REG_A4XX_RBBM_CLOCK_DELAY_GPC				0x0000001b

#define REG_A4XX_RBBM_CLOCK_HYST_GPC				0x0000001c

#define REG_A4XX_RBBM_CLOCK_CTL_TSE_RAS_RBBM			0x0000001d

#define REG_A4XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM			0x0000001e

#define REG_A4XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM			0x0000001f

#define REG_A4XX_RBBM_CLOCK_CTL					0x00000020

#define REG_A4XX_RBBM_SP_HYST_CNT				0x00000021

#define REG_A4XX_RBBM_SW_RESET_CMD				0x00000022

#define REG_A4XX_RBBM_AHB_CTL0					0x00000023

#define REG_A4XX_RBBM_AHB_CTL1					0x00000024

#define REG_A4XX_RBBM_AHB_CMD					0x00000025

#define REG_A4XX_RBBM_RB_SUB_BLOCK_SEL_CTL			0x00000026

#define REG_A4XX_RBBM_RAM_ACC_63_32				0x00000028

#define REG_A4XX_RBBM_WAIT_IDLE_CLOCKS_CTL			0x0000002b

#define REG_A4XX_RBBM_INTERFACE_HANG_INT_CTL			0x0000002f

#define REG_A4XX_RBBM_INTERFACE_HANG_MASK_CTL4			0x00000034

#define REG_A4XX_RBBM_INT_CLEAR_CMD				0x00000036

#define REG_A4XX_RBBM_INT_0_MASK				0x00000037

#define REG_A4XX_RBBM_RBBM_CTL					0x0000003e

#define REG_A4XX_RBBM_AHB_DEBUG_CTL				0x0000003f

#define REG_A4XX_RBBM_VBIF_DEBUG_CTL				0x00000041

#define REG_A4XX_RBBM_CLOCK_CTL2				0x00000042

#define REG_A4XX_RBBM_BLOCK_SW_RESET_CMD			0x00000045

#define REG_A4XX_RBBM_RESET_CYCLES				0x00000047

#define REG_A4XX_RBBM_EXT_TRACE_BUS_CTL				0x00000049

#define REG_A4XX_RBBM_CFG_DEBBUS_SEL_A				0x0000004a

#define REG_A4XX_RBBM_CFG_DEBBUS_SEL_B				0x0000004b

#define REG_A4XX_RBBM_CFG_DEBBUS_SEL_C				0x0000004c

#define REG_A4XX_RBBM_CFG_DEBBUS_SEL_D				0x0000004d

#define REG_A4XX_RBBM_PERFCTR_CP_0_LO				0x0000009c

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_SP(uint32_t i0) { return 0x00000068 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_SP_REG(uint32_t i0) { return 0x00000068 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_SP(uint32_t i0) { return 0x0000006c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_SP_REG(uint32_t i0) { return 0x0000006c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_SP(uint32_t i0) { return 0x00000070 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_SP_REG(uint32_t i0) { return 0x00000070 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_SP(uint32_t i0) { return 0x00000074 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_SP_REG(uint32_t i0) { return 0x00000074 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_RB(uint32_t i0) { return 0x00000078 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_RB_REG(uint32_t i0) { return 0x00000078 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_RB(uint32_t i0) { return 0x0000007c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL2_RB_REG(uint32_t i0) { return 0x0000007c + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_MARB_CCU(uint32_t i0) { return 0x00000082 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_CTL_MARB_CCU_REG(uint32_t i0) { return 0x00000082 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_RB_MARB_CCU(uint32_t i0) { return 0x00000086 + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_HYST_RB_MARB_CCU_REG(uint32_t i0) { return 0x00000086 + 0x1*i0; }

#define REG_A4XX_RBBM_CLOCK_HYST_COM_DCOM			0x00000080

#define REG_A4XX_RBBM_CLOCK_CTL_COM_DCOM			0x00000081

#define REG_A4XX_RBBM_CLOCK_CTL_HLSQ				0x0000008a

#define REG_A4XX_RBBM_CLOCK_HYST_HLSQ				0x0000008b

#define REG_A4XX_RBBM_CLOCK_DELAY_HLSQ				0x0000008c

#define REG_A4XX_RBBM_CLOCK_DELAY_COM_DCOM			0x0000008d

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_RB_MARB_CCU_L1(uint32_t i0) { return 0x0000008e + 0x1*i0; }

static inline uint32_t REG_A4XX_RBBM_CLOCK_DELAY_RB_MARB_CCU_L1_REG(uint32_t i0) { return 0x0000008e + 0x1*i0; }

#define REG_A4XX_RBBM_PERFCTR_PWR_1_LO				0x00000168

#define REG_A4XX_RBBM_PERFCTR_CTL				0x00000170

#define REG_A4XX_RBBM_PERFCTR_LOAD_CMD0				0x00000171

#define REG_A4XX_RBBM_PERFCTR_LOAD_CMD1				0x00000172

#define REG_A4XX_RBBM_PERFCTR_LOAD_CMD2				0x00000173

#define REG_A4XX_RBBM_PERFCTR_LOAD_VALUE_LO			0x00000174

#define REG_A4XX_RBBM_PERFCTR_LOAD_VALUE_HI			0x00000175

#define REG_A4XX_RBBM_GPU_BUSY_MASKED				0x0000017a

#define REG_A4XX_RBBM_INT_0_STATUS				0x0000017d

#define REG_A4XX_RBBM_CLOCK_STATUS				0x00000182

#define REG_A4XX_RBBM_AHB_STATUS				0x00000189

#define REG_A4XX_RBBM_AHB_ME_SPLIT_STATUS			0x0000018c

#define REG_A4XX_RBBM_AHB_PFP_SPLIT_STATUS			0x0000018d

#define REG_A4XX_RBBM_AHB_ERROR_STATUS				0x0000018f

#define REG_A4XX_RBBM_STATUS					0x00000191
#define A4XX_RBBM_STATUS_HI_BUSY				0x00000001
#define A4XX_RBBM_STATUS_CP_ME_BUSY				0x00000002
#define A4XX_RBBM_STATUS_CP_PFP_BUSY				0x00000004
#define A4XX_RBBM_STATUS_CP_NRT_BUSY				0x00004000
#define A4XX_RBBM_STATUS_VBIF_BUSY				0x00008000
#define A4XX_RBBM_STATUS_TSE_BUSY				0x00010000
#define A4XX_RBBM_STATUS_RAS_BUSY				0x00020000
#define A4XX_RBBM_STATUS_RB_BUSY				0x00040000
#define A4XX_RBBM_STATUS_PC_DCALL_BUSY				0x00080000
#define A4XX_RBBM_STATUS_PC_VSD_BUSY				0x00100000
#define A4XX_RBBM_STATUS_VFD_BUSY				0x00200000
#define A4XX_RBBM_STATUS_VPC_BUSY				0x00400000
#define A4XX_RBBM_STATUS_UCHE_BUSY				0x00800000
#define A4XX_RBBM_STATUS_SP_BUSY				0x01000000
#define A4XX_RBBM_STATUS_TPL1_BUSY				0x02000000
#define A4XX_RBBM_STATUS_MARB_BUSY				0x04000000
#define A4XX_RBBM_STATUS_VSC_BUSY				0x08000000
#define A4XX_RBBM_STATUS_ARB_BUSY				0x10000000
#define A4XX_RBBM_STATUS_HLSQ_BUSY				0x20000000
#define A4XX_RBBM_STATUS_GPU_BUSY_NOHC				0x40000000
#define A4XX_RBBM_STATUS_GPU_BUSY				0x80000000

#define REG_A4XX_RBBM_INTERFACE_RRDY_STATUS5			0x0000019f

#define REG_A4XX_CP_SCRATCH_UMASK				0x00000228

#define REG_A4XX_CP_SCRATCH_ADDR				0x00000229

#define REG_A4XX_CP_RB_BASE					0x00000200

#define REG_A4XX_CP_RB_CNTL					0x00000201

#define REG_A4XX_CP_RB_WPTR					0x00000205

#define REG_A4XX_CP_RB_RPTR_ADDR				0x00000203

#define REG_A4XX_CP_RB_RPTR					0x00000204

#define REG_A4XX_CP_IB1_BASE					0x00000206

#define REG_A4XX_CP_IB1_BUFSZ					0x00000207

#define REG_A4XX_CP_IB2_BASE					0x00000208

#define REG_A4XX_CP_IB2_BUFSZ					0x00000209

#define REG_A4XX_CP_ME_RB_DONE_DATA				0x00000217

#define REG_A4XX_CP_QUEUE_THRESH2				0x00000219

#define REG_A4XX_CP_MERCIU_SIZE					0x0000021b

#define REG_A4XX_CP_ROQ_ADDR					0x0000021c

#define REG_A4XX_CP_ROQ_DATA					0x0000021d

#define REG_A4XX_CP_MEQ_ADDR 					0x0000021e

#define REG_A4XX_CP_MEQ_DATA 					0x0000021f

#define REG_A4XX_CP_MERCIU_ADDR					0x00000220

#define REG_A4XX_CP_MERCIU_DATA					0x00000221

#define REG_A4XX_CP_MERCIU_DATA2				0x00000222

#define REG_A4XX_CP_PFP_UCODE_ADDR				0x00000223

#define REG_A4XX_CP_PFP_UCODE_DATA				0x00000224

#define REG_A4XX_CP_ME_RAM_WADDR				0x00000225

#define REG_A4XX_CP_ME_RAM_RADDR				0x00000226

#define REG_A4XX_CP_ME_RAM_DATA					0x00000227

#define REG_A4XX_CP_PREEMPT					0x0000022a

#define REG_A4XX_CP_CNTL					0x0000022c

#define REG_A4XX_CP_ME_CNTL					0x0000022d

#define REG_A4XX_CP_DEBUG					0x0000022e

#define REG_A4XX_CP_DEBUG_ECO_CONTROL				0x00000231

#define REG_A4XX_CP_DRAW_STATE_ADDR				0x00000232

#define REG_A4XX_CP_PROTECT_REG_0				0x00000240

static inline uint32_t REG_A4XX_CP_PROTECT(uint32_t i0) { return 0x00000240 + 0x1*i0; }

static inline uint32_t REG_A4XX_CP_PROTECT_REG(uint32_t i0) { return 0x00000240 + 0x1*i0; }

#define REG_A4XX_CP_PROTECT_CTRL				0x00000250

#define REG_A4XX_CP_ST_BASE					0x000004c0

#define REG_A4XX_CP_STQ_AVAIL					0x000004ce

#define REG_A4XX_CP_MERCIU_STAT					0x000004d0

#define REG_A4XX_CP_WFI_PEND_CTR				0x000004d2

#define REG_A4XX_CP_HW_FAULT					0x000004d8

#define REG_A4XX_CP_PROTECT_STATUS				0x000004da

#define REG_A4XX_CP_EVENTS_IN_FLIGHT				0x000004dd

#define REG_A4XX_CP_PERFCTR_CP_SEL_0				0x00000500

#define REG_A4XX_CP_PERFCOMBINER_SELECT				0x0000050b

static inline uint32_t REG_A4XX_CP_SCRATCH(uint32_t i0) { return 0x00000578 + 0x1*i0; }

static inline uint32_t REG_A4XX_CP_SCRATCH_REG(uint32_t i0) { return 0x00000578 + 0x1*i0; }

#define REG_A4XX_SP_VS_STATUS					0x00000ec0

#define REG_A4XX_SP_PERFCTR_SP_SEL_11				0x00000ecf

#define REG_A4XX_SP_SP_CTRL_REG					0x000022c0
#define A4XX_SP_SP_CTRL_REG_BINNING_PASS			0x00080000

#define REG_A4XX_SP_INSTR_CACHE_CTRL				0x000022c1

#define REG_A4XX_SP_VS_CTRL_REG0				0x000022c4
#define A4XX_SP_VS_CTRL_REG0_THREADMODE__MASK			0x00000001
#define A4XX_SP_VS_CTRL_REG0_THREADMODE__SHIFT			0
static inline uint32_t A4XX_SP_VS_CTRL_REG0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG0_THREADMODE__SHIFT) & A4XX_SP_VS_CTRL_REG0_THREADMODE__MASK;
}
#define A4XX_SP_VS_CTRL_REG0_VARYING				0x00000002
#define A4XX_SP_VS_CTRL_REG0_CACHEINVALID			0x00000004
#define A4XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__MASK		0x000003f0
#define A4XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT		4
static inline uint32_t A4XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT) & A4XX_SP_VS_CTRL_REG0_HALFREGFOOTPRINT__MASK;
}
#define A4XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__MASK		0x0003fc00
#define A4XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT		10
static inline uint32_t A4XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT) & A4XX_SP_VS_CTRL_REG0_FULLREGFOOTPRINT__MASK;
}
#define A4XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__MASK		0x000c0000
#define A4XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__SHIFT		18
static inline uint32_t A4XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP(uint32_t val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__SHIFT) & A4XX_SP_VS_CTRL_REG0_INOUTREGOVERLAP__MASK;
}
#define A4XX_SP_VS_CTRL_REG0_THREADSIZE__MASK			0x00100000
#define A4XX_SP_VS_CTRL_REG0_THREADSIZE__SHIFT			20
static inline uint32_t A4XX_SP_VS_CTRL_REG0_THREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG0_THREADSIZE__SHIFT) & A4XX_SP_VS_CTRL_REG0_THREADSIZE__MASK;
}
#define A4XX_SP_VS_CTRL_REG0_SUPERTHREADMODE			0x00200000
#define A4XX_SP_VS_CTRL_REG0_PIXLODENABLE			0x00400000

#define REG_A4XX_SP_VS_CTRL_REG1				0x000022c5
#define A4XX_SP_VS_CTRL_REG1_CONSTLENGTH__MASK			0x000000ff
#define A4XX_SP_VS_CTRL_REG1_CONSTLENGTH__SHIFT			0
static inline uint32_t A4XX_SP_VS_CTRL_REG1_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG1_CONSTLENGTH__SHIFT) & A4XX_SP_VS_CTRL_REG1_CONSTLENGTH__MASK;
}
#define A4XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__MASK		0x7f000000
#define A4XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__SHIFT		24
static inline uint32_t A4XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING(uint32_t val)
{
	return ((val) << A4XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__SHIFT) & A4XX_SP_VS_CTRL_REG1_INITIALOUTSTANDING__MASK;
}

#define REG_A4XX_SP_VS_PARAM_REG				0x000022c6
#define A4XX_SP_VS_PARAM_REG_POSREGID__MASK			0x000000ff
#define A4XX_SP_VS_PARAM_REG_POSREGID__SHIFT			0
static inline uint32_t A4XX_SP_VS_PARAM_REG_POSREGID(uint32_t val)
{
	return ((val) << A4XX_SP_VS_PARAM_REG_POSREGID__SHIFT) & A4XX_SP_VS_PARAM_REG_POSREGID__MASK;
}
#define A4XX_SP_VS_PARAM_REG_PSIZEREGID__MASK			0x0000ff00
#define A4XX_SP_VS_PARAM_REG_PSIZEREGID__SHIFT			8
static inline uint32_t A4XX_SP_VS_PARAM_REG_PSIZEREGID(uint32_t val)
{
	return ((val) << A4XX_SP_VS_PARAM_REG_PSIZEREGID__SHIFT) & A4XX_SP_VS_PARAM_REG_PSIZEREGID__MASK;
}
#define A4XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__MASK		0xfff00000
#define A4XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__SHIFT		20
static inline uint32_t A4XX_SP_VS_PARAM_REG_TOTALVSOUTVAR(uint32_t val)
{
	return ((val) << A4XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__SHIFT) & A4XX_SP_VS_PARAM_REG_TOTALVSOUTVAR__MASK;
}

static inline uint32_t REG_A4XX_SP_VS_OUT(uint32_t i0) { return 0x000022c7 + 0x1*i0; }

static inline uint32_t REG_A4XX_SP_VS_OUT_REG(uint32_t i0) { return 0x000022c7 + 0x1*i0; }
#define A4XX_SP_VS_OUT_REG_A_REGID__MASK			0x000001ff
#define A4XX_SP_VS_OUT_REG_A_REGID__SHIFT			0
static inline uint32_t A4XX_SP_VS_OUT_REG_A_REGID(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OUT_REG_A_REGID__SHIFT) & A4XX_SP_VS_OUT_REG_A_REGID__MASK;
}
#define A4XX_SP_VS_OUT_REG_A_COMPMASK__MASK			0x00001e00
#define A4XX_SP_VS_OUT_REG_A_COMPMASK__SHIFT			9
static inline uint32_t A4XX_SP_VS_OUT_REG_A_COMPMASK(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OUT_REG_A_COMPMASK__SHIFT) & A4XX_SP_VS_OUT_REG_A_COMPMASK__MASK;
}
#define A4XX_SP_VS_OUT_REG_B_REGID__MASK			0x01ff0000
#define A4XX_SP_VS_OUT_REG_B_REGID__SHIFT			16
static inline uint32_t A4XX_SP_VS_OUT_REG_B_REGID(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OUT_REG_B_REGID__SHIFT) & A4XX_SP_VS_OUT_REG_B_REGID__MASK;
}
#define A4XX_SP_VS_OUT_REG_B_COMPMASK__MASK			0x1e000000
#define A4XX_SP_VS_OUT_REG_B_COMPMASK__SHIFT			25
static inline uint32_t A4XX_SP_VS_OUT_REG_B_COMPMASK(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OUT_REG_B_COMPMASK__SHIFT) & A4XX_SP_VS_OUT_REG_B_COMPMASK__MASK;
}

static inline uint32_t REG_A4XX_SP_VS_VPC_DST(uint32_t i0) { return 0x000022d8 + 0x1*i0; }

static inline uint32_t REG_A4XX_SP_VS_VPC_DST_REG(uint32_t i0) { return 0x000022d8 + 0x1*i0; }
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC0__MASK			0x000000ff
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC0__SHIFT			0
static inline uint32_t A4XX_SP_VS_VPC_DST_REG_OUTLOC0(uint32_t val)
{
	return ((val) << A4XX_SP_VS_VPC_DST_REG_OUTLOC0__SHIFT) & A4XX_SP_VS_VPC_DST_REG_OUTLOC0__MASK;
}
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC1__MASK			0x0000ff00
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC1__SHIFT			8
static inline uint32_t A4XX_SP_VS_VPC_DST_REG_OUTLOC1(uint32_t val)
{
	return ((val) << A4XX_SP_VS_VPC_DST_REG_OUTLOC1__SHIFT) & A4XX_SP_VS_VPC_DST_REG_OUTLOC1__MASK;
}
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC2__MASK			0x00ff0000
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC2__SHIFT			16
static inline uint32_t A4XX_SP_VS_VPC_DST_REG_OUTLOC2(uint32_t val)
{
	return ((val) << A4XX_SP_VS_VPC_DST_REG_OUTLOC2__SHIFT) & A4XX_SP_VS_VPC_DST_REG_OUTLOC2__MASK;
}
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC3__MASK			0xff000000
#define A4XX_SP_VS_VPC_DST_REG_OUTLOC3__SHIFT			24
static inline uint32_t A4XX_SP_VS_VPC_DST_REG_OUTLOC3(uint32_t val)
{
	return ((val) << A4XX_SP_VS_VPC_DST_REG_OUTLOC3__SHIFT) & A4XX_SP_VS_VPC_DST_REG_OUTLOC3__MASK;
}

#define REG_A4XX_SP_VS_OBJ_OFFSET_REG				0x000022e0
#define A4XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A4XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A4XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_SP_VS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A4XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A4XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A4XX_SP_VS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A4XX_SP_VS_OBJ_START				0x000022e1

#define REG_A4XX_SP_VS_PVT_MEM_PARAM				0x000022e2

#define REG_A4XX_SP_VS_PVT_MEM_ADDR				0x000022e3

#define REG_A4XX_SP_VS_LENGTH_REG				0x000022e5

#define REG_A4XX_SP_FS_CTRL_REG0				0x000022e8
#define A4XX_SP_FS_CTRL_REG0_THREADMODE__MASK			0x00000001
#define A4XX_SP_FS_CTRL_REG0_THREADMODE__SHIFT			0
static inline uint32_t A4XX_SP_FS_CTRL_REG0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG0_THREADMODE__SHIFT) & A4XX_SP_FS_CTRL_REG0_THREADMODE__MASK;
}
#define A4XX_SP_FS_CTRL_REG0_VARYING				0x00000002
#define A4XX_SP_FS_CTRL_REG0_CACHEINVALID			0x00000004
#define A4XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__MASK		0x000003f0
#define A4XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT		4
static inline uint32_t A4XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__SHIFT) & A4XX_SP_FS_CTRL_REG0_HALFREGFOOTPRINT__MASK;
}
#define A4XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__MASK		0x0003fc00
#define A4XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT		10
static inline uint32_t A4XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__SHIFT) & A4XX_SP_FS_CTRL_REG0_FULLREGFOOTPRINT__MASK;
}
#define A4XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__MASK		0x000c0000
#define A4XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__SHIFT		18
static inline uint32_t A4XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP(uint32_t val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__SHIFT) & A4XX_SP_FS_CTRL_REG0_INOUTREGOVERLAP__MASK;
}
#define A4XX_SP_FS_CTRL_REG0_THREADSIZE__MASK			0x00100000
#define A4XX_SP_FS_CTRL_REG0_THREADSIZE__SHIFT			20
static inline uint32_t A4XX_SP_FS_CTRL_REG0_THREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG0_THREADSIZE__SHIFT) & A4XX_SP_FS_CTRL_REG0_THREADSIZE__MASK;
}
#define A4XX_SP_FS_CTRL_REG0_SUPERTHREADMODE			0x00200000
#define A4XX_SP_FS_CTRL_REG0_PIXLODENABLE			0x00400000

#define REG_A4XX_SP_FS_CTRL_REG1				0x000022e9
#define A4XX_SP_FS_CTRL_REG1_CONSTLENGTH__MASK			0x000000ff
#define A4XX_SP_FS_CTRL_REG1_CONSTLENGTH__SHIFT			0
static inline uint32_t A4XX_SP_FS_CTRL_REG1_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_SP_FS_CTRL_REG1_CONSTLENGTH__SHIFT) & A4XX_SP_FS_CTRL_REG1_CONSTLENGTH__MASK;
}
#define A4XX_SP_FS_CTRL_REG1_FACENESS				0x00080000
#define A4XX_SP_FS_CTRL_REG1_VARYING				0x00100000
#define A4XX_SP_FS_CTRL_REG1_FRAGCOORD				0x00200000

#define REG_A4XX_SP_FS_OBJ_OFFSET_REG				0x000022ea
#define A4XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A4XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A4XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_SP_FS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A4XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A4XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A4XX_SP_FS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A4XX_SP_FS_OBJ_START				0x000022eb

#define REG_A4XX_SP_FS_PVT_MEM_PARAM				0x000022ec

#define REG_A4XX_SP_FS_PVT_MEM_ADDR				0x000022ed

#define REG_A4XX_SP_FS_LENGTH_REG				0x000022ef

#define REG_A4XX_SP_FS_OUTPUT_REG				0x000022f0
#define A4XX_SP_FS_OUTPUT_REG_DEPTH_ENABLE			0x00000080
#define A4XX_SP_FS_OUTPUT_REG_DEPTH_REGID__MASK			0x0000ff00
#define A4XX_SP_FS_OUTPUT_REG_DEPTH_REGID__SHIFT		8
static inline uint32_t A4XX_SP_FS_OUTPUT_REG_DEPTH_REGID(uint32_t val)
{
	return ((val) << A4XX_SP_FS_OUTPUT_REG_DEPTH_REGID__SHIFT) & A4XX_SP_FS_OUTPUT_REG_DEPTH_REGID__MASK;
}

static inline uint32_t REG_A4XX_SP_FS_MRT(uint32_t i0) { return 0x000022f1 + 0x1*i0; }

static inline uint32_t REG_A4XX_SP_FS_MRT_REG(uint32_t i0) { return 0x000022f1 + 0x1*i0; }
#define A4XX_SP_FS_MRT_REG_REGID__MASK				0x000000ff
#define A4XX_SP_FS_MRT_REG_REGID__SHIFT				0
static inline uint32_t A4XX_SP_FS_MRT_REG_REGID(uint32_t val)
{
	return ((val) << A4XX_SP_FS_MRT_REG_REGID__SHIFT) & A4XX_SP_FS_MRT_REG_REGID__MASK;
}
#define A4XX_SP_FS_MRT_REG_HALF_PRECISION			0x00000100
#define A4XX_SP_FS_MRT_REG_MRTFORMAT__MASK			0x0003f000
#define A4XX_SP_FS_MRT_REG_MRTFORMAT__SHIFT			12
static inline uint32_t A4XX_SP_FS_MRT_REG_MRTFORMAT(enum a4xx_color_fmt val)
{
	return ((val) << A4XX_SP_FS_MRT_REG_MRTFORMAT__SHIFT) & A4XX_SP_FS_MRT_REG_MRTFORMAT__MASK;
}

#define REG_A4XX_SP_HS_OBJ_OFFSET_REG				0x0000230d
#define A4XX_SP_HS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A4XX_SP_HS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A4XX_SP_HS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_HS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_SP_HS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_SP_HS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A4XX_SP_HS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A4XX_SP_HS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_HS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A4XX_SP_HS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A4XX_SP_DS_OBJ_OFFSET_REG				0x00002334
#define A4XX_SP_DS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A4XX_SP_DS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A4XX_SP_DS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_DS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_SP_DS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_SP_DS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A4XX_SP_DS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A4XX_SP_DS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_DS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A4XX_SP_DS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A4XX_SP_GS_OBJ_OFFSET_REG				0x0000235b
#define A4XX_SP_GS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK	0x01ff0000
#define A4XX_SP_GS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT	16
static inline uint32_t A4XX_SP_GS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_GS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_SP_GS_OBJ_OFFSET_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_SP_GS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK		0xfe000000
#define A4XX_SP_GS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT	25
static inline uint32_t A4XX_SP_GS_OBJ_OFFSET_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_SP_GS_OBJ_OFFSET_REG_SHADEROBJOFFSET__SHIFT) & A4XX_SP_GS_OBJ_OFFSET_REG_SHADEROBJOFFSET__MASK;
}

#define REG_A4XX_SP_GS_LENGTH_REG				0x00002360

#define REG_A4XX_VPC_DEBUG_RAM_SEL				0x00000e60

#define REG_A4XX_VPC_DEBUG_RAM_READ				0x00000e61

#define REG_A4XX_VPC_DEBUG_ECO_CONTROL				0x00000e64

#define REG_A4XX_VPC_PERFCTR_VPC_SEL_3				0x00000e68

#define REG_A4XX_VPC_ATTR					0x00002140
#define A4XX_VPC_ATTR_TOTALATTR__MASK				0x000001ff
#define A4XX_VPC_ATTR_TOTALATTR__SHIFT				0
static inline uint32_t A4XX_VPC_ATTR_TOTALATTR(uint32_t val)
{
	return ((val) << A4XX_VPC_ATTR_TOTALATTR__SHIFT) & A4XX_VPC_ATTR_TOTALATTR__MASK;
}
#define A4XX_VPC_ATTR_PSIZE					0x00000200
#define A4XX_VPC_ATTR_THRDASSIGN__MASK				0x00003000
#define A4XX_VPC_ATTR_THRDASSIGN__SHIFT				12
static inline uint32_t A4XX_VPC_ATTR_THRDASSIGN(uint32_t val)
{
	return ((val) << A4XX_VPC_ATTR_THRDASSIGN__SHIFT) & A4XX_VPC_ATTR_THRDASSIGN__MASK;
}
#define A4XX_VPC_ATTR_ENABLE					0x02000000

#define REG_A4XX_VPC_PACK					0x00002141
#define A4XX_VPC_PACK_NUMBYPASSVAR__MASK			0x000000ff
#define A4XX_VPC_PACK_NUMBYPASSVAR__SHIFT			0
static inline uint32_t A4XX_VPC_PACK_NUMBYPASSVAR(uint32_t val)
{
	return ((val) << A4XX_VPC_PACK_NUMBYPASSVAR__SHIFT) & A4XX_VPC_PACK_NUMBYPASSVAR__MASK;
}
#define A4XX_VPC_PACK_NUMFPNONPOSVAR__MASK			0x0000ff00
#define A4XX_VPC_PACK_NUMFPNONPOSVAR__SHIFT			8
static inline uint32_t A4XX_VPC_PACK_NUMFPNONPOSVAR(uint32_t val)
{
	return ((val) << A4XX_VPC_PACK_NUMFPNONPOSVAR__SHIFT) & A4XX_VPC_PACK_NUMFPNONPOSVAR__MASK;
}
#define A4XX_VPC_PACK_NUMNONPOSVSVAR__MASK			0x00ff0000
#define A4XX_VPC_PACK_NUMNONPOSVSVAR__SHIFT			16
static inline uint32_t A4XX_VPC_PACK_NUMNONPOSVSVAR(uint32_t val)
{
	return ((val) << A4XX_VPC_PACK_NUMNONPOSVSVAR__SHIFT) & A4XX_VPC_PACK_NUMNONPOSVSVAR__MASK;
}

static inline uint32_t REG_A4XX_VPC_VARYING_INTERP(uint32_t i0) { return 0x00002142 + 0x1*i0; }

static inline uint32_t REG_A4XX_VPC_VARYING_INTERP_MODE(uint32_t i0) { return 0x00002142 + 0x1*i0; }

static inline uint32_t REG_A4XX_VPC_VARYING_PS_REPL(uint32_t i0) { return 0x0000214a + 0x1*i0; }

static inline uint32_t REG_A4XX_VPC_VARYING_PS_REPL_MODE(uint32_t i0) { return 0x0000214a + 0x1*i0; }

#define REG_A4XX_VPC_SO_FLUSH_WADDR_3				0x0000216e

#define REG_A4XX_VSC_BIN_SIZE					0x00000c00
#define A4XX_VSC_BIN_SIZE_WIDTH__MASK				0x0000001f
#define A4XX_VSC_BIN_SIZE_WIDTH__SHIFT				0
static inline uint32_t A4XX_VSC_BIN_SIZE_WIDTH(uint32_t val)
{
	return ((val >> 5) << A4XX_VSC_BIN_SIZE_WIDTH__SHIFT) & A4XX_VSC_BIN_SIZE_WIDTH__MASK;
}
#define A4XX_VSC_BIN_SIZE_HEIGHT__MASK				0x000003e0
#define A4XX_VSC_BIN_SIZE_HEIGHT__SHIFT				5
static inline uint32_t A4XX_VSC_BIN_SIZE_HEIGHT(uint32_t val)
{
	return ((val >> 5) << A4XX_VSC_BIN_SIZE_HEIGHT__SHIFT) & A4XX_VSC_BIN_SIZE_HEIGHT__MASK;
}

#define REG_A4XX_VSC_SIZE_ADDRESS				0x00000c01

#define REG_A4XX_VSC_SIZE_ADDRESS2				0x00000c02

#define REG_A4XX_VSC_DEBUG_ECO_CONTROL				0x00000c03

static inline uint32_t REG_A4XX_VSC_PIPE_CONFIG(uint32_t i0) { return 0x00000c08 + 0x1*i0; }

static inline uint32_t REG_A4XX_VSC_PIPE_CONFIG_REG(uint32_t i0) { return 0x00000c08 + 0x1*i0; }
#define A4XX_VSC_PIPE_CONFIG_REG_X__MASK			0x000003ff
#define A4XX_VSC_PIPE_CONFIG_REG_X__SHIFT			0
static inline uint32_t A4XX_VSC_PIPE_CONFIG_REG_X(uint32_t val)
{
	return ((val) << A4XX_VSC_PIPE_CONFIG_REG_X__SHIFT) & A4XX_VSC_PIPE_CONFIG_REG_X__MASK;
}
#define A4XX_VSC_PIPE_CONFIG_REG_Y__MASK			0x000ffc00
#define A4XX_VSC_PIPE_CONFIG_REG_Y__SHIFT			10
static inline uint32_t A4XX_VSC_PIPE_CONFIG_REG_Y(uint32_t val)
{
	return ((val) << A4XX_VSC_PIPE_CONFIG_REG_Y__SHIFT) & A4XX_VSC_PIPE_CONFIG_REG_Y__MASK;
}
#define A4XX_VSC_PIPE_CONFIG_REG_W__MASK			0x00f00000
#define A4XX_VSC_PIPE_CONFIG_REG_W__SHIFT			20
static inline uint32_t A4XX_VSC_PIPE_CONFIG_REG_W(uint32_t val)
{
	return ((val) << A4XX_VSC_PIPE_CONFIG_REG_W__SHIFT) & A4XX_VSC_PIPE_CONFIG_REG_W__MASK;
}
#define A4XX_VSC_PIPE_CONFIG_REG_H__MASK			0x0f000000
#define A4XX_VSC_PIPE_CONFIG_REG_H__SHIFT			24
static inline uint32_t A4XX_VSC_PIPE_CONFIG_REG_H(uint32_t val)
{
	return ((val) << A4XX_VSC_PIPE_CONFIG_REG_H__SHIFT) & A4XX_VSC_PIPE_CONFIG_REG_H__MASK;
}

static inline uint32_t REG_A4XX_VSC_PIPE_DATA_ADDRESS(uint32_t i0) { return 0x00000c10 + 0x1*i0; }

static inline uint32_t REG_A4XX_VSC_PIPE_DATA_ADDRESS_REG(uint32_t i0) { return 0x00000c10 + 0x1*i0; }

static inline uint32_t REG_A4XX_VSC_PIPE_DATA_LENGTH(uint32_t i0) { return 0x00000c18 + 0x1*i0; }

static inline uint32_t REG_A4XX_VSC_PIPE_DATA_LENGTH_REG(uint32_t i0) { return 0x00000c18 + 0x1*i0; }

#define REG_A4XX_VSC_PIPE_PARTIAL_POSN_1			0x00000c41

#define REG_A4XX_VSC_PERFCTR_VSC_SEL_0				0x00000c50

#define REG_A4XX_VSC_PERFCTR_VSC_SEL_1				0x00000c51

#define REG_A4XX_VFD_DEBUG_CONTROL				0x00000e40

#define REG_A4XX_VFD_PERFCTR_VFD_SEL_7				0x00000e4a

#define REG_A4XX_VFD_CONTROL_0					0x00002200
#define A4XX_VFD_CONTROL_0_TOTALATTRTOVS__MASK			0x000000ff
#define A4XX_VFD_CONTROL_0_TOTALATTRTOVS__SHIFT			0
static inline uint32_t A4XX_VFD_CONTROL_0_TOTALATTRTOVS(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_0_TOTALATTRTOVS__SHIFT) & A4XX_VFD_CONTROL_0_TOTALATTRTOVS__MASK;
}
#define A4XX_VFD_CONTROL_0_BYPASSATTROVS__MASK			0x0001fe00
#define A4XX_VFD_CONTROL_0_BYPASSATTROVS__SHIFT			9
static inline uint32_t A4XX_VFD_CONTROL_0_BYPASSATTROVS(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_0_BYPASSATTROVS__SHIFT) & A4XX_VFD_CONTROL_0_BYPASSATTROVS__MASK;
}
#define A4XX_VFD_CONTROL_0_STRMDECINSTRCNT__MASK		0x03f00000
#define A4XX_VFD_CONTROL_0_STRMDECINSTRCNT__SHIFT		20
static inline uint32_t A4XX_VFD_CONTROL_0_STRMDECINSTRCNT(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_0_STRMDECINSTRCNT__SHIFT) & A4XX_VFD_CONTROL_0_STRMDECINSTRCNT__MASK;
}
#define A4XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__MASK		0xfc000000
#define A4XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__SHIFT		26
static inline uint32_t A4XX_VFD_CONTROL_0_STRMFETCHINSTRCNT(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__SHIFT) & A4XX_VFD_CONTROL_0_STRMFETCHINSTRCNT__MASK;
}

#define REG_A4XX_VFD_CONTROL_1					0x00002201
#define A4XX_VFD_CONTROL_1_MAXSTORAGE__MASK			0x0000ffff
#define A4XX_VFD_CONTROL_1_MAXSTORAGE__SHIFT			0
static inline uint32_t A4XX_VFD_CONTROL_1_MAXSTORAGE(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_1_MAXSTORAGE__SHIFT) & A4XX_VFD_CONTROL_1_MAXSTORAGE__MASK;
}
#define A4XX_VFD_CONTROL_1_REGID4VTX__MASK			0x00ff0000
#define A4XX_VFD_CONTROL_1_REGID4VTX__SHIFT			16
static inline uint32_t A4XX_VFD_CONTROL_1_REGID4VTX(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_1_REGID4VTX__SHIFT) & A4XX_VFD_CONTROL_1_REGID4VTX__MASK;
}
#define A4XX_VFD_CONTROL_1_REGID4INST__MASK			0xff000000
#define A4XX_VFD_CONTROL_1_REGID4INST__SHIFT			24
static inline uint32_t A4XX_VFD_CONTROL_1_REGID4INST(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_1_REGID4INST__SHIFT) & A4XX_VFD_CONTROL_1_REGID4INST__MASK;
}

#define REG_A4XX_VFD_CONTROL_2					0x00002202

#define REG_A4XX_VFD_CONTROL_3					0x00002203
#define A4XX_VFD_CONTROL_3_REGID_VTXCNT__MASK			0x0000ff00
#define A4XX_VFD_CONTROL_3_REGID_VTXCNT__SHIFT			8
static inline uint32_t A4XX_VFD_CONTROL_3_REGID_VTXCNT(uint32_t val)
{
	return ((val) << A4XX_VFD_CONTROL_3_REGID_VTXCNT__SHIFT) & A4XX_VFD_CONTROL_3_REGID_VTXCNT__MASK;
}

#define REG_A4XX_VFD_CONTROL_4					0x00002204

#define REG_A4XX_VFD_INDEX_OFFSET				0x00002208

static inline uint32_t REG_A4XX_VFD_FETCH(uint32_t i0) { return 0x0000220a + 0x4*i0; }

static inline uint32_t REG_A4XX_VFD_FETCH_INSTR_0(uint32_t i0) { return 0x0000220a + 0x4*i0; }
#define A4XX_VFD_FETCH_INSTR_0_FETCHSIZE__MASK			0x0000007f
#define A4XX_VFD_FETCH_INSTR_0_FETCHSIZE__SHIFT			0
static inline uint32_t A4XX_VFD_FETCH_INSTR_0_FETCHSIZE(uint32_t val)
{
	return ((val) << A4XX_VFD_FETCH_INSTR_0_FETCHSIZE__SHIFT) & A4XX_VFD_FETCH_INSTR_0_FETCHSIZE__MASK;
}
#define A4XX_VFD_FETCH_INSTR_0_BUFSTRIDE__MASK			0x0001ff80
#define A4XX_VFD_FETCH_INSTR_0_BUFSTRIDE__SHIFT			7
static inline uint32_t A4XX_VFD_FETCH_INSTR_0_BUFSTRIDE(uint32_t val)
{
	return ((val) << A4XX_VFD_FETCH_INSTR_0_BUFSTRIDE__SHIFT) & A4XX_VFD_FETCH_INSTR_0_BUFSTRIDE__MASK;
}
#define A4XX_VFD_FETCH_INSTR_0_SWITCHNEXT			0x00080000
#define A4XX_VFD_FETCH_INSTR_0_INSTANCED			0x00100000

static inline uint32_t REG_A4XX_VFD_FETCH_INSTR_1(uint32_t i0) { return 0x0000220b + 0x4*i0; }

static inline uint32_t REG_A4XX_VFD_FETCH_INSTR_2(uint32_t i0) { return 0x0000220c + 0x4*i0; }
#define A4XX_VFD_FETCH_INSTR_2_SIZE__MASK			0xfffffff0
#define A4XX_VFD_FETCH_INSTR_2_SIZE__SHIFT			4
static inline uint32_t A4XX_VFD_FETCH_INSTR_2_SIZE(uint32_t val)
{
	return ((val >> 4) << A4XX_VFD_FETCH_INSTR_2_SIZE__SHIFT) & A4XX_VFD_FETCH_INSTR_2_SIZE__MASK;
}

static inline uint32_t REG_A4XX_VFD_FETCH_INSTR_3(uint32_t i0) { return 0x0000220d + 0x4*i0; }
#define A4XX_VFD_FETCH_INSTR_3_STEPRATE__MASK			0x000001ff
#define A4XX_VFD_FETCH_INSTR_3_STEPRATE__SHIFT			0
static inline uint32_t A4XX_VFD_FETCH_INSTR_3_STEPRATE(uint32_t val)
{
	return ((val) << A4XX_VFD_FETCH_INSTR_3_STEPRATE__SHIFT) & A4XX_VFD_FETCH_INSTR_3_STEPRATE__MASK;
}

static inline uint32_t REG_A4XX_VFD_DECODE(uint32_t i0) { return 0x0000228a + 0x1*i0; }

static inline uint32_t REG_A4XX_VFD_DECODE_INSTR(uint32_t i0) { return 0x0000228a + 0x1*i0; }
#define A4XX_VFD_DECODE_INSTR_WRITEMASK__MASK			0x0000000f
#define A4XX_VFD_DECODE_INSTR_WRITEMASK__SHIFT			0
static inline uint32_t A4XX_VFD_DECODE_INSTR_WRITEMASK(uint32_t val)
{
	return ((val) << A4XX_VFD_DECODE_INSTR_WRITEMASK__SHIFT) & A4XX_VFD_DECODE_INSTR_WRITEMASK__MASK;
}
#define A4XX_VFD_DECODE_INSTR_CONSTFILL				0x00000010
#define A4XX_VFD_DECODE_INSTR_FORMAT__MASK			0x00000fc0
#define A4XX_VFD_DECODE_INSTR_FORMAT__SHIFT			6
static inline uint32_t A4XX_VFD_DECODE_INSTR_FORMAT(enum a4xx_vtx_fmt val)
{
	return ((val) << A4XX_VFD_DECODE_INSTR_FORMAT__SHIFT) & A4XX_VFD_DECODE_INSTR_FORMAT__MASK;
}
#define A4XX_VFD_DECODE_INSTR_REGID__MASK			0x000ff000
#define A4XX_VFD_DECODE_INSTR_REGID__SHIFT			12
static inline uint32_t A4XX_VFD_DECODE_INSTR_REGID(uint32_t val)
{
	return ((val) << A4XX_VFD_DECODE_INSTR_REGID__SHIFT) & A4XX_VFD_DECODE_INSTR_REGID__MASK;
}
#define A4XX_VFD_DECODE_INSTR_INT				0x00100000
#define A4XX_VFD_DECODE_INSTR_SWAP__MASK			0x00c00000
#define A4XX_VFD_DECODE_INSTR_SWAP__SHIFT			22
static inline uint32_t A4XX_VFD_DECODE_INSTR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A4XX_VFD_DECODE_INSTR_SWAP__SHIFT) & A4XX_VFD_DECODE_INSTR_SWAP__MASK;
}
#define A4XX_VFD_DECODE_INSTR_SHIFTCNT__MASK			0x1f000000
#define A4XX_VFD_DECODE_INSTR_SHIFTCNT__SHIFT			24
static inline uint32_t A4XX_VFD_DECODE_INSTR_SHIFTCNT(uint32_t val)
{
	return ((val) << A4XX_VFD_DECODE_INSTR_SHIFTCNT__SHIFT) & A4XX_VFD_DECODE_INSTR_SHIFTCNT__MASK;
}
#define A4XX_VFD_DECODE_INSTR_LASTCOMPVALID			0x20000000
#define A4XX_VFD_DECODE_INSTR_SWITCHNEXT			0x40000000

#define REG_A4XX_TPL1_DEBUG_ECO_CONTROL				0x00000f00

#define REG_A4XX_TPL1_PERFCTR_TP_SEL_7				0x00000f0b

#define REG_A4XX_TPL1_TP_TEX_OFFSET				0x00002380

#define REG_A4XX_TPL1_TP_CS_TEXMEMOBJ_BASE_ADDR			0x000023a6

#define REG_A4XX_GRAS_TSE_STATUS				0x00000c80

#define REG_A4XX_GRAS_DEBUG_ECO_CONTROL				0x00000c81

#define REG_A4XX_GRAS_PERFCTR_TSE_SEL_0				0x00000c88

#define REG_A4XX_GRAS_PERFCTR_TSE_SEL_3				0x00000c8b

#define REG_A4XX_GRAS_CL_CLIP_CNTL				0x00002000

#define REG_A4XX_GRAS_CLEAR_CNTL				0x00002003
#define A4XX_GRAS_CLEAR_CNTL_NOT_FASTCLEAR			0x00000001

#define REG_A4XX_GRAS_CL_GB_CLIP_ADJ				0x00002004
#define A4XX_GRAS_CL_GB_CLIP_ADJ_HORZ__MASK			0x000003ff
#define A4XX_GRAS_CL_GB_CLIP_ADJ_HORZ__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_GB_CLIP_ADJ_HORZ(uint32_t val)
{
	return ((val) << A4XX_GRAS_CL_GB_CLIP_ADJ_HORZ__SHIFT) & A4XX_GRAS_CL_GB_CLIP_ADJ_HORZ__MASK;
}
#define A4XX_GRAS_CL_GB_CLIP_ADJ_VERT__MASK			0x000ffc00
#define A4XX_GRAS_CL_GB_CLIP_ADJ_VERT__SHIFT			10
static inline uint32_t A4XX_GRAS_CL_GB_CLIP_ADJ_VERT(uint32_t val)
{
	return ((val) << A4XX_GRAS_CL_GB_CLIP_ADJ_VERT__SHIFT) & A4XX_GRAS_CL_GB_CLIP_ADJ_VERT__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_XOFFSET_0			0x00002008
#define A4XX_GRAS_CL_VPORT_XOFFSET_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_XOFFSET_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_XOFFSET_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_XOFFSET_0__SHIFT) & A4XX_GRAS_CL_VPORT_XOFFSET_0__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_XSCALE_0				0x00002009
#define A4XX_GRAS_CL_VPORT_XSCALE_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_XSCALE_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_XSCALE_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_XSCALE_0__SHIFT) & A4XX_GRAS_CL_VPORT_XSCALE_0__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_YOFFSET_0			0x0000200a
#define A4XX_GRAS_CL_VPORT_YOFFSET_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_YOFFSET_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_YOFFSET_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_YOFFSET_0__SHIFT) & A4XX_GRAS_CL_VPORT_YOFFSET_0__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_YSCALE_0				0x0000200b
#define A4XX_GRAS_CL_VPORT_YSCALE_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_YSCALE_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_YSCALE_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_YSCALE_0__SHIFT) & A4XX_GRAS_CL_VPORT_YSCALE_0__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_ZOFFSET_0			0x0000200c
#define A4XX_GRAS_CL_VPORT_ZOFFSET_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_ZOFFSET_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_ZOFFSET_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_ZOFFSET_0__SHIFT) & A4XX_GRAS_CL_VPORT_ZOFFSET_0__MASK;
}

#define REG_A4XX_GRAS_CL_VPORT_ZSCALE_0				0x0000200d
#define A4XX_GRAS_CL_VPORT_ZSCALE_0__MASK			0xffffffff
#define A4XX_GRAS_CL_VPORT_ZSCALE_0__SHIFT			0
static inline uint32_t A4XX_GRAS_CL_VPORT_ZSCALE_0(float val)
{
	return ((fui(val)) << A4XX_GRAS_CL_VPORT_ZSCALE_0__SHIFT) & A4XX_GRAS_CL_VPORT_ZSCALE_0__MASK;
}

#define REG_A4XX_GRAS_SU_POINT_MINMAX				0x00002070
#define A4XX_GRAS_SU_POINT_MINMAX_MIN__MASK			0x0000ffff
#define A4XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT			0
static inline uint32_t A4XX_GRAS_SU_POINT_MINMAX_MIN(float val)
{
	return ((((uint32_t)(val * 16.0))) << A4XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT) & A4XX_GRAS_SU_POINT_MINMAX_MIN__MASK;
}
#define A4XX_GRAS_SU_POINT_MINMAX_MAX__MASK			0xffff0000
#define A4XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT			16
static inline uint32_t A4XX_GRAS_SU_POINT_MINMAX_MAX(float val)
{
	return ((((uint32_t)(val * 16.0))) << A4XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT) & A4XX_GRAS_SU_POINT_MINMAX_MAX__MASK;
}

#define REG_A4XX_GRAS_SU_POINT_SIZE				0x00002071
#define A4XX_GRAS_SU_POINT_SIZE__MASK				0xffffffff
#define A4XX_GRAS_SU_POINT_SIZE__SHIFT				0
static inline uint32_t A4XX_GRAS_SU_POINT_SIZE(float val)
{
	return ((((int32_t)(val * 16.0))) << A4XX_GRAS_SU_POINT_SIZE__SHIFT) & A4XX_GRAS_SU_POINT_SIZE__MASK;
}

#define REG_A4XX_GRAS_ALPHA_CONTROL				0x00002073
#define A4XX_GRAS_ALPHA_CONTROL_ALPHA_TEST_ENABLE		0x00000004

#define REG_A4XX_GRAS_SU_POLY_OFFSET_SCALE			0x00002074
#define A4XX_GRAS_SU_POLY_OFFSET_SCALE__MASK			0xffffffff
#define A4XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT			0
static inline uint32_t A4XX_GRAS_SU_POLY_OFFSET_SCALE(float val)
{
	return ((fui(val)) << A4XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT) & A4XX_GRAS_SU_POLY_OFFSET_SCALE__MASK;
}

#define REG_A4XX_GRAS_SU_POLY_OFFSET_OFFSET			0x00002075
#define A4XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK			0xffffffff
#define A4XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT			0
static inline uint32_t A4XX_GRAS_SU_POLY_OFFSET_OFFSET(float val)
{
	return ((fui(val)) << A4XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT) & A4XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK;
}

#define REG_A4XX_GRAS_DEPTH_CONTROL				0x00002077
#define A4XX_GRAS_DEPTH_CONTROL_FORMAT__MASK			0x00000003
#define A4XX_GRAS_DEPTH_CONTROL_FORMAT__SHIFT			0
static inline uint32_t A4XX_GRAS_DEPTH_CONTROL_FORMAT(enum a4xx_depth_format val)
{
	return ((val) << A4XX_GRAS_DEPTH_CONTROL_FORMAT__SHIFT) & A4XX_GRAS_DEPTH_CONTROL_FORMAT__MASK;
}

#define REG_A4XX_GRAS_SU_MODE_CONTROL				0x00002078
#define A4XX_GRAS_SU_MODE_CONTROL_CULL_FRONT			0x00000001
#define A4XX_GRAS_SU_MODE_CONTROL_CULL_BACK			0x00000002
#define A4XX_GRAS_SU_MODE_CONTROL_FRONT_CW			0x00000004
#define A4XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__MASK		0x000007f8
#define A4XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__SHIFT		3
static inline uint32_t A4XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH(float val)
{
	return ((((int32_t)(val * 4.0))) << A4XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__SHIFT) & A4XX_GRAS_SU_MODE_CONTROL_LINEHALFWIDTH__MASK;
}
#define A4XX_GRAS_SU_MODE_CONTROL_POLY_OFFSET			0x00000800
#define A4XX_GRAS_SU_MODE_CONTROL_RENDERING_PASS		0x00100000

#define REG_A4XX_GRAS_SC_CONTROL				0x0000207b
#define A4XX_GRAS_SC_CONTROL_RENDER_MODE__MASK			0x0000000c
#define A4XX_GRAS_SC_CONTROL_RENDER_MODE__SHIFT			2
static inline uint32_t A4XX_GRAS_SC_CONTROL_RENDER_MODE(enum a3xx_render_mode val)
{
	return ((val) << A4XX_GRAS_SC_CONTROL_RENDER_MODE__SHIFT) & A4XX_GRAS_SC_CONTROL_RENDER_MODE__MASK;
}
#define A4XX_GRAS_SC_CONTROL_MSAA_SAMPLES__MASK			0x00000380
#define A4XX_GRAS_SC_CONTROL_MSAA_SAMPLES__SHIFT		7
static inline uint32_t A4XX_GRAS_SC_CONTROL_MSAA_SAMPLES(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_CONTROL_MSAA_SAMPLES__SHIFT) & A4XX_GRAS_SC_CONTROL_MSAA_SAMPLES__MASK;
}
#define A4XX_GRAS_SC_CONTROL_MSAA_DISABLE			0x00000800
#define A4XX_GRAS_SC_CONTROL_RASTER_MODE__MASK			0x0000f000
#define A4XX_GRAS_SC_CONTROL_RASTER_MODE__SHIFT			12
static inline uint32_t A4XX_GRAS_SC_CONTROL_RASTER_MODE(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_CONTROL_RASTER_MODE__SHIFT) & A4XX_GRAS_SC_CONTROL_RASTER_MODE__MASK;
}

#define REG_A4XX_GRAS_SC_SCREEN_SCISSOR_TL			0x0000207c
#define A4XX_GRAS_SC_SCREEN_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK			0x00007fff
#define A4XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_SCREEN_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT) & A4XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK;
}
#define A4XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_SCREEN_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT) & A4XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK;
}

#define REG_A4XX_GRAS_SC_SCREEN_SCISSOR_BR			0x0000207d
#define A4XX_GRAS_SC_SCREEN_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK			0x00007fff
#define A4XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_SCREEN_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT) & A4XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK;
}
#define A4XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_SCREEN_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT) & A4XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK;
}

#define REG_A4XX_GRAS_SC_WINDOW_SCISSOR_BR			0x0000209c
#define A4XX_GRAS_SC_WINDOW_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK			0x00007fff
#define A4XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_WINDOW_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT) & A4XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK;
}
#define A4XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_WINDOW_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT) & A4XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK;
}

#define REG_A4XX_GRAS_SC_WINDOW_SCISSOR_TL			0x0000209d
#define A4XX_GRAS_SC_WINDOW_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK			0x00007fff
#define A4XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_WINDOW_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT) & A4XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK;
}
#define A4XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_WINDOW_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT) & A4XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK;
}

#define REG_A4XX_GRAS_SC_EXTENT_WINDOW_BR			0x0000209e
#define A4XX_GRAS_SC_EXTENT_WINDOW_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_EXTENT_WINDOW_BR_X__MASK			0x00007fff
#define A4XX_GRAS_SC_EXTENT_WINDOW_BR_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_EXTENT_WINDOW_BR_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_EXTENT_WINDOW_BR_X__SHIFT) & A4XX_GRAS_SC_EXTENT_WINDOW_BR_X__MASK;
}
#define A4XX_GRAS_SC_EXTENT_WINDOW_BR_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_EXTENT_WINDOW_BR_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_EXTENT_WINDOW_BR_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_EXTENT_WINDOW_BR_Y__SHIFT) & A4XX_GRAS_SC_EXTENT_WINDOW_BR_Y__MASK;
}

#define REG_A4XX_GRAS_SC_EXTENT_WINDOW_TL			0x0000209f
#define A4XX_GRAS_SC_EXTENT_WINDOW_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A4XX_GRAS_SC_EXTENT_WINDOW_TL_X__MASK			0x00007fff
#define A4XX_GRAS_SC_EXTENT_WINDOW_TL_X__SHIFT			0
static inline uint32_t A4XX_GRAS_SC_EXTENT_WINDOW_TL_X(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_EXTENT_WINDOW_TL_X__SHIFT) & A4XX_GRAS_SC_EXTENT_WINDOW_TL_X__MASK;
}
#define A4XX_GRAS_SC_EXTENT_WINDOW_TL_Y__MASK			0x7fff0000
#define A4XX_GRAS_SC_EXTENT_WINDOW_TL_Y__SHIFT			16
static inline uint32_t A4XX_GRAS_SC_EXTENT_WINDOW_TL_Y(uint32_t val)
{
	return ((val) << A4XX_GRAS_SC_EXTENT_WINDOW_TL_Y__SHIFT) & A4XX_GRAS_SC_EXTENT_WINDOW_TL_Y__MASK;
}

#define REG_A4XX_UCHE_CACHE_MODE_CONTROL			0x00000e80

#define REG_A4XX_UCHE_TRAP_BASE_LO				0x00000e83

#define REG_A4XX_UCHE_TRAP_BASE_HI				0x00000e84

#define REG_A4XX_UCHE_CACHE_STATUS				0x00000e88

#define REG_A4XX_UCHE_INVALIDATE0				0x00000e8a

#define REG_A4XX_UCHE_INVALIDATE1				0x00000e8b

#define REG_A4XX_UCHE_CACHE_WAYS_VFD				0x00000e8c

#define REG_A4XX_UCHE_PERFCTR_UCHE_SEL_7			0x00000e95

#define REG_A4XX_HLSQ_TIMEOUT_THRESHOLD				0x00000e00

#define REG_A4XX_HLSQ_DEBUG_ECO_CONTROL				0x00000e04

#define REG_A4XX_HLSQ_PERF_PIPE_MASK				0x00000e0e

#define REG_A4XX_HLSQ_CONTROL_0_REG				0x000023c0
#define A4XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__MASK		0x00000010
#define A4XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__SHIFT		4
static inline uint32_t A4XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A4XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__SHIFT) & A4XX_HLSQ_CONTROL_0_REG_FSTHREADSIZE__MASK;
}
#define A4XX_HLSQ_CONTROL_0_REG_FSSUPERTHREADENABLE		0x00000040
#define A4XX_HLSQ_CONTROL_0_REG_SPSHADERRESTART			0x00000200
#define A4XX_HLSQ_CONTROL_0_REG_RESERVED2			0x00000400
#define A4XX_HLSQ_CONTROL_0_REG_CHUNKDISABLE			0x04000000
#define A4XX_HLSQ_CONTROL_0_REG_CONSTMODE__MASK			0x08000000
#define A4XX_HLSQ_CONTROL_0_REG_CONSTMODE__SHIFT		27
static inline uint32_t A4XX_HLSQ_CONTROL_0_REG_CONSTMODE(uint32_t val)
{
	return ((val) << A4XX_HLSQ_CONTROL_0_REG_CONSTMODE__SHIFT) & A4XX_HLSQ_CONTROL_0_REG_CONSTMODE__MASK;
}
#define A4XX_HLSQ_CONTROL_0_REG_LAZYUPDATEDISABLE		0x10000000
#define A4XX_HLSQ_CONTROL_0_REG_SPCONSTFULLUPDATE		0x20000000
#define A4XX_HLSQ_CONTROL_0_REG_TPFULLUPDATE			0x40000000
#define A4XX_HLSQ_CONTROL_0_REG_SINGLECONTEXT			0x80000000

#define REG_A4XX_HLSQ_CONTROL_1_REG				0x000023c1
#define A4XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__MASK		0x00000040
#define A4XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__SHIFT		6
static inline uint32_t A4XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE(enum a3xx_threadsize val)
{
	return ((val) << A4XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__SHIFT) & A4XX_HLSQ_CONTROL_1_REG_VSTHREADSIZE__MASK;
}
#define A4XX_HLSQ_CONTROL_1_REG_VSSUPERTHREADENABLE		0x00000100
#define A4XX_HLSQ_CONTROL_1_REG_RESERVED1			0x00000200
#define A4XX_HLSQ_CONTROL_1_REG_COORDREGID__MASK		0x00ff0000
#define A4XX_HLSQ_CONTROL_1_REG_COORDREGID__SHIFT		16
static inline uint32_t A4XX_HLSQ_CONTROL_1_REG_COORDREGID(uint32_t val)
{
	return ((val) << A4XX_HLSQ_CONTROL_1_REG_COORDREGID__SHIFT) & A4XX_HLSQ_CONTROL_1_REG_COORDREGID__MASK;
}
#define A4XX_HLSQ_CONTROL_1_REG_ZWCOORD				0x02000000

#define REG_A4XX_HLSQ_CONTROL_2_REG				0x000023c2
#define A4XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__MASK	0xfc000000
#define A4XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__SHIFT	26
static inline uint32_t A4XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD(uint32_t val)
{
	return ((val) << A4XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__SHIFT) & A4XX_HLSQ_CONTROL_2_REG_PRIMALLOCTHRESHOLD__MASK;
}
#define A4XX_HLSQ_CONTROL_2_REG_FACEREGID__MASK			0x000003fc
#define A4XX_HLSQ_CONTROL_2_REG_FACEREGID__SHIFT		2
static inline uint32_t A4XX_HLSQ_CONTROL_2_REG_FACEREGID(uint32_t val)
{
	return ((val) << A4XX_HLSQ_CONTROL_2_REG_FACEREGID__SHIFT) & A4XX_HLSQ_CONTROL_2_REG_FACEREGID__MASK;
}

#define REG_A4XX_HLSQ_CONTROL_3_REG				0x000023c3
#define A4XX_HLSQ_CONTROL_3_REG_REGID__MASK			0x000000ff
#define A4XX_HLSQ_CONTROL_3_REG_REGID__SHIFT			0
static inline uint32_t A4XX_HLSQ_CONTROL_3_REG_REGID(uint32_t val)
{
	return ((val) << A4XX_HLSQ_CONTROL_3_REG_REGID__SHIFT) & A4XX_HLSQ_CONTROL_3_REG_REGID__MASK;
}

#define REG_A4XX_HLSQ_VS_CONTROL_REG				0x000023c5
#define A4XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__MASK		0x000000ff
#define A4XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A4XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__SHIFT) & A4XX_HLSQ_VS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A4XX_HLSQ_VS_CONTROL_REG_CONSTOBJECTOFFSET__MASK	0x0000ff00
#define A4XX_HLSQ_VS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT	8
static inline uint32_t A4XX_HLSQ_VS_CONTROL_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_VS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_HLSQ_VS_CONTROL_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_HLSQ_VS_CONTROL_REG_SHADEROBJOFFSET__MASK		0x00fe0000
#define A4XX_HLSQ_VS_CONTROL_REG_SHADEROBJOFFSET__SHIFT		17
static inline uint32_t A4XX_HLSQ_VS_CONTROL_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_VS_CONTROL_REG_SHADEROBJOFFSET__SHIFT) & A4XX_HLSQ_VS_CONTROL_REG_SHADEROBJOFFSET__MASK;
}
#define A4XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A4XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A4XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__SHIFT) & A4XX_HLSQ_VS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A4XX_HLSQ_FS_CONTROL_REG				0x000023c6
#define A4XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__MASK		0x000000ff
#define A4XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A4XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__SHIFT) & A4XX_HLSQ_FS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A4XX_HLSQ_FS_CONTROL_REG_CONSTOBJECTOFFSET__MASK	0x0000ff00
#define A4XX_HLSQ_FS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT	8
static inline uint32_t A4XX_HLSQ_FS_CONTROL_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_FS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_HLSQ_FS_CONTROL_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_HLSQ_FS_CONTROL_REG_SHADEROBJOFFSET__MASK		0x00fe0000
#define A4XX_HLSQ_FS_CONTROL_REG_SHADEROBJOFFSET__SHIFT		17
static inline uint32_t A4XX_HLSQ_FS_CONTROL_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_FS_CONTROL_REG_SHADEROBJOFFSET__SHIFT) & A4XX_HLSQ_FS_CONTROL_REG_SHADEROBJOFFSET__MASK;
}
#define A4XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A4XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A4XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__SHIFT) & A4XX_HLSQ_FS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A4XX_HLSQ_HS_CONTROL_REG				0x000023c7
#define A4XX_HLSQ_HS_CONTROL_REG_CONSTLENGTH__MASK		0x000000ff
#define A4XX_HLSQ_HS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A4XX_HLSQ_HS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_HS_CONTROL_REG_CONSTLENGTH__SHIFT) & A4XX_HLSQ_HS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A4XX_HLSQ_HS_CONTROL_REG_CONSTOBJECTOFFSET__MASK	0x0000ff00
#define A4XX_HLSQ_HS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT	8
static inline uint32_t A4XX_HLSQ_HS_CONTROL_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_HS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_HLSQ_HS_CONTROL_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_HLSQ_HS_CONTROL_REG_SHADEROBJOFFSET__MASK		0x00fe0000
#define A4XX_HLSQ_HS_CONTROL_REG_SHADEROBJOFFSET__SHIFT		17
static inline uint32_t A4XX_HLSQ_HS_CONTROL_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_HS_CONTROL_REG_SHADEROBJOFFSET__SHIFT) & A4XX_HLSQ_HS_CONTROL_REG_SHADEROBJOFFSET__MASK;
}
#define A4XX_HLSQ_HS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A4XX_HLSQ_HS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A4XX_HLSQ_HS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_HS_CONTROL_REG_INSTRLENGTH__SHIFT) & A4XX_HLSQ_HS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A4XX_HLSQ_DS_CONTROL_REG				0x000023c8
#define A4XX_HLSQ_DS_CONTROL_REG_CONSTLENGTH__MASK		0x000000ff
#define A4XX_HLSQ_DS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A4XX_HLSQ_DS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_DS_CONTROL_REG_CONSTLENGTH__SHIFT) & A4XX_HLSQ_DS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A4XX_HLSQ_DS_CONTROL_REG_CONSTOBJECTOFFSET__MASK	0x0000ff00
#define A4XX_HLSQ_DS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT	8
static inline uint32_t A4XX_HLSQ_DS_CONTROL_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_DS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_HLSQ_DS_CONTROL_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_HLSQ_DS_CONTROL_REG_SHADEROBJOFFSET__MASK		0x00fe0000
#define A4XX_HLSQ_DS_CONTROL_REG_SHADEROBJOFFSET__SHIFT		17
static inline uint32_t A4XX_HLSQ_DS_CONTROL_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_DS_CONTROL_REG_SHADEROBJOFFSET__SHIFT) & A4XX_HLSQ_DS_CONTROL_REG_SHADEROBJOFFSET__MASK;
}
#define A4XX_HLSQ_DS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A4XX_HLSQ_DS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A4XX_HLSQ_DS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_DS_CONTROL_REG_INSTRLENGTH__SHIFT) & A4XX_HLSQ_DS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A4XX_HLSQ_GS_CONTROL_REG				0x000023c9
#define A4XX_HLSQ_GS_CONTROL_REG_CONSTLENGTH__MASK		0x000000ff
#define A4XX_HLSQ_GS_CONTROL_REG_CONSTLENGTH__SHIFT		0
static inline uint32_t A4XX_HLSQ_GS_CONTROL_REG_CONSTLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_GS_CONTROL_REG_CONSTLENGTH__SHIFT) & A4XX_HLSQ_GS_CONTROL_REG_CONSTLENGTH__MASK;
}
#define A4XX_HLSQ_GS_CONTROL_REG_CONSTOBJECTOFFSET__MASK	0x0000ff00
#define A4XX_HLSQ_GS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT	8
static inline uint32_t A4XX_HLSQ_GS_CONTROL_REG_CONSTOBJECTOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_GS_CONTROL_REG_CONSTOBJECTOFFSET__SHIFT) & A4XX_HLSQ_GS_CONTROL_REG_CONSTOBJECTOFFSET__MASK;
}
#define A4XX_HLSQ_GS_CONTROL_REG_SHADEROBJOFFSET__MASK		0x00fe0000
#define A4XX_HLSQ_GS_CONTROL_REG_SHADEROBJOFFSET__SHIFT		17
static inline uint32_t A4XX_HLSQ_GS_CONTROL_REG_SHADEROBJOFFSET(uint32_t val)
{
	return ((val) << A4XX_HLSQ_GS_CONTROL_REG_SHADEROBJOFFSET__SHIFT) & A4XX_HLSQ_GS_CONTROL_REG_SHADEROBJOFFSET__MASK;
}
#define A4XX_HLSQ_GS_CONTROL_REG_INSTRLENGTH__MASK		0xff000000
#define A4XX_HLSQ_GS_CONTROL_REG_INSTRLENGTH__SHIFT		24
static inline uint32_t A4XX_HLSQ_GS_CONTROL_REG_INSTRLENGTH(uint32_t val)
{
	return ((val) << A4XX_HLSQ_GS_CONTROL_REG_INSTRLENGTH__SHIFT) & A4XX_HLSQ_GS_CONTROL_REG_INSTRLENGTH__MASK;
}

#define REG_A4XX_HLSQ_UPDATE_CONTROL				0x000023db

#define REG_A4XX_PC_BINNING_COMMAND				0x00000d00
#define A4XX_PC_BINNING_COMMAND_BINNING_ENABLE			0x00000001

#define REG_A4XX_PC_DRAWCALL_SETUP_OVERRIDE			0x00000d0c

#define REG_A4XX_PC_PERFCTR_PC_SEL_0				0x00000d10

#define REG_A4XX_PC_PERFCTR_PC_SEL_7				0x00000d17

#define REG_A4XX_PC_BIN_BASE					0x000021c0

#define REG_A4XX_PC_PRIM_VTX_CNTL				0x000021c4
#define A4XX_PC_PRIM_VTX_CNTL_VAROUT				0x00000001
#define A4XX_PC_PRIM_VTX_CNTL_PROVOKING_VTX_LAST		0x02000000
#define A4XX_PC_PRIM_VTX_CNTL_PSIZE				0x04000000

#define REG_A4XX_UNKNOWN_21C5					0x000021c5

#define REG_A4XX_PC_RESTART_INDEX				0x000021c6

#define REG_A4XX_PC_GS_PARAM					0x000021e5

#define REG_A4XX_PC_HS_PARAM					0x000021e7

#define REG_A4XX_VBIF_VERSION					0x00003000

#define REG_A4XX_VBIF_CLKON					0x00003001
#define A4XX_VBIF_CLKON_FORCE_ON_TESTBUS			0x00000001

#define REG_A4XX_VBIF_ABIT_SORT					0x0000301c

#define REG_A4XX_VBIF_ABIT_SORT_CONF				0x0000301d

#define REG_A4XX_VBIF_GATE_OFF_WRREQ_EN				0x0000302a

#define REG_A4XX_VBIF_IN_RD_LIM_CONF0				0x0000302c

#define REG_A4XX_VBIF_IN_RD_LIM_CONF1				0x0000302d

#define REG_A4XX_VBIF_IN_WR_LIM_CONF0				0x00003030

#define REG_A4XX_VBIF_IN_WR_LIM_CONF1				0x00003031

#define REG_A4XX_VBIF_ROUND_ROBIN_QOS_ARB			0x00003049

#define REG_A4XX_UNKNOWN_0CC5					0x00000cc5

#define REG_A4XX_UNKNOWN_0CC6					0x00000cc6

#define REG_A4XX_UNKNOWN_0D01					0x00000d01

#define REG_A4XX_UNKNOWN_0E05					0x00000e05

#define REG_A4XX_UNKNOWN_0E42					0x00000e42

#define REG_A4XX_UNKNOWN_0EC2					0x00000ec2

#define REG_A4XX_UNKNOWN_0EC3					0x00000ec3

#define REG_A4XX_UNKNOWN_0F03					0x00000f03

#define REG_A4XX_UNKNOWN_2001					0x00002001

#define REG_A4XX_UNKNOWN_209B					0x0000209b

#define REG_A4XX_UNKNOWN_20EF					0x000020ef

#define REG_A4XX_UNKNOWN_20F0					0x000020f0

#define REG_A4XX_UNKNOWN_20F1					0x000020f1

#define REG_A4XX_UNKNOWN_20F2					0x000020f2

#define REG_A4XX_UNKNOWN_20F7					0x000020f7
#define A4XX_UNKNOWN_20F7__MASK					0xffffffff
#define A4XX_UNKNOWN_20F7__SHIFT				0
static inline uint32_t A4XX_UNKNOWN_20F7(float val)
{
	return ((fui(val)) << A4XX_UNKNOWN_20F7__SHIFT) & A4XX_UNKNOWN_20F7__MASK;
}

#define REG_A4XX_UNKNOWN_2152					0x00002152

#define REG_A4XX_UNKNOWN_2153					0x00002153

#define REG_A4XX_UNKNOWN_2154					0x00002154

#define REG_A4XX_UNKNOWN_2155					0x00002155

#define REG_A4XX_UNKNOWN_2156					0x00002156

#define REG_A4XX_UNKNOWN_2157					0x00002157

#define REG_A4XX_UNKNOWN_21C3					0x000021c3

#define REG_A4XX_UNKNOWN_21E6					0x000021e6

#define REG_A4XX_UNKNOWN_2209					0x00002209

#define REG_A4XX_UNKNOWN_22D7					0x000022d7

#define REG_A4XX_UNKNOWN_2381					0x00002381

#define REG_A4XX_UNKNOWN_23A0					0x000023a0

#define REG_A4XX_TEX_SAMP_0					0x00000000
#define A4XX_TEX_SAMP_0_MIPFILTER_LINEAR_NEAR			0x00000001
#define A4XX_TEX_SAMP_0_XY_MAG__MASK				0x00000006
#define A4XX_TEX_SAMP_0_XY_MAG__SHIFT				1
static inline uint32_t A4XX_TEX_SAMP_0_XY_MAG(enum a4xx_tex_filter val)
{
	return ((val) << A4XX_TEX_SAMP_0_XY_MAG__SHIFT) & A4XX_TEX_SAMP_0_XY_MAG__MASK;
}
#define A4XX_TEX_SAMP_0_XY_MIN__MASK				0x00000018
#define A4XX_TEX_SAMP_0_XY_MIN__SHIFT				3
static inline uint32_t A4XX_TEX_SAMP_0_XY_MIN(enum a4xx_tex_filter val)
{
	return ((val) << A4XX_TEX_SAMP_0_XY_MIN__SHIFT) & A4XX_TEX_SAMP_0_XY_MIN__MASK;
}
#define A4XX_TEX_SAMP_0_WRAP_S__MASK				0x000000e0
#define A4XX_TEX_SAMP_0_WRAP_S__SHIFT				5
static inline uint32_t A4XX_TEX_SAMP_0_WRAP_S(enum a4xx_tex_clamp val)
{
	return ((val) << A4XX_TEX_SAMP_0_WRAP_S__SHIFT) & A4XX_TEX_SAMP_0_WRAP_S__MASK;
}
#define A4XX_TEX_SAMP_0_WRAP_T__MASK				0x00000700
#define A4XX_TEX_SAMP_0_WRAP_T__SHIFT				8
static inline uint32_t A4XX_TEX_SAMP_0_WRAP_T(enum a4xx_tex_clamp val)
{
	return ((val) << A4XX_TEX_SAMP_0_WRAP_T__SHIFT) & A4XX_TEX_SAMP_0_WRAP_T__MASK;
}
#define A4XX_TEX_SAMP_0_WRAP_R__MASK				0x00003800
#define A4XX_TEX_SAMP_0_WRAP_R__SHIFT				11
static inline uint32_t A4XX_TEX_SAMP_0_WRAP_R(enum a4xx_tex_clamp val)
{
	return ((val) << A4XX_TEX_SAMP_0_WRAP_R__SHIFT) & A4XX_TEX_SAMP_0_WRAP_R__MASK;
}

#define REG_A4XX_TEX_SAMP_1					0x00000001
#define A4XX_TEX_SAMP_1_COMPARE_FUNC__MASK			0x0000000e
#define A4XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT			1
static inline uint32_t A4XX_TEX_SAMP_1_COMPARE_FUNC(enum adreno_compare_func val)
{
	return ((val) << A4XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT) & A4XX_TEX_SAMP_1_COMPARE_FUNC__MASK;
}
#define A4XX_TEX_SAMP_1_UNNORM_COORDS				0x00000020
#define A4XX_TEX_SAMP_1_MIPFILTER_LINEAR_FAR			0x00000040
#define A4XX_TEX_SAMP_1_MAX_LOD__MASK				0x000fff00
#define A4XX_TEX_SAMP_1_MAX_LOD__SHIFT				8
static inline uint32_t A4XX_TEX_SAMP_1_MAX_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A4XX_TEX_SAMP_1_MAX_LOD__SHIFT) & A4XX_TEX_SAMP_1_MAX_LOD__MASK;
}
#define A4XX_TEX_SAMP_1_MIN_LOD__MASK				0xfff00000
#define A4XX_TEX_SAMP_1_MIN_LOD__SHIFT				20
static inline uint32_t A4XX_TEX_SAMP_1_MIN_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A4XX_TEX_SAMP_1_MIN_LOD__SHIFT) & A4XX_TEX_SAMP_1_MIN_LOD__MASK;
}

#define REG_A4XX_TEX_CONST_0					0x00000000
#define A4XX_TEX_CONST_0_TILED					0x00000001
#define A4XX_TEX_CONST_0_SWIZ_X__MASK				0x00000070
#define A4XX_TEX_CONST_0_SWIZ_X__SHIFT				4
static inline uint32_t A4XX_TEX_CONST_0_SWIZ_X(enum a4xx_tex_swiz val)
{
	return ((val) << A4XX_TEX_CONST_0_SWIZ_X__SHIFT) & A4XX_TEX_CONST_0_SWIZ_X__MASK;
}
#define A4XX_TEX_CONST_0_SWIZ_Y__MASK				0x00000380
#define A4XX_TEX_CONST_0_SWIZ_Y__SHIFT				7
static inline uint32_t A4XX_TEX_CONST_0_SWIZ_Y(enum a4xx_tex_swiz val)
{
	return ((val) << A4XX_TEX_CONST_0_SWIZ_Y__SHIFT) & A4XX_TEX_CONST_0_SWIZ_Y__MASK;
}
#define A4XX_TEX_CONST_0_SWIZ_Z__MASK				0x00001c00
#define A4XX_TEX_CONST_0_SWIZ_Z__SHIFT				10
static inline uint32_t A4XX_TEX_CONST_0_SWIZ_Z(enum a4xx_tex_swiz val)
{
	return ((val) << A4XX_TEX_CONST_0_SWIZ_Z__SHIFT) & A4XX_TEX_CONST_0_SWIZ_Z__MASK;
}
#define A4XX_TEX_CONST_0_SWIZ_W__MASK				0x0000e000
#define A4XX_TEX_CONST_0_SWIZ_W__SHIFT				13
static inline uint32_t A4XX_TEX_CONST_0_SWIZ_W(enum a4xx_tex_swiz val)
{
	return ((val) << A4XX_TEX_CONST_0_SWIZ_W__SHIFT) & A4XX_TEX_CONST_0_SWIZ_W__MASK;
}
#define A4XX_TEX_CONST_0_MIPLVLS__MASK				0x000f0000
#define A4XX_TEX_CONST_0_MIPLVLS__SHIFT				16
static inline uint32_t A4XX_TEX_CONST_0_MIPLVLS(uint32_t val)
{
	return ((val) << A4XX_TEX_CONST_0_MIPLVLS__SHIFT) & A4XX_TEX_CONST_0_MIPLVLS__MASK;
}
#define A4XX_TEX_CONST_0_FMT__MASK				0x1fc00000
#define A4XX_TEX_CONST_0_FMT__SHIFT				22
static inline uint32_t A4XX_TEX_CONST_0_FMT(enum a4xx_tex_fmt val)
{
	return ((val) << A4XX_TEX_CONST_0_FMT__SHIFT) & A4XX_TEX_CONST_0_FMT__MASK;
}
#define A4XX_TEX_CONST_0_TYPE__MASK				0x60000000
#define A4XX_TEX_CONST_0_TYPE__SHIFT				29
static inline uint32_t A4XX_TEX_CONST_0_TYPE(enum a4xx_tex_type val)
{
	return ((val) << A4XX_TEX_CONST_0_TYPE__SHIFT) & A4XX_TEX_CONST_0_TYPE__MASK;
}

#define REG_A4XX_TEX_CONST_1					0x00000001
#define A4XX_TEX_CONST_1_HEIGHT__MASK				0x00007fff
#define A4XX_TEX_CONST_1_HEIGHT__SHIFT				0
static inline uint32_t A4XX_TEX_CONST_1_HEIGHT(uint32_t val)
{
	return ((val) << A4XX_TEX_CONST_1_HEIGHT__SHIFT) & A4XX_TEX_CONST_1_HEIGHT__MASK;
}
#define A4XX_TEX_CONST_1_WIDTH__MASK				0x1fff8000
#define A4XX_TEX_CONST_1_WIDTH__SHIFT				15
static inline uint32_t A4XX_TEX_CONST_1_WIDTH(uint32_t val)
{
	return ((val) << A4XX_TEX_CONST_1_WIDTH__SHIFT) & A4XX_TEX_CONST_1_WIDTH__MASK;
}

#define REG_A4XX_TEX_CONST_2					0x00000002
#define A4XX_TEX_CONST_2_FETCHSIZE__MASK			0x0000000f
#define A4XX_TEX_CONST_2_FETCHSIZE__SHIFT			0
static inline uint32_t A4XX_TEX_CONST_2_FETCHSIZE(enum a4xx_tex_fetchsize val)
{
	return ((val) << A4XX_TEX_CONST_2_FETCHSIZE__SHIFT) & A4XX_TEX_CONST_2_FETCHSIZE__MASK;
}
#define A4XX_TEX_CONST_2_PITCH__MASK				0x3ffffe00
#define A4XX_TEX_CONST_2_PITCH__SHIFT				9
static inline uint32_t A4XX_TEX_CONST_2_PITCH(uint32_t val)
{
	return ((val) << A4XX_TEX_CONST_2_PITCH__SHIFT) & A4XX_TEX_CONST_2_PITCH__MASK;
}
#define A4XX_TEX_CONST_2_SWAP__MASK				0xc0000000
#define A4XX_TEX_CONST_2_SWAP__SHIFT				30
static inline uint32_t A4XX_TEX_CONST_2_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A4XX_TEX_CONST_2_SWAP__SHIFT) & A4XX_TEX_CONST_2_SWAP__MASK;
}

#define REG_A4XX_TEX_CONST_3					0x00000003
#define A4XX_TEX_CONST_3_LAYERSZ__MASK				0x00003fff
#define A4XX_TEX_CONST_3_LAYERSZ__SHIFT				0
static inline uint32_t A4XX_TEX_CONST_3_LAYERSZ(uint32_t val)
{
	return ((val >> 12) << A4XX_TEX_CONST_3_LAYERSZ__SHIFT) & A4XX_TEX_CONST_3_LAYERSZ__MASK;
}
#define A4XX_TEX_CONST_3_DEPTH__MASK				0x7ffc0000
#define A4XX_TEX_CONST_3_DEPTH__SHIFT				18
static inline uint32_t A4XX_TEX_CONST_3_DEPTH(uint32_t val)
{
	return ((val) << A4XX_TEX_CONST_3_DEPTH__SHIFT) & A4XX_TEX_CONST_3_DEPTH__MASK;
}

#define REG_A4XX_TEX_CONST_4					0x00000004
#define A4XX_TEX_CONST_4_LAYERSZ__MASK				0x0000000f
#define A4XX_TEX_CONST_4_LAYERSZ__SHIFT				0
static inline uint32_t A4XX_TEX_CONST_4_LAYERSZ(uint32_t val)
{
	return ((val >> 12) << A4XX_TEX_CONST_4_LAYERSZ__SHIFT) & A4XX_TEX_CONST_4_LAYERSZ__MASK;
}
#define A4XX_TEX_CONST_4_BASE__MASK				0xffffffe0
#define A4XX_TEX_CONST_4_BASE__SHIFT				5
static inline uint32_t A4XX_TEX_CONST_4_BASE(uint32_t val)
{
	return ((val >> 5) << A4XX_TEX_CONST_4_BASE__SHIFT) & A4XX_TEX_CONST_4_BASE__MASK;
}

#define REG_A4XX_TEX_CONST_5					0x00000005

#define REG_A4XX_TEX_CONST_6					0x00000006

#define REG_A4XX_TEX_CONST_7					0x00000007


#endif /* A4XX_XML */
