#ifndef __ARCH_ARM_MACH_OMAP2_CM_REGBITS_24XX_H
#define __ARCH_ARM_MACH_OMAP2_CM_REGBITS_24XX_H

/*
 * OMAP24XX Clock Management register bits
 *
 * Copyright (C) 2007 Texas Instruments, Inc.
 * Copyright (C) 2007 Nokia Corporation
 *
 * Written by Paul Walmsley
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#define OMAP24XX_EN_CAM_SHIFT				31
#define OMAP24XX_EN_WDT4_SHIFT				29
#define OMAP2420_EN_WDT3_SHIFT				28
#define OMAP24XX_EN_MSPRO_SHIFT				27
#define OMAP24XX_EN_FAC_SHIFT				25
#define OMAP2420_EN_EAC_SHIFT				24
#define OMAP24XX_EN_HDQ_SHIFT				23
#define OMAP2420_EN_I2C2_SHIFT				20
#define OMAP2420_EN_I2C1_SHIFT				19
#define OMAP2430_EN_MCBSP5_SHIFT			5
#define OMAP2430_EN_MCBSP4_SHIFT			4
#define OMAP2430_EN_MCBSP3_SHIFT			3
#define OMAP24XX_EN_SSI_SHIFT				1
#define OMAP24XX_EN_MPU_WDT_SHIFT			3
#define OMAP24XX_CLKSEL_MPU_SHIFT			0
#define OMAP24XX_CLKSEL_MPU_WIDTH			5
#define OMAP24XX_AUTOSTATE_MPU_MASK			(1 << 0)
#define OMAP24XX_EN_TV_SHIFT				2
#define OMAP24XX_EN_DSS2_SHIFT				1
#define OMAP24XX_EN_DSS1_SHIFT				0
#define OMAP24XX_EN_DSS1_MASK				(1 << 0)
#define OMAP2430_EN_I2CHS2_SHIFT			20
#define OMAP2430_EN_I2CHS1_SHIFT			19
#define OMAP2430_EN_MMCHSDB2_SHIFT			17
#define OMAP2430_EN_MMCHSDB1_SHIFT			16
#define OMAP24XX_EN_MAILBOXES_SHIFT			30
#define OMAP2430_EN_SDRC_SHIFT				2
#define OMAP24XX_EN_PKA_SHIFT				4
#define OMAP24XX_EN_AES_SHIFT				3
#define OMAP24XX_EN_RNG_SHIFT				2
#define OMAP24XX_EN_SHA_SHIFT				1
#define OMAP24XX_EN_DES_SHIFT				0
#define OMAP24XX_ST_MAILBOXES_SHIFT			30
#define OMAP24XX_ST_HDQ_SHIFT				23
#define OMAP2420_ST_I2C2_SHIFT				20
#define OMAP2430_ST_I2CHS1_SHIFT			19
#define OMAP2420_ST_I2C1_SHIFT				19
#define OMAP2430_ST_I2CHS2_SHIFT			20
#define OMAP24XX_ST_MCBSP2_SHIFT			16
#define OMAP24XX_ST_MCBSP1_SHIFT			15
#define OMAP24XX_ST_DSS_SHIFT				0
#define OMAP2430_ST_MCBSP5_SHIFT			5
#define OMAP2430_ST_MCBSP4_SHIFT			4
#define OMAP2430_ST_MCBSP3_SHIFT			3
#define OMAP24XX_ST_AES_SHIFT				3
#define OMAP24XX_ST_RNG_SHIFT				2
#define OMAP24XX_ST_SHA_SHIFT				1
#define OMAP24XX_AUTO_SDRC_SHIFT			2
#define OMAP24XX_AUTO_GPMC_SHIFT			1
#define OMAP24XX_AUTO_SDMA_SHIFT			0
#define OMAP24XX_CLKSEL_USB_MASK			(0x7 << 25)
#define OMAP24XX_CLKSEL_SSI_MASK			(0x1f << 20)
#define OMAP2420_CLKSEL_VLYNQ_MASK			(0x1f << 15)
#define OMAP24XX_CLKSEL_DSS2_MASK			(0x1 << 13)
#define OMAP24XX_CLKSEL_DSS1_MASK			(0x1f << 8)
#define OMAP24XX_CLKSEL_L4_SHIFT			5
#define OMAP24XX_CLKSEL_L4_WIDTH			2
#define OMAP24XX_CLKSEL_L3_SHIFT			0
#define OMAP24XX_CLKSEL_L3_WIDTH			5
#define OMAP24XX_CLKSEL_GPT12_MASK			(0x3 << 22)
#define OMAP24XX_CLKSEL_GPT11_MASK			(0x3 << 20)
#define OMAP24XX_CLKSEL_GPT10_MASK			(0x3 << 18)
#define OMAP24XX_CLKSEL_GPT9_MASK			(0x3 << 16)
#define OMAP24XX_CLKSEL_GPT8_MASK			(0x3 << 14)
#define OMAP24XX_CLKSEL_GPT7_MASK			(0x3 << 12)
#define OMAP24XX_CLKSEL_GPT6_MASK			(0x3 << 10)
#define OMAP24XX_CLKSEL_GPT5_MASK			(0x3 << 8)
#define OMAP24XX_CLKSEL_GPT4_MASK			(0x3 << 6)
#define OMAP24XX_CLKSEL_GPT3_MASK			(0x3 << 4)
#define OMAP24XX_CLKSEL_GPT2_MASK			(0x3 << 2)
#define OMAP24XX_AUTOSTATE_DSS_MASK			(1 << 2)
#define OMAP24XX_AUTOSTATE_L4_MASK			(1 << 1)
#define OMAP24XX_AUTOSTATE_L3_MASK			(1 << 0)
#define OMAP24XX_EN_3D_SHIFT				2
#define OMAP24XX_EN_2D_SHIFT				1
#define OMAP24XX_AUTOSTATE_GFX_MASK			(1 << 0)
#define OMAP2430_EN_ICR_SHIFT				6
#define OMAP24XX_EN_OMAPCTRL_SHIFT			5
#define OMAP24XX_EN_WDT1_SHIFT				4
#define OMAP24XX_EN_32KSYNC_SHIFT			1
#define OMAP24XX_ST_MPU_WDT_SHIFT			3
#define OMAP24XX_ST_32KSYNC_SHIFT			1
#define OMAP24XX_CLKSEL_GPT1_MASK			(0x3 << 0)
#define OMAP24XX_EN_54M_PLL_SHIFT			6
#define OMAP24XX_EN_96M_PLL_SHIFT			2
#define OMAP24XX_EN_DPLL_MASK				(0x3 << 0)
#define OMAP24XX_ST_54M_APLL_SHIFT			9
#define OMAP24XX_ST_96M_APLL_SHIFT			8
#define OMAP24XX_AUTO_54M_MASK				(0x3 << 6)
#define OMAP24XX_AUTO_96M_MASK				(0x3 << 2)
#define OMAP24XX_AUTO_DPLL_SHIFT			0
#define OMAP24XX_AUTO_DPLL_MASK				(0x3 << 0)
#define OMAP24XX_APLLS_CLKIN_SHIFT			23
#define OMAP24XX_APLLS_CLKIN_MASK			(0x7 << 23)
#define OMAP24XX_DPLL_MULT_MASK				(0x3ff << 12)
#define OMAP24XX_DPLL_DIV_MASK				(0xf << 8)
#define OMAP24XX_54M_SOURCE_SHIFT			5
#define OMAP24XX_54M_SOURCE_WIDTH			1
#define OMAP2430_96M_SOURCE_SHIFT			4
#define OMAP2430_96M_SOURCE_WIDTH			1
#define OMAP24XX_48M_SOURCE_MASK			(1 << 3)
#define OMAP24XX_CORE_CLK_SRC_MASK			(0x3 << 0)
#define OMAP2420_EN_IVA_COP_SHIFT			10
#define OMAP2420_EN_IVA_MPU_SHIFT			8
#define OMAP24XX_CM_FCLKEN_DSP_EN_DSP_SHIFT		0
#define OMAP2420_EN_DSP_IPI_SHIFT			1
#define OMAP2420_CLKSEL_IVA_MASK			(0x1f << 8)
#define OMAP24XX_CLKSEL_DSP_IF_MASK			(0x3 << 5)
#define OMAP24XX_CLKSEL_DSP_MASK			(0x1f << 0)
#define OMAP2420_AUTOSTATE_IVA_MASK			(1 << 8)
#define OMAP24XX_AUTOSTATE_DSP_MASK			(1 << 0)
#define OMAP2430_EN_OSC_SHIFT				1
#define OMAP2430_CM_ICLKEN_MDM_EN_MDM_SHIFT		0
#define OMAP2430_CLKSEL_MDM_MASK			(0xf << 0)
#define OMAP2430_AUTOSTATE_MDM_MASK			(1 << 0)
#define OMAP24XX_CLKSTCTRL_DISABLE_AUTO		0x0
#define OMAP24XX_CLKSTCTRL_ENABLE_AUTO		0x1
#endif
