/*
 * $Id: pci.c,v 1.36 1998/08/02 23:22:11 paulus Exp $
 * Common pmac/prep/chrp pci routines. -- Cort
 */

#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/string.h>
#include <linux/init.h>
#include <linux/config.h>
#include <linux/pci.h>
#include <linux/openpic.h>

#include <asm/processor.h>
#include <asm/io.h>
#include <asm/prom.h>
#include <asm/pci-bridge.h>
#include <asm/residual.h>
#include <asm/byteorder.h>
#include <asm/irq.h>
#include <asm/gg2.h>

unsigned long isa_io_base;
unsigned long isa_mem_base;
unsigned long pci_dram_offset;

unsigned int * pci_config_address;
unsigned char * pci_config_data;

/*
 * It would be nice if we could create a include/asm/pci.h and have just
 * function ptrs for all these in there, but that isn't the case.
 * We have a function, pcibios_*() which calls the function ptr ptr_pcibios_*()
 * which has been setup by pcibios_init().  This is all to avoid a check
 * for pmac/prep every time we call one of these.  It should also make the move
 * to a include/asm/pcibios.h easier, we can drop the ptr_ on these functions
 * and create pci.h
 *   -- Cort
 */
int (*ptr_pcibios_read_config_byte)(unsigned char bus, unsigned char dev_fn,
				    unsigned char offset, unsigned char *val);
int (*ptr_pcibios_read_config_word)(unsigned char bus, unsigned char dev_fn,
				    unsigned char offset, unsigned short *val);
int (*ptr_pcibios_read_config_dword)(unsigned char bus, unsigned char dev_fn,
				     unsigned char offset, unsigned int *val);
int (*ptr_pcibios_write_config_byte)(unsigned char bus, unsigned char dev_fn,
				     unsigned char offset, unsigned char val);
int (*ptr_pcibios_write_config_word)(unsigned char bus, unsigned char dev_fn,
				     unsigned char offset, unsigned short val);
int (*ptr_pcibios_write_config_dword)(unsigned char bus, unsigned char dev_fn,
				      unsigned char offset, unsigned int val);

#define decl_config_access_method(name) \
extern int name##_pcibios_read_config_byte(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned char *val); \
extern int name##_pcibios_read_config_word(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned short *val); \
extern int name##_pcibios_read_config_dword(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned int *val); \
extern int name##_pcibios_write_config_byte(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned char val); \
extern int name##_pcibios_write_config_word(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned short val); \
extern int name##_pcibios_write_config_dword(unsigned char bus, \
	unsigned char dev_fn, unsigned char offset, unsigned int val)

#define set_config_access_method(name) \
	ptr_pcibios_read_config_byte = name##_pcibios_read_config_byte; \
	ptr_pcibios_read_config_word = name##_pcibios_read_config_word; \
	ptr_pcibios_read_config_dword = name##_pcibios_read_config_dword; \
	ptr_pcibios_write_config_byte = name##_pcibios_write_config_byte; \
	ptr_pcibios_write_config_word = name##_pcibios_write_config_word; \
	ptr_pcibios_write_config_dword = name##_pcibios_write_config_dword

decl_config_access_method(pmac);
decl_config_access_method(grackle);
decl_config_access_method(gg2);
decl_config_access_method(raven);
decl_config_access_method(prep);
decl_config_access_method(mbx);

int pcibios_read_config_byte(unsigned char bus, unsigned char dev_fn,
			     unsigned char offset, unsigned char *val)
{
	return ptr_pcibios_read_config_byte(bus,dev_fn,offset,val);
}
int pcibios_read_config_word(unsigned char bus, unsigned char dev_fn,
			     unsigned char offset, unsigned short *val)
{
	return ptr_pcibios_read_config_word(bus,dev_fn,offset,val);
}
int pcibios_read_config_dword(unsigned char bus, unsigned char dev_fn,
			      unsigned char offset, unsigned int *val)
{
	return ptr_pcibios_read_config_dword(bus,dev_fn,offset,val);
}
int pcibios_write_config_byte(unsigned char bus, unsigned char dev_fn,
			      unsigned char offset, unsigned char val)
{
	return ptr_pcibios_write_config_byte(bus,dev_fn,offset,val);
}
int pcibios_write_config_word(unsigned char bus, unsigned char dev_fn,
			      unsigned char offset, unsigned short val)
{
	return ptr_pcibios_write_config_word(bus,dev_fn,offset,val);
}
int pcibios_write_config_dword(unsigned char bus, unsigned char dev_fn,
			       unsigned char offset, unsigned int val)
{
	return ptr_pcibios_write_config_dword(bus,dev_fn,offset,val);
}

int pcibios_present(void)
{
	return 1;
}

__initfunc(void pcibios_init(void))
{
}

__initfunc(void
	   setup_pci_ptrs(void))
{
	PPC_DEVICE *hostbridge;
#ifndef CONFIG_MBX  
	switch (_machine) {
	case _MACH_prep:
	  	hostbridge=residual_find_device(PROCESSORDEVICE, NULL,
						BridgeController, PCIBridge,
						-1, 0);
		if (hostbridge && 
		    hostbridge->DeviceId.Interface == PCIBridgeIndirect) {
			PnP_TAG_PACKET * pkt;	
			set_config_access_method(raven);
			pkt=PnP_find_large_vendor_packet(
			       res->DevicePnPHeap+hostbridge->AllocatedOffset, 
			       3, 0);
			if(pkt) { 
#define p pkt->L4_Pack.L4_Data.L4_PPCPack
				pci_config_address= (unsigned *)
				  ld_le32((unsigned *) p.PPCData);
				pci_config_data= (unsigned char *)
				  ld_le32((unsigned *) (p.PPCData+8));
			} else {/* default values */
				pci_config_address= (unsigned *) 0x80000cf8;
				pci_config_data= (unsigned char *) 0x80000cfc; 
			}  
		} else {
			set_config_access_method(prep);
		}
		break;
	case _MACH_Pmac:
		if (find_devices("pci") != 0) {
			/* looks like a G3 powermac */
			set_config_access_method(grackle);
		} else {
			set_config_access_method(pmac);
		}
		break;
	case _MACH_chrp:
		if ( !strncmp("MOT",
			      get_property(find_path_device("/"), "model", NULL),3) )
		{
			isa_io_base = 0xfe000000;
			set_config_access_method(raven);
		}
		else
		{
			isa_io_base = GG2_ISA_IO_BASE;
			set_config_access_method(gg2);
		}
		break;
	default:
		printk("setup_pci_ptrs(): unknown machine type!\n");
	}
#else  /* CONFIG_MBX */
	set_config_access_method(mbx);
#endif /* CONFIG_MBX */	
#undef set_config_access_method
}

__initfunc(void pcibios_fixup(void))
{
	extern unsigned long route_pci_interrupts(void);
	struct pci_dev *dev;
	extern struct bridge_data **bridges;
	extern unsigned char *Motherboard_map;
	extern unsigned char *Motherboard_routes;
	
	/*
	 * FIXME: This is broken: We should not assign IRQ's to IRQless
	 *	  devices (look at PCI_INTERRUPT_PIN) and we also should
	 *	  honor the existence of multi-function devices where
	 *	  different functions have different interrupt pins. [mj]
	 */
	switch (_machine )
	{
	case _MACH_prep:
		route_pci_interrupts();
		for(dev=pci_devices; dev; dev=dev->next)
		{
			unsigned char d = PCI_SLOT(dev->devfn);
			dev->irq = Motherboard_routes[Motherboard_map[d]];
		}
		break;
	case _MACH_chrp:
		/* PCI interrupts are controlled by the OpenPIC */
		for(dev=pci_devices; dev; dev=dev->next)
			if (dev->irq)
				dev->irq = openpic_to_irq(dev->irq);
		break;
	case _MACH_Pmac:
		for(dev=pci_devices; dev; dev=dev->next)
		{
			/*
			 * Open Firmware often doesn't initialize the,
			 * PCI_INTERRUPT_LINE config register properly, so we
			 * should find the device node and se if it has an
			 * AAPL,interrupts property.
			 */
			struct bridge_data *bp = bridges[dev->bus->number];
			struct device_node *node;
			unsigned int *reg;
			unsigned char pin;
			
			if (pci_read_config_byte(dev, PCI_INTERRUPT_PIN, &pin) ||
			    !pin)
				continue;	/* No interrupt generated -> no fixup */
			for (node = bp->node->child; node != 0;
			     node = node->sibling) {
				reg = (unsigned int *) get_property(node, "reg", 0);
				if (reg == 0 || ((reg[0] >> 8) & 0xff) != dev->devfn)
					continue;
				/* this is the node, see if it has interrupts */
				if (node->n_intrs > 0)
					dev->irq = node->intrs[0].line;
				break;
			}
		}
		break;
	}
}

__initfunc(void pcibios_fixup_bus(struct pci_bus *bus))
{
}

__initfunc(char *pcibios_setup(char *str))
{
	return str;
}
