#ifndef _SPINLOCK_H
#define _SPINLOCK_H

#define MAX_THREADS	256

#include <stdlib.h>
#include "kernel.h"

#ifdef USE_TICKETS
#define LOCK_NAME	"ticket"
#include "tickets.h"
#elif defined(USE_QSPINLOCK)
#define LOCK_NAME	"qspinlock"
#include "qspinlock.h"
#else
#define LOCK_NAME	"test-and-set"
#include "tas.h"
#endif

typedef arch_spinlock_t		spinlock_t;
#define SPIN_LOCK_UNLOCKED	__ARCH_SPIN_LOCK_UNLOCKED
#define spin_lock		arch_spin_lock
#define spin_unlock		arch_spin_unlock

#endif	/* _SPINLOCK_H */
