/*
 * Userspace Semaphores
 */
#ifndef	_USERSEM_H
#define	_USERSEM_H
#include <unistd.h> /* size_t */

/* You should never touch this structure directly! */
struct futex
{
	int count;
};

/* Prepare this area for futex use (returns -ve on error). */
int futex_region(void *area, size_t size);

void futex_init(struct futex *sem);
/* Down and up operations */
int futex_down(struct futex *sem);
int futex_up(struct futex *sem);
#endif /* _USERSEM_H */
