/*
 * pivot.c - read from the HDAPS (HardDrive Active Protection System).
 *
 * Copyright (C) 2005 Robert Love <rml@novell.com>
 *
 * "Why does that kid keep dropping his laptop?"
 */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

#include "../kernel/hdaps.h"

int main (int argc, char *argv[])
{
	unsigned int verbose = 0;
	struct hdaps_data data;		
	__u16 rest_x, rest_y;
	int i, fd, ret;

	if (argc <= 1) {
		fprintf (stderr, "usage: %s <dev>\n", argv[0]);
		return 1;
	}

	fd = open (argv[1], O_RDONLY);
	if (fd < 0) {
		perror ("open");
		return 1;
	}

	ret = read (fd, &data, sizeof (data));
	if (ret < 0) {
		perror ("read");
		goto out;
	} else if (ret == 0) {
		fprintf (stderr, "Unexpectedly read zero!\n");
		goto out;
	}

	/* get some base data for calibration */
	rest_x = data.x_pos;
	rest_y = data.y_pos;

	for (i = 0; i < 1000; i++) {
		struct timespec ts = { 0, 5000000 };

		ret = read (fd, &data, sizeof (data));
		if (ret < 0) {
			perror ("read");
			break;
		} else if (ret == 0) {
			fprintf (stderr, "Unexpectedly read zero!\n");
			break;
		}

		printf ("(x,y) acceleration: (%d,%d)\n",
			rest_x - data.x_pos,
			rest_y - data.y_pos);

		if (verbose) {
			printf ("temp=%d temp2=%d unknown=%d ",
				data.temp, data.temp2, data.unknown);
			printf ("keybd=%d mouse=%d\n",
				KEYBD_ISSET(data.km_activity),
				MOUSE_ISSET(data.km_activity));
		}

		if (!data.x_pos || (data.x_pos > 1000)
				|| (data.temp != data.temp2)) {
			fprintf (stderr, "invalid data returned!\n");
			ret = 1;
			break;
		}

		ret = nanosleep (&ts, NULL);
		if (ret) {
			perror ("nanosleep");
			break;
		}
	}

out:
	ret = close (fd);
	if (ret) {
		perror ("close");
		return 1;
	}
	
	return ret;
}
