/*
 *	Deadman	0.02:	A Software Deadman Device
 *
 *	(c) Copyright 2000 Eric Soderberg <seric@cup.hp.com>, All Rights Reserved.
 *				http://www.hp.com
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *	
 *	Neither Eric Soderberg or Hewlett-Packard admit liability nor provide 
 *	warranty for any of this software. This material is provided 
 *	"AS-IS" and at no charge.	
 *
 */

#ifndef _DEADMAN_INCLUDED /* allows multiple inclusion */
#define _DEADMAN_INCLUDED 

#ifdef __KERNEL__
#include <linux/ioctl.h>
#include <linux/time.h>
#else
#include <sys/ioctl.h>
#include <time.h>
#endif

#define	DEADMAN_IOCTL_BASE	'W'

/*
 * DEADMAN_QUERY_CURRENT returns the amount of time that has elapsed
 * since the system was booted (converts jiffies to timespec).
 * Any user can call this.
 */
#define DEADMAN_QUERY_CURRENT _IOR(DEADMAN_IOCTL_BASE, 0x30, struct timespec)
/*
 * DEADMAN_ENABLE turns on the deadman timer which will expire at the
 * specified time.
 * The process calling this must be owned by root.
 * EBUSY is reported if it is already enabled.
 * EPERM is reported if the caller is not the root user.
 */
#define DEADMAN_ENABLE _IOW(DEADMAN_IOCTL_BASE, 0x31, struct timespec)
/*
 * DEADMAN_DISABLE turns off the deadman timer.
 * The process calling this must be owned by root.
 * EINVAL is reported if it is not enabled.
 * EPERM is reported if the caller is not the root user.
 */
#define DEADMAN_DISABLE _IO(DEADMAN_IOCTL_BASE, 0x32)

/*
 * DEADMAN_UPDATE advances the expiration time of the deadman timer.
 * The process calling this must be owned by root.
 * EINVAL is reported and no action is taken if the deadman timer is
 * not enabled.
 * EPERM is reported if the caller is not the root user.
 */
#define DEADMAN_UPDATE _IOW(DEADMAN_IOCTL_BASE, 0x33, struct timespec)

#define DEADMAN_VERSION "0.02"

#endif /* _DEADMAN_INCLUDED */
