/* Dazuko. Check parameters of XP calls before making real calls.
   Written by John Ogness <jogness@antivir.de>

   Copyright (c) 2003 H+BEDV Datentechnik GmbH
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

   3. Neither the name of Dazuko nor the names of its contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef DAZUKO_CALL_H
#define DAZUKO_CALL_H

struct xp_mutex;
struct xp_rwlock;
struct xp_queue;
struct xp_atomic;
struct xp_file;
struct dazuko_file_struct;
struct xp_daemon_id;

int call_xp_init_mutex(struct xp_mutex *mutex);
int call_xp_down(struct xp_mutex *mutex);
int call_xp_up(struct xp_mutex *mutex);
int call_xp_destroy_mutex(struct xp_mutex *mutex);
int call_xp_init_rwlock(struct xp_rwlock *rwlock);
int call_xp_write_lock(struct xp_rwlock *rwlock);
int call_xp_write_unlock(struct xp_rwlock *rwlock);
int call_xp_read_lock(struct xp_rwlock *rlock);
int call_xp_read_unlock(struct xp_rwlock *rlock);
int call_xp_destroy_rwlock(struct xp_rwlock *rwlock);
int call_xp_init_queue(struct xp_queue *queue);
int call_xp_wait_until_condition(struct xp_queue *queue, int (*cfunction)(void *), void *cparam, int allow_interrupt);
int call_xp_notify(struct xp_queue *queue);
int call_xp_destroy_queue(struct xp_queue *queue);
void* call_xp_malloc(size_t size);
int call_xp_free(void *ptr);
int call_xp_copyin(const void *user_src, void *kernel_dest, size_t size);
int call_xp_copyout(const void *kernel_src, void *user_dest, size_t size);
int call_xp_verify_user_writable(const void *user_ptr, size_t size);
int call_xp_verify_user_readable(const void *user_ptr, size_t size);
int call_xp_is_absolute_path(const char *path);
int call_xp_atomic_set(struct xp_atomic *atomic, int value);
int call_xp_atomic_inc(struct xp_atomic *atomic);
int call_xp_atomic_dec(struct xp_atomic *atomic);
int call_xp_atomic_read(struct xp_atomic *atomic);
int call_xp_copy_file(struct xp_file *dest, struct xp_file *src);
int call_xp_compare_file(struct xp_file *file1, struct xp_file *file2);
#define call_xp_sys_hook xp_sys_hook
#define call_xp_sys_unhook xp_sys_unhook
int call_xp_file_struct_check(struct dazuko_file_struct *dfs);
int call_xp_file_struct_check_cleanup(struct dazuko_file_struct *dfs);
int call_xp_id_compare(struct xp_daemon_id *id1, struct xp_daemon_id *id2);
int call_xp_id_free(struct xp_daemon_id *id);
struct xp_daemon_id* call_xp_id_copy(struct xp_daemon_id *id);
#define call_xp_print xp_print

#endif
