#ifndef __GRINTERNAL_H
#define __GRINTERNAL_H

#ifdef CONFIG_GRKERNSEC

#include <linux/grdefs.h>
#include <linux/gracl.h>
#include <linux/grmsg.h>

extern void gr_add_learn_entry(const char *fmt, ...);
extern __u32 gr_search_file(const struct dentry *dentry, const __u32 mode,
			    const struct vfsmount *mnt);
extern __u32 gr_check_create(const struct dentry *new_dentry,
			     const struct dentry *parent,
			     const struct vfsmount *mnt, const __u32 mode);
extern int gr_check_protected_task(const struct task_struct *task);
extern __u32 to_gr_audit(const __u32 reqmode);
extern int gr_handle_rename(struct inode *old_dir, struct inode *new_dir,
			    struct dentry *old_dentry,
			    struct dentry *new_dentry,
			    struct vfsmount *mnt, const __u8 replace);
extern int gr_set_acls(const int type);
extern int gr_acl_is_enabled(void);
extern char gr_roletype_to_char(void);

extern void gr_handle_alertkill(void);
extern char *gr_to_filename(const struct dentry *dentry,
			    const struct vfsmount *mnt);
extern char *gr_to_filename1(const struct dentry *dentry,
			    const struct vfsmount *mnt);
extern char *gr_to_filename2(const struct dentry *dentry,
			    const struct vfsmount *mnt);
extern char *gr_to_filename3(const struct dentry *dentry,
			    const struct vfsmount *mnt);

extern int grsec_enable_link;
extern int grsec_enable_fifo;
extern int grsec_enable_execve;
extern int grsec_enable_forkbomb;
extern int grsec_forkbomb_gid;
extern int grsec_forkbomb_sec;
extern int grsec_forkbomb_max;
extern int grsec_enable_execlog;
extern int grsec_enable_resourcelog;
extern int grsec_enable_signal;
extern int grsec_enable_forkfail;
extern int grsec_enable_time;
extern int grsec_enable_chroot_shmat;
extern int grsec_enable_chroot_findtask;
extern int grsec_enable_chroot_mount;
extern int grsec_enable_chroot_double;
extern int grsec_enable_chroot_pivot;
extern int grsec_enable_chroot_chdir;
extern int grsec_enable_chroot_chmod;
extern int grsec_enable_chroot_mknod;
extern int grsec_enable_chroot_fchdir;
extern int grsec_enable_chroot_nice;
extern int grsec_enable_chroot_execlog;
extern int grsec_enable_chroot_caps;
extern int grsec_enable_chroot_sysctl;
extern int grsec_enable_chroot_unix;
extern int grsec_enable_tpe;
extern int grsec_tpe_gid;
extern int grsec_enable_tpe_all;
extern int grsec_enable_randpid;
extern int grsec_enable_socket_all;
extern int grsec_socket_all_gid;
extern int grsec_enable_socket_client;
extern int grsec_socket_client_gid;
extern int grsec_enable_socket_server;
extern int grsec_socket_server_gid;
extern int grsec_audit_gid;
extern int grsec_enable_group;
extern int grsec_enable_audit_ipc;
extern int grsec_enable_audit_textrel;
extern int grsec_enable_mount;
extern int grsec_enable_chdir;
extern int grsec_lock;

extern struct task_struct *child_reaper;

extern spinlock_t grsec_alert_lock;
extern unsigned long grsec_alert_wtime;
extern unsigned long grsec_alert_fyet;

extern spinlock_t grsec_audit_lock;

extern rwlock_t grsec_exec_file_lock;

#define gr_task_fullpath(tsk) (tsk->exec_file ? \
			gr_to_filename2(tsk->exec_file->f_dentry, \
			tsk->exec_file->f_vfsmnt) : "/")

#define gr_parent_task_fullpath(tsk) (tsk->p_pptr->exec_file ? \
			gr_to_filename3(tsk->p_pptr->exec_file->f_dentry, \
			tsk->p_pptr->exec_file->f_vfsmnt) : "/")

#define gr_task_fullpath0(tsk) (tsk->exec_file ? \
			gr_to_filename(tsk->exec_file->f_dentry, \
			tsk->exec_file->f_vfsmnt) : "/")

#define gr_parent_task_fullpath0(tsk) (tsk->p_pptr->exec_file ? \
			gr_to_filename1(tsk->p_pptr->exec_file->f_dentry, \
			tsk->p_pptr->exec_file->f_vfsmnt) : "/")

#define proc_is_chrooted(tsk_a)  ((tsk_a->pid > 1) && \
			  ((tsk_a->fs->root->d_inode->i_dev != \
			  child_reaper->fs->root->d_inode->i_dev) || \
			  (tsk_a->fs->root->d_inode->i_ino != \
			  child_reaper->fs->root->d_inode->i_ino)))

#define have_same_root(tsk_a,tsk_b) ((tsk_a->fs->root->d_inode->i_dev == \
			  tsk_b->fs->root->d_inode->i_dev) && \
			  (tsk_a->fs->root->d_inode->i_ino == \
			  tsk_b->fs->root->d_inode->i_ino))

#define DEFAULTSECARGS gr_task_fullpath(current), current->comm, \
		       current->pid, current->uid, \
		       current->euid, current->gid, current->egid, \
		       gr_parent_task_fullpath(current), \
		       current->p_pptr->comm, current->p_pptr->pid, \
		       current->p_pptr->uid, current->p_pptr->euid, \
		       current->p_pptr->gid, current->p_pptr->egid

#define GR_CHROOT_CAPS ( \
	CAP_TO_MASK(CAP_FOWNER) | \
	CAP_TO_MASK(CAP_LINUX_IMMUTABLE) | CAP_TO_MASK(CAP_NET_ADMIN) | \
	CAP_TO_MASK(CAP_SYS_MODULE) | CAP_TO_MASK(CAP_SYS_RAWIO) | \
	CAP_TO_MASK(CAP_SYS_PACCT) | CAP_TO_MASK(CAP_SYS_ADMIN) | \
	CAP_TO_MASK(CAP_SYS_BOOT) | CAP_TO_MASK(CAP_SYS_TIME) | \
	CAP_TO_MASK(CAP_NET_RAW) | CAP_TO_MASK(CAP_SYS_TTY_CONFIG) | \
	CAP_TO_MASK(CAP_IPC_OWNER))

#define security_alert_good(normal_msg,args...) \
({ \
	read_lock(&tasklist_lock); \
	read_lock(&grsec_exec_file_lock); \
	spin_lock(&grsec_alert_lock); \
	\
	if (!grsec_alert_wtime || jiffies - grsec_alert_wtime > CONFIG_GRKERNSEC_FLOODTIME * HZ) { \
	    grsec_alert_wtime = jiffies; grsec_alert_fyet = 0; \
	    if (current->curr_ip && gr_acl_is_enabled()) \
		printk(KERN_ALERT "grsec: From %u.%u.%u.%u: (%.64s:%c:%.950s) " normal_msg "\n", NIPQUAD(current->curr_ip), current->role->rolename, gr_roletype_to_char(), current->acl->filename , ## args); \
	    else if (current->curr_ip) \
		printk(KERN_ALERT "grsec: From %u.%u.%u.%u: " normal_msg "\n", NIPQUAD(current->curr_ip) , ## args); \
	    else if (gr_acl_is_enabled()) \
		printk(KERN_ALERT "grsec: (%.64s:%c:%.950s) " normal_msg "\n", current->role->rolename, gr_roletype_to_char(), current->acl->filename , ## args); \
	    else \
	    	printk(KERN_ALERT "grsec: " normal_msg "\n" , ## args); \
	} else if((jiffies - grsec_alert_wtime < CONFIG_GRKERNSEC_FLOODTIME * HZ) && (grsec_alert_fyet < CONFIG_GRKERNSEC_FLOODBURST)) { \
	    grsec_alert_fyet++; \
	    if (current->curr_ip && gr_acl_is_enabled()) \
		printk(KERN_ALERT "grsec: From %u.%u.%u.%u: (%.64s:%c:%.950s) " normal_msg "\n", NIPQUAD(current->curr_ip), current->role->rolename, gr_roletype_to_char(), current->acl->filename , ## args); \
	    else if (current->curr_ip) \
		printk(KERN_ALERT "grsec: From %u.%u.%u.%u: " normal_msg "\n", NIPQUAD(current->curr_ip) , ## args); \
	    else if (gr_acl_is_enabled()) \
		printk(KERN_ALERT "grsec: (%.64s:%c:%.950s) " normal_msg "\n", current->role->rolename, gr_roletype_to_char(), current->acl->filename , ## args); \
	    else \
	    	printk(KERN_ALERT "grsec: " normal_msg "\n" , ## args); \
	} else if (grsec_alert_fyet == CONFIG_GRKERNSEC_FLOODBURST) { \
	    grsec_alert_wtime = jiffies; grsec_alert_fyet++; \
	    printk(KERN_ALERT "grsec: more alerts, logging disabled for " \
		    "%d seconds\n", CONFIG_GRKERNSEC_FLOODTIME); \
	} \
	\
	spin_unlock(&grsec_alert_lock); \
	read_unlock(&grsec_exec_file_lock); \
	read_unlock(&tasklist_lock); \
})

#define security_alert(normal_msg,args...) \
({ \
	security_alert_good(normal_msg,args); \
	gr_handle_alertkill(); \
})

#define security_audit(normal_msg,args...) \
({ \
	read_lock(&tasklist_lock); \
	read_lock(&grsec_exec_file_lock); \
	spin_lock(&grsec_audit_lock); \
	if (current->curr_ip && gr_acl_is_enabled()) \
	    printk(KERN_INFO "grsec: From %u.%u.%u.%u: (%.64s:%.950s) " normal_msg "\n", NIPQUAD(current->curr_ip), current->role->rolename, current->acl->filename , ## args); \
	else if (current->curr_ip) \
	    printk(KERN_INFO "grsec: From %u.%u.%u.%u: " normal_msg "\n", NIPQUAD(current->curr_ip) , ## args); \
	else if (gr_acl_is_enabled()) \
	    printk(KERN_INFO "grsec: (%.64s:%.950s) " normal_msg "\n", current->role->rolename, current->acl->filename , ## args); \
	else \
	    printk(KERN_INFO "grsec: " normal_msg "\n" , ## args); \
	spin_unlock(&grsec_audit_lock); \
	read_unlock(&grsec_exec_file_lock); \
	read_unlock(&tasklist_lock); \
})

#define security_learn(normal_msg,args...) \
({ \
	preempt_disable(); \
	gr_add_learn_entry(normal_msg "\n", ## args); \
	preempt_enable(); \
})

#endif

#endif
