/******************************************************************************
 *
 * Name:	skqueue.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.1 $
 * Date:	$Date: 2001/06/05 08:28:25 $
 * Purpose:	Defines for the event queue.
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skqueue.h,v $
 *	Revision 1.1  2001/06/05 08:28:25  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 * This module contains all defines and types for the event queue.
 *
 * Include File Hierarchy:
 *
 *	"skdrv1st.h"
 *	"skqueue.h"
 *	"skdrv2nd.h"
 *
 ******************************************************************************/

#ifndef _SKQUEUE_H_
#define _SKQUEUE_H_

/* Define Error Numbers and messages */
#define	SKERR_Q_E001	(SK_ERRBASE_QUEUE+0)
#define	SKERR_Q_E001MSG	"Event queue overflow"
#define	SKERR_Q_E002	(SKERR_Q_E001+1)
#define	SKERR_Q_E002MSG	"Undefined event class"

/* Define the event classes to be served. */
#define	SKGI_DRV	1	/* Driver Event Class */
#define	SKGI_RLMT	2	/* RLMT Event Class */
#define	SKGI_PNMI	3	/* PNMI Event Class */
#define	SKGI_CSUM	4	/* Checksum Event Class */
#define	SKGI_HWAC	5	/* Hardware Access Event Class */

/* Define event queue as circular buffer. */
#define SK_MAX_EVENT	64

/* Parameter union for the Para stuff. */
typedef	union u_EvPara {
	void	*pParaPtr;	/* Parameter pointer */
	SK_U64	Para64;		/* Parameter 64-bit version */
	SK_U32	Para32[2];	/* Parameter array of 32-bit parameters */
} SK_EVPARA;

/*
 * Events are class/value pairs
 *	class	is addressee, e.g. RLMT, HWAC etc.
 *	value	is command, e.g. reset, port switch etc.
 */
typedef	struct s_EventElem {
	SK_U32		Class;	/* Event class */
	SK_U32		Event;	/* Event value */
	SK_EVPARA	Para;	/* Event parameter */
} SK_EVENTELEM;

typedef	struct s_Queue {
	SK_EVENTELEM	EvQueue[SK_MAX_EVENT];
	SK_EVENTELEM	*EvPut;
	SK_EVENTELEM	*EvGet;
	SK_BOOL			CheckQueue;		/* Queue not empty */
	SK_U8			Filler1;
	SK_U16			Filler2;
} SK_QUEUE;


extern void SkEventInit(
	SK_AC		*pAC,
	SK_IOC		IoC,
	int			Level);
extern void SkEventQueue(
	SK_AC		*pAC,
	SK_U32		Class,
	SK_U32		Event,
	SK_EVPARA	Para);
extern int SkEventDispatcher(
	SK_AC		*pAC,
	SK_IOC		IoC);
#endif	/* _SKQUEUE_H_ */

