#include <asm/uaccess.h>
#include <asm/unistd.h>
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>
#include <asm/bitops.h>
#include <linux/trustee.h>

/*
   Daniel Podlejski <underley@debian.pl>, 2001.03.06
   trustee syscall number is now avaliable
   in /proc/trustee/syscall
   Vyacheslav Zavadsky - integration 
   Martin Devera, devik@cdi.cz - trustees syscall replacement
*/

/*
 * The /proc/trustee directory inodes...
 */

static struct proc_dir_entry *proc_trustee_syscall;

/*
 * This is the handler for /proc/trustee/syscall
 */

static int trustee_syscall_read_proc(char *page, char **start, off_t off,
					int count, int *eof, void *data)
{
     strcpy (page,"0"); /* indicate no syscall available */
     return 1;
  
}

/* write to /proc/trustee/syscall replaces set_trustee syscall */
static int trustee_write_proc(struct file *file, const char *buffer,
                          unsigned long count, void *data)
{
    int rv;
    if (count != sizeof(struct trustee_command)) return -EINVAL;
    rv = sys_set_trustee ((struct trustee_command *)buffer);
    if (rv < 0) return rv;
    return count;
}


/*
 * Called by proc_root_init() to initialize the /proc/trustee subtree
 */

void __init proc_trustee_init(void)
{
	struct proc_dir_entry *ent;
	
	ent = create_proc_entry("trustee", S_IFDIR, 0);
	if (!ent) return;

	ent = create_proc_entry("trustee/syscall", 0, 0);
	ent->read_proc = trustee_syscall_read_proc;
    ent->write_proc = trustee_write_proc;
}













