/******************************************************************************
 *
 * Name:	skgihw.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.9 $
 * Date:	$Date: 2001/10/23 09:50:30 $
 * Purpose:	HW defines for driver and all other modules
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skgihw.h,v $
 *	Revision 1.9  2001/10/23 09:50:30  rschmidt
 *	Changed define for START_TIMEOUT()
 *	
 *	Revision 1.8  2001/09/27 11:37:15  jschmalz
 *	Added some SK_U64 casts in conjunction with SkOsGetTime and
 *	change of some structure-names: ProdIdx to ConProdIdx, Rx to ProdRx and
 *	Tx to ConTx
 *	
 *	Revision 1.7  2001/09/26 13:56:11  rschmidt
 *	Added PCI sub-device Id for single chip board.
 *	Editorial changes.
 *	
 *	Revision 1.6  2001/09/21 11:13:48  mmoser
 *	make module runnable with W2K
 *	
 *	Revision 1.5  2001/09/13 15:10:55  jschmalz
 *	Changed to new C-Style for common-modules and added some definitions
 *	
 *	Revision 1.4  2001/08/16 07:55:02  mmoser
 *	send and receive ring structures added
 *	
 *	Revision 1.3  2001/08/14 14:54:51  rschmidt
 *	Renamed Rx and Tx descriptor structures.
 *	New defines for descriptor rings.
 *	Eliminated define for SK_JUMBO.
 *	
 *	Revision 1.2  2001/06/13 15:11:21  rschmidt
 *	Added auto-negotiation for Fiber.
 *	
 *	Revision 1.1  2001/06/05 08:28:24  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 ******************************************************************************/

#ifndef _SKGIHW_H_
#define _SKGIHW_H_

#include "skgiauto.h"


#define START_TIMEOUT()			SkOsGetTime(pAC)
#define TIMEOUT_REACHED(s,t,n)	SkCheckTimeout(pAC,s,t,n)


/* Hardware definitions */

#define BIT31		(1 << 31)
#define BIT30		(1 << 30)
#define BIT29		(1 << 29)
#define BIT28		(1 << 28)
#define BIT27		(1 << 27)
#define BIT26		(1 << 26)
#define BIT25		(1 << 25)
#define BIT24		(1 << 24)
#define BIT23		(1 << 23)
#define BIT22		(1 << 22)
#define BIT21		(1 << 21)
#define BIT20		(1 << 20)
#define BIT19		(1 << 19)
#define BIT18		(1 << 18)
#define BIT17		(1 << 17)
#define BIT16		(1 << 16)
#define BIT15		(1 << 15)
#define BIT14		(1 << 14)
#define BIT13		(1 << 13)
#define BIT12		(1 << 12)
#define BIT11		(1 << 11)
#define BIT10		(1 << 10)
#define BIT9		(1 << 9)
#define BIT8		(1 << 8)
#define BIT7		(1 << 7)
#define BIT6		(1 << 6)
#define BIT5		(1 << 5)
#define BIT4		(1 << 4)
#define BIT3		(1 << 3)
#define BIT2		(1 << 2)
#define BIT1		(1 << 1)
#define BIT0		(1 << 0)

#define SHIFT31(x)	((x) << 31)
#define SHIFT30(x)	((x) << 30)
#define SHIFT29(x)	((x) << 29)
#define SHIFT28(x)	((x) << 28)
#define SHIFT27(x)	((x) << 27)
#define SHIFT26(x)	((x) << 26)
#define SHIFT25(x)	((x) << 25)
#define SHIFT24(x)	((x) << 24)
#define SHIFT23(x)	((x) << 23)
#define SHIFT22(x)	((x) << 22)
#define SHIFT21(x)	((x) << 21)
#define SHIFT20(x)	((x) << 20)
#define SHIFT19(x)	((x) << 19)
#define SHIFT18(x)	((x) << 18)
#define SHIFT17(x)	((x) << 17)
#define SHIFT16(x)	((x) << 16)
#define SHIFT15(x)	((x) << 15)
#define SHIFT14(x)	((x) << 14)
#define SHIFT13(x)	((x) << 13)
#define SHIFT12(x)	((x) << 12)
#define SHIFT11(x)	((x) << 11)
#define SHIFT10(x)	((x) << 10)
#define SHIFT9(x)	((x) << 9)
#define SHIFT8(x)	((x) << 8)
#define SHIFT7(x)	((x) << 7)
#define SHIFT6(x)	((x) << 6)
#define SHIFT5(x)	((x) << 5)
#define SHIFT4(x)	((x) << 4)
#define SHIFT3(x)	((x) << 3)
#define SHIFT2(x)	((x) << 2)
#define SHIFT1(x)	((x) << 1)
#define SHIFT0(x)	((x) << 0)

#define SK_REVISION_1_0				0x10

#define PCI_VENDOR_ID_SYSKONNECT	0x1148
#define PCI_VENDOR_ID_ALTEON		0x12ae
#define PCI_VENDOR_ID_BROADCOM		0x14e4
#define PCI_VENDOR_ID_ALTIMA		0x173B

#define	PCI_DEVICE_ID_SYSKONNECT_SK9DXX		0x4400
#define	PCI_DEVICE_ID_SYSKONNECT_SK9MXX		0x4500
#define	PCI_DEVICE_ID_SYSKONNECT_SK9SXX		0x4600

#define	PCI_SUB_DEVICE_ID_SYSKONNECT_SK9D21	0x4421
#define	PCI_SUB_DEVICE_ID_SYSKONNECT_SK9D41	0x4441
#define	PCI_SUB_DEVICE_ID_SYSKONNECT_SK9D11	0x4411
#define	PCI_SUB_DEVICE_ID_SYSKONNECT_SK9D61	0x4461


/*****************/
/* PCI registers */
/*****************/

#ifndef PCI_VENDOR_ID
#define PCI_VENDOR_ID			0x0
#endif
#ifndef PCI_DEVICE_ID
#define PCI_DEVICE_ID			0x2
#endif
#ifndef PCI_COMMAND
#define PCI_COMMAND				0x4
#endif
								            /* Bit 15..10:	reserved */
	#define FAST_B2B_ENAB	       	BIT9    /* Bit 9:	Fast Back-To-Back enable */
	#define SYSERR_ENAB		   	    BIT8    /* Bit 8:	SERR enable */
    #define STEP_CTRL   		   	BIT7    /* Bit 7:	Address Stepping */
	#define PARITY_ERR_ENAB 	   	BIT6    /* Bit 6:	Parity Report Response enable */
    #define PALETTE_SNOOP	       	BIT5    /* Bit 5:	VGA palette snoop */
	#define MEM_WR_INV		   	    BIT4    /* Bit 4:	Memory write an inv cycl ena */
	#define SPEC_CYCLE  		   	BIT3    /* Bit 3:	Special Cycle enable */
	#define BUS_MASTER	    	   	BIT2    /* Bit 2:	Bus Master enable */
	#define MEM_SPACE		       	BIT1    /* Bit 1:	Memory Space Access enable */
	#define IO_SPACE		   	    BIT0    /* Bit 0:	IO Space Access enable */

#ifndef PCI_STATUS
#define PCI_STATUS				0x6
#endif
/*	PCI_STATUS	16 bit	Status */
    #define DETECT_PARITY_ERROR		BIT15	/* Bit 15:	Parity Error */
    #define	SIGNALED_SYSTEM_ERROR	BIT14	/* Bit 14:	Signaled SERR */
    #define	RESEIVED_MASTER_ABORT	BIT13	/* Bit 13:	Received Master Abort */
    #define	RESEIVED_TARGET_ABORT	BIT12	/* Bit 12:	Received Target Abort */
	#define SIGNALED_TARGET_ABORT	BIT11	/* Bit 11:	Signaled Target Abort */
    #define	DEVSEL_TIMING		   SHIFT9(3)/* Bit 10..9:	DEVSEL Timing */
    #define	DEV_TIMING_FAST		   SHIFT9(0)/* fast */
    #define	DEV_TIMING_MEDIUM	   SHIFT9(1)/* medium */
    #define	DEV_TIMING_SLOW		   SHIFT9(2)/* slow */
    #define	MASTER_DATA_PARITY_ERR	BIT8	/* Bit 8:	Master Data Parity Error */
    #define	FAST BACK-TO-BACK CAP	BIT7	/* Bit 7:	Fast Back-to-Back Capability */
    #define	RESERVED				BIT6	/* Bit 6:	User Defined Features */
    #define CAPABLE_66MHZ			BIT5	/* Bit 5:	66 MHz PCI bus clock capable */
    #define CAPABILITIES_LIST		BIT4	/* Bit 4:	New cap. list implemented */
											/* Bit 3..0:	reserved */

#define PCI_CLASS_REVISION		0x08	/* High 24 bits are class, low 8 revision */
	#define PCI_CLASS_NETWORK_ETHERNET	0x0200
#define	PCI_CLASS				0x9
	/*	PCI_CLASS_CODE	24 bit	Class Code */
	/*	Byte 2:		Base Class		(02) */
	/*	Byte 1:		SubClass		(00) */
	/*	Byte 0:		Programming Interface	(00) */
#define PCI_CACHE_LINE_SIZE		0x0c
	/*	PCI_CACHE_LSZ	8 bit	Cache Line Size */
	/*	Possible values: 0,2,4,8,16,32,64,128	*/
#define	PCI_LAT_TIM     		0x0d		/*  8 bit	Latency Timer */
#define	PCI_HEADER_TYP	        0x0e		/*  8 bit	Header Type */
#define	PCI_BIST        		0x0f		/*  8 bit	Built-in selftest */
	/*	PCI_BIST	8 bit	Built-in selftest */
	/*	Built-in Self test not supported (optional) */
#define	PCI_BASE_1ST        	0x10		/* 32 bit	1st Base address */
/*	PCI_BASE_1ST	32 bit	1st Base address */
#define	PCI_BASE_2ND        	0x14		/* 32 bit	2nd Base address */
/*	PCI_BASE_2ND	32 bit	2nd Base address */
	#define	PCI_MEMSIZE			0x4000L		/* use 16 kB Memory Base */
	#define	PCI_MEMBASE_MSK 	0xffffc000L	/* Bit 31..14:	Memory Base Address */
	#define	PCI_MEMSIZE_MSK 	0x00003ff0L	/* Bit 13.. 4:	Memory Size Req. */
	#define	PCI_PREFEN				BIT3	/* Bit	3:	Prefetchable */
	#define	PCI_MEM_TYP_MASK	SHIFT1(0x03)/* Bit	2.. 1:	Memory Type */
	#define	PCI_MEM32BIT		SHIFT1(0x00)/* Base addr anywhere in 32 Bit range */
	#define	PCI_MEM1M			SHIFT1(0x01)/* Base addr below 1 MegaByte */
	#define	PCI_MEM64BIT		SHIFT1(0x02)/* Base addr anywhere in 64 Bit range */
	#define	PCI_MEMSPACE			BIT0	/* Bit	0:	Memory Space Indic. */

	#define	PCI_IOBASE			0xffffff00L	/* Bit 31..8:	I/O Base address */
	#define	PCI_IOSIZE			0x000000fcL	/* Bit	7..2:	I/O Size Requirements */
											/* Bit	1:	reserved */
	#define	PCI_IOSPACE				BIT1	/* Bit	0:	I/O Space Indicator */

	/* Byte 18..2b:	reserved */
#define PCI_SUBSYSTEM_VENDOR_ID	0x2c
#define PCI_SUBSYSTEM_ID		0x2e
#define	PCI_BASE_ROM	        0x30		/* 32 bit	Expansion ROM Base Address */
	#define	PCI_ROMBASE		SHIFT17(0xfffeL)/* Bit 31..17:	ROM BASE address (1st)*/
	#define	PCI_ROMBASZ		SHIFT14(0x1cL)	/* Bit 16..14:	Treat as BASE or SIZE */
	#define	PCI_ROMSIZE		SHIFT11(0x38L)	/* Bit 13..11:	ROM Size Requirements */
											/* Bit 10.. 1:	reserved */
	#define	PCI_ROMEN		SHIFT0(0x1L)	/* Bit 0:	Address Decode enable */
	/* Byte 31..33:	reserved */
#define PCI_CAP_PTR     		0x34		/*  8 bit 	Capabilities Ptr */
	/* Byte 35..3b:	reserved */
#define	PCI_IRQ_LINE	        0x3c		/*  8 bit	Interrupt Line */
#define	PCI_IRQ_PIN		        0x3d		/*  8 bit	Interrupt Pin */
#define	PCI_MIN_GNT		        0x3e		/*  8 bit	Min_Gnt */
#define	PCI_MAX_LAT		        0x3f		/*  8 bit	Max_Lat */

#define	PCIX_CAP_REG	        0x40		/*  8 bit 	PCI-X Capability Register */
#define	PCIX_NCAPPTR_PM      	0x41		/*  8 bit 	Next Capability Pointer Power Management */
#define	PCIX_COMMAND        	0x42		/* 16 bit 	PCI-X Command Register */
	#define MAX_SPLIT_TRANS			(BIT6 | BIT5 | BIT4)
	#define MAX_READ_B_CNT			(BIT3 | BIT2)
	#define ENAB_RELAX_ORD			BIT1
	#define PARITY_RECOVER			BIT0
#define	PCI_XSTATUS     		0x44		/* 32 bit 	PCI-X Status Register */
	/* PCI-X Power Management Capabilities */	
#define PCI_PM_CAP_REG			0x48    	/*  8 bit 	Power Management Capability */
	#define PCI_PM_CAP_PME_D3COLD	BIT31
	#define PCI_PM_CAP_PME_D3HOT	BIT30
#define	PCI_NCAPPTR_VPD     	0x49		/*  8 bit 	Next Capability Pointer Vital Product Data */
#define	PCI_PMANAG_CAP      	0x4a		/*  8 bit 	Power Management Capability */
#define PCI_PM_STATUS_CTRL_REG	0x4c		/*  8 bit 	Power Management Control/Status */

	#define PM_POWER_STATE_MASK		(BIT0 | BIT1)
	#define PM_POWER_STATE_D0		0
	#define PM_POWER_STATE_D1		1
	#define PM_POWER_STATE_D2		2
	#define PM_POWER_STATE_D3		3
	
	#define PM_PME_ENABLE			BIT8
	#define PM_PME_ASSERTED			BIT15
#define	PCI_PMANAG_DATA	        0x4f		/*  8 bit 	Power Management Data */
	/* Vital Product Data Capabilities */	
#define	PCI_VPD_CAID	        0x50		/*  8 bit 	VPD Capability */
#define	PCI_NCAPPTR_MSI	        0x51		/*  8 bit 	Next Capability Pointer Vital Product Data */
#define	PCI_VPD_ADDRFL	        0x52		/* 16 bit 	VPD Address and Flag */
#define	PCI_VPD_DATA	        0x54		/* 32 bit 	VPD Data */
	/* Message signaled interrupt Capabilities */	
#define	PCI_MSI_CAID	        0x58		/*  8 bit 	MSI Capability */
#define	PCI_NCAPPTR_0	        0x59		/*  8 bit 	Next Capability Pointer (Points to NULL) */
#define	PCI_MSI_CONTROL         0x5a		/* 16 bit 	MSI Control Register */
#define	PCI_MSI_ADDR0	        0x5c		/* 32 bit 	MSI Address Register 64 Bit */
#define	PCI_MSI_ADDR1	        0x5f		/* 32 bit 	MSI Address Register 64 Bit */
#define	PCI_MSI_DATA	        0x64		/* 16 bit 	MSI Data Register */

	/* Private PCI configuration Registers */	
#define PCI_MISC_H_CTRL			0x68    	/* 32 bit Miscellaneous Host Control Register */
	#define ASIC_REVISION			(BIT31 | BIT30 | BIT29 | BIT28)
	#define ENAB_INDIR_ADDR			BIT7
	#define ENAB_W_SWAP				BIT6
	#define ENAB_CLK_CTRL			BIT5
	#define ENAB_PCI_STATE			BIT4
	#define ENAB_EW_SWAP			BIT3
	#define ENAB_EB_SWAP			BIT2
	#define MASK_PCI_INT			BIT1
	#define CLR_INT					BIT0

	#define CHIP_REV_ID_5700_A0		0x7000
	#define CHIP_REV_ID_5700_A1		0x7001
	#define CHIP_REV_ID_5700_B0		0x7100
	#define CHIP_REV_ID_5700_B1		0x7101
	#define CHIP_REV_ID_5700_B2		0x7102
	#define CHIP_REV_ID_5700_B4		0x7104		/* Altima AC1000 */
	#define CHIP_REV_ID_5700_C0		0x7200
	
	#define CHIP_REV_ID_5701_A0		0x0000
	#define CHIP_REV_ID_5701_B0		0x0100
	
	#define CHIP_REV_ID_5701_B2		0x0102		/* Altima AC1001 */
	
#define PCI_DMA_RW_CTRL			0x6c   		/* 32 bit DMA Read/Write Control Register */
	#define DMA_WR_COMMAND(x)		SHIFT28(x)
	#define DMA_RD_COMMAND(x)		SHIFT24(x)
	#define ASSERT_ALL_BE			BIT23
	#define USE_RD_MULT				BIT22
	#define DMA_WRITE_WM(x)			SHIFT19(x)
	#define DMA_READ_WM(x)			SHIFT16(x)
	#define ONE_DMA_ATONCE			BIT14
	#define DMA_WR_BND(x)			SHIFT11(x)
	#define DMA_RD_BND(x)			SHIFT8(x)
	#define MINIMUM_DMA(x)			SHIFT0(x)
#define PCI_STATE_REG			0x70    	/* 32 bit DMA Read/Write Control Register */
	#define PCI_BUS_32_BIT			BIT4
	#define BUS_SPEED_HIGH			BIT3
	#define CONVENTIONAL_PCI_MODE	BIT2
	#define INT_NOT_ACTIVE			BIT1
	#define FORCE_PCI_RESET			BIT0

#define PCI_REG_CLOCK_CTRL		0x74
	#define POWER_DOWN_PCI_PLL133	BIT15
	#define SELECT_ALTERNATE_CLOCK	BIT12
	#define DISABLE_TX_CLOCK		BIT11
	#define DISABLE_RX_CLOCK		BIT10


#define PCI_REG_BASE			0x78
#define PCI_MEM_WIN_BASE		0x7c
#define PCI_REG_DATA			0x80
#define PCI_MEM_WIN_DATA		0x84

/*****************/
/* I/O registers */
/*****************/

/*------ MAC Control Regs ------*/

#define ETH_MAC_MODE			0x400
	#define ENAB_FHDE				BIT23
	#define ENAB_RDE				BIT22
	#define ENAB_TDE				BIT21
	#define ENAB_MIP				BIT20
	#define ENAB_ACPI				BIT19
	#define ENAB_MAGIC_PACKET		BIT18
	#define SEND_CONFIGS			BIT17
	#define FLUSH_TX_STATS			BIT16
	#define CLEAR_TX_STATS			BIT15
	#define ENAB_TX_STATS			BIT14
	#define FLUSH_RX_STATS			BIT13
	#define CLEAR_RX_STATS			BIT12
	#define ENAB_RX_STATS			BIT11
	#define LINK_POLARITY			BIT10
	#define MAX_DEFER				BIT9
	#define ENAB_TX_BURST			BIT8
	#define TAGGED_MAC_CTRL			BIT7
	#define	MAC_LOOPBACK			BIT4
	#define PORT_MODE(x)			SHIFT2(x)
	#define HALF_DUPLEX				BIT1
	#define GLOBAL_RESET			BIT0

	#define PM_TBI		3			/* Ten Bit Interface */
	#define PM_GMII		2			/* Gigabit Media Independent Interface */
	#define PM_MII		1			/* Media Independent Interface */
	#define PM_NONE		0

	#define PORT_MODE_MASK			PORT_MODE(3)

#define ETH_MAC_STATUS			0x404
	#define TX_STATS_OVERRUN		BIT27
	#define RX_STATS_OVERRUN		BIT26
	#define ODI_ERROR				BIT25
	#define AP_ERROR				BIT24
	#define MI_INTERRUPT			BIT23
	#define MI_COMPLETION			BIT22
	#define LINK_STATE_CHANGED		BIT12
	#define PORT_DECODE_ERROR		BIT10
	#define SYNC_CHANGED			BIT4
	#define CFG_CHANGED				BIT3
	#define RECEIVING_CFG			BIT2
	#define SIGNAL_DETECTED			BIT1
	#define PCS_SYNCED				BIT0

#define ETH_MAC_EVENT_ENABLE	0x408
	#define TX_STATS_OVERRUN_ATN	BIT27
	#define RX_STATS_OVERRUN_ATN	BIT26
	#define ODI_ERROR_ATN			BIT25
	#define AP_ERROR_ATN			BIT24
	#define MI_INTERRUPT_ATN		BIT23
	#define MI_COMPLETION_ATN		BIT22
	#define LINK_STATE_CHANGED_ATN	BIT12
	#define PORT_DECODE_ERROR_ATN	BIT10

#define LED_CONTROL				0x40c
#define MAC_ADDR1_HIGH			0x410
#define MAC_ADDR1_LOW			0x414
#define MAC_ADDR2_HIGH			0x418
#define MAC_ADDR2_LOW			0x41c
#define MAC_ADDR3_HIGH			0x420
#define MAC_ADDR3_LOW			0x424
#define MAC_ADDR4_HIGH			0x428
#define MAC_ADDR4_LOW			0x42c
#define WOL_PATTERN_PTR			0x430
#define WOL_PATTERN_CONFIG		0x434
#define TX_RANDOM_BACKOFF		0x438
#define RX_MTU_SIZE				0x43c
#define GIGA_PCS_TEST			0x440
#define TX_AUTONEG				0x444
#define RX_AUTONEG				0x448
#define MI_COMMUNICATION		0x44c
	#define MI_START				BIT29
	#define MI_RD_FAIL				BIT28
	#define MI_COMMAND(x)			SHIFT26(x)
	#define MI_CMD_READ				SHIFT26(2)
	#define MI_CMD_WRITE			SHIFT26(1)
	#define MI_PHY_ADDR(x)			SHIFT21(x)
	#define MI_REG_ADDR(x)			SHIFT16(x)
	#define MI_DATA(x)				SHIFT0(x)
	#define	MDI_PHY_ADDR			1		/* Addr on MDIO interface */

#define MI_STATUS				0x450
	#define MODE_10MBPS				BIT1
	#define LINK_STATUS				BIT0

#define MI_MODE					0x454
	#define MI_MODE_RESERVED		SHIFT16(0x000c)
	#define CORE_CLK_SPEED			BIT15
	#define PORT_POLLING			BIT4
	#define USE_SHORT_PREAMBLE		BIT1
	#define CLK_SPEED				BIT0

#define AUTO_POLL_STATUS		0x458
#define TRANSMIT_MODE			0x45c
	#define ENAB_LONG_PAUSE			BIT6
	#define ENAB_BIG_BACKOFF		BIT5
	#define TX_ENAB_FLOW_CTRL		BIT4
	#define TX_MAC_ENAB				BIT1
	#define TX_MAC_RESET			BIT0

#define TRANSMIT_STATUS			0x460
	#define LINK_UP					BIT3

#define TRANSMIT_LENGTHS		0x464
	#define IPG_CRS_LEN(x)			SHIFT12(x)
	#define IPG_LEN(x)				SHIFT8(x)
	#define SLOT_TIME_LEN(x)		SHIFT0(x)

#define RECEIVE_MODE			0x468
	#define KEEP_VLAN_TAG_DIAG		BIT10
	#define NO_CRC_CHECK			BIT9
	#define PROMISC_MODE			BIT8
	#define LENGTH_CHECK			BIT7
	#define ACCEPT_RUNTS			BIT6
	#define ACCEPT_OVERSIZED		BIT5
	#define KEEP_PAUSE				BIT4
	#define KEEP_MAC_CTRL			BIT3
	#define RX_ENAB_FLOW_CTRL		BIT2
	#define RX_MAC_ENAB				BIT1
	#define RX_MAC_RESET			BIT0

#define RECEIVE_STATUS			0x46c
#define MAC_HASH0				0x470
#define MAC_HASH1				0x474
#define MAC_HASH2				0x478
#define MAC_HASH3				0x47c
#define RX_RULES_CTRL0			0x480
#define RX_RULES_MASK_VAL0		0x484
#define RX_RULES_CTRL1			0x488
#define RX_RULES_MASK_VAL1		0x48c
#define RX_RULES_CTRL2			0x490
#define RX_RULES_MASK_VAL2		0x494
#define RX_RULES_CTRL3			0x498
#define RX_RULES_MASK_VAL3		0x49c
#define RX_RULES_CTRL4			0x4a0
#define RX_RULES_MASK_VAL4		0x4a4
#define RX_RULES_CTRL5			0x4a8
#define RX_RULES_MASK_VAL5		0x4ac
#define RX_RULES_CTRL6			0x4b0
#define RX_RULES_MASK_VAL6		0x4b4
#define RX_RULES_CTRL7			0x4b8
#define RX_RULES_MASK_VAL7		0x4bc
#define RX_RULES_CTRL8			0x4c0
#define RX_RULES_MASK_VAL8		0x4c4
#define RX_RULES_CTRL9			0x4c8
#define RX_RULES_MASK_VAL9		0x4cc
#define RX_RULES_CTRL10			0x4d0
#define RX_RULES_MASK_VAL10		0x4d4
#define RX_RULES_CTRL11			0x4d8
#define RX_RULES_MASK_VAL11		0x4dc
#define RX_RULES_CTRL12			0x4e0
#define RX_RULES_MASK_VAL12		0x4e4
#define RX_RULES_CTRL13			0x4e8
#define RX_RULES_MASK_VAL13		0x4ec
#define RX_RULES_CTRL14			0x4f0
#define RX_RULES_MASK_VAL14		0x4f4
#define RX_RULES_CTRL15			0x4f8
#define RX_RULES_MASK_VAL15		0x4fc
#define RX_RULES_CONFIG			0x500
	#define RX_DEFAULT_CLASS(x)		SHIFT3(x)
#define RX_STATS_MEM			0x800
#define TX_STATS_MEM			0x880

/*------ Send Data Initiator Control Regs ------*/

#define TX_DAT_INIT_MODE		0x0c00
	#define ENAB_STATS_OVF_ATTN		BIT2
	#define TX_DAT_INIT_ENAB		BIT1
	#define TX_DAT_INIT_RESET		BIT0

#define TX_DAT_INIT_STATUS		0x0c00
	#define TX_DAT_OVL_ATTN			BIT2

#define TX_DAT_INIT_STATS_CTRL	0x0c08
#define TX_DAT_INIT_STATS_MASK	0x0c0c
#define TX_DAT_INIT_STATS_INC	0x0c10
#define TX_DAT_INIT_COS1		0x0c80
#define TX_DAT_INIT_COS2		0x0c84
#define TX_DAT_INIT_COS3		0x0c88
#define TX_DAT_INIT_COS4		0x0c8c
#define TX_DAT_INIT_COS5		0x0c90
#define TX_DAT_INIT_COS6		0x0c94
#define TX_DAT_INIT_COS7		0x0c98
#define TX_DAT_INIT_COS8		0x0c9c
#define TX_DAT_INIT_COS9		0x0ca0
#define TX_DAT_INIT_COS10		0x0ca4
#define TX_DAT_INIT_COS11		0x0ca8
#define TX_DAT_INIT_COS12		0x0cac
#define TX_DAT_INIT_COS13		0x0cb0
#define TX_DAT_INIT_COS14		0x0cb4
#define TX_DAT_INIT_COS15		0x0cb8
#define TX_DAT_INIT_COS16		0x0cbc
#define STATS_DMA_Q_FULL		0x0cc0
#define STATS_DMA_HIGH_Q_FULL	0x0cc4
#define STATS_SDC_Q_FULL		0x0cc8
#define STATS_SET_TX_PRO_IDX	0x0ccc
#define STATS_UPDATED			0x0cd0
#define STATS_INTERRUPTS		0x0cd4
#define STATS_AVOIDED_INTs		0x0cd8
#define STATS_THRESH_HIT		0x0cdc

/*------ Send Data Completion Control Regs ------*/

#define TX_DAT_COMPL_MODE		0x1000
	#define TX_DAT_COMPL_ENAB		BIT1
	#define TX_DAT_COMPL_RESET		BIT0

/*------ Send BD Selector Control Regs ------*/

#define TX_BD_SEL_MODE			0x1400
	#define ENAB_TX_BD_SEL_ATTN		BIT2
	#define TX_BD_SEL_ENAB			BIT1
	#define TX_BD_SEL_RESET			BIT0

#define TX_BD_SEL_STATUS		0x1404
	#define TX_BD_SEL_ERR			BIT2

#define TX_BD_SEL_HW_DIAG		0x1408
#define TX_BD_SEL_CONS_IDX1		0x1440
#define TX_BD_SEL_CONS_IDX2		0x1444
#define TX_BD_SEL_CONS_IDX3		0x1448
#define TX_BD_SEL_CONS_IDX4		0x144c
#define TX_BD_SEL_CONS_IDX5		0x1450
#define TX_BD_SEL_CONS_IDX6		0x1454
#define TX_BD_SEL_CONS_IDX7		0x1458
#define TX_BD_SEL_CONS_IDX8		0x145c
#define TX_BD_SEL_CONS_IDX9		0x1460
#define TX_BD_SEL_CONS_IDX10	0x1464
#define TX_BD_SEL_CONS_IDX11	0x1468
#define TX_BD_SEL_CONS_IDX12	0x146c
#define TX_BD_SEL_CONS_IDX13	0x1470
#define TX_BD_SEL_CONS_IDX14	0x1474
#define TX_BD_SEL_CONS_IDX15	0x1478
#define TX_BD_SEL_CONS_IDX16	0x147c

/*------ Send BD Initiator Control Regs ------*/

#define TX_BD_INIT_MODE			0x1800
	#define ENAB_TX_BD_INIT_ATTN	BIT2
	#define TX_BD_INIT_ENAB			BIT1
	#define TX_BD_INIT_RESET		BIT0

#define TX_BD_INIT_STATUS		0x1804
	#define TX_BD_INIT_ERR			BIT2

#define BD_INIT_TX_PROD_IDX1	0x1808
#define BD_INIT_TX_PROD_IDX2	0x180c
#define BD_INIT_TX_PROD_IDX3	0x1810
#define BD_INIT_TX_PROD_IDX4	0x1814
#define BD_INIT_TX_PROD_IDX5	0x1818
#define BD_INIT_TX_PROD_IDX6	0x181c
#define BD_INIT_TX_PROD_IDX7	0x1820
#define BD_INIT_TX_PROD_IDX8	0x1824
#define BD_INIT_TX_PROD_IDX9	0x1828
#define BD_INIT_TX_PROD_IDX10	0x182c
#define BD_INIT_TX_PROD_IDX11	0x1830
#define BD_INIT_TX_PROD_IDX12	0x1834
#define BD_INIT_TX_PROD_IDX13	0x1838
#define BD_INIT_TX_PROD_IDX14	0x183c
#define BD_INIT_TX_PROD_IDX15	0x1840
#define BD_INIT_TX_PROD_IDX16	0x1844

/*------ Send BD Completion Control Regs ------*/

#define TX_BD_COMPL_MODE		0x1c00
	#define TX_BD_COMPL_ATTN_ENAB	BIT2
	#define TX_BD_COMPL_ENAB		BIT1
	#define TX_BD_COMPL_RESET		BIT0

/*------ Ring Control Regs ------*/

#define JUM_RX_HOST_HIGH		0x2440
#define JUM_RX_HOST_LOW			0x2444
#define JUM_RX_LEN_FLAGS		0x2448
#define JUM_RX_NIC_ADDR			0x244c
#define STD_RX_HOST_HIGH		0x2450
#define STD_RX_HOST_LOW			0x2454
#define STD_RX_LEN_FLAGS		0x2458
#define STD_RX_NIC_ADDR			0x245c
#define MIN_RX_HOST_HIGH		0x2460
#define MIN_RX_HOST_LOW			0x2464
#define MIN_RX_LEN_FLAGS		0x2468
#define MIN_RX_NIC_ADDR			0x246c
#define MIN_RX_REPLEN_TRHESH	0x2c14
#define STD_RX_REPLEN_TRHESH	0x2c18
#define JUM_RX_REPLEN_TRHESH	0x2c1c

/*------ Receive List Placement Control Regs ------*/

#define RX_LIST_PLACE_MODE		0x2000
	#define RX_LIST_PL_SOV_ATTN		BIT4
	#define RX_LIST_PL_MOR_ATTN		BIT3
	#define RX_LIST_PL_ATTN_ENAB	BIT2
	#define RX_LIST_PL_ENAB			BIT1
	#define RX_LIST_PL_RESET		BIT0
#define RX_LIST_PLACE_STATUS	0x2004
#define RX_SEL_LIST_LOCK		0x2008
#define RX_SEL_NE_BITS			0x200c
#define RX_LIST_PLACE_CONFIG	0x2010
	#define DEFAULT_INT_QUEUE(x)	SHIFT13(x)
	#define BAD_FRAMES_CLASS(x)		SHIFT8(x)
	#define NUMBER_OF_LISTS(x)		SHIFT3(x)
	#define NUMBER_LISTS_GROUP(x)	SHIFT0(x)

#define RX_LIST_PLACE_STATS_C	0x2014
#define RX_LIST_PLACE_STATS_EM	0x2018
#define RX_LIST_PLACE_STATS_IN	0x201c
#define RX_SEL_LIST1_HEAD		0x2100
#define RX_SEL_LIST1_TAIL		0x2104
#define RX_SEL_LIST1_CNT		0x2108
#define RX_SEL_LIST2_HEAD		0x2110
#define RX_SEL_LIST2_TAIL		0x2114
#define RX_SEL_LIST2_CNT		0x2118
#define RX_SEL_LIST3_HEAD		0x2120
#define RX_SEL_LIST3_TAIL		0x2124
#define RX_SEL_LIST3_CNT		0x2128
#define RX_SEL_LIST4_HEAD		0x2130
#define RX_SEL_LIST4_TAIL		0x2134
#define RX_SEL_LIST4_CNT		0x2138
#define RX_SEL_LIST5_HEAD		0x2140
#define RX_SEL_LIST5_TAIL		0x2144
#define RX_SEL_LIST5_CNT		0x2148
#define RX_SEL_LIST6_HEAD		0x2150
#define RX_SEL_LIST6_TAIL		0x2154
#define RX_SEL_LIST6_CNT		0x2158
#define RX_SEL_LIST7_HEAD		0x2160
#define RX_SEL_LIST7_TAIL		0x2164
#define RX_SEL_LIST7_CNT		0x2168
#define RX_SEL_LIST8_HEAD		0x2170
#define RX_SEL_LIST8_TAIL		0x2174
#define RX_SEL_LIST8_CNT		0x2178
#define RX_SEL_LIST9_HEAD		0x2180
#define RX_SEL_LIST9_TAIL		0x2184
#define RX_SEL_LIST9_CNT		0x2188
#define RX_SEL_LIST10_HEAD		0x2190
#define RX_SEL_LIST10_TAIL		0x2194
#define RX_SEL_LIST10_CNT		0x2198
#define RX_SEL_LIST11_HEAD		0x21a0
#define RX_SEL_LIST11_TAIL		0x21a4
#define RX_SEL_LIST11_CNT		0x21a8
#define RX_SEL_LIST12_HEAD		0x21b0
#define RX_SEL_LIST12_TAIL		0x21b4
#define RX_SEL_LIST12_CNT		0x21b8
#define RX_SEL_LIST13_HEAD		0x21c0
#define RX_SEL_LIST13_TAIL		0x21c4
#define RX_SEL_LIST13_CNT		0x21c8
#define RX_SEL_LIST14_HEAD		0x21d0
#define RX_SEL_LIST14_TAIL		0x21d4
#define RX_SEL_LIST14_CNT		0x21d8
#define RX_SEL_LIST15_HEAD		0x21e0
#define RX_SEL_LIST15_TAIL		0x21e4
#define RX_SEL_LIST15_CNT		0x21e8
#define RX_SEL_LIST16_HEAD		0x21f0
#define RX_SEL_LIST16_TAIL		0x21f4
#define RX_SEL_LIST16_CNT		0x21f8
#define LOCAL_STATS_CLASS1		0x2200
#define LOCAL_STATS_CLASS2		0x2204
#define LOCAL_STATS_CLASS3		0x2208
#define LOCAL_STATS_CLASS4		0x220c
#define LOCAL_STATS_CLASS5		0x2210
#define LOCAL_STATS_CLASS6		0x2214
#define LOCAL_STATS_CLASS7		0x2218
#define LOCAL_STATS_CLASS8		0x221c
#define LOCAL_STATS_CLASS9		0x2220
#define LOCAL_STATS_CLASS10		0x2224
#define LOCAL_STATS_CLASS11		0x2228
#define LOCAL_STATS_CLASS12		0x222c
#define LOCAL_STATS_CLASS13		0x2230
#define LOCAL_STATS_CLASS14		0x2234
#define LOCAL_STATS_CLASS15		0x2238
#define LOCAL_STATS_CLASS16		0x223c
#define LOCAL_STATS_DROP		0x2240
#define LOCAL_STATS_DMA_FULL	0x2244
#define LOCAL_STATS_DMA_HIGH	0x2248
#define LOCAL_STATS_NO_MORE		0x224c
#define LOCAL_STATS_IFLN_D		0x2250
#define LOCAL_STATS_IFLN_E		0x2254
#define LOCAL_STATS_RX_THRESH	0x2258

/*------ Receive Data and Receive BD Initiator Control Regs ------*/

#define RX_DAT_RX_BD_MODE		0x2400
	#define ENAB_ILL_SIZE_ATTN		BIT4
	#define ENAB_FRAME_TOO_LARGE	BIT3
	#define ENAB_JUMBO_NEEDED_ATTN	BIT2
	#define RX_DAT_RX_BD_ENAB		BIT1
	#define RX_DAT_RX_BD_RESET		BIT0

#define RX_DAT_RX_BD_STATUS		0x2404
	#define ILLEGAL_RET_RING_SIZE	BIT4
	#define FRAME_TOO_LARGE			BIT3
	#define JUMBO_NEEDED_DISAB		BIT2

#define RX_DAT_RX_BD_JUM_RCB	0x2440
#define RX_DAT_RX_BD_STD_RCB	0x2450
#define RX_DAT_RX_BD_MIN_RCB	0x2460
#define RX_DAT_RX_BD_JUM_IDX	0x2470
#define RX_DAT_RX_BD_STD_IDX	0x2474
#define RX_DAT_RX_BD_MIN_IDX	0x2478
#define RX_DAT_RX_BD_RET_IDX1	0x2480
#define RX_DAT_RX_BD_RET_IDX2	0x2484
#define RX_DAT_RX_BD_RET_IDX3	0x2488
#define RX_DAT_RX_BD_RET_IDX4	0x248c
#define RX_DAT_RX_BD_RET_IDX5	0x2490
#define RX_DAT_RX_BD_RET_IDX6	0x2494
#define RX_DAT_RX_BD_RET_IDX7	0x2498
#define RX_DAT_RX_BD_RET_IDX8	0x249c
#define RX_DAT_RX_BD_RET_IDX9	0x24a0
#define RX_DAT_RX_BD_RET_IDX10	0x24a4
#define RX_DAT_RX_BD_RET_IDX11	0x24a8
#define RX_DAT_RX_BD_RET_IDX12	0x24ac
#define RX_DAT_RX_BD_RET_IDX13	0x24b0
#define RX_DAT_RX_BD_RET_IDX14	0x24b4
#define RX_DAT_RX_BD_RET_IDX15	0x24b8
#define RX_DAT_RX_BD_RET_IDX16	0x24bc
#define RX_DAT_RX_BD_HW_DIAG	0x24c0

/*------ Receive Data Completion Control Regs ------*/

#define RX_DAT_COMPL_MODE		0x2800
	#define RX_DAT_ATTN_ENAB		BIT2
	#define RX_DAT_COMPL_ENAB		BIT1
	#define RX_DAT_COMPL_RESET		BIT0

/*------ Receive BD Initiator Control Regs ------*/

#define RX_BD_INIT_MODE			0x2c00
	#define RX_BD_AVAIL				BIT2
	#define RX_BD_INIT_ENAB			BIT1
	#define RX_BD_INIT_RESET		BIT0

#define RX_BD_INIT_STATUS		0x2c04
#define RX_BD_IN_JUM_PROD_IDX	0x2c08
#define RX_BD_IN_STD_PROD_IDX	0x2c0c
#define RX_BD_IN_MIN_PROD_IDX	0x2c10
#define MIN_RX_BD_REPLEN_TRESH	0x2c14
#define STD_RX_BD_REPLEN_THRESH	0x2c18
#define JUM_RX_BD_REPLEN_THRESH	0x2c1c

/*------ Receive BD Completion Control Regs ------*/

#define RX_BD_COMPL_MODE		0x3000
	#define RX_BD_COMPL_ATTN_ENAB	BIT2
	#define RX_BD_COMPL_ENAB		BIT1
	#define RX_BD_COMPL_RESET		BIT0
#define RX_BD_COMPL_STATUS		0x3004
#define NIC_JUM_RX_PROD_IDX		0x3008
#define NIC_STD_RX_PROD_IDX		0x300c
#define NIC_MIN_RX_PROD_IDX		0x3010

/*------ Receive List Selector Control Regs ------*/

#define RX_LIST_SEL_MODE		0x3400
	#define RX_LIST_SEL_ATTN_ENAB	BIT2
	#define RX_LIST_SEL_ENAB		BIT1
	#define RX_LIST_SEL_RESET		BIT0
#define RX_LIST_SEL_STATUS		0x3404

/*------ Mbuf Cluster Free Regs ------*/

#define MBUF_CLUST_FREE_MODE	0x3800
	#define MBUF_CLUST_FREE_ATTN	BIT2
	#define MBUF_CLUST_FREE_ENAB	BIT1
	#define MBUF_CLUST_FREE_RESET	BIT0

#define MBUF_CLUST_FREE_STATUS	0x3804

/*------ Host Coalescing Control Regs ------*/

#define HOST_COAL_MODE			0x3c00
    #define COAL_NO_INT_ON_COAL_NOW_MODE   	BIT11
    #define COAL_CLR_TICKS_ON_TX_BD_EVENT  	BIT10
    #define COAL_CLR_TICKS_ON_RX_BD_EVENT  	BIT9
	#define COALESC_NOW				BIT3
	#define COAL_ATTENTION_ENAB		BIT2
	#define COAL_ENG_ENABLE			BIT1
	#define COAL_ENG_RESET			BIT0
#define HOST_COAL_STATUS		0x3c04
#define RX_COAL_TICKS			0x3c08
#define TX_COAL_TICKS			0x3c0c
#define RX_MAX_COAL_BD_CNT		0x3c10
#define TX_MAX_COAL_BD_CNT		0x3c14
#define RX_COAL_TICKS_INT		0x3c18
#define TX_COAL_TICKS_INT		0x3c1c
#define RX_MAX_COAL_BD_INT		0x3c20
#define TX_MAX_COAL_BD_INT		0x3c24
#define STATISTICS_TICKS		0x3c28
#define STATISTICS_HOST_HIGH	0x3c30
#define STATISTICS_HOST_LOW		0x3c34
#define STATUS_BLOCK_HOST_HIGH	0x3c38
#define STATUS_BLOCK_HOST_LOW	0x3c3c
#define STATISTICS_BASE_ADDR	0x3c40
#define STATUS_BLOCK_BASE_ADDR	0x3c44
#define FLOW_ATTN				0x3c48
#define NIC_JUM_RX_CONS_IDX		0x3c50
#define NIC_STD_RX_CONS_IDX		0x3c54
#define NIC_MIN_RX_CONS_IDX		0x3c58
#define NIC_RR_PROD_IDX1		0x3c80
#define NIC_RR_PROD_IDX2		0x3c84
#define NIC_RR_PROD_IDX3		0x3c88
#define NIC_RR_PROD_IDX4		0x3c8c
#define NIC_RR_PROD_IDX5		0x3c90
#define NIC_RR_PROD_IDX6		0x3c94
#define NIC_RR_PROD_IDX7		0x3c98
#define NIC_RR_PROD_IDX8		0x3c9c
#define NIC_RR_PROD_IDX9		0x3ca0
#define NIC_RR_PROD_IDX10		0x3ca4
#define NIC_RR_PROD_IDX11		0x3ca8
#define NIC_RR_PROD_IDX12		0x3cac
#define NIC_RR_PROD_IDX13		0x3cb0
#define NIC_RR_PROD_IDX14		0x3cb4
#define NIC_RR_PROD_IDX15		0x3cb8
#define NIC_RR_PROD_IDX16		0x3cbc
#define NIC_SEND_CONS_IDX1		0x3cc0
#define NIC_SEND_CONS_IDX2		0x3cc4
#define NIC_SEND_CONS_IDX3		0x3cc8
#define NIC_SEND_CONS_IDX4		0x3ccc
#define NIC_SEND_CONS_IDX5		0x3cd0
#define NIC_SEND_CONS_IDX6		0x3cd4
#define NIC_SEND_CONS_IDX7		0x3cd8
#define NIC_SEND_CONS_IDX8		0x3cdc
#define NIC_SEND_CONS_IDX9		0x3ce0
#define NIC_SEND_CONS_IDX10		0x3ce4
#define NIC_SEND_CONS_IDX11		0x3ce8
#define NIC_SEND_CONS_IDX12		0x3cec
#define NIC_SEND_CONS_IDX13		0x3cf0
#define NIC_SEND_CONS_IDX14		0x3cf4
#define NIC_SEND_CONS_IDX15		0x3cf8
#define NIC_SEND_CONS_IDX16		0x3cfc

/*------ Memory Arbiter Regs ------*/

#define MEM_ARB_MODE			0x4000
	#define MEM_ARB_ENAB			BIT1
	#define MEM_ARB_RESET			BIT0

/*------ Buffer Manager Control Regs ------*/

#define BM_MODE					0x4400
	#define MBUF_LOW_ATTN_ENAB		BIT4
	#define BM_TEST_MODE			BIT3
	#define BM_ERR_ATTN_ENAB		BIT2
	#define BM_ENAB					BIT1
	#define BM_RESET				BIT0

#define BM_STATUS				0x4404
	#define BM_LOW_ATTN				BIT4
	#define BM_ERROR				BIT2

#define MBUF_POOL_BASE			0x4408
#define MBUF_POOL_LENGTH		0x440c
#define MBUF_POOL_RD_LOW_WM		0x4410
#define MBUF_POOL_RX_LOW_WM		0x4414
#define MBUF_POOL_HIGH_WM		0x4418
#define RX_CPU_ALLOC_REQ		0x441c
#define RX_CPU_ALLOC_RESP		0x4420
#define TX_CPU_ALLOC_REQ		0x4424
#define TX_CPU_ALLOC_RESP		0x4428
#define DMA_DESCR_POOL_BASE		0x442c
#define DMA_DESCR_POOL_LEN		0x4430
#define DMA_DESCR_P_LOW_WM		0x4434
#define DMA_DESCR_P_HIGH_WM		0x4438
#define RX_CPU_D_ALLOC_REQ		0x443c
#define RX_CPU_D_ALLOC_RESP		0x4440
#define TX_CPU_D_ALLOC_REQ		0x4444
#define TX_CPU_D_ALLOC_RESP		0x4448
#define HW_DIAG_REG1			0x444c
#define HW_DIAG_REG2			0x4450
#define HW_DIAG_REG3			0x4454

/*------ Write DMA Control Regs ------*/

#define READ_DMA_MODE			0x4800
	#define WRITE_LONGER_DMA		BIT9
	#define PCI_FIFO_OVERREAD		BIT8
	#define PCI_FIFO_UNDERRUN		BIT7
	#define PCI_FIFO_OVERRUN		BIT6
	#define PCI_HOST_ADDR_OV		BIT5
	#define PCI_PARITY				BIT4
	#define PCI_MASTER_ABORT		BIT3
	#define PCI_ABORT_TARGET		BIT2
	#define READ_DMA_ENAB			BIT1
	#define READ_DMA_RESET			BIT0

#define READ_DMA_STATUS			0x4804

/*------ Write DMA Control Regs ------*/

#define WRITE_DMA_MODE			0x4c00
	#define READ_LONGER_DMA			BIT9
	/* here: same bits as for Read DMA Control */
	#define WRITE_DMA_ENAB			BIT1
	#define WRITE_DMA_RESET			BIT0
#define WRITE_DMA_STATUS		0x4c04

/*------ Mailbox Regs (shadow region of 0x5800 .. 0x59FF------*/

#define INTERRUPT_MAILBOX0		0x200
#define INTERRUPT_MAILBOX1		0x208
#define INTERRUPT_MAILBOX2		0x210
#define INTERRUPT_MAILBOX3		0x218
#define GENERAL_MAILBOX1		0x220
#define GENERAL_MAILBOX2		0x228
#define GENERAL_MAILBOX3		0x230
#define GENERAL_MAILBOX4		0x238
#define GENERAL_MAILBOX5		0x240
#define GENERAL_MAILBOX6		0x248
#define GENERAL_MAILBOX7		0x250
#define GENERAL_MAILBOX8		0x258
#define RELOAD_STAT_MAILBOX		0x260
#define STD_RX_RING_PROD_IDX	0x268
#define JUM_RX_RING_PROD_IDX	0x270
#define MIN_RX_RING_PROD_IDX	0x278
#define RX_RET_CONSUM_IDX1		0x280
#define RX_RET_CONSUM_IDX2		0x288
#define RX_RET_CONSUM_IDX3		0x290
#define RX_RET_CONSUM_IDX4		0x298
#define RX_RET_CONSUM_IDX5		0x2a0
#define RX_RET_CONSUM_IDX6		0x2a8
#define RX_RET_CONSUM_IDX7		0x2b0
#define RX_RET_CONSUM_IDX8		0x2b8
#define RX_RET_CONSUM_IDX9		0x2c0
#define RX_RET_CONSUM_IDX10		0x2c8
#define RX_RET_CONSUM_IDX11		0x2d0
#define RX_RET_CONSUM_IDX12		0x2d8
#define RX_RET_CONSUM_IDX13		0x2e0
#define RX_RET_CONSUM_IDX14		0x2e8
#define RX_RET_CONSUM_IDX15		0x2f0
#define RX_RET_CONSUM_IDX16		0x2f8
#define TX_HOST_PROD_IDX1		0x300
#define TX_HOST_PROD_IDX2		0x308
#define TX_HOST_PROD_IDX3		0x310
#define TX_HOST_PROD_IDX4		0x318
#define TX_HOST_PROD_IDX5		0x320
#define TX_HOST_PROD_IDX6		0x328
#define TX_HOST_PROD_IDX7		0x330
#define TX_HOST_PROD_IDX8		0x338
#define TX_HOST_PROD_IDX9		0x340
#define TX_HOST_PROD_IDX10		0x348
#define TX_HOST_PROD_IDX11		0x350
#define TX_HOST_PROD_IDX12		0x358
#define TX_HOST_PROD_IDX13		0x360
#define TX_HOST_PROD_IDX14		0x368
#define TX_HOST_PROD_IDX15		0x370
#define TX_HOST_PROD_IDX16		0x378
#define TX_NIC_PROD_IDX1		0x380
#define TX_NIC_PROD_IDX2		0x388
#define TX_NIC_PROD_IDX3		0x390
#define TX_NIC_PROD_IDX4		0x398
#define TX_NIC_PROD_IDX5		0x3a0
#define TX_NIC_PROD_IDX6		0x3a8
#define TX_NIC_PROD_IDX7		0x3b0
#define TX_NIC_PROD_IDX8		0x3b8
#define TX_NIC_PROD_IDX9		0x3c0
#define TX_NIC_PROD_IDX10		0x3c8
#define TX_NIC_PROD_IDX11		0x3d0
#define TX_NIC_PROD_IDX12		0x3d8
#define TX_NIC_PROD_IDX13		0x3e0
#define TX_NIC_PROD_IDX14		0x3e8
#define TX_NIC_PROD_IDX15		0x3f0
#define TX_NIC_PROD_IDX16		0x3f8

#define HIGH_PRIO_MB_VECTOR		0x5a00
#define HIGH_PRIO_MB_MASK		0x5a04
#define LOW_PRIO_MB_VECTOR		0x5a08
#define LOW_PRIO_MB_MASK		0x5a0c

/*------ FTQ (internal hw queues) Regs ------*/

#define FTQ_RESET				0x5c00

/*------ DMA Completion Regs ------*/

#define DMA_COMPL_MODE			0x6400
	#define DMA_COMPL_ENAB			BIT1
	#define DMA_COMPL_RESET			BIT0

/*------ General Control Regs ------*/

#define MODE_CTRL				0x6800
	#define ENAB_RX_MC				BIT30
	#define TX_RINGS_COMB			BIT29
	#define INT_FLOW_ATTENT			BIT28
	#define INT_DMA_ATTENT			BIT27
	#define INT_MAC_ATTENT			BIT26
	#define INT_RX_C_ATTENT			BIT25
	#define INT_TX_C_ATTENT			BIT24
	#define RX_NO_PH_CHKSUM			BIT23
	#define TX_NO_PH_CHKSUM			BIT20
	#define HOST_SEND_BD			BIT17
	#define HOST_STACK_UP			BIT16
	#define FORCE_32B_PCI			BIT15
	#define NO_INT_RX				BIT14
	#define NO_INT_TX				BIT13
	#define RX_ALLOW_BAD			BIT11
	#define RX_NO_CRC				BIT10
	#define NO_FRAME_CRACK			BIT9
	#define W_SWAP_DATA				BIT5
	#define B_SWAP_DATA				BIT4
	#define W_SWAP_NONFRAME			BIT2
	#define B_SWAP_NONFRAME			BIT1
	#define UPDATE_ON_COAL			BIT0

#define MISC_CONF				0x6804
	#define TIMER_PRESCALE(x)		SHIFT1(x)
	#define CORE_CLK_RESET			BIT0

#define MISC_LOCAL				0x6808
	#define AUTO_SEEPROM_ACC		BIT24
	#define SSRAM_CYCLE_DESEL		BIT23
	#define SSRAM_TYPE				BIT22
	#define BANK_SELECT				BIT21
	#define SRAM_SIZE(x)			SHIFT18(x)
	#define ENAB_EXT_MEM			BIT17
	#define MISC_PINS_OUT(x)		SHIFT14(x)
	#define MISC_PINS_OUT_ENAB(x)	SHIFT11(x)
	#define MISC_PINS_IN(x)			SHIFT8(x)
	#define INT_ON_ATTENTION		BIT3
	#define SET_INT					BIT2
	#define CLEAR_INT				BIT1
	#define INT_STATE				BIT0

#define US_TIMER_REG            0x680c


#define EEPROM_ADDR				0x6838
	#define EEPROM_A_READ			BIT31
	#define EEPROM_A_WRITE			0
	#define EEPROM_A_COMPL			BIT30
	#define EEPROM_A_FSM_RESET		BIT29
	#define EEPROM_A_DEV_ID(x)		SHIFT26(x)
	#define EEPROM_A_DEV_MASK		0x1c000000
	#define EEPROM_A_DEV			0
	#define EEPROM_A_START			BIT25
	#define EEPROM_A_CLK_P(x)		SHIFT16(x)
	#define EEPROM_A_CLK			SHIFT16(0x60)
	#define EEPROM_A_ADDR(x)		SHIFT0(x)
	#define EEPROM_A_ADDR_MASK		SHIFT0(x)

#define EEPROM_DATA				0x683c

#define EEPROM_CTRL				0x6840
	#define EEPROM_C_DIN			BIT5
	#define EEPROM_C_DOUT			BIT4
	#define EEPROM_C_DOUT_T			BIT3
	#define EEPROM_C_CIN			BIT2
	#define EEPROM_C_COUT			BIT1
	#define EEPROM_C_COUT_T			BIT0

#define MDI_CTRL				0x6844
	#define MDI_CLK					BIT3
	#define MDI_SELECT				BIT2
	#define MDI_ENAB				BIT1
	#define MDI_DATA				BIT0

#define EEPROM_DELAY			0x6848

/********************/
/* Memory addresses	*/
/********************/

/* len and flags for RCBs */
	#define RING_MAX_LEN(x)			SHIFT16(x)
	#define DISABLE_RING			BIT1
	#define EXTENDED_RX				BIT0

#define TX_RCB_BASE				0x100
	#define TX_RCB_HIGH_OFFS		0x0
	#define TX_RCB_LOW_OFFS			0x4
	#define TX_RCB_LEN_FLAGS_OFFS	0x8
	#define TX_RCB_NIC_ADDR_OFFS	0xc

#define RX_RCB_BASE				0x200
	#define RX_RCB_HIGH_OFFS		0x0
	#define RX_RCB_LOW_OFFS			0x4
	#define RX_RCB_LEN_FLAGS_OFFS	0x8
	#define RX_RCB_NIC_ADDR_OFFS	0xc

#define FW_MAILBOX				0xb50
	#define FW_MAILBOX_VAL			0x4b657654	/* 'KevT' */

#define FW_RUNMODE				0xb54


/****************************/
/* Serial EEPROM addresses	*/
/****************************/

#define EEPROM_BOOT_CODE_OFS	0x00c	/* Boot Code Offset (start address) */

#define EEPROM_MAC_ADDR_HIGH	0x07c	/* Upper 2 bytes at offset 2 */
#define EEPROM_MAC_ADDR_LOW		0x080	/* Lower 4 bytes at offset 0 */

#define EEPROM_PART_NUMBER		0x084	/* part number string */

#define EEPROM_BOARD_INFO		0x200	
			/* revision : 2 byte at offset 0, val: "10", "11", ... */
			/* PMD  type: 1 byte at offset 2, val: 'T', 'S', ... */
			/* conn type: 1 byte at offset 3, val: 'J', 'C', ... */

#define EEPROM_MAC_ADDR2_HIGH	0x204	/* Upper 2 bytes at offset 2 */
#define EEPROM_MAC_ADDR2_LOW	0x208	/* Lower 4 bytes at offset 0 */

/****************************/
/* Status Word bits			*/
/****************************/

#define	STATUS_WORD_ERROR			BIT2
#define	STATUS_WORD_LINK_CHANGED	BIT1
#define	STATUS_WORD_UPDATED			BIT0

/****************************/
/* Receive Flags			*/
/****************************/

#define	RX_TCP_UDP_IS_TCP			BIT14
#define	RX_TCP_UDP_CKSUM			BIT13
#define	RX_IP_CKSUM					BIT12
#define	RX_MINI_BD					BIT11
#define	RX_ERROR_FRAME				BIT10
#define	RX_VLAN_TAG					BIT6
#define	RX_PACKET_END				BIT2

/****************************/
/* Send Flags				*/
/****************************/

#define	TX_DONT_GEN_CRC				BIT15
#define	TX_CHOOSE_SRC_ADDR(x)		SWITCH13(x)
#define	TX_INSERT_SRC_ADDR			BIT12
#define	TX_CPU_POST_DMA				BIT9
#define	TX_CPU_PRE_DMA				BIT8
#define	TX_COAL_NOW					BIT7
#define	TX_VLAN_TAG					BIT6
#define	TX_IP_FRAG_ENG				BIT4
#define	TX_IP_FRAG					BIT3
#define	TX_PACKET_END				BIT2
#define	TX_IP_CKSUM					BIT1
#define	TX_TCP_UDP_CKSUM			BIT0


#define	TX_BD_ADDR					0x4000
#define	RX_MIN_BD_ADDR				TBD
#define	RX_STD_BD_ADDR				0x6000
#define	RX_JUM_BD_ADDR				0x7000


/*****************************/
/* UsePhyInterrupt parameter */
/*****************************/

#define USE_PHY_INT_AUTO			0x00
#define USE_PHY_INT_ENABLE			0x01
#define USE_PHY_INT_DISABLE			0x02


/******************************************************************************/
/* Flow control */
/******************************************************************************/

#define FLOW_CONTROL_NONE			0x00
#define FLOW_CONTROL_RECEIVE_PAUSE	0x01
#define FLOW_CONTROL_TRANSMIT_PAUSE	0x02
/*
 * This value can be or-ed with RECEIVE_PAUSE and TRANSMIT_PAUSE.
 * If the auto-negotiation is disabled and the RECEIVE_PAUSE and
 * TRANSMIT_PAUSE bits are set, then flow control is enabled regardless
 * of link partner's flow control capability.
 */
#define FLOW_CONTROL_AUTO_PAUSE		0x8000


/******************************************************************************/
/* BCM5400, BCM5401 and BCM5411 phy info. */
/******************************************************************************/

/* OUI: bit 31-10; Model#: bit 9-4; Rev# bit 3-0. */
#define PHY_UNKNOWN_PHY				0x00000000
#define PHY_BCM5400_PHY_ID			0x60008040
#define PHY_BCM5401_PHY_ID			0x60008050
#define PHY_BCM5411_PHY_ID			0x60008070

#define PHY_BCM5701_PHY_ID			0x60008110

#define PHY_BCM5401_B0_REV			0x1
#define PHY_BCM5401_B2_REV			0x3
#define PHY_BCM5401_C0_REV			0x6

#define PHY_ID_OUI_MASK				0xfffffc00
#define PHY_ID_MODEL_MASK			0x000003f0
#define PHY_ID_REV_MASK				0x0000000f
#define PHY_ID_MASK					(PHY_ID_OUI_MASK | PHY_ID_MODEL_MASK)


#define UNKNOWN_PHY_ID(x)	((((x) & PHY_ID_MASK) != PHY_BCM5400_PHY_ID) && \
							(((x) & PHY_ID_MASK) != PHY_BCM5401_PHY_ID) && \
							(((x) & PHY_ID_MASK) != PHY_BCM5411_PHY_ID))

/******************************************************************************/
/* MII registers. */
/******************************************************************************/

/* Control register. */
#define PHY_CTRL_REG				0x00
	#define SPEED_MASK					(BIT6 | BIT13)
	#define SPEED_SELECT_10MBPS			0
	#define SPEED_SELECT_100MBPS		BIT13
	#define SPEED_SELECT_1000MBPS		BIT6
	#define COLLISION_TEST_ENABLE		BIT7
	#define FULL_DUPLEX_MODE			BIT8
	#define RESTART_AUTO_NEG			BIT9
	#define ISOLATE_PHY					BIT10
	#define LOWER_POWER_MODE			BIT11
	#define AUTO_NEG_ENABLE				BIT12
	#define LOOPBACK_MODE				BIT14
	#define PHY_RESET					BIT15


/* Status register. */
#define PHY_STATUS_REG				0x01
	#define LINK_PASS					BIT2
	#define AUTO_NEG_COMPLETE			BIT5


/* Phy Id registers. */
#define PHY_ID1_REG					0x02
	#define ID1_OUI_MASK				0xffff

#define PHY_ID2_REG					0x03
	#define ID2_REV_MASK				0x000f
	#define ID2_MODEL_MASK				0x03f0
	#define ID2_OUI_MASK				0xfc00


/* Auto-negotiation advertisement register. */
#define PHY_AN_AD_REG				0x04
	#define AD_ASYM_PAUSE				BIT11
	#define AD_PAUSE_CAPABLE			BIT10
	#define AD_10BASET_HALF				BIT5
	#define AD_10BASET_FULL				BIT6
	#define AD_100BASETX_HALF			BIT7
	#define AD_100BASETX_FULL			BIT8
	#define AD_PROTOCOL_802_3_CSMA_CD	0x01


/* Auto-negotiation Link Partner Ability register. */
#define PHY_LINK_PARTNER_ABIL_REG	0x05
	#define ASYM_PAUSE					BIT11
	#define PAUSE_CAPABLE				BIT10


/* Auto-negotiation expansion register. */
#define PHY_AN_EXPANSION_REG		0x06


/* 1000Base-T control register. */
#define BCM540X_1000BASET_CTRL_REG	0x09
	#define MASTER_SLAVE_ENABLE			BIT12
	#define MASTER_SLAVE_VALUE			BIT11
	#define AD_1000BASET_HALF			BIT8
	#define AD_1000BASET_FULL			BIT9


/* Extended control register. */
#define BCM540X_EXT_CTRL_REG		0x10
	#define LINK3_LED_MODE				BIT1
	#define TBI_MODE					BIT15


/* Extended status register. */
#define BCM540X_EXT_STATUS_REG		0x11

/* Error Counters			 */
#define BCM5411_RX_ERROR_CNT				0x12
#define BCM5411_FALSE_CARRIER_SENSE_CNT		0x13
#define BCM5411_RX_NOT_OK_CNT				0x14


/* DSP Coefficient Read/Write Port. */
#define BCM540X_DSP_RW_PORT			0x15


/* DSP Coeficient Address Register. */
#define BCM540X_DSP_ADDRESS_REG		0x17

#define BCM540X_DSP_TAP_NUMBER_MASK			0x00
#define BCM540X_DSP_AGC_A					0x00
#define BCM540X_DSP_AGC_B					0x01
#define BCM540X_DSP_MSE_PAIR_STATUS			0x02
#define BCM540X_DSP_SOFT_DECISION			0x03
#define BCM540X_DSP_PHASE_REG				0x04
#define BCM540X_DSP_SKEW					0x05
#define BCM540X_DSP_POWER_SAVER_UPPER_BOUND	0x06
#define BCM540X_DSP_POWER_SAVER_LOWER_BOUND	0x07
#define BCM540X_DSP_LAST_ECHO				0x08
#define BCM540X_DSP_FREQUENCY				0x09
#define BCM540X_DSP_PLL_BANDWIDTH			0x0a
#define BCM540X_DSP_PLL_PHASE_OFFSET		0x0b

#define BCM540X_DSP_FILTER_DCOFFSET			(BIT10 | BIT11)
#define BCM540X_DSP_FILTER_FEXT3			(BIT8 | BIT9 | BIT11)
#define BCM540X_DSP_FILTER_FEXT2			(BIT9 | BIT11)
#define BCM540X_DSP_FILTER_FEXT1			(BIT8 | BIT11)
#define BCM540X_DSP_FILTER_FEXT0			BIT11
#define BCM540X_DSP_FILTER_NEXT3			(BIT8 | BIT9 | BIT10)
#define BCM540X_DSP_FILTER_NEXT2			(BIT9 | BIT10)
#define BCM540X_DSP_FILTER_NEXT1			(BIT8 | BIT10)
#define BCM540X_DSP_FILTER_NEXT0			BIT10
#define BCM540X_DSP_FILTER_ECHO				(BIT8 | BIT9)
#define BCM540X_DSP_FILTER_DFE				BIT9
#define BCM540X_DSP_FILTER_FFE				BIT8

#define BCM540X_DSP_CONTROL_ALL_FILTERS		BIT12

#define BCM540X_DSP_SEL_CH_0				0
#define BCM540X_DSP_SEL_CH_1				BIT13
#define BCM540X_DSP_SEL_CH_2				BIT14
#define BCM540X_DSP_SEL_CH_3				(BIT13 | BIT14)

#define BCM540X_CONTROL_ALL_CHANNELS		BIT15


/* Auxiliary Control Register (Shadow Register) */
#define BCM540X_AUX_CTRL			0x18
	#define SEL_MASK					0x7
	#define SEL_NORMAL					0x00
	#define SEL_10BASET					0x01
	#define SEL_POWER_CONTROL			0x02
	#define SEL_IP_PHONE				0x03
	#define SEL_MISC_TEST1				0x04
	#define SEL_MISC_TEST2				0x05
	#define SEL_IP_PHONE_SEED			0x06


/* Shadow register selector == '000' */
#define NORMAL_DIAG_MODE				BIT3
#define NORMAL_DISABLE_MBP				BIT4
#define NORMAL_DISABLE_LOW_PWR			BIT5
#define NORMAL_DISABLE_INV_PRF			BIT6
#define NORMAL_DISABLE_PRF				BIT7
#define NORMAL_RX_SLICING_NORMAL		0
#define NORMAL_RX_SLICING_4D			BIT8
#define NORMAL_RX_SLICING_3LVL_1D		BIT9
#define NORMAL_RX_SLICING_5LVL_1D		(BIT8 | BIT9)
#define NORMAL_TX_6DB_CODING			BIT10
#define NORMAL_ENABLE_SM_DSP_CLOCK		BIT11
#define NORMAL_EDGERATE_CTRL_4NS		0
#define NORMAL_EDGERATE_CTRL_5NS		BIT12
#define NORMAL_EDGERATE_CTRL_3NS		BIT13
#define NORMAL_EDGERATE_CTRL_0NS		(BIT12 | BIT13)
#define NORMAL_EXT_PACKET_LENGTH		BIT14
#define NORMAL_EXTERNAL_LOOPBACK		BIT15


/* Shadow register selector == '010' */
#define POWER_EN_WOL					BIT3
#define POWER_ISOLATE					BIT5
#define POWER_RESERVED					(BIT8 | BIT7 | BIT4 )
#define POWER_1_8_VOLT					0
#define POWER_1_5_VOLT					BIT9
#define POWER_1_3_VOLT					BIT10

/* Auxiliary status summary */
#define BCM540X_AUX_STATUS			0x19
	#define X_LINK_PASS					BIT2
	#define X_SPEED_MASK				(BIT8 | BIT9 | BIT10)
	#define X_10BASET_HD				BIT8
	#define X_10BASET_FD				BIT9
	#define X_100BASETX_HD				(BIT8 | BIT9)
	#define X_100BASET4					BIT10
	#define X_100BASETX_FD				(BIT8 | BIT10)
	#define X_100BASET_HD				(BIT9 | BIT10)
	#define X_100BASET_FD				(BIT8 | BIT9 | BIT10)
	#define X_AUTO_NEG_COMPLETE			BIT15


/* Interrupt status */
#define BCM540X_INT_STATUS			0x1a
	#define LINK_CHANGE					BIT1
	#define SPEED_CHANGE				BIT2
	#define DUPLEX_CHANGE				BIT3
	#define AUTO_NEG_PAGE_RX			BIT10
	#define EXCEEDED_LOW_CNT            BIT11
	#define EXCEEDED_HIGH_CNT           BIT12
	#define MDIX_STATUS_CHANGE          BIT13
	#define ILLEGAL_PAIR_SWAP           BIT14


/* Interrupt mask register */
#define BCM540X_INT_MASK			0x1b


/***************************************************/
/* Default and max values for "integer" parameters */
/***************************************************/

#define RX_RETURN_RING_ENTRIES_MAX	1024
#define TX_RING_ENTRIES_MAX			 512



#define	DIV_MIN_RX_REPLEN_TRESH		8
#define	DIV_STD_RX_REPLEN_TRESH		8
#define	DIV_JUM_RX_REPLEN_TRESH		8


/******************************************************************************/
/* Status codes */
/******************************************************************************/

#define STATUS_LINK_DOWN			0
#define STATUS_LINK_UP				1
#define STATUS_LINK_WRONG_SET	 	2


/******************************************************************************/
/* Requested media type */
/******************************************************************************/

#define REQ_MEDIA_TYPE_AUTO							0
#define REQ_MEDIA_TYPE_UTP_AUTO						1
#define REQ_MEDIA_TYPE_UTP_10MBPS_HALF				2
#define REQ_MEDIA_TYPE_UTP_10MBPS_FULL				3
#define REQ_MEDIA_TYPE_UTP_100MBPS_HALF				4
#define REQ_MEDIA_TYPE_UTP_100MBPS_FULL				5
#define REQ_MEDIA_TYPE_UTP_1000MBPS_HALF			6
#define REQ_MEDIA_TYPE_UTP_1000MBPS_FULL			7
#define REQ_MEDIA_TYPE_FIBER_1000MBPS_HALF			8
#define REQ_MEDIA_TYPE_FIBER_1000MBPS_FULL			9


/******************************************************************************/
/* Media type */
/******************************************************************************/

#define MEDIA_TYPE_AUTO					0
#define MEDIA_TYPE_UTP					1
#define MEDIA_TYPE_BNC					2
#define MEDIA_TYPE_FIBER				3


/******************************************************************************/
/* Line speed */
/******************************************************************************/

#define LINK_SPEED_UNKNOWN				0
#define LINK_SPEED_10MBPS				1
#define LINK_SPEED_100MBPS				2
#define LINK_SPEED_1000MBPS				3


/******************************************************************************/
/* Duplex mode */
/******************************************************************************/

#define DUPLEX_MODE_UNKNOWN				0
#define DUPLEX_MODE_HALF				1
#define DUPLEX_MODE_FULL				2

/* HW Access Init values */
#define	SK_INIT_DATA			0
#define	SK_INIT_IO				1
#define	SK_INIT_RUN				2

/* Auto-negotiation config values */
#define	SK_AUTONEG_OFF			0
#define	SK_AUTONEG_ON			1
#define	SK_AUTONEG_SENS			2

/* Link speed config values */

#define SK_LSPEED_AUTO			0
#define SK_LSPEED_10MBPS		1
#define SK_LSPEED_100MBPS		2
#define SK_LSPEED_1000MBPS		3

/* Duplex capabilities config values */
#define	SK_DUPCAP_BOTH			0
#define	SK_DUPCAP_HALF			1
#define	SK_DUPCAP_FULL			2

/* Set Link Mode Parameter */
#define	SK_LMODE_HALF			1	/* Half Duplex Mode */
#define	SK_LMODE_FULL			2	/* Full Duplex Mode */
#define	SK_LMODE_AUTOHALF		3	/* AutoHalf Duplex Mode */
#define	SK_LMODE_AUTOFULL		4	/* AutoFull Duplex Mode */
#define	SK_LMODE_AUTOBOTH		5	/* AutoBoth Duplex Mode */
#define	SK_LMODE_AUTOSENSE		6	/* configured mode auto sensing */
#define SK_LMODE_INDETERMINATED	7	/* Return value for virtual port if
									 * multiple ports are differently
									 * configured.
									 */
/*
 * Link mode current state
 */
#define	SK_LMODE_STAT_UNKNOWN		 1	/* Unknown Duplex Mode */
#define	SK_LMODE_STAT_HALF			 2	/* Half Duplex Mode */
#define	SK_LMODE_STAT_FULL			 3	/* Full Duplex Mode */
#define SK_LMODE_STAT_AUTOHALF		 4	/* Half Duplex Mode obtained by AutoNeg */
#define SK_LMODE_STAT_AUTOFULL		 5	/* Half Duplex Mode obtained by AutoNeg */
#define SK_LMODE_STAT_INDETERMINATED 6	/* Return value for virtual port if
										 * multiple ports are differently
										 * configured.
										 */

/*
 * Set Flow Control Mode Parameter (and capabilities)
 */
#define	SK_FLOW_MODE_NONE			1	/* No Flow Control */
#define	SK_FLOW_MODE_LOC_SEND		2	/* Local station sends PAUSE */
#define	SK_FLOW_MODE_SYMMETRIC		3	/* Both station may send PAUSE */
#define	SK_FLOW_MODE_SYM_OR_REM		4	/* Both station may send PAUSE or just
										 * the remote station may send PAUSE.
										 */
#define SK_FLOW_MODE_INDETERMINATED 5	/* Return value for virtual port if
										 * multiple ports are differently
										 * configured.
										 */

/*
 * Set Master/Slave Mode Parameter (and capabilities)
 */
#define	SK_MS_MODE_AUTO				1	/* Automatic resolution */
#define	SK_MS_MODE_MASTER			2	/* This station is master */
#define	SK_MS_MODE_SLAVE			3	/* This station is slave */
#define SK_MS_MODE_INDETERMINATED	4	/* Return value for virtual port if
										 * multiple ports are differently
										 * configured.
										 */

/*
 * Master/Slave Status Parameter
 */
#define	SK_MS_STAT_UNSET			1	/* The MS status is never been determ*/
#define	SK_MS_STAT_MASTER			2	/* This station is master */
#define	SK_MS_STAT_SLAVE			3	/* This station is slave */
#define	SK_MS_STAT_FAULT			4	/* MS resolution failed */
#define SK_MS_STAT_INDETERMINATED	5	/* Return value for virtual port if
										 * multiple ports are differently
										 * configured.
										 */

#if 0
/*
 * Auto-negotiation timeout in 100ms granularity.
 */
#define	SK_AND_MAX_TO		6	/* Wait 600 msec before link comes up */

/*
 * Define Auto-negotiation error codes here
 */
#define	SK_AND_OK			0	/* no error */
#define	SK_AND_OTHER		1	/* other error than below */
#define	SK_AND_DUP_CAP		2	/* Duplex capabilities error */

/*
 * Link Capability value
 */
#define	SK_LMODE_CAP_HALF			(1<<0)	/* Half Duplex Mode */
#define	SK_LMODE_CAP_FULL			(1<<1)	/* Full Duplex Mode */
#define	SK_LMODE_CAP_AUTOHALF		(1<<2)	/* AutoHalf Duplex Mode */
#define	SK_LMODE_CAP_AUTOFULL		(1<<3)	/* AutoFull Duplex Mode */
#define SK_LMODE_CAP_INDETERMINATED (1<<4)	/* Return value for virtual port if
											 * multiple ports are differently
											 * configured.
											 */
#endif	/* 0 */

/*
 * Define the Event the special IRQ/INI module can handle
 */
// #define SK_HWEV_WATIM		1	/* Timeout for WA errata #2 XMAC */
#define SK_HWEV_PORT_START		2	/* Port Start Event by RLMT */
#define SK_HWEV_PORT_STOP		3	/* Port Stop Event by RLMT */
// #define SK_HWEV_CLEAR_STAT	4	/* Clear Statistics by PNMI */
// #define SK_HWEV_UPDATE_STAT	5	/* Update Statistics by PNMI */
// #define SK_HWEV_SET_LMODE	6	/* Set Link Mode by PNMI */
// #define SK_HWEV_SET_FLOWMODE	7	/* Set Flow Control Mode by PNMI */
// #define SK_HWEV_SET_ROLE		8	/* Set Master/Slave (Role) by PNMI */
// #define SK_HWEV_HALFDUP_CHK	9	/* Set Master/Slave (Role) by PNMI */

#define	SKERR_HWI_E001		(SK_ERRBASE_HWINIT)
#define	SKERR_HWI_E001MSG	"DupCap setting not possible in "
#define	SKERR_HWI_E002		(SKERR_HWI_E001+1)
#define	SKERR_HWI_E002MSG	"default AutoNeg mode (Sense)"
#define	SKERR_HWI_E003		(SKERR_HWI_E002+1)
#define	SKERR_HWI_E003MSG	"--> using AutoNeg=On"
#define	SKERR_HWI_E004		(SKERR_HWI_E003+1)
#define	SKERR_HWI_E004MSG	"Speed setting not possible in "
#define	SKERR_HWI_E005		(SKERR_HWI_E004+1)
#define	SKERR_HWI_E005MSG	"Illegal link mode"
#define	SKERR_HWI_E006		(SKERR_HWI_E005+1)
#define	SKERR_HWI_E006MSG	"Speed not available for fiber adapters"
#define	SKERR_HWI_E007		(SKERR_HWI_E006+1)
#define	SKERR_HWI_E007MSG	"AutoNeg=Sense --> Speed ignored"
#define	SKERR_HWI_E008		(SKERR_HWI_E007+1)
#define	SKERR_HWI_E008MSG	"FlowCtrl impossible without AutoNeg -> disabled"
#define	SKERR_HWI_E009		(SKERR_HWI_E008+1)
#define	SKERR_HWI_E009MSG	"Role not available for fiber adapters"
#define	SKERR_HWI_E010		(SKERR_HWI_E009+1)
#define	SKERR_HWI_E010MSG	"Role available only in 1000 Mbps mode"
#define	SKERR_HWI_E011		(SKERR_HWI_E010+1)
#define	SKERR_HWI_E011MSG	"Illegal combination for AutoNeg and Speed"
#define	SKERR_HWI_E012		(SKERR_HWI_E011+1)
#define	SKERR_HWI_E012MSG	"--> using Speed=1000"
#define	SKERR_HWI_E013		(SKERR_HWI_E012+1)
#define	SKERR_HWI_E013MSG	"SkGiReadPhy error"
#define	SKERR_HWI_E014		(SKERR_HWI_E013+1)
#define	SKERR_HWI_E014MSG	"SkGiWritePhy error"


/* macros ********************************************************************/

#define SK_BYTE_SWAP32(a) 			\
	((((a) >> 24) & 0x000000ff) |	\
	 (((a) >>  8) & 0x0000ff00) |	\
	 (((a) <<  8) & 0x00ff0000) |	\
	 (((a) << 24) & 0xff000000))

/* types *********************************************************************/
typedef struct s_Adr_64_BE	ADR_64_BE;

struct s_Adr_64_BE {
	SK_U32			High;
	SK_U32			Low;
};

/* Rx Buffer Descriptor: 32 bytes */
typedef struct {
	ADR_64_BE		Buffer;
	SK_U16			Length;
	SK_U16			Index;
	SK_U16			Flags;
	SK_U16			Type;
	SK_U16			TcpUdpChksum;
	SK_U16			IpChksum;
	SK_U16			VlanTag;
	SK_U16			ErrFlags;
	SK_U32			Reserved;
	SK_U32			Opaque;
} RX_DESC, *P_RX_DESC;

/* Send Buffer Descriptor: 16 Bytes */
typedef struct {
	ADR_64_BE		Buffer;
	SK_U16			Flags;
	SK_U16			Length;
	SK_U16			VlanTag;
	SK_U16			Reserved;
} TX_DESC, *P_TX_DESC;

typedef struct s_Prod_IDX	SK_PROD_IDX;

/* Producer Indices: 4 Bytes */
struct s_Prod_IDX {
	volatile SK_U16	ProdRx;
	volatile SK_U16	ConTx;
};

/* send and receive ring structures			*/

typedef struct s_REC_RING {
	RX_DESC			*pRbdRing;
	SK_PHYS_ADDR	Phys;
	SK_I32			NumDescs;		/* Number of descriptors */
	SK_I32			FreeBds;		/* Number of free buffer descriptors */
	SK_I32			NextFreeBd;		/* Next free buffer descriptor */
	SK_I32			NextUsedBd;		/* Next used buffer descriptor */
	SK_I32			BufferSize;		/* Max size of buffers in this ring */
	SK_I32			Mailbox;		/* Index of mailbox register for queue */
	volatile SK_U16	*pStatusIdx;	/* Pointer into status block */
	SK_SPINLOCK		RingLock;
} REC_RING, *P_REC_RING;

typedef struct s_SND_RING {
	TX_DESC			*pSbdRing;
	SK_TX_PACKET	*pDescriptors;	/* Pointer to send packet descriptors */
	SK_PHYS_ADDR	Phys;
	SK_I32			NumDescs;		/* Number of descriptors */
	SK_I32			FreeBds;		/* Number of free buffer descriptors */
	SK_I32			NextFreeBd;		/* Next free buffer descriptor */
	SK_I32			NextUsedBd;		/* Next used buffer descriptor */
	SK_I32			Mailbox;		/* Index of mailbox register for queue */
	SK_SPINLOCK		RingLock;
} SND_RING, *P_SND_RING;


typedef struct s_Status_Block	STATUS_BLOCK;

/* Status Block: 80 Bytes */
struct s_Status_Block {
	volatile SK_U32	Status;
	volatile SK_U32	Reserved;
	volatile SK_U16	RxJumConsumerIdx;
	volatile SK_U16	RxStdConsumerIdx;
	volatile SK_U16	RxMinConsumerIdx;
	volatile SK_U16	Reserved1;
	SK_PROD_IDX		ConProdIdx[16];
};

typedef struct s_CONFIG	SK_GI_CONFIG;

struct s_CONFIG {
	SK_U32			AutoNeg;			/* Auto-negotiation configuration */
	SK_U32			DupCap;				/* Duplex capabilities configuration */
	SK_U32			LinkSpeed;			/* Link speed configuration */
	SK_U32			FlowCtrl;			/* Flow control configuration */
	SK_U32			MsMode;				/* Master/Slave mode configuration */

	SK_U32			TxRingNum;			/* Number of send rings */
	SK_U32			RxRingNum;			/* Number of receive rings */

	SK_U32			TaskOffloadCap;
	SK_U32			TxCopySize;
	SK_U32			RxCopySize;

	SK_U32			MbufDescLow;
	SK_U32			MbufRxLow;
	SK_U32			MbufHigh;

	SK_U32			RxCoalTicks;
	SK_U32			TxCoalTicks;
	SK_U32			RxCoalFrames;
	SK_U32			TxCoalFrames;
	SK_U32			RxCoalTicksInt;
	SK_U32			TxCoalTicksInt;
	SK_U32			RxCoalFramesInt;
	SK_U32			TxCoalFramesInt;
	SK_U32			StatsCoalTicks;

	SK_BOOL			AutoNegSet;
	SK_BOOL			DupCapSet;
	SK_BOOL			LinkSpeedSet;
	SK_BOOL			MsModeSet;
	SK_BOOL			FlowCtrlSet;

	SK_BOOL			EnableNwi;
	SK_BOOL			UseJumbo;
};

typedef struct s_HW_Info	SK_GI_HW;

struct s_HW_Info {
	SK_U32			SavedCacheLineReg;
	SK_U32			SubsystemVendorId;
	SK_U32			ClassCode;
	SK_U32			BaseAddress;
	SK_U32			PhyIdentifier;
	SK_U32			LinkMode;
	
	SK_U32			MiscHost;
	SK_U32			MiscLocal;
	SK_U32			MacMode;
	/* Current PHY settings */
	SK_U16 			DuplexMode;
	SK_U16 			LineSpeed;
	SK_U16 			FlowControl;
	SK_U16 			MediaType;
	SK_U16 			ReqMediaType;
	SK_U16 			LinkStatus;
	SK_U16 			UsePhyInterrupt;

	SK_U16			PciState;
	SK_U16			ChipRevId;
	SK_U8			PmdType;
	SK_U8			CacheLineSize;
	SK_U8			RevisionId;
	
	SK_BOOL			IsCopper;

	AUTO_NEG_STATE	AutoNeg;				/* Auto-Negotiation */
};

/* prototypes ********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif __cplusplus

extern SK_STATUS SkGiHwacDeinit(
	SK_AC		*pAC,
	SK_IOC		IoC);
extern SK_STATUS SkGiHwacInit(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U16		Level);
extern SK_STATUS SkGiInitPhy(
	SK_AC		*pAC,
	SK_IOC		IoC);
extern SK_STATUS SkGiReadProm(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U16		Addr,
	SK_U32		*pData32);
extern SK_STATUS SkGiHwEvent(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Event,
	SK_EVPARA	Para);

extern SK_STATUS SkGiReadPhy(
	SK_AC	*pAC,	/* Pointer to Adapter Context */
	SK_IOC	IoC,	/* I/O Context */
	SK_U16	Addr,
	SK_U16	*pData16);

extern SK_STATUS SkGiWritePhy(
	SK_AC	*pAC,	/* Pointer to Adapter Context */
	SK_IOC	IoC,	/* I/O Context */
	SK_U16	Addr,
	SK_U16	Data16);

extern SK_STATUS SkGpioOut(
	SK_AC	*pAC,			/* Adapter contex  */	
	SK_IOC	IoC,			/* I/O contex  */	
	SK_U8	GpioNo,			/* GPIO Number */
	SK_U8	OnOff);			/* GPIO On or Off */

SK_STATUS SkReadI2cBlock(
	SK_AC	*pAC,			/* Adapter contex */	
	SK_IOC	IoC,			/* I/O contex */	
	SK_U8	DeviceID,		/* I2C Device */
	SK_U32	Offset,			/* Offset in the I2C*/
	SK_U32	Amount,			/* Number of bytes */
	SK_U8	*Data );		/* Data array */

SK_STATUS SkWriteI2cBlock(
	SK_AC	*pAC,			/* Adapter contex */
	SK_IOC	IoC,			/* I/O contex */	
	SK_U8	DeviceID,		/* I2C Device */
	SK_U32	Offset,			/* Offset in the I2C*/	
	SK_U32	Amount,			/* Number of bytes */
	SK_U8	*Data );		/* Data array */

#ifdef __cplusplus
}
#endif __cplusplus

#endif	/* SKGIHW_H_ */

