#ifndef _SHFS_PROC_H_
#define _SHFS_PROC_H_

#include "shfs_dcache.h"
#include "shfs_fcache.h"
#include "shfs.h"

#define PRINTF_BUFFER_SIZE (SHFS_PATH_MAX * 10)
#define READLN_BUFFER_SIZE (SHFS_LINE_MAX * 10)

#define VALID(time) (CURRENT_TIME - (time) <= SHFS_DCACHE_TTL)

void shfs_init_root_dirent(struct shfs_sb_info*, struct shfs_fattr*);
int shfs_parse_options(struct shfs_sb_info*, char*);
int shfs_pipe_printf(struct shfs_sb_info*, const char*, ...);
int shfs_pipe_readln(struct shfs_sb_info*, char*, int);
int reply(char *);
int shfs_get_name(struct dentry*, char*);
inline int shfs_lock(struct shfs_sb_info*);
inline void shfs_locku(struct shfs_sb_info*);
inline void shfs_unlock(struct shfs_sb_info*);
int shfs_remove_sigpipe(int result);
int shfs_get_attr(struct dentry*, struct shfs_fattr*);
struct inode* shfs_iget(struct super_block*, struct shfs_fattr*);
int shfs_proc_open(struct shfs_sb_info*, char*, int);
int shfs_proc_read(struct dentry*, unsigned, unsigned, char*, int);
int shfs_proc_write(struct dentry*, unsigned, unsigned, char*);
int shfs_proc_mkdir(struct shfs_sb_info*, char*);
int shfs_proc_rmdir(struct shfs_sb_info*, char*);
int shfs_proc_rename(struct shfs_sb_info*, char*, char*);
int shfs_proc_unlink(struct shfs_sb_info*, char*);
int shfs_proc_create(struct shfs_sb_info*, char*, int);
int shfs_proc_link(struct shfs_sb_info*, char*, char*);
int shfs_proc_symlink(struct shfs_sb_info*, const char*, const char*);
int shfs_proc_chmod(struct shfs_sb_info*, char*, umode_t);
int shfs_proc_chown(struct shfs_sb_info*, char*, uid_t user);
int shfs_proc_chgrp(struct shfs_sb_info*, char*, gid_t group);
int shfs_proc_trunc(struct shfs_sb_info *, char *, loff_t);
int shfs_proc_settime(struct shfs_sb_info *, char *, int, time_t *);
int shfs_init(struct shfs_sb_info*);
int shfs_finish(struct shfs_sb_info*);

int shfs_notify_change(struct dentry*, struct iattr*);
int shfs_lookup_validate(struct dentry*);
int shfs_revalidate_inode(struct dentry *);

#endif	/* _SHFS_PROC_H_ */
