/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_def.h - defines data structures and related constants

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/

#ifndef CAM_DEF_H
#define CAM_DEF_H


#ifdef _DOS
	#define	FARPTR	__far
#else
	#define	FARPTR
#endif

#ifdef NT
  #pragma pack (1)
#endif /* NT */

#ifndef PACKED
	#if defined (__LINUX__) || defined (__FreeBSD__)			
	    #define PACKED __attribute__((packed))
	#else  
	    #define PACKED
	#endif
#endif

#ifdef U8
	#undef	U8
	#undef	U16
	#undef	U32
	#undef	PU8
	#undef	PU16
	#undef	PU32
#endif
	#define U8 unsigned char
	#define U16 unsigned short
	#define U32 unsigned long
	#define PU8 U8 FARPTR *
	#define PU16 U16 FARPTR *
	#define PU32 U32 FARPTR *


#ifdef	PVOID
	#undef	PVOID
#endif
	#define PVOID void FARPTR *



typedef struct _CAM_INFO {
		U8		VerMajor;
		U8		VerMinor;
		U8		VerOEM;
		U8		VerBuild;
		U16		CAMFlag;
		U16		DeviceID;
		U32		MinMemSize;
		U8		NumofATA;
		U8		NumofXOR;
		U8		NumofHDMA;
		U8		VirMemBase;
} PACKED CAM_INFO, PACKED FARPTR *PCAM_INFO;


typedef struct _ADAPTER_CONFIG_INFO {
	U8		Adapter_ID;
	U8		Reserved[3];
	U32		BaseAddress[6];
	U32		MemPhyAddress;	    
	PVOID	MemVirAddr;		
	U32		MemSize;
}PACKED ADAPTER_CONFIG_INFO, PACKED FARPTR *PADAPTER_CONFIG_INFO;

typedef struct _CHNL_CONFIG {
		U8		bCh;
		U8		ChnlType;
		U8		ChnlSpeed;
		U8		CableType;
}PACKED CHNL_CONFIG, PACKED FARPTR *PCHNL_CONFIG;

/* definitions for ChnlType */
#define	CHNL_ATA	0x01		/* the channel is a parallel ATA channel */
#define	CHNL_SATA	0x02		/* the channel is a serial ATA channel */

/* definitions for ChnlSpeed */
#define	CHNL_U33	0x01		/* the channle support upto Ultra DMA mode 2 */
#define	CHNL_U100	0x02		/* the channel support upto Ultra DMA mode 5 */
#define	CHNL_U133 	0x04		/* the channel support Ultra DMA mode 6 	 */
#define	CHNL_U150 	0x08		/* the channel support Ultra150				 */

/* definitions for CableType */
#define	CABLE_40	0x01		/* 40-conductor cable 	*/
#define	CABLE_80	0x02		/* 80-condutor cable 	*/
#define	CABLE_SATA	0x03		/* SATA cable 			*/


typedef struct _ENCLOSURE_TYPE	PACKED ENCLOSURE_TYPE, PACKED FARPTR *PENCLOSURE_TYPE;

typedef struct  _DEV_CONFIG {
		U8		bCh; 					
		U8		bID;						
		U8		DevFlag;
		U8		PIOMode;
		U8		MDMAMode;
		U8		UDMAMode;
		U8		Model[22];
		U16		CylNum;
		U8		HeadNum;
		U8		SecPerTrk;
		U32		MAXLBAL;
		U32		MAXLBAH;
		PENCLOSURE_TYPE pEnclosure;
		U8		Features;
		U8		SerialNo[21];
		U8		FWVersion[10];
}PACKED DEV_CONFIG, PACKED FARPTR *PDEV_CONFIG;

/* definitions for DevFlag */
#define	DEV_NOTFOUND		0x00	/* No drive exists */
#define	DEV_EXIST			0x01	/* The drive exists */
#define	DEV_ATA_DEVICE		0x02	/* This drive is a ATA device */
#define	DEV_ATAPI_DEVICE	0x04	/* This drive is a ATAPI device */
#define	DEV_48BIT			0x10	/* This drive with 48-bit LBA support */
#define	DEV_ATA5			0x20	/* This device claims compliance with ATA-5 */
#define DEV_INT_DRQ			0x40	/* This device interrupts with the assertion of DRQ after receiving ATAPI Packet Command */

/* definitions for Features */
#define DEV_EN_SMART		0x01	/* SMART feature set has been enabled. */
#define DEV_EN_WRITECACHE	0x02	/* write cache has been enabled. */
#define DEV_SMART		0x10	/* supports SMART feature set. */
#define DEV_WRITECACHE		0x20	/* write cache supported. */


typedef struct _CAMSG {
	U32		StartAddr;
	U16		wCount;
	U8		Reserved;				
	U8		CtrlFlag;					
} PACKED CAMSG, PACKED FARPTR *PCAMSG;

/* definitions for CtrlFlag */
#define EOT					0x80	/* End of the SG table */
#define XOR_DEST 			0x10	/* XOR module will save result to the buffer described by this SG */
#define XOR_SRC				0x20	/* XOR module will use data in the buffer as source */
#define XOR_BOTH			0x30	/* XOR module will use data in the buffer as source then save result to the buffer */
#define IDE_DUMP			0x08	/* The controller will discard data of this buffer described by this SG */

typedef struct _ATA_TASK	PACKED ATA_TASK, PACKED FARPTR *PATA_TASK;	

struct _ATA_TASK {
	void (*callback)(PATA_TASK pTask);	/* call back function */
	U8		bCh; 					
	U8		bID;						
	U8		ATAStatus;					
	U8		ATACmdFlag;
union {
	U8		Cdb[16];				
	struct {
			U8		bError;
			U8		bFeature;	
			U16		bCount;			
			U32		LBAl;		
			U32		LBAh;
			U8		bCmd;
			U8		bStatus;
			U16		Reserved;	/* to align with Cdb */
		} PACKED ATACmd;
	} Cmd;
		U8		SGCount;
		U8		SenseInfoLength; 
		U32		DataTransferLength;
		PVOID	DataBuffer;
		U32		pSG;
		PVOID	SenseInfoBuffer; 
		PVOID	pTaskExtension;
};

/* definitions for ATAStatus */
#define	ATA_ERROR			0x01	/* indicate this ATA_TASK is failed */
#define	ATA_ABORT			0x02	/* indicate this ATA_TASK is aborted */
#define ATA_TIMEOUT			0x04	/* indicate this ATA_TASK timeout */
#define	ATAERR_OVERRUN		0x08	/* indicate total count of S/G table is larger than HDD requires */
#define	ATAERR_UNDERRUN 	0x10	/* indicate total count of S/G table is less than HDD requires */
#define	ATAERR_DRV			0x20	/* check bError and bStatus of ATACmd or check sense data in SenseInfoBuffer to get the detail information */
#define	ATAERR_PCI			0x40	/* Indicates that is due to PCI system error */
#define	ATAERR_PARITY       	0x80	/* Indicates that is due to PCI parity check error */
#define	ATAERR_HWERROR		ATAERR_OVERRUN+ATAERR_UNDERRUN+ATAERR_DRV+ATAERR_PCI+ATAERR_PARITY

/* definitions for ATACmdFlag */
#define PSEUDO_CMD			0x01	/* indicate a pseudo command is in bCmd */
#define camDATA_XFER			0x02	/* indicate this is a data transfer command */
#define camDATA_IN			0x04	/* indicate this is a data in command */
#define ATA_DEVICE			0x08	/* indicate specified device is a ATA device */
#define PIO_XFER				0x10	/* indicate this is a data transfer command by PIO */
#define ATA_STATUS_RETURN 	0x20 /* indicate return ATA registers statuses when this command completed */
#define INTERNAL_SENSE		0x40
#define SWAPBOX_CMD			0x80	/* indicate this task is for swap box */

typedef struct _CAM_XOR_TASK 	PACKED CAM_XOR_TASK, PACKED FARPTR *PCAM_XOR_TASK;	

struct _CAM_XOR_TASK {
	void (*callback)(PCAM_XOR_TASK pTask);	/* call back function */
	U8		bID;
	U8		bFlag;
	U8		reserved;
	U8		bCount;
	PCAMSG	pSGTable[MAX_XOR_SG];
	PVOID	pTaskExtension;
};

/* definitions for bFlag */
#define XOR_IsCmp		0x01  	/* Caller want to compare */
#define	XOR_ABORT		0x02	/* indicate this CAM_XOR_TASK is aborted */
#define	XOR_ERROR		0x10	/* Indicates error occurred in XOR */
#define	XORERR_CMP		0x20	/* Indicates that is due to compare data not the same */
#define	XORERR_PCI		0x40	/* Indicates that is due to PCI system error */
#define	XORERR_PARITY	0x80	/* Indicates that is due to PCI parity error */
#define	XORERR_HWERROR	XORERR_CMP+XORERR_PCI+XORERR_PARITY

struct _ENCLOSURE_TYPE {
	U8		BOXID;
	U8		BOXType;
	U8		BOXConfig;
	U8		NumofBay;
	U8		NumofFAN;
	U8		NumofSensor;
	U16		ChkPeriod;
};

/* definitions for BOXType */
#define	camNOBOX		0xFF		/* no box or bad box */
#define	SuperSwap		0x01
#define	camUNKNOWNBOX	0x00

/* definitions for BOXConfig */
#define	WITH_FAN		0x01		/* the enclosure has fan(s)*/
#define	WITH_KEY		0x02		/* the enclosure has key to turn on/off power */
#define	WITH_SENSOR		0x04		/* the enclosure has sensor(s) */
#define	MODE_198P		0x10		/* 198 or 198p mode */
#define	MODE_SF			0x20		/* SF mode */

typedef struct _ENCLOSURE_STATUS {
	U8		NeedCheck;
	U8		LEDColor;
	U8		PowerState;
	U8		Reserved;
	U16		RemPeriod;
	U16		TEMPStatus;
	U32		FANStatus;
	U32		VOL5V;
	U32		VOL12V;
} PACKED ENCLOSURE_STATUS, PACKED FARPTR *PENCLOSURE_STATUS;

/* definitions for LEDColor */
#define	camLED_OFF		0x00
#define	LED_Red			0x01
#define	LED_Green		0x02
#define	LED_Amber		0x03
#define	LED_MASK		0x03

/* definitions for PowerState */
#define	PowerOFF		0x01
#define	PowerON			0x00

/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/

typedef struct _ADATER_CONFIG {
	
	U8		Adapter_ID;
	U8		Reserved[3];
	U32		ATABaseAddr;
	U32		XORBaseAddr;
	U32		HostBaseAddr;
	U32		MemIOBaseAddr;
	U32		MemPhyAddress;	    
	PVOID		MemVirAddr;		
	U32		MemSize;
	U32		PLL_Parms;			/* for PDC20618/619/620 */

}PACKED ADAPTER_CONFIG, PACKED FARPTR *PADAPTER_CONFIG;


typedef	struct _FLASH_CONFIG {
	U16		Flag;				
	U16		Flash_Type;			/* flash memory type */
	U32		Old_Timing;			/* keep old PLL or TBG clcok setting */
	U32		New_Timing;			/* timing during programming flash memory */
	U32		FlashMemAddr;			/* address to access flash memory */

}PACKED FLASH_CONFIG, PACKED FARPTR *PFLASH_CONFIG;
#define	FLASH_FOUND		bit(0)
#define FLASH_620		bit(1)			/* PDC20620/617 series ASIC */
#define FLASH_320		bit(2)			/* PDC20320/375 series ASIC */


typedef struct PACKET_HEAD{
	PVOID  NPA;					/* Next Packet Address*/
	PVOID  PTA;    				/* Parent Task Address, original Task Point */
	U16    ModelType;			/* indicate this is ATA or XOR packet */
	U16    Flag;
	U32    Address;				/* packet physical address of itself */ 
	PVOID  PSG;    				/* SG virtual address used for this packet */
}PACKED PACKET_HEAD, PACKED FARPTR *PPACKET_HEAD;
#define PACKET_HEAD_SIZE	sizeof(PACKET_HEAD)

/* definition for PACKET_HEAD */
#define	PACFLAG_ATAPI		bit(0)	/* indicate this packet is for ATAPI device */



typedef struct _ATA_PACKET{

	U8	bControl;
	U8	bReserved;
	U8	bSynSeqID;				/* synchronization sequence ID */
	U8	bDelaySeqID;			/* delay seqence ID           */
                                              
	U32	ulPSG;					/* point to SG table		*/
	U32	ulNCA;					/* Pointer to Next ATA Packet  */

	U8	bATRL[MAXREGCNT];

}PACKED ATA_PACKET, PACKED FARPTR *PATA_PACKET;


/* definition for ATA/ATAPI packet */
#define ATACTRL_DMAREAD			bit(2)		/* DMA Read command*/
#define ATACTRL_NONDATA			bit(3)		/* Non-Data command */
#define ATACTRL_DELAY			bit(4)
#define ATACTRL_PAUSE			bit(5)
#define ATACTRL_BOX				bit(6)		/* Command is for enclusure control */


typedef struct _XOR_PACKET {
	U8	bControl;
	U8	bReserved;
	U8	bSynSeqID;				/* synchronization sequence ID */
	U8	bDelaySeqID;			/* delay seqence ID */
	
	U32 ulPSG[4];				/* point to SG table 0--3*/ 
	U32 ulNCA;					/* Pointer to Next XOR Packet */ 

}PACKED XOR_PACKET, PACKED FARPTR *PXOR_PACKET;

/* definition for XOR packet */
#define XORCTRL_CMP				0
#define XORCTRL_XOR				bit(0)
#define XORCTRL_DELAY			bit(4)
#define XORCTRL_PAUSE			bit(5)

#define CAM_PRD_TBL_SIZE 	0x108			/* Max. 33 PRD entries */
/* Important: the addresses must be DWord boundary. */
typedef struct _CAM_ATA_SG {
	U8	ATA_SG[CAM_PRD_TBL_SIZE];
	U8	PadByte[4];				/* for fixing the ASIC bug about ATAPI device commands */
	U32	Address;				/* packet physical address of itself */ 
}PACKED CAM_ATA_SG, PACKED FARPTR *PCAM_ATA_SG;

/* Important: the addresses must be DWord boundary. */
typedef struct _CAM_XOR_SG {
	U8 XOR_SG[MAX_XOR_SG][CAM_PRD_TBL_SIZE];
	U32	 Address;				/* packet physical address of itself */ 
}PACKED CAM_XOR_SG, PACKED FARPTR *PCAM_XOR_SG;


typedef struct _CAM_ATA_PACKET{
	PACKET_HEAD   PacketHead;
	ATA_PACKET    ATAPacket;
}PACKED CAM_ATA_PACKET, PACKED FARPTR *PCAM_ATA_PACKET;

typedef struct _CAM_XOR_PACKET{
	PACKET_HEAD   PacketHead;
	XOR_PACKET    XORPacket;
}PACKED CAM_XOR_PACKET, PACKED FARPTR *PCAM_XOR_PACKET;

#define ATA_PAC_SIZE sizeof(CAM_ATA_PACKET)
#define XOR_PAC_SIZE sizeof(CAM_XOR_PACKET)

#define ATA_SG_SIZE sizeof(CAM_ATA_SG)
#define XOR_SG_SIZE sizeof(CAM_XOR_SG)

typedef enum {
    ATA0 = 0x00,
    ATA1 = 0x01,
    ATA2 = 0x02,
    ATA3 = 0x03,    
    XOR = 0x04
} ModType;

typedef struct _SEQ_INFO
{
	ModType	Owner;				/* which module the SEQ belongs to */
	U8		PACCNT;				/* current packet count in this SEQ ID */
	PVOID	pCurPAC;			/* point to current packet */
	PVOID	SEQID2PacketHead;
	PVOID	SEQID2PacketTail;
	U8		GO;
}PACKED SEQ_INFO, PACKED FARPTR *PSEQ_INFO;


typedef enum {
    ATA_PAC = 0x00,
    XOR_PAC = 0x01,
    HDMA_PAC = 0x02
} PAC_TYPE, PAC_Q_TYPE;

typedef struct{
	PCAM_XOR_PACKET pXORPacket;
}PACKED XOR_QUEUE, PACKED FARPTR *pXOR_QUEUE;

typedef struct{
	PCAM_ATA_PACKET pATAPacket;
}PACKED ATA_QUEUE, PACKED FARPTR *pATA_QUEUE;

typedef struct _MODULE_PACKET_COUNT{
	U8 ATAModule[MAX_ATA_CHNL];
	U8 XORModule[MAX_XOR_MODULE];
}PACKED MODULE_PACKET_COUNT, PACKED FARPTR *PMODULE_PACKET_COUNT;

typedef struct _MODULE_TIMEOUT{
	U32 ATACommand;
	U32 ATAPICommand;
	U32 BOXCommand;
	U32 XORCommand;
}PACKED MODULE_TIMEOUT, PACKED FARPTR *PMODULE_TIMEOUT;

typedef struct _CAM_IDENTIFY_DATA {

	U16 GeneralConfiguration;			/* 00 00	*/
	U16 NumberOfCylinders;              /* 02  1	*/
	U16 Reserved1;                      /* 04  2	*/
	U16 NumberOfHeads;                  /* 06  3	*/
	U16 UnformattedBytesPerTrack;       /* 08  4	*/
	U16 UnformattedBytesPerSector;      /* 0A  5	*/
	U16 SectorsPerTrack;				/* 0C  6	*/
	U16 VendorUnique1[3];               /* 0E  7-9	*/
	U16 SerialNumber[10];               /* 14  10-19	*/
	U16 BufferType;						/* 28  20	*/
	U16 BufferSectorSize;				/* 2A  21	*/
	U16 NumberOfEccBytes;				/* 2C  22	*/
	U16 FirmwareRevision[4];			/* 2E  23-26	*/
	U16 ModelNumber[20];				/* 36  27-46	*/
	U8  MaximumBlockTransfer;			/* 5E  47	*/
	U8  VendorUnique2;					/* 5F	*/
	U16 DoubleWordIo;					/* 60  48	*/
	U16 Capabilities;					/* 62  49	*/
	U16 Reserved2;						/* 64  50	*/
	U8  VendorUnique3;					/* 66  51	*/
	U8  PioCycleTimingMode;				/* 67	*/
	U8  VendorUnique4;					/* 68  52	*/
	U8  DmaCycleTimingMode;				/* 69	*/
	U16 FieldsValid;					/* 6A  53	*/
	U16 NumberOfCurrentCylinders;		/* 6C  54	*/
	U16 NumberOfCurrentHeads;			/* 6E  55	*/
	U16 CurrentSectorsPerTrack;			/* 70  56	*/
	U16 CurrentSectorCapacity1;			/* 72  57-58	*/
	U16 CurrentSectorCapacity2;			/* 72  57-58	*/
	U16 CurrentMultiSectorSetting;		/*     59	*/
	U16 UserAddressableSectors1;		/*     60-61	*/
	U16 UserAddressableSectors2;		/*     60-61	*/
	U16 SingleWordDMAModes;				/*     62	*/
	U16 MultiWordDMAModes;				/*     63	*/
	U16 AdvancedPIOModes;				/*     64	*/
	U16 MinimumMWXferCycleTime;			/*     65	*/
	U16 RecommendedMWXferCycleTime;		/*     66	*/
	U16 MinimumPIOCycleTime;			/*     67	*/
	U16 MinimumPIOCycleTimeIORDY;		/*     68	*/
	U16 Reserved5[4];					/*     69-72	*/
	U16 QueueDepth;						/*     73	*/
 	U16 Word74;
	U16 Word75;
	U16 Word76;
	U16 Word77;
	U16 Word78;
	U16 Word79;
 	U16 MajorRevision;					/*     80	*/
	U16 MinorRevision;					/*     81	*/
	U16 CommandSetSupport1;				/*     82	*/
	U16 CommandSetSupport2;				/*     83	*/
	U16 CommandSetSupport3;				/*     84	*/
	U16 CommandSetSupport4;				/*     85	*/
	U16 CommandSetSupport5;				/*     86	*/
	U16 CommandSetSupport6;				/*     87	*/
	U16 CommandSetSupport7;				/*     88	*/
	U16 Reserved7[11];					/*     89 - 99	*/
	U16 MaxLBA1;						/*     100	*/
	U16 MaxLBA2;						/*     101	*/
	U16 MaxLBA3;						/*     102	*/
	U16 MaxLBA4;						/*     103	*/
	U16 Reserved8[22];					/*     104 - 125	*/
	U16 LastLUNID;						/*	   126 (for ATAPI device )	*/
	U16 SpecialFunctionsEnabled;		/*     127	*/
	U16 Reserved9[128];					/*     128-255	*/
	
}PACKED CAM_IDENTIFY_DATA, PACKED FARPTR *PCAM_IDENTIFY_DATA;

#ifdef NT
  #pragma pack ()
#endif /* NT */

#endif
