/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#ifndef _H_FCDDS
#define _H_FCDDS

#include "fc_hw.h"

#define LNAMESIZE 16

#ifndef DMA_MAXMIN_16M
#define         DMA_MAXMIN_16M          0x8
#define         DMA_MAXMIN_32M          0x9
#define         DMA_MAXMIN_64M          0xa
#define         DMA_MAXMIN_128M         0xb
#define         DMA_MAXMIN_256M         0xc
#define         DMA_MAXMIN_512M         0xd
#define         DMA_MAXMIN_1G           0xe
#define         DMA_MAXMIN_2G           0xf
#endif

/****************************************************************************/
/*      This is the DDS structure for the FC device                         */
/****************************************************************************/

typedef struct {
   char logical_name[LNAMESIZE]; /* logical name in ASCII characters */
   char dev_alias[LNAMESIZE];    /* logical name in ASCII characters */
   uint32 devno;                 /* major/minor device number */

   /* PCI parameters */
   int  bus_id;                  /* for use with i_init and bus io */
   int  sla;                     /* for use with pci_cfgrw and bus io */
   int  bus_intr_lvl;            /* interrupt level */
   uint64  bus_mem_addr;         /* bus memory base address */
   uint64  bus_io_addr;          /* I/O reg base address */

   uint32 xmt_que_size;         /* size of xmit queue for mbufs */
   uint32 num_iocbs;            /* number of iocb buffers to allocate */
   uint32 num_bufs;             /* number of ELS/IP buffers to allocate */
   uint32 fcpfabric_tmo;        /* Extra FCP timeout for fabrics (in secs) */

   ushort topology;             /* link topology for init link */
   ushort post_ip_buf;          /* number of IP buffers to post to ring 1 */

   ushort rsvd1;
   uchar  ipclass;              /* class to use for transmitting IP data */
   uchar  fcpclass;             /* class to use for transmitting FCP data */

   uchar  network_on;           /* true if networking is enabled */
   uchar  fcp_on;               /* true if FCP access is enabled */
   uchar  frame_512;            /* true if 512 byte framesize is required */
   uchar  use_adisc;            /* Use ADISC results in FCP rediscovery */

   uchar  first_check;          /* Ignore 0x2900 check condition after PLOGI */
   uchar  sli;                  /* Service Level Interface supported */
   uchar  ffnumrings;           /* number of FF rings being used */

   uchar   scandown;
   uchar   linkdown_tmo;        /* linkdown timer, seconds */
   uchar   nodev_tmo;
   uchar   fabric_reg;          /* perform RFT_ID with NameServer */

   uchar  nummask[4];           /* number of masks/rings being used */
   uchar  rval[6];              /* rctl for ring, assume mask is 0xff */
   uchar  tval[6];              /* type for ring, assume mask is 0xff */

   uchar  verbose;              /* how much to hurl onto the console */
   uchar  ack0support;          /* Run with ACK0 for CLASS2 sequences */
   uchar  log_only;             /* console messages just logged to log file */
   uchar  automap;              /* assign scsi ids to all FCP devices */

   uint32 default_tgt_queue_depth; /* max # cmds outstanding to a target */

   uchar  dds1_os;              /* system dependent variable */
   uchar  default_lun_queue_depth; /* max # cmds outstanding to a lun */
   uchar  nodev_holdio;         /* Hold I/O errors if device disappears */
   uchar  zone_rscn;            /* system dependent variable */

   uchar  check_cond_err;
   uchar  delay_rsp_err;
   uchar  rscn_adisc;  
   uchar  filler1;
   uchar  filler2;
   uchar  filler3;

   uint32 dds5_os;              /* system dependent variable */
} fc_dds_t;

/* Values for seed_base and fcp_mapping */
#define FCP_SEED_WWPN      0x1          /* Entry scsi id is seeded for WWPN */
#define FCP_SEED_WWNN      0x2          /* Entry scsi id is seeded for WWNN */
#define FCP_SEED_DID       0x4          /* Entry scsi id is seeded for DID */
#define FCP_SEED_MASK      0x7          /* mask for seeded flags */



/* Allocate space for any environment specific dds parameters */





/****************************************************************************/
/*      Device VPD save area                                                */
/****************************************************************************/

typedef struct fc_vpd {
   uint32 status;               /* vpd status value */
   uint32 length;               /* number of bytes actually returned */
   struct {
        uint32   rsvd1;         /* Revision numbers */
        uint32   biuRev;
        uint32   smRev;
        uint32   smFwRev;
        uint32   endecRev;
        ushort   rBit;
        uchar    fcphHigh;
        uchar    fcphLow;
        uchar    feaLevelHigh;
        uchar    feaLevelLow;
    uint32   postKernRev;
    uint32   opFwRev;
    uchar    opFwName[16];
    uint32   sli1FwRev;
    uchar    sli1FwName[16];
    uint32   sli2FwRev;
    uchar    sli2FwName[16];
   } rev;
} fc_vpd_t;

/****************************************************************************/
/*  Node table information that the config routine needs                    */
/****************************************************************************/


/****************************************************************************/
/*  SCIOCOMPLETE results buffer structure                                   */
/****************************************************************************/

struct iorslt {
   struct buf *buf_struct_ptr;
   uint32  b_flags;
   uint32  b_resid;
   char b_error;
};

/****************************************************************************/
/*  Special ioctl calls for the Fibre Channel SCSI LAN device driver        */
/****************************************************************************/

#define SCIONODES       0x47            /* ioctl to get node table */
#define SCIOSTRAT       0x48            /* strategy ioctl */
#define SCIOCOMPLETE    0x49            /* I/O completion ioctl */
#define SCIORESUMEQ     0x4a            /* device resume Q ioctl */


#endif /* _H_FCDDS */
