/* loadcard.c 
 *   by Nathan Laredo (laredo@gnu.org)
 *
 * Stradis 4:2:2 MPEG-2 Decoder Driver
 * Copyright (C) 1999 Nathan Laredo <laredo@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <linux/types.h>
#include <linux/videodev.h>
#include "ibmmpeg2.h"

struct file_list {
	char *name;
	char *loadwhat;
};

#define LOADCOUNT	7
struct file_list files[LOADCOUNT] = {	/* order is important */
	"/etc/stradis/decxla.bit",	"decxla",
	"/etc/stradis/decxl.bit",	"decxl",
	"/etc/stradis/decxldva.bit",	"decxldva",
	"/etc/stradis/decxldv.bit",	"decxldv",
	"/etc/stradis/decoder2.bit",	"decoder2",
	"/etc/stradis/decoder.vid",	"decoder.vid",
	"/etc/stradis/decoder.aud",	"decoder.aud"
};

int main(int argc, char **argv)
{
	int videofd, d, f, i, c;
	char outf[80];
	struct video_code loader;
	__u8 mydata[32768];

	if (argc < 2) {
		fprintf(stderr, "usage: %s device\n", argv[0]);
		exit(1);
	}
	loader.data = mydata;
	d = atoi(argv[1]);
	sprintf(outf, "/dev/video%d", d);
	if ((videofd = open(outf, O_RDWR)) < 0) {
		perror(outf);
		exit(1);
	}
	for (i = 0; i < LOADCOUNT; i++) {
		if ((f = open(files[i].name, O_RDONLY)) < 0) {
			perror(files[i].name);
			exit(1);
		}
		if ((c = read(f, loader.data, 32768)) < 2048) {
			fprintf(stderr, "file %s too short\n",
				files[i].name);
		}
		strcpy(loader.loadwhat,files[i].loadwhat);
		loader.datasize = c;
		if (ioctl(videofd, VIDIOCSMICROCODE, &loader) != 0) {
			fprintf(stderr, "%s %s %d\n",
				files[i].name, loader.loadwhat,
				loader.datasize);
			perror("ioctl");
		}
		usleep(100000);
	}
	close(f);
	exit(0);
}	/* main */
