/* 
 * Copyright (c) 1995, 1997 Jeffrey A. Uphoff
 * Modified by Olaf Kirch, Oct. 1996.
 *
 * NSM for Linux.
 */

#include <signal.h>
#include <unistd.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include "statd.h"
#include "version.h"

#ifndef lint
static char vcid[] = "$Id: statd.c,v 2.3 1998/08/25 22:06:24 juphoff Exp $";
#endif

short int restart = 0;
int	_rpcpmstart = 0;	/* flags for tirpc rpcgen */
int	_rpcfdtype = 0;
int	_rpcsvcdirty = 0;

extern void sm_prog_1 (struct svc_req *, register SVCXPRT);

#ifdef SIMULATIONS
extern void simulator (int, char **);
#endif


/*
 * Signal handler.
 */
static void 
killer (int sig)
{
  log (L_FATAL, "Caught signal %d, un-registering and exiting.", sig);
  pmap_unset (SM_PROG, SM_VERS);
  exit (0);
}


/* 
 * Entry routine/main loop.
 */
int
main (int argc, char **argv)
{
  int pid;

  log_init (argv[0]);

#ifdef SIMULATIONS
  if (argc > 1)
    simulator (--argc, ++argv);	/* simulator() does exit() */
#endif
  
  if ((pid = fork ()) < 0) {
    perror ("Could not fork");
    exit (1);
  } else if (pid != 0) {
    /* Parent. */
    exit (0);
  }
  /* Child. */
  signal (SIGHUP, killer);
  signal (SIGINT, killer);
  signal (SIGTERM, killer);

  for (;;) {
    pmap_unset (SM_PROG, SM_VERS);
    change_state ();
    shuffle_dirs ();
    notify_hosts ();
    ++restart;
    do_regist (SM_PROG, sm_prog_1);
/*     do_regist (SM_PROG, (__dispatch_fn_t)sm_prog_1); */
    my_svc_run ();		/* I rolled my own, Olaf made it better... */
  }
  return 0;
}


/*
 * Register services.
 */
void
do_regist(u_long prog, void (*sm_prog_1)())
/* do_regist(u_long prog, __dispatch_fn_t sm_prog_1) */
{
  SVCXPRT        *transp;

  if ((transp = svcudp_create(RPC_ANYSOCK)) == NULL)
    die("cannot create udp service.");

  if (!svc_register(transp, prog, SM_VERS, sm_prog_1, IPPROTO_UDP))
    die("unable to register (SM_PROG, SM_VERS, udp).");

  if ((transp = svctcp_create(RPC_ANYSOCK, 0, 0)) == NULL)
    die("cannot create tcp service.");

  if (!svc_register(transp, prog, SM_VERS, sm_prog_1, IPPROTO_TCP))
    die("unable to register (SM_PROG, SM_VERS, tcp).");
}
