%{!?release: %define release 0}
%{!?version: %define version 0.2.4}

%{!?uses_avahi:  %define uses_avahi 1}
%{!?uses_openssl:  %define uses_openssl 1}
%{!?uses_gcrypt: %define uses_gcrypt 0}

%if %{uses_gcrypt}
%define	uses_openssl 0
%endif

%define _libname libsipwitch0
%define _devname libsipwitch-devel

Name: sipwitch
Summary: "sipwitch" - SIP telephony server for secure phone systems
Version: %{version}
Release: %{release}%{?dist}
License: GPL v3 or later
URL: http://www.gnu.org/software/sipwitch
Group: Networking/Telephony
Source0: http://www.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 1.9.5
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: gcc-c++ pkgconfig
%if %uses_openssl
BuildRequires: openssl-devel
%endif
%if %uses_gcrypt
BuildRequires: libgcrypt-devel
%endif
%if %uses_avahi
BuildRequires: avahi-devel
%endif

%package -n %{_libname}
Group: System/Libraries
Summary: Runtime library for sipwitch server and plugins

%package -n %{_devname}
Requires: libucommon-devel >= 1.9.5
Requires: %{_libname} = %{version}
Group: Development/Libraries
Summary: Headers and static link library
Provides: %{name}-devel = %{version}-%{release}

%package plugin-zeroconf
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Zeroconf plugin for sipwitch

%package plugin-scripting
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Scripting plugin for sipwitch

%description
GNU SIP Witch is a pure SIP-based office telephone call server that supports
generic phone system features like call forwarding, hunt groups and call
distribution, call coverage and ring groups, holding, and call transfer, as
well as offering SIP specific capabilities such as presence and messaging. It
supports secure telephone extensions for making calls over the Internet, and
intercept/decrypt-free peer-to-peer audio and video extensions. It is not a SIP
proxy, a multi-protocol telephone server, or an IP-PBX, and does not try to
emulate Asterisk, FreeSWITCH, or Yate. 

%description -n %{_libname}
Runtime library needed for GNU SIP Witch server and plugins.

%description -n %{_devname}
Static link and header files for building plugins that interface with sipwitch.
This might be used for externally creating sipwitch modules, though normally
modules are found or added to the core distribution directly.  This may also
be for developing external application services which need to communicate with 
a running sipwitch daemon instance.

%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch events.

%prep
%setup
%build

%configure CXXFLAGS="$RPM_OPT_FLAGS" 
%{__make} %{?_smp_mflags} 

%install

%makeinstall
%{__strip} %{buildroot}/%{_libdir}/lib*.so.*.*
%{__strip} %{buildroot}/%{_libdir}/sipwitch/*.so
%{__strip} %{buildroot}/%{_sbindir}/*
%{__strip} %{buildroot}/%{_bindir}/*
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.a
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.la

# setup for automatic plugin loading.  
# Plugins selected by packages admin has installed.
echo "PLUGINS=auto" >>%{buildroot}/etc/sysconfig/sipwitch

%clean
%{__rm} -rf %{buildroot}

%files 
%defattr(-,root,root,-)
%doc README COPYING INSTALL NEWS FEATURES SUPPORT TODO NOTES AUTHORS ChangeLog
%{_sbindir}/*
%{_bindir}/*
%dir %{_libdir}/sipwitch
%config %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_sysconfdir}/init.d/sipwitch
%attr(0770,root,root) %dir %{_localstatedir}/lib/sipwitch
%attr(0660,root,root) %config %{_sysconfdir}/sipwitch.conf
%attr(0660,root,root) %config %{_sysconfdir}/sysconfig/sipwitch
%attr(0660,root,root) %config %{_localstatedir}/lib/sipwitch/*.xml
%attr(0770,root,root) %dir %{_localstatedir}/log/sipwitch

%files -n %{_libname}
%{_libdir}/lib*.so.*

%files plugin-zeroconf
%defattr(-,root,root,-)
%{_libdir}/sipwitch/zeroconf.*

%files plugin-scripting
%defattr(-,root,root,-)
%{_libdir}/sipwitch/scripting.*

%files -n %{_devname}
%defattr(-,root,root,-)
%{_libdir}/lib*.a
%{_libdir}/lib*.so
%{_libdir}/lib*.la
%dir %{_includedir}/sipwitch
%{_includedir}/sipwitch/*.h
%{_libdir}/pkgconfig/*.pc

%post -n %{_libname} -p /sbin/ldconfig

%postun -n %{_libname} -p /sbin/ldconfig

%post
if [ -x /sbin/chkconfig ] ; then /sbin/chkconfig --add sipwitch ; fi

%preun
if [ -x /sbin/chkconfig ] ; then /sbin/chkconfig --del sipwitch ; fi

%changelog
* Fri Jul 25 2008 - dyfet@gnutelephony.org
- spec file updated for plugins and new library naming.

* Mon Jul 21 2008 - dyfet@gnutelephony.org
- initial spec file distribution.


