/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.PrimIntegerVector;

public abstract class LongVector<E>
extends PrimIntegerVector<E> {
    long[] data;
    protected static long[] empty = new long[0];

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            long[] tmp = new long[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public long[] getBuffer() {
        return this.data;
    }

    @Override
    protected void setBuffer(Object buffer) {
        this.data = (long[])buffer;
    }

    @Override
    public final long longAt(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final long longAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final int intAtBuffer(int index) {
        return (int)this.data[index];
    }

    public final void setLongAt(int index, long value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.data[index] = value;
    }

    public final void setLongAtBuffer(int index, long value) {
        this.data[index] = value;
    }

    public void add(long v) {
        int sz = this.size();
        this.addSpace(sz, 1);
        this.setLongAt(sz, v);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        long[] d = this.data;
        while (--count >= 0) {
            d[start++] = 0L;
        }
    }
}

