export type Sqlite3Database = {
  internalDbHandle: any;
  exec(sqlStr: string): Promise<void>;
  prepare(stmtStr: string): Promise<Sqlite3Statement>;
  close(): Promise<void>;
};
export type Sqlite3Statement = {
  internalStatement: any;

  run(params?: BindParams): Promise<RunResult>;
  getAll(params?: BindParams): Promise<ResultRow[]>;
  getFirst(params?: BindParams): Promise<ResultRow | undefined>;
};

export interface RunResult {
  lastInsertRowid: number | bigint;
}

export type Sqlite3Value = string | Uint8Array | number | null | bigint;

export type BindParams = Record<string, Sqlite3Value | undefined>;
export type ResultRow = Record<string, Sqlite3Value>;

/**
 * Common interface that multiple sqlite3 bindings
 * (such as better-sqlite3 or qtart's sqlite3 bindings)
 * can adapt to.
 *
 * This does not expose full sqlite3 functionality, but just enough
 * to be used by our IndexedDB sqlite3 backend.
 */
export interface Sqlite3Interface {
  open(filename: string): Promise<Sqlite3Database>;
}
