#ifndef __GDK_SUPERWIN_H__
#define __GDK_SUPERWIN_H__

#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct _GdkSuperWin GdkSuperWin;

typedef void (*GdkSuperWinFunc) (GdkSuperWin *super_win,
				 XEvent      *event,
				 gpointer     data);

struct _GdkSuperWin
{
  GdkWindow *shell_window;
  GdkWindow *bin_window;

  /* Private */
  GList *translate_queue;
  
  GdkSuperWinFunc event_func;
  gpointer        func_data;
  GDestroyNotify  notify;

  GdkVisibilityState   visibility;
};

GdkSuperWin *gdk_superwin_new    (GdkWindow      *parent_window,
				  guint           x,
				  guint           y,
				  guint           width,
				  guint           height);
void         gdk_superwin_set_event_func (GdkSuperWin    *superwin,
					  GdkSuperWinFunc event_func,
					  gpointer        func_data,
					  GDestroyNotify  notify);
void         gdk_superwin_scroll (GdkSuperWin *superwin,
				  gint         dx,
				  gint         dy);
void         gdk_superwin_resize (GdkSuperWin *superwin,
				  gint         width,
				  gint         height);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif __GDK_SUPERWIN_H__

