/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitem_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"


/**
 * SECTION: gimpitem
 * @title: gimpitem
 * @short_description: Functions to manipulate items.
 *
 * Functions to manipulate items.
 **/


/**
 * gimp_item_is_valid:
 * @item_ID: The item to check.
 *
 * Returns TRUE if the item is valid.
 *
 * This procedure checks if the given item ID is valid and refers to an
 * existing item.
 *
 * Returns: Whether the item ID is valid.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_valid (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean valid = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-valid",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    valid = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return valid;
}

/**
 * gimp_item_get_image:
 * @item_ID: The item.
 *
 * Returns the item's image.
 *
 * This procedure returns the item's image.
 *
 * Returns: The item's image.
 *
 * Since: 2.8
 **/
gint32
gimp_item_get_image (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 image_ID = -1;

  return_vals = gimp_run_procedure ("gimp-item-get-image",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    image_ID = return_vals[1].data.d_image;

  gimp_destroy_params (return_vals, nreturn_vals);

  return image_ID;
}

/**
 * gimp_item_delete:
 * @item_ID: The item to delete.
 *
 * Delete a item.
 *
 * This procedure deletes the specified item. This must not be done if
 * the image containing this item was already deleted or if the item
 * was already removed from the image. The only case in which this
 * procedure is useful is if you want to get rid of a item which has
 * not yet been added to an image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_delete (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-delete",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_is_drawable:
 * @item_ID: The item.
 *
 * Returns whether the item is a drawable.
 *
 * This procedure returns TRUE if the specified item is a drawable.
 *
 * Returns: TRUE if the item is a drawable, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_drawable (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean drawable = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-drawable",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    drawable = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return drawable;
}

/**
 * gimp_item_is_layer:
 * @item_ID: The item.
 *
 * Returns whether the item is a layer.
 *
 * This procedure returns TRUE if the specified item is a layer.
 *
 * Returns: TRUE if the item is a layer, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_layer (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean layer = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-layer",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    layer = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer;
}

/**
 * gimp_item_is_text_layer:
 * @item_ID: The item.
 *
 * Returns whether the item is a text layer.
 *
 * This procedure returns TRUE if the specified item is a text layer.
 *
 * Returns: TRUE if the item is a text layer, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_text_layer (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean text_layer = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-text-layer",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    text_layer = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return text_layer;
}

/**
 * gimp_item_is_channel:
 * @item_ID: The item.
 *
 * Returns whether the item is a channel.
 *
 * This procedure returns TRUE if the specified item is a channel.
 *
 * Returns: TRUE if the item is a channel, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_channel (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean channel = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-channel",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    channel = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return channel;
}

/**
 * gimp_item_is_layer_mask:
 * @item_ID: The item.
 *
 * Returns whether the item is a layer mask.
 *
 * This procedure returns TRUE if the specified item is a layer mask.
 *
 * Returns: TRUE if the item is a layer mask, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_layer_mask (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean layer_mask = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-layer-mask",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    layer_mask = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_mask;
}

/**
 * gimp_item_is_selection:
 * @item_ID: The item.
 *
 * Returns whether the item is a selection.
 *
 * This procedure returns TRUE if the specified item is a selection.
 *
 * Returns: TRUE if the item is a selection, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_selection (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean selection = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-selection",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    selection = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return selection;
}

/**
 * gimp_item_is_vectors:
 * @item_ID: The item.
 *
 * Returns whether the item is a vectors.
 *
 * This procedure returns TRUE if the specified item is a vectors.
 *
 * Returns: TRUE if the item is a vectors, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_vectors (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean vectors = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-vectors",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    vectors = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return vectors;
}

/**
 * gimp_item_is_group:
 * @item_ID: The item.
 *
 * Returns whether the item is a group item.
 *
 * This procedure returns TRUE if the specified item is a group item
 * which can have children.
 *
 * Returns: TRUE if the item is a group, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_group (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean group = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-is-group",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    group = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return group;
}

/**
 * gimp_item_get_parent:
 * @item_ID: The item.
 *
 * Returns the item's parent item.
 *
 * This procedure returns the item's parent item, if any.
 *
 * Returns: The item's parent item.
 *
 * Since: 2.8
 **/
gint32
gimp_item_get_parent (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 parent_ID = -1;

  return_vals = gimp_run_procedure ("gimp-item-get-parent",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    parent_ID = return_vals[1].data.d_item;

  gimp_destroy_params (return_vals, nreturn_vals);

  return parent_ID;
}

/**
 * gimp_item_get_children:
 * @item_ID: The item.
 * @num_children: The item's number of children.
 *
 * Returns the item's list of children.
 *
 * This procedure returns the list of items which are children of the
 * specified item. The order is topmost to bottommost.
 *
 * Returns: The item's list of children.
 *
 * Since: 2.8
 **/
gint *
gimp_item_get_children (gint32  item_ID,
                        gint   *num_children)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint *child_ids = NULL;

  return_vals = gimp_run_procedure ("gimp-item-get-children",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  *num_children = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_children = return_vals[1].data.d_int32;
      child_ids = g_new (gint32, *num_children);
      memcpy (child_ids,
              return_vals[2].data.d_int32array,
              *num_children * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return child_ids;
}

/**
 * gimp_item_get_name:
 * @item_ID: The item.
 *
 * Get the name of the specified item.
 *
 * This procedure returns the specified item's name.
 *
 * Returns: The item name.
 *
 * Since: 2.8
 **/
gchar *
gimp_item_get_name (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-item-get-name",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_item_set_name:
 * @item_ID: The item.
 * @name: The new item name.
 *
 * Set the name of the specified item.
 *
 * This procedure sets the specified item's name.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_name (gint32       item_ID,
                    const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-name",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_visible:
 * @item_ID: The item.
 *
 * Get the visibility of the specified item.
 *
 * This procedure returns the specified item's visibility.
 *
 * Returns: The item visibility.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_visible (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean visible = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-get-visible",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    visible = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return visible;
}

/**
 * gimp_item_set_visible:
 * @item_ID: The item.
 * @visible: The new item visibility.
 *
 * Set the visibility of the specified item.
 *
 * This procedure sets the specified item's visibility.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_visible (gint32   item_ID,
                       gboolean visible)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-visible",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, visible,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_linked:
 * @item_ID: The item.
 *
 * Get the linked state of the specified item.
 *
 * This procedure returns the specified item's linked state.
 *
 * Returns: The item linked state (for moves).
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_linked (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean linked = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-get-linked",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    linked = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return linked;
}

/**
 * gimp_item_set_linked:
 * @item_ID: The item.
 * @linked: The new item linked state.
 *
 * Set the linked state of the specified item.
 *
 * This procedure sets the specified item's linked state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_linked (gint32   item_ID,
                      gboolean linked)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-linked",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, linked,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_lock_content:
 * @item_ID: The item.
 *
 * Get the 'lock content' state of the specified item.
 *
 * This procedure returns the specified item's lock content state.
 *
 * Returns: Whether the item's contents are locked.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_lock_content (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean lock_content = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-get-lock-content",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    lock_content = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return lock_content;
}

/**
 * gimp_item_set_lock_content:
 * @item_ID: The item.
 * @lock_content: The new item 'lock content' state.
 *
 * Set the 'lock content' state of the specified item.
 *
 * This procedure sets the specified item's lock content state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_lock_content (gint32   item_ID,
                            gboolean lock_content)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-lock-content",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, lock_content,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_lock_position:
 * @item_ID: The item.
 *
 * Get the 'lock position' state of the specified item.
 *
 * This procedure returns the specified item's lock position state.
 *
 * Returns: Whether the item's position is locked.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_get_lock_position (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean lock_position = FALSE;

  return_vals = gimp_run_procedure ("gimp-item-get-lock-position",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    lock_position = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return lock_position;
}

/**
 * gimp_item_set_lock_position:
 * @item_ID: The item.
 * @lock_position: The new item 'lock position' state.
 *
 * Set the 'lock position' state of the specified item.
 *
 * This procedure sets the specified item's lock position state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_lock_position (gint32   item_ID,
                             gboolean lock_position)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-lock-position",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, lock_position,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_color_tag:
 * @item_ID: The item.
 *
 * Get the color tag of the specified item.
 *
 * This procedure returns the specified item's color tag.
 *
 * Returns: The item's color tag.
 *
 * Since: 2.10
 **/
GimpColorTag
gimp_item_get_color_tag (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpColorTag color_tag = 0;

  return_vals = gimp_run_procedure ("gimp-item-get-color-tag",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    color_tag = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return color_tag;
}

/**
 * gimp_item_set_color_tag:
 * @item_ID: The item.
 * @color_tag: The new item color tag.
 *
 * Set the color tag of the specified item.
 *
 * This procedure sets the specified item's color tag.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_color_tag (gint32       item_ID,
                         GimpColorTag color_tag)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-color-tag",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, color_tag,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_tattoo:
 * @item_ID: The item.
 *
 * Get the tattoo of the specified item.
 *
 * This procedure returns the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: The item tattoo.
 *
 * Since: 2.8
 **/
gint
gimp_item_get_tattoo (gint32 item_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint tattoo = 0;

  return_vals = gimp_run_procedure ("gimp-item-get-tattoo",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    tattoo = return_vals[1].data.d_tattoo;

  gimp_destroy_params (return_vals, nreturn_vals);

  return tattoo;
}

/**
 * gimp_item_set_tattoo:
 * @item_ID: The item.
 * @tattoo: The new item tattoo.
 *
 * Set the tattoo of the specified item.
 *
 * This procedure sets the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_tattoo (gint32 item_ID,
                      gint   tattoo)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-set-tattoo",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_INT32, tattoo,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_attach_parasite:
 * @item_ID: The item.
 * @parasite: The parasite to attach to the item.
 *
 * Add a parasite to an item.
 *
 * This procedure attaches a parasite to an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_attach_parasite (gint32              item_ID,
                           const GimpParasite *parasite)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-attach-parasite",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_PARASITE, parasite,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_detach_parasite:
 * @item_ID: The item.
 * @name: The name of the parasite to detach from the item.
 *
 * Removes a parasite from an item.
 *
 * This procedure detaches a parasite from an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_detach_parasite (gint32       item_ID,
                           const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-item-detach-parasite",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_item_get_parasite:
 * @item_ID: The item.
 * @name: The name of the parasite to find.
 *
 * Look up a parasite in an item
 *
 * Finds and returns the parasite that is attached to an item.
 *
 * Returns: The found parasite.
 *
 * Since: 2.8
 **/
GimpParasite *
gimp_item_get_parasite (gint32       item_ID,
                        const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpParasite *parasite = NULL;

  return_vals = gimp_run_procedure ("gimp-item-get-parasite",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    parasite = gimp_parasite_copy (&return_vals[1].data.d_parasite);

  gimp_destroy_params (return_vals, nreturn_vals);

  return parasite;
}

/**
 * gimp_item_get_parasite_list:
 * @item_ID: The item.
 * @num_parasites: The number of attached parasites.
 *
 * List all parasites.
 *
 * Returns a list of all parasites currently attached the an item.
 *
 * Returns: The names of currently attached parasites. The returned
 * value must be freed with g_strfreev().
 *
 * Since: 2.8
 **/
gchar **
gimp_item_get_parasite_list (gint32  item_ID,
                             gint   *num_parasites)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **parasites = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-item-get-parasite-list",
                                    &nreturn_vals,
                                    GIMP_PDB_ITEM, item_ID,
                                    GIMP_PDB_END);

  *num_parasites = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_parasites = return_vals[1].data.d_int32;
      if (*num_parasites > 0)
        {
          parasites = g_new0 (gchar *, *num_parasites + 1);
          for (i = 0; i < *num_parasites; i++)
            parasites[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return parasites;
}
