/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <cairo.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpcolor/gimpcolor.h"
#include "libgimpconfig/gimpconfig.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpcontainer.h"
#include "core/gimpdashpattern.h"
#include "core/gimpdatafactory.h"
#include "core/gimpparamspecs.h"
#include "core/gimpstrokeoptions.h"
#include "paint/gimppaintoptions.h"
#include "plug-in/gimpplugin-context.h"
#include "plug-in/gimpplugin.h"
#include "plug-in/gimppluginmanager.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimppdbcontext.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
context_push_invoker (GimpProcedure         *procedure,
                      Gimp                  *gimp,
                      GimpContext           *context,
                      GimpProgress          *progress,
                      const GimpValueArray  *args,
                      GError               **error)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_push (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_pop_invoker (GimpProcedure         *procedure,
                     Gimp                  *gimp,
                     GimpContext           *context,
                     GimpProgress          *progress,
                     const GimpValueArray  *args,
                     GError               **error)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_pop (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_set_defaults_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
    gimp_config_reset (GIMP_CONFIG (context));

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GimpValueArray *
context_list_paint_methods_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  GimpValueArray *return_vals;
  gint32 num_paint_methods = 0;
  gchar **paint_methods = NULL;

  paint_methods = gimp_container_get_name_array (gimp->paint_info_list,
                                                 &num_paint_methods);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);

  g_value_set_int (gimp_value_array_index (return_vals, 1), num_paint_methods);
  gimp_value_take_stringarray (gimp_value_array_index (return_vals, 2), paint_methods, num_paint_methods);

  return return_vals;
}

static GimpValueArray *
context_get_paint_method_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpPaintInfo *paint_info = gimp_context_get_paint_info (context);

  if (paint_info)
    name = g_strdup (gimp_object_get_name (paint_info));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_paint_method_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintInfo *paint_info = gimp_pdb_get_paint_info (gimp, name, error);

      if (paint_info)
        gimp_context_set_paint_info (context, paint_info);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_stroke_method_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  GimpValueArray *return_vals;
  gint32 stroke_method = 0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "method", &stroke_method,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), stroke_method);

  return return_vals;
}

static GimpValueArray *
context_set_stroke_method_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  gint32 stroke_method;

  stroke_method = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "method", stroke_method,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_foreground_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  GimpValueArray *return_vals;
  GimpRGB foreground = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_foreground (context, &foreground);
  gimp_rgb_set_alpha (&foreground, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  gimp_value_set_rgb (gimp_value_array_index (return_vals, 1), &foreground);

  return return_vals;
}

static GimpValueArray *
context_set_foreground_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpRGB foreground;

  gimp_value_get_rgb (gimp_value_array_index (args, 0), &foreground);

  if (success)
    {
      gimp_rgb_set_alpha (&foreground, 1.0);
      gimp_context_set_foreground (context, &foreground);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_background_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  GimpValueArray *return_vals;
  GimpRGB background = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_background (context, &background);
  gimp_rgb_set_alpha (&background, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  gimp_value_set_rgb (gimp_value_array_index (return_vals, 1), &background);

  return return_vals;
}

static GimpValueArray *
context_set_background_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpRGB background;

  gimp_value_get_rgb (gimp_value_array_index (args, 0), &background);

  if (success)
    {
      gimp_rgb_set_alpha (&background, 1.0);
      gimp_context_set_background (context, &background);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_set_default_colors_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gimp_context_set_default_colors (context);

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GimpValueArray *
context_swap_colors_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gimp_context_swap_colors (context);

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GimpValueArray *
context_get_opacity_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  GimpValueArray *return_vals;
  gdouble opacity = 0.0;

  opacity = gimp_context_get_opacity (context) * 100.0;

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (gimp_value_array_index (return_vals, 1), opacity);

  return return_vals;
}

static GimpValueArray *
context_set_opacity_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  gdouble opacity;

  opacity = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      gimp_context_set_opacity (context, opacity / 100.0);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_paint_mode_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  GimpValueArray *return_vals;
  gint32 paint_mode = 0;

  paint_mode = gimp_context_get_paint_mode (context);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), paint_mode);

  return return_vals;
}

static GimpValueArray *
context_set_paint_mode_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  gint32 paint_mode;

  paint_mode = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      if (paint_mode == GIMP_OVERLAY_MODE)
        paint_mode = GIMP_SOFTLIGHT_MODE;

      gimp_context_set_paint_mode (context, paint_mode);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_width_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  GimpValueArray *return_vals;
  gdouble line_width = 0.0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "width", &line_width,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (gimp_value_array_index (return_vals, 1), line_width);

  return return_vals;
}

static GimpValueArray *
context_set_line_width_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  gdouble line_width;

  line_width = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "width", line_width,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_width_unit_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  GimpValueArray *return_vals;
  GimpUnit line_width_unit = 0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "unit", &line_width_unit,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (gimp_value_array_index (return_vals, 1), line_width_unit);

  return return_vals;
}

static GimpValueArray *
context_set_line_width_unit_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpUnit line_width_unit;

  line_width_unit = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "unit", line_width_unit,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_cap_style_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  GimpValueArray *return_vals;
  gint32 cap_style = 0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "cap-style", &cap_style,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), cap_style);

  return return_vals;
}

static GimpValueArray *
context_set_line_cap_style_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  gint32 cap_style;

  cap_style = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "cap-style", cap_style,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_join_style_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  GimpValueArray *return_vals;
  gint32 join_style = 0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "join-style", &join_style,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), join_style);

  return return_vals;
}

static GimpValueArray *
context_set_line_join_style_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  gint32 join_style;

  join_style = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "join-style", join_style,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_miter_limit_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  GimpValueArray *return_vals;
  gdouble miter_limit = 0.0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "miter-limit", &miter_limit,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (gimp_value_array_index (return_vals, 1), miter_limit);

  return return_vals;
}

static GimpValueArray *
context_set_line_miter_limit_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  gdouble miter_limit;

  miter_limit = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "miter-limit", miter_limit,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_dash_offset_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  GimpValueArray *return_vals;
  gdouble dash_offset = 0.0;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  g_object_get (options,
                "dash-offset", &dash_offset,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (gimp_value_array_index (return_vals, 1), dash_offset);

  return return_vals;
}

static GimpValueArray *
context_set_line_dash_offset_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  gdouble dash_offset;

  dash_offset = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      g_object_set (options,
                    "dash-offset", dash_offset,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_line_dash_pattern_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  GimpValueArray *return_vals;
  gint32 num_dashes = 0;
  gdouble *dashes = NULL;

  GimpStrokeOptions *options =
    gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

  GArray *pattern = gimp_stroke_options_get_dash_info (options);

  dashes = gimp_dash_pattern_to_double_array (pattern, &num_dashes);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);

  g_value_set_int (gimp_value_array_index (return_vals, 1), num_dashes);
  gimp_value_take_floatarray (gimp_value_array_index (return_vals, 2), dashes, num_dashes);

  return return_vals;
}

static GimpValueArray *
context_set_line_dash_pattern_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  gint32 num_dashes;
  const gdouble *dashes;

  num_dashes = g_value_get_int (gimp_value_array_index (args, 0));
  dashes = gimp_value_get_floatarray (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpStrokeOptions *options =
        gimp_pdb_context_get_stroke_options (GIMP_PDB_CONTEXT (context));

      GArray *pattern = NULL;

      if (num_dashes > 0)
        {
          pattern = gimp_dash_pattern_from_double_array (num_dashes, dashes);

          if (! pattern)
            success = FALSE;
        }

      if (success)
        gimp_stroke_options_take_dash_pattern (options, GIMP_DASH_CUSTOM, pattern);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    name = g_strdup (gimp_object_get_name (brush));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_brush_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpBrush *brush = gimp_pdb_get_brush (gimp, name, FALSE, error);

      if (brush)
        gimp_context_set_brush (context, brush);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_size_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-size", &size,
                   NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), size);

  return return_vals;
}

static GimpValueArray *
context_set_brush_size_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  gdouble size;

  size = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-size", (gdouble) size,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_set_brush_default_size_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        gimp_paint_options_set_default_brush_size (list->data, brush);

      g_list_free (options);
    }
  else
    {
      success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_aspect_ratio_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble aspect = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-aspect-ratio", &aspect,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), aspect);

  return return_vals;
}

static GimpValueArray *
context_set_brush_aspect_ratio_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  gdouble aspect;

  aspect = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-aspect-ratio", (gdouble) aspect,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_angle_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-angle", &angle,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), angle);

  return return_vals;
}

static GimpValueArray *
context_set_brush_angle_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  gdouble angle;

  angle = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-angle", (gdouble) angle,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_spacing_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble spacing = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-spacing", &spacing,
                   NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), spacing);

  return return_vals;
}

static GimpValueArray *
context_set_brush_spacing_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  gdouble spacing;

  spacing = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-spacing", (gdouble) spacing,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_set_brush_default_spacing_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        gimp_paint_options_set_default_brush_spacing (list->data, brush);

      g_list_free (options);
    }
  else
    {
      success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_hardness_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble hardness = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-hardness", &hardness,
                   NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), hardness);

  return return_vals;
}

static GimpValueArray *
context_set_brush_hardness_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  gdouble hardness;

  hardness = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-hardness", (gdouble) hardness,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_set_brush_default_hardness_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        gimp_paint_options_set_default_brush_hardness (list->data, brush);

      g_list_free (options);
    }
  else
    {
      success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_brush_force_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble force = 0.0;

  /* all options should have the same value, so pick a random one */
  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-paintbrush");

  if (options)
    g_object_get (options,
                  "brush-force", &force,
                   NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), force);

  return return_vals;
}

static GimpValueArray *
context_set_brush_force_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  gdouble force;

  force = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GList *options;
      GList *list;

      options = gimp_pdb_context_get_brush_options (GIMP_PDB_CONTEXT (context));

      for (list = options; list; list = g_list_next (list))
        g_object_set (list->data,
                      "brush-force", (gdouble) force,
                       NULL);

      g_list_free (options);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_dynamics_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpDynamics *dynamics = gimp_context_get_dynamics (context);

  if (dynamics)
    name = g_strdup (gimp_object_get_name (dynamics));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_dynamics_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpDynamics *dynamics = gimp_pdb_get_dynamics (gimp, name, FALSE, error);

      if (dynamics)
        gimp_context_set_dynamics (context, dynamics);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_pattern_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpPattern *pattern = gimp_context_get_pattern (context);

  if (pattern)
    name = g_strdup (gimp_object_get_name (pattern));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_pattern_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPattern *pattern = gimp_pdb_get_pattern (gimp, name, error);

      if (pattern)
        gimp_context_set_pattern (context, pattern);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_gradient_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpGradient *gradient = gimp_context_get_gradient (context);

  if (gradient)
    name = g_strdup (gimp_object_get_name (gradient));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_gradient_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpGradient *gradient = gimp_pdb_get_gradient (gimp, name, FALSE, error);

      if (gradient)
        gimp_context_set_gradient (context, gradient);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_palette_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpPalette *palette = gimp_context_get_palette (context);

  if (palette)
    name = g_strdup (gimp_object_get_name (palette));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_palette_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, FALSE, error);

      if (palette)
        gimp_context_set_palette (context, palette);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_font_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  GimpFont *font = gimp_context_get_font (context);

  if (font)
    name = g_strdup (gimp_object_get_name (font));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
context_set_font_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpFont *font = gimp_pdb_get_font (gimp, name, error);

      if (font)
        gimp_context_set_font (context, font);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_antialias_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  GimpValueArray *return_vals;
  gboolean antialias = FALSE;

  g_object_get (context,
                "antialias", &antialias,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (gimp_value_array_index (return_vals, 1), antialias);

  return return_vals;
}

static GimpValueArray *
context_set_antialias_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  gboolean antialias;

  antialias = g_value_get_boolean (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "antialias", antialias,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_feather_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  GimpValueArray *return_vals;
  gboolean feather = FALSE;

  g_object_get (context,
                "feather", &feather,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (gimp_value_array_index (return_vals, 1), feather);

  return return_vals;
}

static GimpValueArray *
context_set_feather_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  gboolean feather;

  feather = g_value_get_boolean (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "feather", feather,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_feather_radius_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  GimpValueArray *return_vals;
  gdouble feather_radius_x = 0.0;
  gdouble feather_radius_y = 0.0;

  g_object_get (context,
                "feather-radius-x", &feather_radius_x,
                "feather-radius-y", &feather_radius_y,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);

  g_value_set_double (gimp_value_array_index (return_vals, 1), feather_radius_x);
  g_value_set_double (gimp_value_array_index (return_vals, 2), feather_radius_y);

  return return_vals;
}

static GimpValueArray *
context_set_feather_radius_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  gdouble feather_radius_x;
  gdouble feather_radius_y;

  feather_radius_x = g_value_get_double (gimp_value_array_index (args, 0));
  feather_radius_y = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      g_object_set (context,
                    "feather-radius-x", feather_radius_x,
                    "feather-radius-y", feather_radius_y,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_sample_merged_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  GimpValueArray *return_vals;
  gboolean sample_merged = FALSE;

  g_object_get (context,
                "sample-merged", &sample_merged,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (gimp_value_array_index (return_vals, 1), sample_merged);

  return return_vals;
}

static GimpValueArray *
context_set_sample_merged_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  gboolean sample_merged;

  sample_merged = g_value_get_boolean (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "sample-merged", sample_merged,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_sample_criterion_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  GimpValueArray *return_vals;
  gint32 sample_criterion = 0;

  g_object_get (context,
                "sample-criterion", &sample_criterion,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), sample_criterion);

  return return_vals;
}

static GimpValueArray *
context_set_sample_criterion_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  gint32 sample_criterion;

  sample_criterion = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "sample-criterion", sample_criterion,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_sample_threshold_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  GimpValueArray *return_vals;
  gdouble sample_threshold = 0.0;

  g_object_get (context,
                "sample-threshold", &sample_threshold,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (gimp_value_array_index (return_vals, 1), sample_threshold);

  return return_vals;
}

static GimpValueArray *
context_set_sample_threshold_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  gdouble sample_threshold;

  sample_threshold = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "sample-threshold", sample_threshold,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_sample_threshold_int_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  GimpValueArray *return_vals;
  gint32 sample_threshold = 0;

  gdouble threshold;

  g_object_get (context,
                "sample-threshold", &threshold,
                NULL);

  sample_threshold = (gint) (threshold * 255.99);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (gimp_value_array_index (return_vals, 1), sample_threshold);

  return return_vals;
}

static GimpValueArray *
context_set_sample_threshold_int_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  gint32 sample_threshold;

  sample_threshold = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "sample-threshold", (gdouble) sample_threshold / 255.0,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_sample_transparent_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  GimpValueArray *return_vals;
  gboolean sample_transparent = FALSE;

  g_object_get (context,
                "sample-transparent", &sample_transparent,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (gimp_value_array_index (return_vals, 1), sample_transparent);

  return return_vals;
}

static GimpValueArray *
context_set_sample_transparent_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  gboolean sample_transparent;

  sample_transparent = g_value_get_boolean (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "sample-transparent", sample_transparent,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_interpolation_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  GimpValueArray *return_vals;
  gint32 interpolation = 0;

  g_object_get (context,
                "interpolation", &interpolation,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), interpolation);

  return return_vals;
}

static GimpValueArray *
context_set_interpolation_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  gint32 interpolation;

  interpolation = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "interpolation", interpolation,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_transform_direction_invoker (GimpProcedure         *procedure,
                                         Gimp                  *gimp,
                                         GimpContext           *context,
                                         GimpProgress          *progress,
                                         const GimpValueArray  *args,
                                         GError               **error)
{
  GimpValueArray *return_vals;
  gint32 transform_direction = 0;

  g_object_get (context,
                "transform-direction", &transform_direction,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), transform_direction);

  return return_vals;
}

static GimpValueArray *
context_set_transform_direction_invoker (GimpProcedure         *procedure,
                                         Gimp                  *gimp,
                                         GimpContext           *context,
                                         GimpProgress          *progress,
                                         const GimpValueArray  *args,
                                         GError               **error)
{
  gboolean success = TRUE;
  gint32 transform_direction;

  transform_direction = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "transform-direction", transform_direction,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_transform_resize_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  GimpValueArray *return_vals;
  gint32 transform_resize = 0;

  g_object_get (context,
                "transform-resize", &transform_resize,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (gimp_value_array_index (return_vals, 1), transform_resize);

  return return_vals;
}

static GimpValueArray *
context_set_transform_resize_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  gint32 transform_resize;

  transform_resize = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_set (context,
                    "transform-resize", transform_resize,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_transform_recursion_invoker (GimpProcedure         *procedure,
                                         Gimp                  *gimp,
                                         GimpContext           *context,
                                         GimpProgress          *progress,
                                         const GimpValueArray  *args,
                                         GError               **error)
{
  GimpValueArray *return_vals;
  gint32 transform_recursion = 0;

  transform_recursion = 3;

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (gimp_value_array_index (return_vals, 1), transform_recursion);

  return return_vals;
}

static GimpValueArray *
context_set_transform_recursion_invoker (GimpProcedure         *procedure,
                                         Gimp                  *gimp,
                                         GimpContext           *context,
                                         GimpProgress          *progress,
                                         const GimpValueArray  *args,
                                         GError               **error)
{
  gboolean success = TRUE;
  if (success)
    {
    }
  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_size_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "size", &size,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), size);

  return return_vals;
}

static GimpValueArray *
context_set_ink_size_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  gdouble size;

  size = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "size", size,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_angle_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "tilt-angle", &angle,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), angle);

  return return_vals;
}

static GimpValueArray *
context_set_ink_angle_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  gdouble angle;

  angle = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "tilt-angle", angle,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_size_sensitivity_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "size-sensitivity", &size,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), size);

  return return_vals;
}

static GimpValueArray *
context_set_ink_size_sensitivity_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  gdouble size;

  size = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "size-sensitivity", size,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_tilt_sensitivity_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble tilt = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "tilt-sensitivity", &tilt,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), tilt);

  return return_vals;
}

static GimpValueArray *
context_set_ink_tilt_sensitivity_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  gdouble tilt;

  tilt = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "tilt-sensitivity", tilt,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_speed_sensitivity_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble speed = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "vel-sensitivity", &speed,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), speed);

  return return_vals;
}

static GimpValueArray *
context_set_ink_speed_sensitivity_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  gdouble speed;

  speed = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "vel-sensitivity", speed,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_blob_type_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint32 type = 0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "blob-type", &type,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), type);

  return return_vals;
}

static GimpValueArray *
context_set_ink_blob_type_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  gint32 type;

  type = g_value_get_enum (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "blob-type", type,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_blob_aspect_ratio_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble aspect = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    g_object_get (options,
                  "blob-aspect", &aspect,
                  NULL);
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), aspect);

  return return_vals;
}

static GimpValueArray *
context_set_ink_blob_aspect_ratio_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  gdouble aspect;

  aspect = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "blob-aspect", aspect,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
context_get_ink_blob_angle_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  GimpPaintOptions *options =
    gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                        "gimp-ink");

  if (options)
    {
      g_object_get (options,
                    "blob-angle", &angle,
                    NULL);
      angle *= (180-0 / G_PI);
    }
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), angle);

  return return_vals;
}

static GimpValueArray *
context_set_ink_blob_angle_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  gdouble angle;

  angle = g_value_get_double (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-ink");

      if (options)
        g_object_set (options,
                      "blob-angle", (gdouble) angle * G_PI / 180.0,
                      NULL);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_context_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-context-push
   */
  procedure = gimp_procedure_new (context_push_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-push");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-push",
                                     "Pushes a context to the top of the plug-in's context stack.",
                                     "This procedure creates a new context by copying the current context. This copy becomes the new current context for the calling plug-in until it is popped again using 'gimp-context-pop'.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-pop
   */
  procedure = gimp_procedure_new (context_pop_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-pop");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-pop",
                                     "Pops the topmost context from the plug-in's context stack.",
                                     "This procedure removes the topmost context from the plug-in's context stack. The context that was active before the corresponding call to 'gimp-context-push' becomes the new current context of the plug-in.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-defaults
   */
  procedure = gimp_procedure_new (context_set_defaults_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-defaults");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-defaults",
                                     "Reset context settings to their default values.",
                                     "This procedure resets context settings used by various procedures to their default value. This procedure will usually be called after a context push so that a script which calls procedures affected by context settings will not be affected by changes in the global context.",
                                     "Kevin Cozens <kcozens@svn.gnome.org>",
                                     "Kevin Cozens",
                                     "2011",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-list-paint-methods
   */
  procedure = gimp_procedure_new (context_list_paint_methods_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-list-paint-methods");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-list-paint-methods",
                                     "Lists the available paint methods.",
                                     "This procedure lists the names of the available paint methods. Any of the results can be used for 'gimp-context-set-paint-method'.",
                                     "Simon Budig",
                                     "Simon Budig",
                                     "2007",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-paint-methods",
                                                          "num paint methods",
                                                          "The number of the available paint methods",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string_array ("paint-methods",
                                                                 "paint methods",
                                                                 "The names of the available paint methods",
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-method
   */
  procedure = gimp_procedure_new (context_get_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-method",
                                     "Retrieve the currently active paint method.",
                                     "This procedure returns the name of the currently active paint method.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active paint method",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-method
   */
  procedure = gimp_procedure_new (context_set_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-method",
                                     "Set the specified paint method as the active paint method.",
                                     "This procedure allows the active paint method to be set by specifying its name. The name is simply a string which corresponds to one of the names of the available paint methods. If there is no matching method found, this procedure will return an error. Otherwise, the specified method becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the paint method",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-stroke-method
   */
  procedure = gimp_procedure_new (context_get_stroke_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-stroke-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-stroke-method",
                                     "Retrieve the currently active stroke method.",
                                     "This procedure returns the currently active stroke method.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("stroke-method",
                                                      "stroke method",
                                                      "The active stroke method",
                                                      GIMP_TYPE_STROKE_METHOD,
                                                      GIMP_STROKE_LINE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-stroke-method
   */
  procedure = gimp_procedure_new (context_set_stroke_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-stroke-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-stroke-method",
                                     "Set the specified stroke method as the active stroke method.",
                                     "This procedure set the specified stroke method as the active stroke method. The new method will be used in all subsequent stroke operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("stroke-method",
                                                  "stroke method",
                                                  "The new stroke method",
                                                  GIMP_TYPE_STROKE_METHOD,
                                                  GIMP_STROKE_LINE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-foreground
   */
  procedure = gimp_procedure_new (context_get_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-foreground",
                                     "Get the current GIMP foreground color.",
                                     "This procedure returns the current GIMP foreground color. The foreground color is used in a variety of tools such as paint tools, blending, and bucket fill.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("foreground",
                                                        "foreground",
                                                        "The foreground color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-foreground
   */
  procedure = gimp_procedure_new (context_set_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-foreground",
                                     "Set the current GIMP foreground color.",
                                     "This procedure sets the current GIMP foreground color. After this is set, operations which use foreground such as paint tools, blending, and bucket fill will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("foreground",
                                                    "foreground",
                                                    "The foreground color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-background
   */
  procedure = gimp_procedure_new (context_get_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-background",
                                     "Get the current GIMP background color.",
                                     "This procedure returns the current GIMP background color. The background color is used in a variety of tools such as blending, erasing (with non-alpha images), and image filling.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("background",
                                                        "background",
                                                        "The background color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-background
   */
  procedure = gimp_procedure_new (context_set_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-background",
                                     "Set the current GIMP background color.",
                                     "This procedure sets the current GIMP background color. After this is set, operations which use background such as blending, filling images, clearing, and erasing (in non-alpha images) will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("background",
                                                    "background",
                                                    "The background color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-default-colors
   */
  procedure = gimp_procedure_new (context_set_default_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-default-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-default-colors",
                                     "Set the current GIMP foreground and background colors to black and white.",
                                     "This procedure sets the current GIMP foreground and background colors to their initial default values, black and white.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-swap-colors
   */
  procedure = gimp_procedure_new (context_swap_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-swap-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-swap-colors",
                                     "Swap the current GIMP foreground and background colors.",
                                     "This procedure swaps the current GIMP foreground and background colors, so that the new foreground color becomes the old background color and vice versa.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-opacity
   */
  procedure = gimp_procedure_new (context_get_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-opacity",
                                     "Get the opacity.",
                                     "This procedure returns the opacity setting. The return value is a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("opacity",
                                                        "opacity",
                                                        "The opacity",
                                                        0, 100, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-opacity
   */
  procedure = gimp_procedure_new (context_set_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-opacity",
                                     "Set the opacity.",
                                     "This procedure modifies the opacity setting. The value should be a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-mode
   */
  procedure = gimp_procedure_new (context_get_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-mode",
                                     "Get the paint mode.",
                                     "This procedure returns the paint-mode setting. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("paint-mode",
                                                      "paint mode",
                                                      "The paint mode",
                                                      GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                      GIMP_NORMAL_MODE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-mode
   */
  procedure = gimp_procedure_new (context_set_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-mode",
                                     "Set the paint mode.",
                                     "This procedure modifies the paint_mode setting.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-width
   */
  procedure = gimp_procedure_new (context_get_line_width_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-width");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-width",
                                     "Get the line width setting.",
                                     "This procedure returns the line width setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("line-width",
                                                        "line width",
                                                        "The line width setting",
                                                        0.0, 2000.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-width
   */
  procedure = gimp_procedure_new (context_set_line_width_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-width");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-width",
                                     "Set the line width setting.",
                                     "This procedure modifies the line width setting for stroking lines.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("line-width",
                                                    "line width",
                                                    "The line width setting",
                                                    0.0, 2000.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-width-unit
   */
  procedure = gimp_procedure_new (context_get_line_width_unit_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-width-unit");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-width-unit",
                                     "Get the line width unit setting.",
                                     "This procedure returns the line width unit setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_unit ("line-width-unit",
                                                         "line width unit",
                                                         "The line width unit setting",
                                                         TRUE,
                                                         FALSE,
                                                         GIMP_UNIT_PIXEL,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-width-unit
   */
  procedure = gimp_procedure_new (context_set_line_width_unit_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-width-unit");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-width-unit",
                                     "Set the line width unit setting.",
                                     "This procedure modifies the line width unit setting for stroking lines.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("line-width-unit",
                                                     "line width unit",
                                                     "The line width setting unit",
                                                     TRUE,
                                                     FALSE,
                                                     GIMP_UNIT_PIXEL,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-cap-style
   */
  procedure = gimp_procedure_new (context_get_line_cap_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-cap-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-cap-style",
                                     "Get the line cap style setting.",
                                     "This procedure returns the line cap style setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("cap-style",
                                                      "cap style",
                                                      "The line cap style setting",
                                                      GIMP_TYPE_CAP_STYLE,
                                                      GIMP_CAP_BUTT,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-cap-style
   */
  procedure = gimp_procedure_new (context_set_line_cap_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-cap-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-cap-style",
                                     "Set the line cap style setting.",
                                     "This procedure modifies the line cap style setting for stroking lines.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("cap-style",
                                                  "cap style",
                                                  "The line cap style setting",
                                                  GIMP_TYPE_CAP_STYLE,
                                                  GIMP_CAP_BUTT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-join-style
   */
  procedure = gimp_procedure_new (context_get_line_join_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-join-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-join-style",
                                     "Get the line join style setting.",
                                     "This procedure returns the line join style setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("join-style",
                                                      "join style",
                                                      "The line join style setting",
                                                      GIMP_TYPE_JOIN_STYLE,
                                                      GIMP_JOIN_MITER,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-join-style
   */
  procedure = gimp_procedure_new (context_set_line_join_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-join-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-join-style",
                                     "Set the line join style setting.",
                                     "This procedure modifies the line join style setting for stroking lines.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("join-style",
                                                  "join style",
                                                  "The line join style setting",
                                                  GIMP_TYPE_JOIN_STYLE,
                                                  GIMP_JOIN_MITER,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-miter-limit
   */
  procedure = gimp_procedure_new (context_get_line_miter_limit_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-miter-limit");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-miter-limit",
                                     "Get the line miter limit setting.",
                                     "This procedure returns the line miter limit setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("miter-limit",
                                                        "miter limit",
                                                        "The line miter limit setting",
                                                        0.0, 100.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-miter-limit
   */
  procedure = gimp_procedure_new (context_set_line_miter_limit_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-miter-limit");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-miter-limit",
                                     "Set the line miter limit setting.",
                                     "This procedure modifies the line miter limit setting for stroking lines.\n"
                                     "A mitered join is converted to a bevelled join if the miter would extend to a distance of more than (miter-limit * line-width) from the actual join point.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("miter-limit",
                                                    "miter limit",
                                                    "The line miter limit setting",
                                                    0.0, 100.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-dash-offset
   */
  procedure = gimp_procedure_new (context_get_line_dash_offset_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-dash-offset");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-dash-offset",
                                     "Get the line dash offset setting.",
                                     "This procedure returns the line dash offset setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("dash-offset",
                                                        "dash offset",
                                                        "The line dash offset setting",
                                                        0.0, 2000.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-dash-offset
   */
  procedure = gimp_procedure_new (context_set_line_dash_offset_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-dash-offset");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-dash-offset",
                                     "Set the line dash offset setting.",
                                     "This procedure modifies the line dash offset setting for stroking lines.\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("dash-offset",
                                                    "dash offset",
                                                    "The line dash offset setting",
                                                    0.0, 100.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-line-dash-pattern
   */
  procedure = gimp_procedure_new (context_get_line_dash_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-line-dash-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-line-dash-pattern",
                                     "Get the line dash pattern setting.",
                                     "This procedure returns the line dash pattern setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-dashes",
                                                          "num dashes",
                                                          "The number of dashes in the dash_pattern array",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_float_array ("dashes",
                                                                "dashes",
                                                                "The line dash pattern setting",
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-line-dash-pattern
   */
  procedure = gimp_procedure_new (context_set_line_dash_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-line-dash-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-line-dash-pattern",
                                     "Set the line dash pattern setting.",
                                     "This procedure modifies the line dash pattern setting for stroking lines.\n"
                                     "The unit of the dash pattern segments is the actual line width used for the stroke opertation, in other words a segment length of 1.0 results in a square segment shape (or gap shape).\n"
                                     "This setting affects the following procedures: 'gimp-edit-stroke', 'gimp-edit-stroke-vectors'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-dashes",
                                                      "num dashes",
                                                      "The number of dashes in the dash_pattern array",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("dashes",
                                                            "dashes",
                                                            "The line dash pattern setting",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush
   */
  procedure = gimp_procedure_new (context_get_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush",
                                     "Retrieve the currently active brush.",
                                     "This procedure returns the name of the currently active brush. All paint operations and stroke operations use this brush to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active brush",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush
   */
  procedure = gimp_procedure_new (context_set_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush",
                                     "Set the specified brush as the active brush.",
                                     "This procedure allows the active brush to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed brushes. If there is no matching brush found, this procedure will return an error. Otherwise, the specified brush becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the brush",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-size
   */
  procedure = gimp_procedure_new (context_get_brush_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-size",
                                     "Get brush size in pixels.",
                                     "Get the brush size in pixels for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("size",
                                                        "size",
                                                        "Brush size in pixels",
                                                        0, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-size
   */
  procedure = gimp_procedure_new (context_set_brush_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-size",
                                     "Set brush size in pixels.",
                                     "Set the brush size in pixels for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("size",
                                                    "size",
                                                    "Brush size in pixels",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-default-size
   */
  procedure = gimp_procedure_new (context_set_brush_default_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-default-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-default-size",
                                     "Set brush size to its default.",
                                     "Set the brush size to the default (max of width and height) for paintbrush, airbrush, or pencil tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-aspect-ratio
   */
  procedure = gimp_procedure_new (context_get_brush_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-aspect-ratio");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-aspect-ratio",
                                     "Get brush aspect ratio.",
                                     "Set the aspect ratio for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("aspect",
                                                        "aspect",
                                                        "Aspect ratio",
                                                        -20, 20, -20,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-aspect-ratio
   */
  procedure = gimp_procedure_new (context_set_brush_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-aspect-ratio");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-aspect-ratio",
                                     "Set brush aspect ratio.",
                                     "Set the aspect ratio for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("aspect",
                                                    "aspect",
                                                    "Aspect ratio",
                                                    -20, 20, -20,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-angle
   */
  procedure = gimp_procedure_new (context_get_brush_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-angle",
                                     "Get brush angle in degrees.",
                                     "Set the angle in degrees for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("angle",
                                                        "angle",
                                                        "Angle in degrees",
                                                        -180, 180, -180,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-angle
   */
  procedure = gimp_procedure_new (context_set_brush_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-angle",
                                     "Set brush angle in degrees.",
                                     "Set the angle in degrees for brush based paint tools.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "Angle in degrees",
                                                    -180, 180, -180,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-spacing
   */
  procedure = gimp_procedure_new (context_get_brush_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-spacing",
                                     "Get brush spacing as percent of size.",
                                     "Get the brush spacing as percent of size for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("spacing",
                                                        "spacing",
                                                        "Brush spacing as fraction of size",
                                                        0.01, 50.0, 0.01,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-spacing
   */
  procedure = gimp_procedure_new (context_set_brush_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-spacing",
                                     "Set brush spacing as percent of size.",
                                     "Set the brush spacing as percent of size for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("spacing",
                                                    "spacing",
                                                    "Brush spacing as fraction of size",
                                                    0.01, 50.0, 0.01,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-default-spacing
   */
  procedure = gimp_procedure_new (context_set_brush_default_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-default-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-default-spacing",
                                     "Set brush spacing to its default.",
                                     "Set the brush spacing to the default for paintbrush, airbrush, or pencil tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-hardness
   */
  procedure = gimp_procedure_new (context_get_brush_hardness_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-hardness");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-hardness",
                                     "Get brush hardness in paint options.",
                                     "Get the brush hardness for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("hardness",
                                                        "hardness",
                                                        "Brush hardness",
                                                        0.0, 1.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-hardness
   */
  procedure = gimp_procedure_new (context_set_brush_hardness_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-hardness");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-hardness",
                                     "Set brush hardness.",
                                     "Set the brush hardness for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("hardness",
                                                    "hardness",
                                                    "Brush hardness",
                                                    0.0, 1.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-default-hardness
   */
  procedure = gimp_procedure_new (context_set_brush_default_hardness_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-default-hardness");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-default-hardness",
                                     "Set brush spacing to its default.",
                                     "Set the brush spacing to the default for paintbrush, airbrush, or pencil tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush-force
   */
  procedure = gimp_procedure_new (context_get_brush_force_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush-force");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush-force",
                                     "Get brush force in paint options.",
                                     "Get the brush application force for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("force",
                                                        "force",
                                                        "Brush application force",
                                                        0.0, 1.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush-force
   */
  procedure = gimp_procedure_new (context_set_brush_force_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush-force");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush-force",
                                     "Set brush application force.",
                                     "Set the brush application force for brush based paint tools.",
                                     "Alexia Death",
                                     "Alexia Death",
                                     "2014",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("force",
                                                    "force",
                                                    "Brush application force",
                                                    0.0, 1.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-dynamics
   */
  procedure = gimp_procedure_new (context_get_dynamics_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-dynamics");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-dynamics",
                                     "Retrieve the currently active paint dynamics.",
                                     "This procedure returns the name of the currently active paint dynamics. All paint operations and stroke operations use this paint dynamics to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active paint dynamics",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-dynamics
   */
  procedure = gimp_procedure_new (context_set_dynamics_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-dynamics");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-dynamics",
                                     "Set the specified paint dynamics as the active paint dynamics.",
                                     "This procedure allows the active paint dynamics to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed paint dynamics. If there is no matching paint dynamics found, this procedure will return an error. Otherwise, the specified paint dynamics becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the paint dynamics",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-pattern
   */
  procedure = gimp_procedure_new (context_get_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-pattern",
                                     "Retrieve the currently active pattern.",
                                     "This procedure returns name of the the currently active pattern. All clone and bucket-fill operations with patterns will use this pattern to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active pattern",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-pattern
   */
  procedure = gimp_procedure_new (context_set_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-pattern",
                                     "Set the specified pattern as the active pattern.",
                                     "This procedure allows the active pattern to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed patterns. If there is no matching pattern found, this procedure will return an error. Otherwise, the specified pattern becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the pattern",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-gradient
   */
  procedure = gimp_procedure_new (context_get_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-gradient",
                                     "Retrieve the currently active gradient.",
                                     "This procedure returns the name of the currently active gradient.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active gradient",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-gradient
   */
  procedure = gimp_procedure_new (context_set_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-gradient",
                                     "Sets the specified gradient as the active gradient.",
                                     "This procedure lets you set the specified gradient as the active or \"current\" one. The name is simply a string which corresponds to one of the loaded gradients. If no matching gradient is found, this procedure will return an error. Otherwise, the specified gradient will become active and will be used for subsequent custom gradient operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the gradient",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-palette
   */
  procedure = gimp_procedure_new (context_get_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-palette",
                                     "Retrieve the currently active palette.",
                                     "This procedure returns the name of the the currently active palette.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active palette",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-palette
   */
  procedure = gimp_procedure_new (context_set_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-palette",
                                     "Set the specified palette as the active palette.",
                                     "This procedure allows the active palette to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed palettes. If no matching palette is found, this procedure will return an error. Otherwise, the specified palette becomes active and will be used in all subsequent palette operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the palette",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-font
   */
  procedure = gimp_procedure_new (context_get_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-font",
                                     "Retrieve the currently active font.",
                                     "This procedure returns the name of the currently active font.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active font",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-font
   */
  procedure = gimp_procedure_new (context_set_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-font",
                                     "Set the specified font as the active font.",
                                     "This procedure allows the active font to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed fonts. If no matching font is found, this procedure will return an error. Otherwise, the specified font becomes active and will be used in all subsequent font operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the font",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-antialias
   */
  procedure = gimp_procedure_new (context_get_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-antialias",
                                     "Get the antialias setting.",
                                     "This procedure returns the antialias setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("antialias",
                                                         "antialias",
                                                         "The antialias setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-antialias
   */
  procedure = gimp_procedure_new (context_set_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-antialias",
                                     "Set the antialias setting.",
                                     "This procedure modifies the antialias setting. If antialiasing is turned on, the edges of selected region will contain intermediate values which give the appearance of a sharper, less pixelized edge. This should be set as TRUE most of the time unless a binary-only selection is wanted.\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color', 'gimp-image-select-round-rectangle', 'gimp-image-select-ellipse', 'gimp-image-select-polygon', 'gimp-image-select-item'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("antialias",
                                                     "antialias",
                                                     "The antialias setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-feather
   */
  procedure = gimp_procedure_new (context_get_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-feather",
                                     "Get the feather setting.",
                                     "This procedure returns the feather setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("feather",
                                                         "feather",
                                                         "The feather setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-feather
   */
  procedure = gimp_procedure_new (context_set_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-feather",
                                     "Set the feather setting.",
                                     "This procedure modifies the feather setting. If the feather option is enabled, selections will be blurred before combining. The blur is a gaussian blur; its radii can be controlled using 'gimp-context-set-feather-radius'.\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color', 'gimp-image-select-rectangle', 'gimp-image-select-round-rectangle', 'gimp-image-select-ellipse', 'gimp-image-select-polygon', 'gimp-image-select-item'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("feather",
                                                     "feather",
                                                     "The feather setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-feather-radius
   */
  procedure = gimp_procedure_new (context_get_feather_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-feather-radius");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-feather-radius",
                                     "Get the feather radius setting.",
                                     "This procedure returns the feather radius setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("feather-radius-x",
                                                        "feather radius x",
                                                        "The horizontal feather radius",
                                                        0, 1000, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("feather-radius-y",
                                                        "feather radius y",
                                                        "The vertical feather radius",
                                                        0, 1000, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-feather-radius
   */
  procedure = gimp_procedure_new (context_set_feather_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-feather-radius");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-feather-radius",
                                     "Set the feather radius setting.",
                                     "This procedure modifies the feather radius setting.\n"
                                     "This setting affects all procedures that are affected by 'gimp-context-set-feather'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-x",
                                                    "feather radius x",
                                                    "The horizontal feather radius",
                                                    0, 1000, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-y",
                                                    "feather radius y",
                                                    "The vertical feather radius",
                                                    0, 1000, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-merged
   */
  procedure = gimp_procedure_new (context_get_sample_merged_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-merged");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-merged",
                                     "Get the sample merged setting.",
                                     "This procedure returns the sample merged setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("sample-merged",
                                                         "sample merged",
                                                         "The sample merged setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-merged
   */
  procedure = gimp_procedure_new (context_set_sample_merged_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-merged");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-merged",
                                     "Set the sample merged setting.",
                                     "This procedure modifies the sample merged setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls whether the pixel data from the specified drawable is used ('sample-merged' is FALSE), or the pixel data from the composite image ('sample-merged' is TRUE. This is equivalent to sampling for colors after merging all visible layers).\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "The sample merged setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-criterion
   */
  procedure = gimp_procedure_new (context_get_sample_criterion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-criterion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-criterion",
                                     "Get the sample criterion setting.",
                                     "This procedure returns the sample criterion setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("sample-criterion",
                                                      "sample criterion",
                                                      "The sample criterion setting",
                                                      GIMP_TYPE_SELECT_CRITERION,
                                                      GIMP_SELECT_CRITERION_COMPOSITE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-criterion
   */
  procedure = gimp_procedure_new (context_set_sample_criterion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-criterion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-criterion",
                                     "Set the sample criterion setting.",
                                     "This procedure modifies the sample criterion setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls how color similarity is determined. SELECT_CRITERION_COMPOSITE is the default value.\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("sample-criterion",
                                                  "sample criterion",
                                                  "The sample criterion setting",
                                                  GIMP_TYPE_SELECT_CRITERION,
                                                  GIMP_SELECT_CRITERION_COMPOSITE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-threshold
   */
  procedure = gimp_procedure_new (context_get_sample_threshold_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-threshold");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-threshold",
                                     "Get the sample threshold setting.",
                                     "This procedure returns the sample threshold setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("sample-threshold",
                                                        "sample threshold",
                                                        "The sample threshold setting",
                                                        0.0, 1.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-threshold
   */
  procedure = gimp_procedure_new (context_set_sample_threshold_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-threshold");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-threshold",
                                     "Set the sample threshold setting.",
                                     "This procedure modifies the sample threshold setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls what is \"sufficiently close\" to be considered a similar color. If the sample threshold has not been set explicitly, the default threshold set in gimprc will be used.\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("sample-threshold",
                                                    "sample threshold",
                                                    "The sample threshold setting",
                                                    0.0, 1.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-threshold-int
   */
  procedure = gimp_procedure_new (context_get_sample_threshold_int_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-threshold-int");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-threshold-int",
                                     "Get the sample threshold setting as an integer value.",
                                     "This procedure returns the sample threshold setting as an integer value. See 'gimp-context-get-sample-threshold'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("sample-threshold",
                                                          "sample threshold",
                                                          "The sample threshold setting",
                                                          0, 255, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-threshold-int
   */
  procedure = gimp_procedure_new (context_set_sample_threshold_int_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-threshold-int");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-threshold-int",
                                     "Set the sample threshold setting as an integer value.",
                                     "This procedure modifies the sample threshold setting as an integer value. See 'gimp-context-set-sample-threshold'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("sample-threshold",
                                                      "sample threshold",
                                                      "The sample threshold setting",
                                                      0, 255, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-transparent
   */
  procedure = gimp_procedure_new (context_get_sample_transparent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-transparent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-transparent",
                                     "Get the sample transparent setting.",
                                     "This procedure returns the sample transparent setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("sample-transparent",
                                                         "sample transparent",
                                                         "The sample transparent setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-transparent
   */
  procedure = gimp_procedure_new (context_set_sample_transparent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-transparent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-transparent",
                                     "Set the sample transparent setting.",
                                     "This procedure modifies the sample transparent setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls whether transparency is considered to be a unique selectable color. When this setting is TRUE, transparent areas can be selected or filled.\n"
                                     "This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-transparent",
                                                     "sample transparent",
                                                     "The sample transparent setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-interpolation
   */
  procedure = gimp_procedure_new (context_get_interpolation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-interpolation");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-interpolation",
                                     "Get the interpolation type.",
                                     "This procedure returns the interpolation setting. The return value is an integer which corresponds to the values listed in the argument description. If the interpolation has not been set explicitly by 'gimp-context-set-interpolation', the default interpolation set in gimprc will be used.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("interpolation",
                                                      "interpolation",
                                                      "The interpolation type",
                                                      GIMP_TYPE_INTERPOLATION_TYPE,
                                                      GIMP_INTERPOLATION_NONE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-interpolation
   */
  procedure = gimp_procedure_new (context_set_interpolation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-interpolation");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-interpolation",
                                     "Set the interpolation type.",
                                     "This procedure modifies the interpolation setting.\n"
                                     "This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix', 'gimp-image-scale', 'gimp-layer-scale'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "The interpolation type",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-direction
   */
  procedure = gimp_procedure_new (context_get_transform_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-direction",
                                     "Get the transform direction.",
                                     "This procedure returns the transform direction. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("transform-direction",
                                                      "transform direction",
                                                      "The transform direction",
                                                      GIMP_TYPE_TRANSFORM_DIRECTION,
                                                      GIMP_TRANSFORM_FORWARD,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-direction
   */
  procedure = gimp_procedure_new (context_set_transform_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-direction",
                                     "Set the transform direction.",
                                     "This procedure modifies the transform direction setting.\n"
                                     "This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "The transform direction",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-resize
   */
  procedure = gimp_procedure_new (context_get_transform_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-resize",
                                     "Get the transform resize type.",
                                     "This procedure returns the transform resize setting. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("transform-resize",
                                                      "transform resize",
                                                      "The transform resize type",
                                                      GIMP_TYPE_TRANSFORM_RESIZE,
                                                      GIMP_TRANSFORM_RESIZE_ADJUST,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-resize
   */
  procedure = gimp_procedure_new (context_set_transform_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-resize",
                                     "Set the transform resize type.",
                                     "This procedure modifies the transform resize setting. When transforming pixels, if the result of a transform operation has a different size than the original area, this setting determines how the resulting area is sized.\n"
                                     "This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-flip-simple', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-rotate-simple', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-resize",
                                                  "transform resize",
                                                  "The transform resize type",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-recursion
   */
  procedure = gimp_procedure_new (context_get_transform_recursion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-recursion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-recursion",
                                     "Deprecated: There is no replacement for this procedure.",
                                     "Deprecated: There is no replacement for this procedure.",
                                     "",
                                     "",
                                     "",
                                     "NONE");
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("transform-recursion",
                                                          "transform recursion",
                                                          "This returns always 3 and is meaningless",
                                                          1, G_MAXINT32, 1,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-recursion
   */
  procedure = gimp_procedure_new (context_set_transform_recursion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-recursion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-recursion",
                                     "Deprecated: There is no replacement for this procedure.",
                                     "Deprecated: There is no replacement for this procedure.",
                                     "",
                                     "",
                                     "",
                                     "NONE");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("transform-recursion",
                                                      "transform recursion",
                                                      "This parameter is ignored",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-size
   */
  procedure = gimp_procedure_new (context_get_ink_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-size",
                                     "Get ink blob size in pixels.",
                                     "Get the ink blob size in pixels for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("size",
                                                        "size",
                                                        "ink blob size in pixels",
                                                        0, 200, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-size
   */
  procedure = gimp_procedure_new (context_set_ink_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-size",
                                     "Set ink blob size in pixels.",
                                     "Set the ink blob size in pixels for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("size",
                                                    "size",
                                                    "ink blob size in pixels",
                                                    0, 200, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-angle
   */
  procedure = gimp_procedure_new (context_get_ink_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-angle",
                                     "Get ink angle in degrees.",
                                     "Get the ink angle in degrees for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("angle",
                                                        "angle",
                                                        "ink angle in degrees",
                                                        -90, 90, -90,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-angle
   */
  procedure = gimp_procedure_new (context_set_ink_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-angle",
                                     "Set ink angle in degrees.",
                                     "Set the ink angle in degrees for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "ink angle in degrees",
                                                    -90, 90, -90,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-size-sensitivity
   */
  procedure = gimp_procedure_new (context_get_ink_size_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-size-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-size-sensitivity",
                                     "Get ink size sensitivity.",
                                     "Get the ink size sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("size",
                                                        "size",
                                                        "ink size sensitivity",
                                                        0, 1, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-size-sensitivity
   */
  procedure = gimp_procedure_new (context_set_ink_size_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-size-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-size-sensitivity",
                                     "Set ink size sensitivity.",
                                     "Set the ink size sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("size",
                                                    "size",
                                                    "ink size sensitivity",
                                                    0, 1, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-tilt-sensitivity
   */
  procedure = gimp_procedure_new (context_get_ink_tilt_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-tilt-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-tilt-sensitivity",
                                     "Get ink tilt sensitivity.",
                                     "Get the ink tilt sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("tilt",
                                                        "tilt",
                                                        "ink tilt sensitivity",
                                                        0, 1, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-tilt-sensitivity
   */
  procedure = gimp_procedure_new (context_set_ink_tilt_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-tilt-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-tilt-sensitivity",
                                     "Set ink tilt sensitivity.",
                                     "Set the ink tilt sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("tilt",
                                                    "tilt",
                                                    "ink tilt sensitivity",
                                                    0, 1, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-speed-sensitivity
   */
  procedure = gimp_procedure_new (context_get_ink_speed_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-speed-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-speed-sensitivity",
                                     "Get ink speed sensitivity.",
                                     "Get the ink speed sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("speed",
                                                        "speed",
                                                        "ink speed sensitivity",
                                                        0, 1, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-speed-sensitivity
   */
  procedure = gimp_procedure_new (context_set_ink_speed_sensitivity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-speed-sensitivity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-speed-sensitivity",
                                     "Set ink speed sensitivity.",
                                     "Set the ink speed sensitivity for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("speed",
                                                    "speed",
                                                    "ink speed sensitivity",
                                                    0, 1, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-blob-type
   */
  procedure = gimp_procedure_new (context_get_ink_blob_type_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-blob-type");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-blob-type",
                                     "Get ink blob type.",
                                     "Get the ink blob type for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("type",
                                                      "type",
                                                      "Ink blob type",
                                                      GIMP_TYPE_INK_BLOB_TYPE,
                                                      GIMP_INK_BLOB_TYPE_CIRCLE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-blob-type
   */
  procedure = gimp_procedure_new (context_set_ink_blob_type_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-blob-type");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-blob-type",
                                     "Set ink blob type.",
                                     "Set the ink blob type for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("type",
                                                  "type",
                                                  "Ink blob type",
                                                  GIMP_TYPE_INK_BLOB_TYPE,
                                                  GIMP_INK_BLOB_TYPE_CIRCLE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-blob-aspect-ratio
   */
  procedure = gimp_procedure_new (context_get_ink_blob_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-blob-aspect-ratio");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-blob-aspect-ratio",
                                     "Get ink blob aspect ratio.",
                                     "Get the ink blob aspect ratio for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("aspect",
                                                        "aspect",
                                                        "ink blob aspect ratio",
                                                        1, 10, 1,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-blob-aspect-ratio
   */
  procedure = gimp_procedure_new (context_set_ink_blob_aspect_ratio_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-blob-aspect-ratio");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-blob-aspect-ratio",
                                     "Set ink blob aspect ratio.",
                                     "Set the ink blob aspect ratio for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("aspect",
                                                    "aspect",
                                                    "ink blob aspect ratio",
                                                    1, 10, 1,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-ink-blob-angle
   */
  procedure = gimp_procedure_new (context_get_ink_blob_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-ink-blob-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-ink-blob-angle",
                                     "Get ink blob angle in degrees.",
                                     "Get the ink blob angle in degrees for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("angle",
                                                        "angle",
                                                        "ink blob angle in degrees",
                                                        -180, 180, -180,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-ink-blob-angle
   */
  procedure = gimp_procedure_new (context_set_ink_blob_angle_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-ink-blob-angle");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-ink-blob-angle",
                                     "Set ink blob angle in degrees.",
                                     "Set the ink blob angle in degrees for ink tool.",
                                     "Ed Swartz",
                                     "Ed Swartz",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "ink blob angle in degrees",
                                                    -180, 180, -180,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
