/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "plug-in/plug-in-progress.h"
#include "plug-in/plug-in.h"

static ProcRecord progress_init_proc;
static ProcRecord progress_update_proc;
static ProcRecord progress_pulse_proc;
static ProcRecord progress_set_text_proc;
static ProcRecord progress_get_window_handle_proc;
static ProcRecord progress_install_proc;
static ProcRecord progress_uninstall_proc;
static ProcRecord progress_cancel_proc;

void
register_progress_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &progress_init_proc);
  procedural_db_register (gimp, &progress_update_proc);
  procedural_db_register (gimp, &progress_pulse_proc);
  procedural_db_register (gimp, &progress_set_text_proc);
  procedural_db_register (gimp, &progress_get_window_handle_proc);
  procedural_db_register (gimp, &progress_install_proc);
  procedural_db_register (gimp, &progress_uninstall_proc);
  procedural_db_register (gimp, &progress_cancel_proc);
}

static Argument *
progress_init_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  gchar *message;
  gint32 gdisplay;

  message = (gchar *) args[0].value.pdb_pointer;
  if (message && !g_utf8_validate (message, -1, NULL))
    success = FALSE;

  gdisplay = args[1].value.pdb_int;

  if (success)
    {
      if (gimp->current_plug_in && gimp->current_plug_in->open)
        {
          if (! gimp->no_interface)
            plug_in_progress_start (gimp->current_plug_in, message, gdisplay);
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&progress_init_proc, success);
}

static ProcArg progress_init_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "message",
    "Message to use in the progress dialog"
  },
  {
    GIMP_PDB_INT32,
    "gdisplay",
    "GimpDisplay to update progressbar in, or -1 for a seperate window"
  }
};

static ProcRecord progress_init_proc =
{
  "gimp-progress-init",
  "gimp-progress-init",
  "Initializes the progress bar for the current plug-in.",
  "Initializes the progress bar for the current plug-in. It is only valid to call this procedure from a plug-in.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  progress_init_inargs,
  0,
  NULL,
  { { progress_init_invoker } }
};

static Argument *
progress_update_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  gdouble percentage;

  percentage = args[0].value.pdb_float;

  if (gimp->current_plug_in && gimp->current_plug_in->open)
    {
      if (! gimp->no_interface)
        plug_in_progress_set_value (gimp->current_plug_in, percentage);
    }
  else
    success = FALSE;

  return procedural_db_return_args (&progress_update_proc, success);
}

static ProcArg progress_update_inargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "percentage",
    "Percentage of progress completed which must be between 0.0 and 1.0"
  }
};

static ProcRecord progress_update_proc =
{
  "gimp-progress-update",
  "gimp-progress-update",
  "Updates the progress bar for the current plug-in.",
  "Updates the progress bar for the current plug-in. It is only valid to call this procedure from a plug-in.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  progress_update_inargs,
  0,
  NULL,
  { { progress_update_invoker } }
};

static Argument *
progress_pulse_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  if (gimp->current_plug_in && gimp->current_plug_in->open)
    {
      if (! gimp->no_interface)
        plug_in_progress_pulse (gimp->current_plug_in);
    }
  else
    success = FALSE;
  return procedural_db_return_args (&progress_pulse_proc, success);
}

static ProcRecord progress_pulse_proc =
{
  "gimp-progress-pulse",
  "gimp-progress-pulse",
  "Pulses the progress bar for the current plug-in.",
  "Updates the progress bar for the current plug-in. It is only valid to call this procedure from a plug-in. Use this function instead of gimp_progress_update() if you cannot tell how much progress has been made. This usually causes the the progress bar to enter \"activity mode\", where a block bounces back and forth.",
  "Sven Neumann <sven@gimp.org>",
  "Sven Neumann",
  "2005",
  NULL,
  GIMP_INTERNAL,
  0,
  NULL,
  0,
  NULL,
  { { progress_pulse_invoker } }
};

static Argument *
progress_set_text_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  gchar *message;

  message = (gchar *) args[0].value.pdb_pointer;
  if (message && !g_utf8_validate (message, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->current_plug_in && gimp->current_plug_in->open)
        {
          if (! gimp->no_interface)
            plug_in_progress_set_text (gimp->current_plug_in, message);
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&progress_set_text_proc, success);
}

static ProcArg progress_set_text_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "message",
    "Message to use in the progress dialog"
  }
};

static ProcRecord progress_set_text_proc =
{
  "gimp-progress-set-text",
  "gimp-progress-set-text",
  "Changes the text in the progress bar for the current plug-in.",
  "This function allows to change the text in the progress bar for the current plug-in. Unlike gimp_progress_init() it does not change the displayed value.",
  "Sven Neumann <sven@gimp.org>",
  "Sven Neumann",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  progress_set_text_inargs,
  0,
  NULL,
  { { progress_set_text_invoker } }
};

static Argument *
progress_get_window_handle_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gint32 window = 0;

  if (gimp->current_plug_in && gimp->current_plug_in->open)
    {
      if (! gimp->no_interface)
        window = plug_in_progress_get_window (gimp->current_plug_in);
    }
  else
    success = FALSE;

  return_args = procedural_db_return_args (&progress_get_window_handle_proc, success);

  if (success)
    return_args[1].value.pdb_int = window;

  return return_args;
}

static ProcArg progress_get_window_handle_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "window",
    "The progress bar's toplevel window"
  }
};

static ProcRecord progress_get_window_handle_proc =
{
  "gimp-progress-get-window-handle",
  "gimp-progress-get-window-handle",
  "Returns the native window ID of the toplevel window this plug-in's progress is displayed in.",
  "This function returns the native window ID of the toplevel window this plug-in\'s progress is displayed in.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  0,
  NULL,
  1,
  progress_get_window_handle_outargs,
  { { progress_get_window_handle_invoker } }
};

static Argument *
progress_install_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  gchar *progress_callback;

  progress_callback = (gchar *) args[0].value.pdb_pointer;
  if (progress_callback == NULL || !g_utf8_validate (progress_callback, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->current_plug_in && gimp->current_plug_in->open)
        success = plug_in_progress_install (gimp->current_plug_in,
                                            progress_callback);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&progress_install_proc, success);
}

static ProcArg progress_install_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "progress-callback",
    "The callback PDB proc to call"
  }
};

static ProcRecord progress_install_proc =
{
  "gimp-progress-install",
  "gimp-progress-install",
  "Installs a progress callback for the current plug-in.",
  "This function installs a temporary PDB procedure which will handle all progress calls made by this plug-in and any procedure it calls. Calling this function multiple times simply replaces the old progress callbacks.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  progress_install_inargs,
  0,
  NULL,
  { { progress_install_invoker } }
};

static Argument *
progress_uninstall_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  gchar *progress_callback;

  progress_callback = (gchar *) args[0].value.pdb_pointer;
  if (progress_callback == NULL || !g_utf8_validate (progress_callback, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->current_plug_in && gimp->current_plug_in->open)
        success = plug_in_progress_uninstall (gimp->current_plug_in,
                                              progress_callback);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&progress_uninstall_proc, success);
}

static ProcArg progress_uninstall_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "progress-callback",
    "The name of the callback registered for this progress"
  }
};

static ProcRecord progress_uninstall_proc =
{
  "gimp-progress-uninstall",
  "gimp-progress-uninstall",
  "Uninstalls the progress callback for the current plug-in.",
  "This function uninstalls any progress callback installed with gimp_progress_install() before.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  progress_uninstall_inargs,
  0,
  NULL,
  { { progress_uninstall_invoker } }
};

static Argument *
progress_cancel_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  gchar *progress_callback;

  progress_callback = (gchar *) args[0].value.pdb_pointer;
  if (progress_callback == NULL || !g_utf8_validate (progress_callback, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->current_plug_in && gimp->current_plug_in->open)
        success = plug_in_progress_cancel (gimp->current_plug_in,
                                           progress_callback);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&progress_cancel_proc, success);
}

static ProcArg progress_cancel_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "progress-callback",
    "The name of the callback registered for this progress"
  }
};

static ProcRecord progress_cancel_proc =
{
  "gimp-progress-cancel",
  "gimp-progress-cancel",
  "Cancels a running progress.",
  "This function cancels the currently running progress.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  progress_cancel_inargs,
  0,
  NULL,
  { { progress_cancel_invoker } }
};
