/* This file is an image processing operation for GEGL
 *
 * GEGL is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * GEGL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Copyright 2006 Øyvind Kolås <pippin@gimp.org>
 *           2006 Dominik Ernst <dernst@gmx.de>
 *           2006 Kevin Cozens <kcozens@cvs.gnome.org>
 */
#if GEGL_CHANT_PROPERTIES

gegl_chant_path (path, "/tmp/romedalen.png", "Path of file to load.")

#else

#define GEGL_CHANT_SOURCE
#define GEGL_CHANT_NAME            bml 
#define GEGL_CHANT_DESCRIPTION     "Blue Marble loader"
#define GEGL_CHANT_SELF            "bml.c"
#define GEGL_CHANT_CATEGORIES      "hidden"
#define GEGL_CHANT_CLASS_INIT

#include "config.h"
#include "gegl-chant.h"

#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

static gboolean
process (GeglOperation *operation,
         gpointer       context_id)
{
  GeglChantOperation *self = GEGL_CHANT_OPERATION (operation);
  GeglBuffer   *output = NULL;
  gint fd;
  gint i;
  gint width = 86400;
  gint height = 43200;
  guchar        *pixels = g_malloc (3 * width);
  void *format = babl_format ("R'G'B' u8");
  GeglRectangle rect={0,0,width,1};
  output = g_object_new (GEGL_TYPE_BUFFER,
                         "format", format,
                         "x",      0,
                         "y",      0,
                         "width",  width,
                         "height", height,
                         NULL);
  fd = open (self->path, O_RDONLY);
  g_warning ("fd = %i", fd);
  for (i=0;i<height;i++)
    {
      gint nleft = width*3;
      while (nleft > 0)
        {
          gint err;
           do
             {
                err = read (fd, pixels + (width * 3) - nleft, nleft);
             }
           while ((err == -1) && ((errno == EAGAIN) || (errno == EINTR)));

           if (err <= 0)
             {
               g_message ("unable to read tile data from disk: "
                          "%s (%d/%d bytes read)",
                          g_strerror (errno), err, nleft);
               g_free (pixels);
               g_object_unref (output);
               return FALSE;
             }
           nleft -= err;
        }
      gegl_buffer_set (output, &rect, pixels, format);
      fprintf (stdout, "\r%i/%i (%f)     ", i, height, (1.0*i/height));
    }
  close (fd);

  g_free (pixels);
  gegl_operation_set_data (operation, context_id, "output", G_OBJECT (output));
  return  TRUE;
}


static GeglRectangle
get_defined_region (GeglOperation *operation)
{
  GeglRectangle result = {0,0,86400,43200};
  return result;
}


static void class_init (GeglOperationClass *operation_class)
{
  static gboolean done=FALSE;
  if (done)
    return;
  gegl_extension_handler_register (".bin", "bml");
  done = TRUE;
}

#endif
