
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseeditablesample.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseeditablesample.h>
#include        <bse/gsldatahandle.h>


#line 26 "bseeditablesample.proc"


/* --- open --- */
static GType type_id_open = 0;
static void
open_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bseeditablesample.proc"
 {
#line 30 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 29 "bseeditablesample.proc"
  proc->help = ("Open the sample for reading.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 35 "bseeditablesample.proc"
}  }
static BseErrorType
#line 35 "bseeditablesample.proc"
open_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 38 "bseeditablesample.proc"
{
#line 39 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  BseErrorType error;
  
#line 43 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 47 "bseeditablesample.proc"
  
  if (!esample->wchunk)
    error = BSE_ERROR_WAVE_NOT_FOUND;
  else if (esample->open_count)
    {
      esample->open_count++;
      error = BSE_ERROR_NONE;
    }
  else
    {
      error = gsl_wave_chunk_open (esample->wchunk);
      if (!error)
	esample->open_count++;
    }
  
#line 62 "bseeditablesample.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- close --- */
static GType type_id_close = 0;
static void
close_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 68 "bseeditablesample.proc"
 {
#line 70 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
#line 69 "bseeditablesample.proc"
  proc->help = ("Close an opened sample.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 72 "bseeditablesample.proc"
}  }
static BseErrorType
#line 72 "bseeditablesample.proc"
close_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 75 "bseeditablesample.proc"
{
#line 76 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 79 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || !esample->wchunk || !esample->open_count)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 83 "bseeditablesample.proc"
  
  esample->open_count--;
  if (!esample->open_count)
    gsl_wave_chunk_close (esample->wchunk);
  
  return BSE_ERROR_NONE;
}

/* --- get-length --- */
static GType type_id_get_length = 0;
static void
get_length_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 91 "bseeditablesample.proc"
 {
#line 93 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("length", NULL, "Number of values",
			 1, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 92 "bseeditablesample.proc"
  proc->help = ("Return the number of values in the sample.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 97 "bseeditablesample.proc"
}  }
static BseErrorType
#line 97 "bseeditablesample.proc"
get_length_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 100 "bseeditablesample.proc"
{
#line 101 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  GslDataCache *dcache = NULL;
  
#line 105 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 109 "bseeditablesample.proc"
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  sfi_value_set_int (out_values++, dcache ? gsl_data_handle_length (dcache->dhandle) : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-n-channels --- */
static GType type_id_get_n_channels = 0;
static void
get_n_channels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 117 "bseeditablesample.proc"
 {
#line 119 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("n-channels", NULL, "Number of channels",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 118 "bseeditablesample.proc"
  proc->help = ("Return the number of channels in the sample.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 123 "bseeditablesample.proc"
}  }
static BseErrorType
#line 123 "bseeditablesample.proc"
get_n_channels_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 126 "bseeditablesample.proc"
{
#line 127 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 130 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 134 "bseeditablesample.proc"
  
  sfi_value_set_int (out_values++, esample->wchunk ? esample->wchunk->n_channels : 1);
  
  return BSE_ERROR_NONE;
}

/* --- get-osc-freq --- */
static GType type_id_get_osc_freq = 0;
static void
get_osc_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 140 "bseeditablesample.proc"
 {
#line 142 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_freq_simple ("osc-freq", NULL, "Oscillator Frequency",
				      SFI_PARAM_DEFAULT);
#line 141 "bseeditablesample.proc"
  proc->help = ("Return the oscillator frequency for the sample.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 146 "bseeditablesample.proc"
}  }
static BseErrorType
#line 146 "bseeditablesample.proc"
get_osc_freq_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 149 "bseeditablesample.proc"
{
#line 150 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 153 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 157 "bseeditablesample.proc"
  
  sfi_value_set_real (out_values++, esample->wchunk ? esample->wchunk->osc_freq : BSE_KAMMER_FREQUENCY_f);
  
  return BSE_ERROR_NONE;
}

/* --- read-samples --- */
static GType type_id_read_samples = 0;
static void
read_samples_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 163 "bseeditablesample.proc"
 {
#line 165 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("voffset", NULL, "Value offset",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_fblock ("sample_block", NULL, "Block of samples", SFI_PARAM_DEFAULT),
#line 164 "bseeditablesample.proc"
  proc->help = ("Read a set of samples from a specific offset.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 170 "bseeditablesample.proc"
	  }  }
static BseErrorType
#line 170 "bseeditablesample.proc"
read_samples_exec (BseProcedureClass *proc,
		  const GValue      *in_values,
		  GValue            *out_values)
#line 173 "bseeditablesample.proc"
{
#line 174 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  guint              voffset = sfi_value_get_int (in_values++);
  GslDataCache *dcache = NULL;
  SfiFBlock *fblock;
  
#line 180 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset >= gsl_data_handle_length (dcache->dhandle))
    fblock = sfi_fblock_new_sized (1024);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, TRUE);
      guint i, l, dnode_length = dcache->node_size;
      
      l = dnode_length - (voffset - dnode->offset) + dcache->padding;
      l = MIN (l, gsl_data_handle_length (dcache->dhandle) - voffset);
      fblock = sfi_fblock_new_sized (l);
      for (i = 0; i < l; i++)
	fblock->values[i] = dnode->data[voffset - dnode->offset + i];
      gsl_data_cache_unref_node (dcache, dnode);
    }
  
#line 201 "bseeditablesample.proc"
  
  sfi_value_take_fblock (out_values++, fblock);
  
  return BSE_ERROR_NONE;
}

/* --- collect-stats --- */
static GType type_id_collect_stats = 0;
static void
collect_stats_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 207 "bseeditablesample.proc"
 {
#line 209 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("voffset", NULL, "Offset of first stat block",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_real ("offset_scale", NULL, "Factor to scale voffset increments with",
			  0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("block_size", NULL, "Block size to compute stat pairs from",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("stepping", NULL, "Stepping within a stat block",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("max_pairs", NULL, "Maximum number of (min, max) pairs to collect",
			 1, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_fblock ("sample_block", NULL, "Block of samples", SFI_PARAM_DEFAULT),
#line 208 "bseeditablesample.proc"
  proc->help = ("Collect statistics from sample blocks as (minimum, maximum) pairs.");
#line 24 "bseeditablesample.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 222 "bseeditablesample.proc"
	  }  }
static BseErrorType
#line 222 "bseeditablesample.proc"
collect_stats_exec (BseProcedureClass *proc,
		  const GValue      *in_values,
		  GValue            *out_values)
#line 225 "bseeditablesample.proc"
{
#line 226 "bseeditablesample.proc"
  
  BseEditableSample *esample    = bse_value_get_object (in_values++);
  guint              voffset    = sfi_value_get_int (in_values++);
  double             offs_scale = g_value_get_double (in_values++);
  guint              block_size = sfi_value_get_int (in_values++);
  guint              stepping   = sfi_value_get_int (in_values++);
  guint              max_pairs  = sfi_value_get_int (in_values++);
  GslDataCache *dcache = NULL;
  SfiFBlock *fblock;
  
#line 236 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || stepping < 1)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset + block_size > gsl_data_handle_length (dcache->dhandle))
    fblock = sfi_fblock_new_sized (max_pairs * 2);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, GSL_DATA_CACHE_DEMAND_LOAD);
      guint j, dnode_length = dcache->node_size;
      
      fblock = sfi_fblock_new_sized (max_pairs * 2);
      for (j = 0; j < max_pairs; j++)
	{
	  guint i, cur_offset = j * offs_scale;
	  gfloat min = +1, max = -1;
	  
#line 255 "bseeditablesample.proc"
	  
	  cur_offset /= stepping;
	  cur_offset = voffset + cur_offset * stepping;
	  
#line 259 "bseeditablesample.proc"
	  
	  for (i = cur_offset; i < cur_offset + block_size; i += stepping)
	    {
	      guint pos;
	      
	      if (i < dnode->offset || i >= dnode->offset + dnode_length)
		{
		  gsl_data_cache_unref_node (dcache, dnode);
#line 267 "bseeditablesample.proc"
		  
		  dnode = gsl_data_cache_ref_node (dcache, i, j == 0 ? GSL_DATA_CACHE_DEMAND_LOAD : GSL_DATA_CACHE_PEEK);
		  if (!dnode)
		    goto break_loops;
		}
	      pos = i - dnode->offset;
	      min = MIN (min, dnode->data[pos]);
	      max = MAX (max, dnode->data[pos]);
	    }
	  fblock->values[j * 2] = min;
	  fblock->values[j * 2 + 1] = max;
	}
      gsl_data_cache_unref_node (dcache, dnode);
    break_loops:
      sfi_fblock_resize (fblock, j * 2);
    }
  
#line 284 "bseeditablesample.proc"
  
  sfi_value_take_fblock (out_values++, fblock);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_open, "BseEditableSample+open", NULL, 0, open_setup, open_exec, NULL, "/Method/BseEditableSample/General/Open", { 0, }, },
  { &type_id_close, "BseEditableSample+close", NULL, 0, close_setup, close_exec, NULL, "/Method/BseEditableSample/General/Close", { 0, }, },
  { &type_id_get_length, "BseEditableSample+get-length", NULL, 0, get_length_setup, get_length_exec, NULL, "/Method/BseEditableSample/General/Get Length", { 0, }, },
  { &type_id_get_n_channels, "BseEditableSample+get-n-channels", NULL, 0, get_n_channels_setup, get_n_channels_exec, NULL, "/Method/BseEditableSample/General/Get N Channels", { 0, }, },
  { &type_id_get_osc_freq, "BseEditableSample+get-osc-freq", NULL, 0, get_osc_freq_setup, get_osc_freq_exec, NULL, "/Method/BseEditableSample/General/Get Osc Freq", { 0, }, },
  { &type_id_read_samples, "BseEditableSample+read-samples", NULL, 0, read_samples_setup, read_samples_exec, NULL, "/Method/BseEditableSample/General/Read Samples", { 0, }, },
  { &type_id_collect_stats, "BseEditableSample+collect-stats", NULL, 0, collect_stats_setup, collect_stats_exec, NULL, "/Method/BseEditableSample/General/Collect Stats", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
