
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsewave.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsewave.h>
#include        <bse/bseeditablesample.h>


#line 27 "bsewave.proc"


/* --- load-wave --- */
static GType type_id_load_wave = 0;
static void
load_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsewave.proc"
 {
#line 31 "bsewave.proc"
  *(in_pspecs++)    = g_param_spec_object ("wave", "Wave", "Wave object to store loaded contents",
                               BSE_TYPE_WAVE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("file_name", "File Name", "The wave file to read wave chunks from",
                               NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("wave_name", "Wave Name", "The name of the wave to read wave chunks from",
                               NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", "BSE error type",
                             BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                             BSE_PARAM_DEFAULT);
}
#line 30 "bsewave.proc"
  proc->help = "Load sample chunks from a wave file";
#line 24 "bsewave.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsewave.proc"
  proc->date = "2001";
#line 41 "bsewave.proc"
 }
static BseErrorType
#line 41 "bsewave.proc"
load_wave_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 44 "bsewave.proc"
{
#line 45 "bsewave.proc"
  
  BseWave *wave           = (BseWave*) g_value_get_object (in_values++);
  gchar *file_name        = g_value_get_string (in_values++);
  gchar *wave_name        = g_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 51 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave) || !file_name || !wave_name)
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_wave_load_wave_file (wave, file_name, wave_name, NULL, NULL);

#line 57 "bsewave.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- n-wave-chunks --- */
static GType type_id_n_wave_chunks = 0;
static void
n_wave_chunks_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 63 "bsewave.proc"
 {
#line 65 "bsewave.proc"
  *(in_pspecs++)    = g_param_spec_object ("wave", "Wave", NULL,
			       BSE_TYPE_WAVE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_chunks", "Number of Wave Chunks", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 64 "bsewave.proc"
  proc->help = "Get the number of wave chunks of a wave";
#line 24 "bsewave.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsewave.proc"
  proc->date = "2001";
#line 70 "bsewave.proc"
 }
static BseErrorType
#line 70 "bsewave.proc"
n_wave_chunks_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 73 "bsewave.proc"
{
#line 74 "bsewave.proc"
  
  BseWave *wave = g_value_get_object (in_values++);

#line 77 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 81 "bsewave.proc"
  
  g_value_set_uint (out_values++, wave->n_wchunks);

  return BSE_ERROR_NONE;
}

/* --- use-editable --- */
static GType type_id_use_editable = 0;
static void
use_editable_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 87 "bsewave.proc"
 {
#line 89 "bsewave.proc"
  *(in_pspecs++)    = g_param_spec_object ("wave", "Wave", NULL,
			       BSE_TYPE_WAVE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_uint ("chunk_index", NULL, "Index of chunk to edit",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("esample", NULL, "Editable sample",
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
}
#line 88 "bsewave.proc"
  proc->help = "Retrive an editable sample object for a wave chunk.";
#line 24 "bsewave.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsewave.proc"
  proc->date = "2001";
#line 96 "bsewave.proc"
 }
static BseErrorType
#line 96 "bsewave.proc"
use_editable_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 99 "bsewave.proc"
{
#line 100 "bsewave.proc"
  
  BseWave *wave     = g_value_get_object (in_values++);
  guint chunk_index = g_value_get_uint (in_values++);
  BseEditableSample *esample = NULL;
  GslWaveChunk *wchunk = NULL;

#line 106 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;

  wchunk = g_slist_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    {
      esample = g_object_new (BSE_TYPE_EDITABLE_SAMPLE, NULL);
      bse_editable_sample_set_wchunk (esample, wchunk);
      bse_item_use (BSE_ITEM (esample));
      g_object_unref (esample);
    }

#line 119 "bsewave.proc"
  
  g_value_set_object (out_values++, esample);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_load_wave, "BseWave+load-wave", NULL, 0, load_wave_setup, load_wave_exec, NULL, "/Method/BseWave/General/Load Wave", { 0, }, },
  { &type_id_n_wave_chunks, "BseWave+n-wave-chunks", NULL, 0, n_wave_chunks_setup, n_wave_chunks_exec, NULL, "/Method/BseWave/General/N Wave Chunks", { 0, }, },
  { &type_id_use_editable, "BseWave+use-editable", NULL, 0, use_editable_setup, use_editable_exec, NULL, "/Method/BseWave/General/Use Editable", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
