#include <bsw/bsw.h>
#include <bse/bse.h>
#include <bsw/bswglue.h>

/* "/Method/BseContainer/General/List Items" */
BswIterProxy* bsw_container_list_items (BswProxy  container)
{
  BswIterProxy* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_CONTAINER, container); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PROXY, 0);
  cl.proc_name = "BseContainer+list-items";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseContainer/General/Lookup Item" */
BswProxy  bsw_container_lookup_item (BswProxy  container,
                                     const gchar* uname)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_CONTAINER, container); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, uname); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseContainer+lookup-item";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Create Entry" */
guint     bsw_data_pocket_create_entry (BswProxy  data_pocket)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseDataPocket+create-entry";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Delete Entry" */
BswErrorType bsw_data_pocket_delete_entry (BswProxy  data_pocket,
                                           guint     entry_id)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseDataPocket+delete-entry";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get Float" */
gfloat    bsw_data_pocket_get_float (BswProxy  data_pocket,
                                     guint     entry_id,
                                     const gchar* name)
{
  gfloat    result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_float (&cl.ovalue, G_TYPE_FLOAT, 0);
  cl.proc_name = "BseDataPocket+get-float";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_float (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get Int" */
gint      bsw_data_pocket_get_int (BswProxy  data_pocket,
                                   guint     entry_id,
                                   const gchar* name)
{
  gint      result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_int (&cl.ovalue, G_TYPE_INT, 0);
  cl.proc_name = "BseDataPocket+get-int";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_int (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get N Entries" */
guint     bsw_data_pocket_get_n_entries (BswProxy  data_pocket)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseDataPocket+get-n-entries";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get Nth Entry Id" */
guint     bsw_data_pocket_get_nth_entry_id (BswProxy  data_pocket,
                                            guint     entry_index)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_index); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseDataPocket+get-nth-entry-id";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get Object" */
BswProxy  bsw_data_pocket_get_object (BswProxy  data_pocket,
                                      guint     entry_id,
                                      const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseDataPocket+get-object";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Get String" */
gchar* bsw_data_pocket_get_string (BswProxy  data_pocket,
                                   guint     entry_id,
                                   const gchar* name)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseDataPocket+get-string";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Set Float" */
BswErrorType bsw_data_pocket_set_float (BswProxy  data_pocket,
                                        guint     entry_id,
                                        const gchar* name,
                                        gfloat    number)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, number); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseDataPocket+set-float";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Set Int" */
BswErrorType bsw_data_pocket_set_int (BswProxy  data_pocket,
                                      guint     entry_id,
                                      const gchar* name,
                                      gint      number)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, number); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseDataPocket+set-int";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Set Object" */
BswErrorType bsw_data_pocket_set_object (BswProxy  data_pocket,
                                         guint     entry_id,
                                         const gchar* name,
                                         BswProxy  item)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseDataPocket+set-object";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseDataPocket/General/Set String" */
BswErrorType bsw_data_pocket_set_string (BswProxy  data_pocket,
                                         guint     entry_id,
                                         const gchar* name,
                                         const gchar* string)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_DATA_POCKET, data_pocket); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, entry_id); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, string); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseDataPocket+set-string";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Close" */
void bsw_editable_sample_close (BswProxy  esample)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseEditableSample+close";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseEditableSample/General/Collect Stats" */
BswValueBlock* bsw_editable_sample_collect_stats (BswProxy  esample,
                                                  guint     voffset,
                                                  gdouble   offset_scale,
                                                  guint     block_size,
                                                  guint     stepping,
                                                  guint     max_pairs)
{
  BswValueBlock* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, voffset); value++;
  value->g_type = 0; bsw_value_initset_double (value, G_TYPE_DOUBLE, offset_scale); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, block_size); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, stepping); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, max_pairs); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_VALUE_BLOCK, 0);
  cl.proc_name = "BseEditableSample+collect-stats";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Get Length" */
guint     bsw_editable_sample_get_length (BswProxy  esample)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseEditableSample+get-length";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Get N Channels" */
guint     bsw_editable_sample_get_n_channels (BswProxy  esample)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseEditableSample+get-n-channels";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Get Osc Freq" */
gfloat    bsw_editable_sample_get_osc_freq (BswProxy  esample)
{
  gfloat    result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_float (&cl.ovalue, G_TYPE_FLOAT, 0);
  cl.proc_name = "BseEditableSample+get-osc-freq";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_float (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Open" */
BswErrorType bsw_editable_sample_open (BswProxy  esample)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseEditableSample+open";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseEditableSample/General/Read Samples" */
BswValueBlock* bsw_editable_sample_read_samples (BswProxy  esample,
                                                 guint     voffset)
{
  BswValueBlock* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_EDITABLE_SAMPLE, esample); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, voffset); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_VALUE_BLOCK, 0);
  cl.proc_name = "BseEditableSample+read-samples";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Check Is A" */
gboolean  bsw_item_check_is_a (BswProxy  item,
                               const gchar* type_name)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, type_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseItem+check-is-a";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Common Ancestor" */
BswProxy  bsw_item_common_ancestor (BswProxy  item,
                                    BswProxy  item2)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item2); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseItem+common-ancestor";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Name" */
gchar* bsw_item_get_name (BswProxy  item)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseItem+get-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Name Or Type" */
gchar* bsw_item_get_name_or_type (BswProxy  item)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseItem+get-name-or-type";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Parent" */
BswProxy  bsw_item_get_parent (BswProxy  item)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseItem+get-parent";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Project" */
BswProxy  bsw_item_get_project (BswProxy  item)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseItem+get-project";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Seqid" */
guint     bsw_item_get_seqid (BswProxy  item)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseItem+get-seqid";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Type" */
gulong     bsw_item_get_type (BswProxy  item)
{
  gulong     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_ulong (&cl.ovalue, G_TYPE_ULONG, 0);
  cl.proc_name = "BseItem+get-type";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_ulong (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Type Blurb" */
gchar* bsw_item_get_type_blurb (BswProxy  item)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseItem+get-type-blurb";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Type Name" */
gchar* bsw_item_get_type_name (BswProxy  item)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseItem+get-type-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Get Uname Path" */
gchar* bsw_item_get_uname_path (BswProxy  item)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseItem+get-uname-path";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/List Proxies" */
BswIterProxy* bsw_item_list_proxies (BswProxy  item,
                                     const gchar* property)
{
  BswIterProxy* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, property); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PROXY, 0);
  cl.proc_name = "BseItem+list-proxies";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseItem/General/Unuse" */
void bsw_item_unuse (BswProxy  item)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseItem+unuse";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseItem/General/Use" */
BswProxy  bsw_item_use (BswProxy  item)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseItem+use";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseMidiNotifier/General/Current Time" */
guint     bsw_midi_notifier_current_time (BswProxy  midi_notifier)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_MIDI_NOTIFIER, midi_notifier); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseMidiNotifier+current-time";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseObject/General/Is A" */
gboolean  bsw_object_is_a (BswProxy  item,
                           const gchar* type_name)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_OBJECT, item); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, type_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseObject+is-a";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Change Note" */
BswErrorType bsw_part_change_note (BswProxy  part,
                                   guint     id,
                                   guint     tick,
                                   guint     duration,
                                   gint      note,
                                   gint      fine_tune,
                                   gfloat    velocity)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, id); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, fine_tune); value++;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, velocity); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BsePart+change-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Check Overlap" */
BswIterPartNote* bsw_part_check_overlap (BswProxy  part,
                                         guint     tick,
                                         guint     duration,
                                         gint      note)
{
  BswIterPartNote* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PART_NOTE, 0);
  cl.proc_name = "BsePart+check-overlap";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Delete Event" */
BswErrorType bsw_part_delete_event (BswProxy  part,
                                    guint     id)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, id); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BsePart+delete-event";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Deselect Event" */
void bsw_part_deselect_event (BswProxy  part,
                              guint     id)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, id); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+deselect-event";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BsePart/General/Deselect Rectangle" */
void bsw_part_deselect_rectangle (BswProxy  part,
                                  guint     tick,
                                  guint     duration,
                                  gint      min_note,
                                  gint      max_note)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, min_note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, max_note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+deselect-rectangle";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BsePart/General/Get Max Note" */
gint      bsw_part_get_max_note (BswProxy  part)
{
  gint      result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_int (&cl.ovalue, G_TYPE_INT, 0);
  cl.proc_name = "BsePart+get-max-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_int (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Get Max Tick" */
guint     bsw_part_get_max_tick (BswProxy  part)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BsePart+get-max-tick";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Get Min Note" */
gint      bsw_part_get_min_note (BswProxy  part)
{
  gint      result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_int (&cl.ovalue, G_TYPE_INT, 0);
  cl.proc_name = "BsePart+get-min-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_int (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Get Notes" */
BswIterPartNote* bsw_part_get_notes (BswProxy  part,
                                     guint     tick,
                                     gint      note)
{
  BswIterPartNote* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PART_NOTE, 0);
  cl.proc_name = "BsePart+get-notes";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Insert Note" */
guint     bsw_part_insert_note (BswProxy  part,
                                guint     tick,
                                guint     duration,
                                gint      note,
                                gint      fine_tune,
                                gfloat    velocity)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, fine_tune); value++;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, velocity); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BsePart+insert-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Is Selected Event" */
gboolean  bsw_part_is_selected_event (BswProxy  part,
                                      guint     id)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, id); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BsePart+is-selected-event";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/List Notes Crossing" */
BswIterPartNote* bsw_part_list_notes_crossing (BswProxy  part,
                                               guint     tick,
                                               guint     duration)
{
  BswIterPartNote* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PART_NOTE, 0);
  cl.proc_name = "BsePart+list-notes-crossing";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/List Selected Notes" */
BswIterPartNote* bsw_part_list_selected_notes (BswProxy  part)
{
  BswIterPartNote* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PART_NOTE, 0);
  cl.proc_name = "BsePart+list-selected-notes";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BsePart/General/Queue Notes Within" */
void bsw_part_queue_notes_within (BswProxy  part,
                                  guint     tick,
                                  guint     duration,
                                  gint      min_note,
                                  gint      max_note)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, min_note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, max_note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+queue-notes-within";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BsePart/General/Select Event" */
void bsw_part_select_event (BswProxy  part,
                            guint     id)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, id); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+select-event";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BsePart/General/Select Rectangle" */
void bsw_part_select_rectangle (BswProxy  part,
                                guint     tick,
                                guint     duration,
                                gint      min_note,
                                gint      max_note)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, min_note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, max_note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+select-rectangle";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BsePart/General/Select Rectangle Exclusive" */
void bsw_part_select_rectangle_exclusive (BswProxy  part,
                                          guint     tick,
                                          guint     duration,
                                          gint      min_note,
                                          gint      max_note)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, tick); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, duration); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, min_note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, max_note); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BsePart+select-rectangle-exclusive";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseProject/File/Restore" */
BswErrorType bsw_project_restore_from_file (BswProxy  project,
                                            const gchar* file_name)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, file_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseProject+restore-from-file";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/File/Store" */
BswErrorType bsw_project_store_bse (BswProxy  project,
                                    const gchar* file_name,
                                    gboolean  self_contained)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, file_name); value++;
  value->g_type = 0; bsw_value_initset_boolean (value, G_TYPE_BOOLEAN, self_contained); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseProject+store-bse";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Create Midi Synth" */
BswProxy  bsw_project_create_midi_synth (BswProxy  project,
                                         const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_MIDI_SYNTH, 0);
  cl.proc_name = "BseProject+create-midi-synth";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Create Snet" */
BswProxy  bsw_project_create_snet (BswProxy  project,
                                   const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_SNET, 0);
  cl.proc_name = "BseProject+create-snet";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Create Song" */
BswProxy  bsw_project_create_song (BswProxy  project,
                                   const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_SONG, 0);
  cl.proc_name = "BseProject+create-song";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Ensure Wave Repo" */
BswProxy  bsw_project_ensure_wave_repo (BswProxy  project)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_WAVE_REPO, 0);
  cl.proc_name = "BseProject+ensure-wave-repo";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Find Item" */
BswProxy  bsw_project_find_item (BswProxy  project,
                                 const gchar* uname_path)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, uname_path); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_ITEM, 0);
  cl.proc_name = "BseProject+find-item";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Get Data Pocket" */
BswProxy  bsw_project_get_data_pocket (BswProxy  project,
                                       const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_DATA_POCKET, 0);
  cl.proc_name = "BseProject+get-data-pocket";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Is Playing" */
gboolean  bsw_project_is_playing (BswProxy  project)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseProject+is-playing";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/List Uname Paths" */
BswIterString* bsw_project_list_uname_paths (BswProxy  project,
                                             gulong     item_type)
{
  BswIterString* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_ulong (value, G_TYPE_ULONG, item_type); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_STRING, 0);
  cl.proc_name = "BseProject+list-uname-paths";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseProject/General/Match Items By Uname" */
BswIterProxy* bsw_project_match_items_by_uname (BswProxy  project,
                                                gulong     item_type,
                                                const gchar* uname)
{
  BswIterProxy* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  value->g_type = 0; bsw_value_initset_ulong (value, G_TYPE_ULONG, item_type); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, uname); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_ITER_PROXY, 0);
  cl.proc_name = "BseProject+match-items-by-uname";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSNet/General/Can Create Source" */
BswErrorType bsw_snet_can_create_source (BswProxy  snet,
                                         const gchar* module_type)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SNET, snet); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, module_type); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSNet+can-create-source";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSNet/General/Create Source" */
BswProxy  bsw_snet_create_source (BswProxy  snet,
                                  const gchar* module_type)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SNET, snet); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, module_type); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_SOURCE, 0);
  cl.proc_name = "BseSNet+create-source";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSNet/General/Remove Source" */
BswErrorType bsw_snet_remove_source (BswProxy  snet,
                                     BswProxy  module)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SNET, snet); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSNet+remove-source";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSNet/General/Supports User Synths" */
gboolean  bsw_snet_supports_user_synths (BswProxy  snet)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SNET, snet); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseSNet+supports-user-synths";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseScriptControl/General/Get Action" */
gchar* bsw_script_control_get_action (BswProxy  script_control,
                                      guint     nth_action)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, nth_action); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseScriptControl+get-action";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseScriptControl/General/Get Action Blurb" */
gchar* bsw_script_control_get_action_blurb (BswProxy  script_control,
                                            guint     nth_action)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, nth_action); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseScriptControl+get-action-blurb";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseScriptControl/General/Get Action Name" */
gchar* bsw_script_control_get_action_name (BswProxy  script_control,
                                           guint     nth_action)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, nth_action); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseScriptControl+get-action-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseScriptControl/General/Kill" */
void bsw_script_control_kill (BswProxy  script_control)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseScriptControl+kill";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseScriptControl/General/N Actions" */
guint     bsw_script_control_n_actions (BswProxy  script_control)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseScriptControl+n-actions";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseScriptControl/General/Trigger Action" */
void bsw_script_control_trigger_action (BswProxy  script_control,
                                        const gchar* action)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, action); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseScriptControl+trigger-action";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseServer/General/Can Load" */
gboolean  bsw_server_can_load (BswProxy  server,
                               const gchar* file_name)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, file_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseServer+can-load";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Construct Note" */
BswNoteDescription* bsw_server_construct_note (BswProxy  server,
                                               guint     semitone,
                                               gint      octave,
                                               gint      fine_tune)
{
  BswNoteDescription* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, semitone); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, octave); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, fine_tune); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_NOTE_DESCRIPTION, 0);
  cl.proc_name = "BseServer+construct-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Describe Note" */
BswNoteDescription* bsw_server_describe_note (BswProxy  server,
                                              guint     note,
                                              gint      fine_tune)
{
  BswNoteDescription* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, fine_tune); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_NOTE_DESCRIPTION, 0);
  cl.proc_name = "BseServer+describe-note";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Get Midi Notifier" */
BswProxy  bsw_server_get_midi_notifier (BswProxy  server)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_MIDI_NOTIFIER, 0);
  cl.proc_name = "BseServer+get-midi-notifier";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Halt Project" */
void bsw_server_halt_project (BswProxy  server,
                              BswProxy  project)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseServer+halt-project";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseServer/General/N Scripts" */
guint     bsw_server_n_scripts (BswProxy  server)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseServer+n-scripts";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Note From Freq" */
BswNoteDescription* bsw_server_note_from_freq (BswProxy  server,
                                               gfloat    freq)
{
  BswNoteDescription* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, freq); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_NOTE_DESCRIPTION, 0);
  cl.proc_name = "BseServer+note-from-freq";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Note From String" */
BswNoteDescription* bsw_server_note_from_string (BswProxy  server,
                                                 const gchar* name)
{
  BswNoteDescription* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boxed (&cl.ovalue, BSW_TYPE_NOTE_DESCRIPTION, 0);
  cl.proc_name = "BseServer+note-from-string";
  bsw_proxy_call_procedure (&cl);
  result = g_value_dup_boxed (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Run Project" */
BswErrorType bsw_server_run_project (BswProxy  server,
                                     BswProxy  project)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PROJECT, project); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseServer+run-project";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseServer/General/Use New Project" */
BswProxy  bsw_server_use_new_project (BswProxy  server,
                                      const gchar* name)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SERVER, server); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_PROJECT, 0);
  cl.proc_name = "BseServer+use-new-project";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSong/General/Create Part" */
BswProxy  bsw_song_create_part (BswProxy  song)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SONG, song); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_PART, 0);
  cl.proc_name = "BseSong+create-part";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSong/General/Create Track" */
BswProxy  bsw_song_create_track (BswProxy  song)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SONG, song); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_TRACK, 0);
  cl.proc_name = "BseSong+create-track";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSong/General/Remove Part" */
void bsw_song_remove_part (BswProxy  song,
                           BswProxy  part)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SONG, song); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_PART, part); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseSong+remove-part";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseSong/General/Remove Track" */
void bsw_song_remove_track (BswProxy  song,
                            BswProxy  track)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SONG, song); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_TRACK, track); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseSong+remove-track";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseSource/General/Clear Inputs" */
void bsw_source_clear_inputs (BswProxy  module)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseSource+clear-inputs";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseSource/General/Clear Outputs" */
void bsw_source_clear_outputs (BswProxy  module)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseSource+clear-outputs";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseSource/General/Ichannel Blurb" */
gchar* bsw_source_ichannel_blurb (BswProxy  module,
                                  guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ichannel-blurb";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ichannel Cname" */
gchar* bsw_source_ichannel_cname (BswProxy  module,
                                  guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ichannel-cname";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ichannel Get N Joints" */
guint     bsw_source_ichannel_get_n_joints (BswProxy  module,
                                            guint     input_channel)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseSource+ichannel-get-n-joints";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ichannel Get Ochannel" */
guint     bsw_source_ichannel_get_ochannel (BswProxy  module,
                                            guint     input_channel,
                                            guint     input_joint)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_joint); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseSource+ichannel-get-ochannel";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ichannel Get Osource" */
BswProxy  bsw_source_ichannel_get_osource (BswProxy  module,
                                           guint     input_channel,
                                           guint     input_joint)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_joint); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_SOURCE, 0);
  cl.proc_name = "BseSource+ichannel-get-osource";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ichannel Name" */
gchar* bsw_source_ichannel_name (BswProxy  module,
                                 guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ichannel-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Is Joint Ichannel" */
gboolean  bsw_source_is_joint_ichannel (BswProxy  module,
                                        const gchar* input_channel)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseSource+is-joint-ichannel";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Is Joint Ichannel By Id" */
gboolean  bsw_source_is_joint_ichannel_by_id (BswProxy  module,
                                              guint     input_channel)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "BseSource+is-joint-ichannel-by-id";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/N Ichannels" */
guint     bsw_source_n_ichannels (BswProxy  module)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseSource+n-ichannels";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/N Ochannels" */
guint     bsw_source_n_ochannels (BswProxy  module)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseSource+n-ochannels";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ochannel Blurb" */
gchar* bsw_source_ochannel_blurb (BswProxy  module,
                                  guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ochannel-blurb";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ochannel Cname" */
gchar* bsw_source_ochannel_cname (BswProxy  module,
                                  guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ochannel-cname";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Ochannel Name" */
gchar* bsw_source_ochannel_name (BswProxy  module,
                                 guint     input_channel)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "BseSource+ochannel-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Set Input" */
BswErrorType bsw_source_set_input (BswProxy  imodule,
                                   const gchar* input_channel,
                                   BswProxy  omodule,
                                   const gchar* output_channel)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, imodule); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, input_channel); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, omodule); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, output_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSource+set-input";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Set Input By Id" */
BswErrorType bsw_source_set_input_by_id (BswProxy  imodule,
                                         guint     input_channel,
                                         BswProxy  omodule,
                                         guint     output_channel)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, imodule); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, omodule); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, output_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSource+set-input-by-id";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Unset Input" */
BswErrorType bsw_source_unset_input (BswProxy  module,
                                     const gchar* input_channel,
                                     BswProxy  omodule,
                                     const gchar* output_channel)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, input_channel); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, omodule); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, output_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSource+unset-input";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseSource/General/Unset Input By Id" */
BswErrorType bsw_source_unset_input_by_id (BswProxy  module,
                                           guint     input_channel,
                                           BswProxy  omodule,
                                           guint     output_channel)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, module); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, input_channel); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SOURCE, omodule); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, output_channel); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseSource+unset-input-by-id";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseWave/General/Load Wave" */
BswErrorType bsw_wave_load_wave (BswProxy  wave,
                                 const gchar* file_name,
                                 const gchar* wave_name)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE, wave); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, file_name); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, wave_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseWave+load-wave";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseWave/General/N Wave Chunks" */
guint     bsw_wave_n_wave_chunks (BswProxy  wave)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE, wave); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "BseWave+n-wave-chunks";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseWave/General/Use Editable" */
BswProxy  bsw_wave_use_editable (BswProxy  wave,
                                 guint     chunk_index)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE, wave); value++;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, chunk_index); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_EDITABLE_SAMPLE, 0);
  cl.proc_name = "BseWave+use-editable";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseWaveOsc/General/Pcm Seek Perc" */
void bsw_wave_osc_pcm_seek_perc (BswProxy  wosc,
                                 gfloat    pos_perc)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE_OSC, wosc); value++;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, pos_perc); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseWaveOsc+pcm-seek-perc";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseWaveOsc/General/Request Pcm Position" */
void bsw_wave_osc_request_pcm_position (BswProxy  wosc)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE_OSC, wosc); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseWaveOsc+request-pcm-position";
  bsw_proxy_call_procedure (&cl);
}

/* "/Method/BseWaveRepo/General/Load File" */
BswErrorType bsw_wave_repo_load_file (BswProxy  wave_repo,
                                      const gchar* file_name)
{
  BswErrorType result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE_REPO, wave_repo); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, file_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_enum (&cl.ovalue, BSE_TYPE_ERROR_TYPE, 0);
  cl.proc_name = "BseWaveRepo+load-file";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_enum (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Method/BseWaveRepo/General/Remove Wave" */
void bsw_wave_repo_remove_wave (BswProxy  wave_repo,
                                BswProxy  wave)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE_REPO, wave_repo); value++;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_WAVE, wave); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "BseWaveRepo+remove-wave";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Script Utils/Add Action" */
void bsw_script_add_action (const gchar* action,
                            const gchar* name,
                            const gchar* blurb)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, action); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, name); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, blurb); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-script-add-action";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Script Utils/Current Control" */
BswProxy  bsw_script_control (void)
{
  BswProxy  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_proxy (&cl.ovalue, BSE_TYPE_SCRIPT_CONTROL, 0);
  cl.proc_name = "bse-script-control";
  bsw_proxy_call_procedure (&cl);
  result = bsw_value_get_proxy (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Script Utils/Exit Message" */
void bsw_script_exit (BswUserMsgType msg_type,
                      const gchar* message)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_enum (value, BSE_TYPE_USER_MSG_TYPE, msg_type); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, message); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-script-exit";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Script Utils/Progress" */
void bsw_script_progress (gfloat    progress)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, progress); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-script-progress";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Script Utils/Remove Action" */
void bsw_script_remove_action (BswProxy  script_control,
                               const gchar* action)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_SCRIPT_CONTROL, script_control); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, action); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-script-remove-action";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Script Utils/Set Message" */
void bsw_script_set_msg (BswUserMsgType msg_type,
                         const gchar* message)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_enum (value, BSE_TYPE_USER_MSG_TYPE, msg_type); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, message); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-script-set-msg";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Toys/Hello World" */
void bsw_hello_world (void)
{
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  cl.n_ivalues = value - cl.ivalues;
  cl.proc_name = "bse-hello-world";
  bsw_proxy_call_procedure (&cl);
}

/* "/Proc/Toys/Randomizer" */
gchar* bsw_randomizer (gboolean  use_seed,
                       gint      seed)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_boolean (value, G_TYPE_BOOLEAN, use_seed); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, seed); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "bse-randomizer";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Utils/Error Blurb" */
gchar* bsw_error_blurb (BswErrorType error)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_enum (value, BSE_TYPE_ERROR_TYPE, error); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "bse-error-blurb";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Utils/Error Name" */
gchar* bsw_error_name (BswErrorType error)
{
  gchar* result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_enum (value, BSE_TYPE_ERROR_TYPE, error); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_string (&cl.ovalue, G_TYPE_STRING, 0);
  cl.proc_name = "bse-error-name";
  bsw_proxy_call_procedure (&cl);
  result = bsw_collector_get_string (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Utils/Glue/Check" */
gboolean  bsw_proxy_check (BswProxy  item,
                           const gchar* type_name)
{
  gboolean  result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_proxy (value, BSE_TYPE_ITEM, item); value++;
  value->g_type = 0; bsw_value_initset_string (value, G_TYPE_STRING, type_name); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_boolean (&cl.ovalue, G_TYPE_BOOLEAN, 0);
  cl.proc_name = "bse-proxy-check";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_boolean (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Utils/Notes/Note from Freq" */
guint     bsw_note_from_freq (gfloat    frequency)
{
  guint     result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_float (value, G_TYPE_FLOAT, frequency); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_uint (&cl.ovalue, G_TYPE_UINT, 0);
  cl.proc_name = "bse-note-from-freq";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_uint (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

/* "/Proc/Utils/Notes/Note to Freq" */
gfloat    bsw_note_to_freq (guint     note,
                            gint      fine_tune)
{
  gfloat    result;
  BswProxyProcedureCall cl;
  GValue *value = cl.ivalues;
  value->g_type = 0; bsw_value_initset_uint (value, G_TYPE_UINT, note); value++;
  value->g_type = 0; bsw_value_initset_int (value, G_TYPE_INT, fine_tune); value++;
  cl.n_ivalues = value - cl.ivalues;
  cl.ovalue.g_type = 0; bsw_value_initset_float (&cl.ovalue, G_TYPE_FLOAT, 0);
  cl.proc_name = "bse-note-to-freq";
  bsw_proxy_call_procedure (&cl);
  result = g_value_get_float (&cl.ovalue);
  g_value_unset (&cl.ovalue);
  return result;
}

GType bsw_type_wrap_SOURCE (void) { return BSE_TYPE_SOURCE; }
GType bsw_type_wrap_EDITABLE_SAMPLE (void) { return BSE_TYPE_EDITABLE_SAMPLE; }
GType bsw_type_wrap_SONG (void) { return BSE_TYPE_SONG; }
GType bsw_type_wrap_MIDI_SYNTH (void) { return BSE_TYPE_MIDI_SYNTH; }
GType bsw_type_wrap_SNET (void) { return BSE_TYPE_SNET; }
GType bsw_type_wrap_CONTAINER (void) { return BSE_TYPE_CONTAINER; }
GType bsw_type_wrap_OBJECT (void) { return BSE_TYPE_OBJECT; }
GType bsw_type_wrap_DATA_POCKET (void) { return BSE_TYPE_DATA_POCKET; }
GType bsw_type_wrap_MIDI_NOTIFIER (void) { return BSE_TYPE_MIDI_NOTIFIER; }
GType bsw_type_wrap_ERROR_TYPE (void) { return BSE_TYPE_ERROR_TYPE; }
GType bsw_type_wrap_SCRIPT_CONTROL (void) { return BSE_TYPE_SCRIPT_CONTROL; }
GType bsw_type_wrap_SUPER (void) { return BSE_TYPE_SUPER; }
GType bsw_type_wrap_WAVE_REPO (void) { return BSE_TYPE_WAVE_REPO; }
GType bsw_type_wrap_TRACK (void) { return BSE_TYPE_TRACK; }
GType bsw_type_wrap_WAVE (void) { return BSE_TYPE_WAVE; }
GType bsw_type_wrap_WAVE_OSC (void) { return BSE_TYPE_WAVE_OSC; }
GType bsw_type_wrap_PART (void) { return BSE_TYPE_PART; }
GType bsw_type_wrap_PROJECT (void) { return BSE_TYPE_PROJECT; }
GType bsw_type_wrap_ITEM (void) { return BSE_TYPE_ITEM; }
GType bsw_type_wrap_SERVER (void) { return BSE_TYPE_SERVER; }
GType bsw_type_wrap_USER_MSG_TYPE (void) { return BSE_TYPE_USER_MSG_TYPE; }
