
#############################################################################
## $Id: Authorization.pm 6298 2006-05-15 17:07:13Z spadkins $
#############################################################################

package App::Authorization;
$VERSION = (q$Revision: 6298 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Service;
@ISA = ( "App::Service" );

use strict;

=head1 NAME

App::Authorization - A service that is used by various application components to know what the current user is authorized to do

=head1 SYNOPSIS

    use App;

    $context = App->context();
    $auth = $context->service("Authorization");  # or ...
    $auth = $context->authorization();

=head1 DESCRIPTION

An Authorization service is a means by which
by various application components to know what the current user is authorized to do.

=cut

#############################################################################
# CLASS GROUP
#############################################################################

=head1 Class Group: Authorization

The following classes might be a part of the Authorization Class Group.

=over

=item * Class: App::Authorization

=item * Class: App::Authorization::SharedDatastore

=back

=cut

#############################################################################
# CLASS
#############################################################################

=head1 Class: App::Authorization

An Authorization service ...

 * Throws: App::Exception::Authorization
 * Since:  0.01

=head2 Class Design

...

=cut

#############################################################################
# CONSTRUCTOR METHODS
#############################################################################

=head1 Constructor Methods:

=cut

#############################################################################
# new()
#############################################################################

=head2 new()

The constructor is inherited from
L<C<App::Service>|App::Service/"new()">.

=cut

#############################################################################
# PUBLIC METHODS
#############################################################################

=head1 Public Methods:

=cut

#############################################################################
# is_authorized()
#############################################################################

=head2 is_authorized()

    * Signature: $auth->is_authorized($key);
    * Signature: $auth->is_authorized($key, $user);
    * Signature: $auth->is_authorized($key, $user, $options);
    * Signature: $auth->is_authorized($key, undef, $options);
    * Param:     $key               string
    * Param:     $user              string
    * Param:     $options           HASH
    * Return:    $is_auth           boolean
    * Throws:    App::Exception::Authorization
    * Since:     0.01

    Sample Usage: 

    $context = App->context();
    $auth = $context->service("Authorization");  # or ...
    $auth = $context->authorization();
    if ($auth->is_authorized("/main/data/edit")) {
        # ...
    }

=cut

sub is_authorized {
    &App::sub_entry if ($App::trace);
    my ($self, $key, $user, $options) = @_;
    $user = $self->{context}->user() if (!$user);
    my $is_auth = 0;

    $is_auth = 1;
    
    &App::sub_exit($is_auth) if ($App::trace);
    return($is_auth);
}

#############################################################################
# PROTECTED METHODS
#############################################################################

=head1 Protected Methods:

=cut

#############################################################################
# Method: service_type()
#############################################################################

=head2 service_type()

Returns 'Authorization';

    * Signature: $service_type = App::Authorization->service_type();
    * Param:     void
    * Return:    $service_type  string
    * Since:     0.01

    $service_type = $auth->service_type();

=cut

sub service_type () { 'Authorization'; }

=head1 ACKNOWLEDGEMENTS

 * Author:  Stephen Adkins <stephen.adkins@officevision.com>
 * License: This is free software. It is licensed under the same terms as Perl itself.

=head1 SEE ALSO

L<C<App::Context>|App::Context>,
L<C<App::Service>|App::Service>

=cut

1;

