package Google::Ads::AdWords::v201809::ImageDimensionInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %imageHeight_of :ATTR(:get<imageHeight>);
my %imageWidth_of :ATTR(:get<imageWidth>);
my %imageUrl_of :ATTR(:get<imageUrl>);

__PACKAGE__->_factory(
    [ qw(        imageHeight
        imageWidth
        imageUrl

    ) ],
    {
        'imageHeight' => \%imageHeight_of,
        'imageWidth' => \%imageWidth_of,
        'imageUrl' => \%imageUrl_of,
    },
    {
        'imageHeight' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'imageWidth' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'imageUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'imageHeight' => 'imageHeight',
        'imageWidth' => 'imageWidth',
        'imageUrl' => 'imageUrl',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::ImageDimensionInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ImageDimensionInfo from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Information about an image asset in specfic dimensions, either original or resized. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * imageHeight


=item * imageWidth


=item * imageUrl




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

