use ExtUtils::MakeMaker;
use Config;

WriteMakefile(
    'NAME' => "Tiger",
    'OBJECT' => q[tiger$(OBJ_EXT) _tiger$(OBJ_EXT)],
    VERSION_FROM => "Tiger.pm",
    'realclean'  => {'FILES' => 'endian.h'}
);

if (exists($Config{'byteorder'}) and defined($Config{'byteorder'})) {
  $directive = ($Config{'byteorder'} == 1234) ? '#undef' : '#define'; 
  if (-e 'endian.h') {
    warn "Warning: overwriting endian.h\n";
  } else {
    print "Writing endian.h for Tiger\n";
  }
  open(EOUT, '>endian.h')
    or die "error: unable to open 'endian.h' for writing\n";
  print EOUT <<"END_OF_STRING";


#ifndef ENDIAN_H
#define ENDIAN_H

/* Warning! this file is automatically generated; changes WILL disappear */

$directive BIG_ENDIAN_HOST

#endif /* ENDIAN_H */
END_OF_STRING
  close EOUT
    or die "error: unable to properly close 'endian.h'\n";
} else {
  die "error: the parameter 'byteorder' is not defined in Config.\n";
}
