use strict;
use warnings;
use ExtUtils::MakeMaker;

# buffering will ruin your day!
select STDERR; $|=1;
select STDOUT; $|=1;

# prereqs
my $EX_version   = 0;      # Exporter
my $DL_version   = 0;      # DynaLoader
my $EUMM_version = '6.64'; # ExtUtils::MakeMaker
my $TM_version   = 0;      # Test::More

my $UUID_version = get_uuidpm_version();

WriteMakefile1(
    'NAME'             => 'UUID',
    'AUTHOR'           => 'Rick Myers <jrm@cpan.org>',
    'VERSION_FROM'     => 'UUID.pm',
    'ABSTRACT_FROM'    => 'UUID.pm',
    'LICENSE'          => 'artistic_2',
    'MIN_PERL_VERSION' => '5.005',
    'LIBS'             => '',
    'NO_MYMETA'        => 1,
    'INC'              => '-Iulib -Iusrc -Iusrc/uuid',
    'OBJECT'           => '$(O_FILES)',
    'LDFROM'           => join( ' ', qw{
        ulib/uuid/clear.o ulib/uuid/compare.o ulib/uuid/copy.o
        ulib/uuid/gen_uuid.o ulib/uuid/isnull.o ulib/uuid/pack.o
        ulib/uuid/parse.o ulib/uuid/unpack.o ulib/uuid/unparse.o
        ulib/uuid/uuid_time.o UUID.o
    }),
    'C' => [qw{
        ulib/uuid/clear.c ulib/uuid/compare.c ulib/uuid/copy.c
        ulib/uuid/gen_uuid.c ulib/uuid/isnull.c ulib/uuid/pack.c
        ulib/uuid/parse.c ulib/uuid/unpack.c ulib/uuid/unparse.c
        ulib/uuid/uuid_time.c UUID.c
    }],
    'H' => [qw{
        ulib/EUMM.h ulib/config.h ulib/dirpaths.h ulib/uuid/uuid.h
        ulib/uuid/uuid_types.h
    }],
    'PREREQ_PM'          => {
        'DynaLoader' => $DL_version,
        'Exporter'   => $EX_version,
        'strict'     => 0,
        'vars'       => 0,
        'warnings'   => 0,
    },
    'CONFIGURE_REQUIRES' => {
        'Config'              => 0,
        'Devel::CheckLib'     => 0,
        'ExtUtils::MakeMaker' => $EUMM_version,
        'Text::Patch'         => 0,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'BUILD_REQUIRES' => {
        'ExtUtils::MakeMaker' => $EUMM_version,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'TEST_REQUIRES' => {
        'CPAN::Meta'         => 0,
        'DynaLoader'         => $DL_version,
        'Exporter'           => $EX_version,
        'ExtUtils::Manifest' => 0,
        'Test::More'         => $TM_version,
        'lib'                => 0,
        'strict'             => 0,
        'vars'               => 0,
        'warnings'           => 0,
    },
    'META_MERGE' => {
        'dynamic_config' => 0,
        'provides' => {
            'UUID' => {
                'file'    => 'UUID.pm',
                'version' => $UUID_version,
            },
        },
    },
    'realclean' => {
        'FILES' => join( ' ', sort qw{
            ulib perl.exe.stackdump
            LICENSE_new README_new README_new.bak
            META_new.json META_new.yml
            gen_uuid.c.new
        }),
    },
);

exit 0;

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "LICENSE not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{TEST_REQUIRES} if $eumm_version < 6.64;
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{NO_MYMETA} if $eumm_version < 6.58;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}

sub get_uuidpm_version {
    open my $fh, '<', 'UUID.pm' or die "open: UUID.pm: $!";
    while (<$fh>) {
        # $VERSION = '0.30_02';
        return $1
            if /^\$VERSION = '([\d\.\_]+)';$/;
    }
    return undef;
}


package MY;


#
# some of the commented stuff below is just too dangerous
# to fool with just to satisfy ocd.
#


##
## stop rebuilding manifypods.
## hold manifypods until later.
##
#sub manifypods {
#    my $t = shift->SUPER::manifypods(@_);
#    return $t if $t =~ /NOOP/;
#    # dont manifypods every.single.time.
#    $t =~ s{\\$}{\\\n\t\$(INST_MAN3DIR)/UUID.\$(MAN3EXT)\n\n\$(INST_MAN3DIR)/UUID.\$(MAN3EXT): \\}ms;
#    # delay manifypods until after lib build
#    $t =~ s{UUID\.pm$}{UUID.pm \$(INST_DYNAMIC)}ms;
#    $t;
#}


#
# add distlicense and distreadme prereqs.
## silence manicopy step during config.
#
sub distdir {
    my $t = shift->SUPER::distdir(@_);
    $t =~ s{^(distdir :).*$}{$1 create_distdir license metafile readme distlicense distmeta distreadme}m;
    #$t =~ s{PERLRUN}{NOECHO) \$(PERLRUN};
    $t;
}


#
# remove metafile comments in manifest.
# make metafiles authoritative to cpan.
#
sub distmeta {
    my $t = <<'EOS';
distmeta : create_distdir license metafile readme
	$(NOECHO) $(ECHO) Adding META.json to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.json' unless -f 'META.json';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.json' => '' }) }" \
	  -e "    or die \"Could not add META.json to MANIFEST: $$ @\"" --
	$(NOECHO) $(ECHO) Adding META.yml to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.yml' unless -f 'META.yml';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.yml' => '' }) }" \
	  -e "    or die \"Could not add META.yml to MANIFEST: $$ @\"" --
EOS
    $t;
}


#
# re-order meta generation
#
sub metafile {
    my $t = shift->SUPER::metafile_target(@_);
    $t =~ s{^(metafile :.*)$} {$1 meta_json meta_yml}m;
    $t =~ s{^(\s+.+Generating META.yml.*)$}  {\nmeta_yml :\n$1}m;
    $t =~ s{^(\s+.+Generating META.json.*)$} {\nmeta_json :\n$1}m;
    $t;
}


#
# add UUID_DISTTEST flag to 'make disttest'
#
sub dist_test {
    my $t = shift->SUPER::dist_test(@_);
    $t =~ s{ test }{ test UUID_DISTTEST=1 };
    $t;
}


#
# make TEST_VERBOSE=1 when AUTOMATED_TESTING=1
#
sub test {
    my $t = shift->SUPER::test(@_);
    if ( $ENV{AUTOMATED_TESTING}
        or $ENV{NONINTERACTIVE_TESTING}
        or $ENV{PERL_CPAN_REPORTER_CONFIG}
    ) {
        $t =~ s{TEST_VERBOSE=0}{TEST_VERBOSE=1}msg;
    }
    $t;
}


#
# silence "cp_nonempty" bootstrap.
# silence chmod bootstrap.
# remove implicit rules and make our own!
# (some seem to use the implicits first?)
#
sub xs_c { '' }
sub xs_o { '' }
sub dynamic_bs {
    my $t = shift->SUPER::dynamic_bs(@_);
    # delay Mkbootstrap() until after patch
    $t =~ s{^(\S+\s*:\s+.+$)} {$1 ulib\$(DFSEP)uuid\$(DFSEP)gen_uuid.c}m;
    $t;
}
sub perldepend {
    my $t = shift->SUPER::perldepend(@_);
    # delay UUID.c until after Mkbootrap.
    $t =~ s{$} { UUID.bs}s;
    # run xsubpp
    $t .= "\t". '$(XSUBPPRUN) $(XSPROTOARG) $(XSUBPPARGS) $(XSUBPP_EXTRA_ARGS) UUID.xs > UUID.xsc'. "\n";
    $t .= "\t". '$(MV) UUID.xsc UUID.c';
    $t;
}


#
# add distlicense and distreadme targets.
# add autoconf generated targets.
# add explicit object rules.
#
sub postamble {
    return <<'EOP';
# Software::License requires perl-5.12.0
license: create_distdir
	$(NOECHO) $(ECHO) Generating LICENSE
	$(NOECHO) $(RM_F) LICENSE_new
	$(NOECHO) $(ABSPERLRUN) -M5.12.0 -MSoftware::License::Artistic_2_0 \
	  -e 'print Software::License::Artistic_2_0->new({holder => "Rick Myers", year => sprintf("2014-%04d", 1900+(localtime(time))[5])})->fulltext' \
	  > LICENSE_new
	$(NOECHO) $(MV) LICENSE_new $(DISTVNAME)$(DFSEP)LICENSE

distlicense: create_distdir license
	$(NOECHO) $(ECHO) Adding LICENSE to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No LICENSE' unless -f 'LICENSE';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'LICENSE' => '' }) }" \
	  -e "    or die \"Could not add LICENSE to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST

readme: create_distdir
	$(NOECHO) $(ECHO) Generating README
	$(NOECHO) $(RM_F) README_new
	$(NOECHO) pod2text UUID.pm README_new
	$(NOECHO) $(ABSPERLRUN) -i.bak -pe's{\*(\S+)\*}{\1}g' README_new
	$(NOECHO) $(RM_F) README_new.bak
	$(NOECHO) $(MV) README_new $(DISTVNAME)$(DFSEP)README

distreadme: create_distdir readme
	$(NOECHO) $(ECHO) Adding README to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No README' unless -f 'README';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'README' => '' }) }" \
	  -e "    or die \"Could not add README to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST

ulib/.exists:
	$(NOECHO) $(MKPATH) ulib$(DFSEP)uuid$(DFSEP)
	$(NOECHO) $(TOUCH) ulib$(DFSEP).exists

ulib/EUMM.h: $(FIRST_MAKEFILE) ulib/.exists ubin/configure.pl
	$(NOECHO) $(ECHO) Generating EUMM.h
	$(NOECHO) $(RM_F) ulib$(DFSEP)EUMM.h.new ulib$(DFSEP)EUMM.h
	$(NOECHO) $(ABSPERLRUN) -l ubin$(DFSEP)configure.pl ulib$(DFSEP)EUMM.h.new
	$(NOECHO) $(MV) ulib$(DFSEP)EUMM.h.new ulib$(DFSEP)EUMM.h

ulib/config.h: ulib/.exists usrc/config.h.in ubin/subst.pl ulib/EUMM.h
	$(NOECHO) $(ECHO) Generating config.h
	$(NOECHO) $(RM_F) ulib$(DFSEP)config.h.new ulib$(DFSEP)config.h
	$(NOECHO) $(ABSPERLRUN) ubin$(DFSEP)subst.pl usrc$(DFSEP)config.h.in > ulib$(DFSEP)config.h.new
	$(NOECHO) $(ECHO) "#include <EUMM.h>" >> ulib$(DFSEP)config.h.new
	$(NOECHO) $(MV) ulib$(DFSEP)config.h.new ulib$(DFSEP)config.h

ulib/dirpaths.h: ulib/.exists usrc/dirpaths.h.in ubin/subst.pl ulib/config.h
	$(NOECHO) $(ECHO) Generating dirpaths.h
	$(NOECHO) $(RM_F) ulib$(DFSEP)dirpaths.h.new ulib$(DFSEP)dirpaths.h
	$(NOECHO) $(ABSPERLRUN) ubin$(DFSEP)subst.pl usrc$(DFSEP)dirpaths.h.in > ulib$(DFSEP)dirpaths.h.new
	$(NOECHO) $(MV) ulib$(DFSEP)dirpaths.h.new ulib$(DFSEP)dirpaths.h

ulib/uuid/uuid.h: ulib/.exists usrc/uuid/uuid.h.in ubin/subst.pl ulib/dirpaths.h
	$(NOECHO) $(ECHO) Generating uuid.h
	$(NOECHO) $(RM_F) ulib$(DFSEP)uuid$(DFSEP)uuid.h.new ulib$(DFSEP)uuid$(DFSEP)uuid.h
	$(NOECHO) $(ABSPERLRUN) ubin$(DFSEP)subst.pl usrc$(DFSEP)uuid$(DFSEP)uuid.h.in > ulib$(DFSEP)uuid$(DFSEP)uuid.h.new
	$(NOECHO) $(MV) ulib$(DFSEP)uuid$(DFSEP)uuid.h.new ulib$(DFSEP)uuid$(DFSEP)uuid.h

ulib/uuid/uuid_types.h: ulib/.exists usrc/uuid/uuid_types.h.in ubin/subst.pl ulib/uuid/uuid.h
	$(NOECHO) $(ECHO) Generating uuid_types.h
	$(NOECHO) $(RM_F) ulib$(DFSEP)uuid$(DFSEP)uuid_types.h.new ulib$(DFSEP)uuid$(DFSEP)uuid_types.h
	$(NOECHO) $(ABSPERLRUN) ubin$(DFSEP)subst.pl usrc$(DFSEP)uuid$(DFSEP)uuid_types.h.in > ulib$(DFSEP)uuid$(DFSEP)uuid_types.h.new
	$(NOECHO) $(ABSPERLRUN) -i.bak -pe "s!typedef signed char!typedef char!s" ulib$(DFSEP)uuid$(DFSEP)uuid_types.h.new
	$(NOECHO) $(RM_F) ulib$(DFSEP)uuid$(DFSEP)uuid_types.h.new.bak
	$(NOECHO) $(MV) ulib$(DFSEP)uuid$(DFSEP)uuid_types.h.new ulib$(DFSEP)uuid$(DFSEP)uuid_types.h

config :: $(H_FILES)
	$(NOECHO) $(NOOP)


#
# patch for solaris
#
ulib/uuid/gen_uuid.c: usrc/uuid/gen_uuid.c ubin/patch_genuuid.pl ulib/uuid/uuid_types.h
	$(NOECHO) $(ECHO) Patching gen_uuid.c
	$(NOECHO) $(RM_F) gen_uuid.c.new ulib$(DFSEP)uuid$(DFSEP)gen_uuid.c
	$(NOECHO) $(ABSPERLRUN) ubin$(DFSEP)patch_genuuid.pl usrc$(DFSEP)uuid$(DFSEP)gen_uuid.c > gen_uuid.c.new
	$(NOECHO) $(MV) gen_uuid.c.new ulib$(DFSEP)uuid$(DFSEP)gen_uuid.c

#
# apparently some versions of make dont support $<
#
UUID.o : $(XSUBPPDEPS) UUID.bs UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o UUID.o UUID.c

ulib/uuid/clear.o : usrc/uuid/clear.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)clear.o     usrc$(DFSEP)uuid$(DFSEP)clear.c

ulib/uuid/compare.o : usrc/uuid/compare.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)compare.o   usrc$(DFSEP)uuid$(DFSEP)compare.c

ulib/uuid/copy.o : usrc/uuid/copy.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)copy.o      usrc$(DFSEP)uuid$(DFSEP)copy.c

ulib/uuid/gen_uuid.o : ulib/uuid/gen_uuid.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)gen_uuid.o  ulib$(DFSEP)uuid$(DFSEP)gen_uuid.c

ulib/uuid/isnull.o : usrc/uuid/isnull.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)isnull.o    usrc$(DFSEP)uuid$(DFSEP)isnull.c

ulib/uuid/pack.o : usrc/uuid/pack.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)pack.o      usrc$(DFSEP)uuid$(DFSEP)pack.c

ulib/uuid/parse.o : usrc/uuid/parse.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)parse.o     usrc$(DFSEP)uuid$(DFSEP)parse.c

ulib/uuid/unpack.o : usrc/uuid/unpack.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)unpack.o    usrc$(DFSEP)uuid$(DFSEP)unpack.c

ulib/uuid/unparse.o : usrc/uuid/unparse.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)unparse.o   usrc$(DFSEP)uuid$(DFSEP)unparse.c

ulib/uuid/uuid_time.o : usrc/uuid/uuid_time.c UUID.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)uuid_time.o usrc$(DFSEP)uuid$(DFSEP)uuid_time.c

EOP
}
