#!/usr/bin/perl -w
use strict;
use ExtUtils::MakeMaker;

my $build_requires = {
        'ExtUtils::MakeMaker'   => 6.60,
        'Test::More'            => 0.94,
    };

my $prereq_pm = {
        'Acrux'                 => 0.07,
        'ExtUtils::MakeMaker'   => 6.60,
        'URI'                   => 1.00,
        'YAML'                  => 0,
        'IPC::Cmd'              => 0,
        'Text::ParseWords'      => 3.01,
    };

my $exefiles = [qw(
        bin/updater
    )];

WriteMakefile(
    'NAME'              => "App::Updater",
    'DISTNAME'          => "updater",
    'MIN_PERL_VERSION'  => 5.020001,
    'VERSION_FROM'      => 'lib/App/Updater.pm',
    'ABSTRACT_FROM'     => 'lib/App/Updater.pm',
    'BUILD_REQUIRES'    => $build_requires,
    'PREREQ_PM'         => $prereq_pm,
    'EXE_FILES'         => $exefiles,
    'AUTHOR'            => 'Serz Minus (Sergey Lepenkov) <abalama@cpan.org>',
    'LICENSE'           => 'perl',
    'META_MERGE'        => {
        'meta-spec' => {version => 2},
        prereqs     => {runtime => {requires => {perl => '5.020'}}},
        resources => {
            homepage    => 'https://www.serzik.com',
            license     => 'https://dev.perl.org/licenses',
            repository      => {
                    type => 'git',
                    url  => 'https://git.mns.suffit.org/minus/updater.git',
                    web  => 'https://git.mns.suffit.org/minus/updater',
                  },
        },
    },
    clean => {
        FILES => '*.tmp *.old',
    },
);

1;

__END__
