# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153523;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'geographic' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441141", "Sheffield",
"441371", "Great\ Dunmow",
"4413398", "Aboyne",
"4418906", "Ayton",
"441501", "Harthill",
"4419642", "Hornsea",
"441352", "Mold",
"441383", "Dunfermline",
"441380", "Devizes",
"442884", "Northern\ Ireland",
"441690", "Betws\-y\-Coed",
"4414306", "Market\ Weighton",
"442825", "Ballymena",
"441294", "Ardrossan",
"441205", "Boston",
"44114701", "Sheffield",
"441359", "Pakenham",
"441978", "Wrexham",
"4414232", "Harrogate",
"441268", "Basildon",
"4419754", "Alford\ \(Aberdeen\)",
"4413397", "Ballater",
"442311", "Southampton",
"441745", "Rhyl",
"442888", "Northern\ Ireland",
"4418909", "Ayton",
"441655", "Maybole",
"441759", "Pocklington",
"44161", "Manchester",
"441663", "New\ Mills",
"441771", "Maud",
"4418474", "Thurso",
"44117", "Bristol",
"441974", "Llanon",
"441642", "Middlesbrough",
"441264", "Andover",
"441630", "Market\ Drayton",
"441780", "Stamford",
"441633", "Newport",
"4415073", "Louth",
"441298", "Buxton",
"4414309", "Market\ Weighton",
"441752", "Plymouth",
"441234", "Bedford",
"441206", "Colchester",
"441361", "Duns",
"441346", "Fraserburgh",
"4414305", "North\ Cave",
"442826", "Northern\ Ireland",
"4418511", "Great\ Bernera\/Stornoway",
"441905", "Worcester",
"441548", "Kingsbridge",
"441278", "Bridgwater",
"4412292", "Barrow\-in\-Furness",
"4418905", "Ayton",
"441968", "Penicuik",
"441823", "Taunton",
"441747", "Shaftesbury",
"441994", "St\ Clears",
"441844", "Thame",
"441938", "Welshpool",
"44238", "Southampton",
"441207", "Consett",
"4416863", "Llanidloes",
"441929", "Wareham",
"442827", "Ballymoney",
"441347", "Easingwold",
"441444", "Haywards\ Heath",
"441420", "Alton",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"4414343", "Haltwhistle",
"441656", "Bridgend",
"441848", "Thornhill",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441934", "Weston\-super\-Mare",
"44113", "Leeds",
"441520", "Lochcarron",
"441544", "Kington",
"441274", "Bradford",
"441922", "Walsall",
"441746", "Bridgnorth",
"441761", "Temple\ Cloud",
"44116", "Leicester",
"441673", "Market\ Rasen",
"441670", "Morpeth",
"441913", "Durham",
"441995", "Garstang",
"441910", "Tyneside\/Durham\/Sunderland",
"441845", "Thirsk",
"441904", "York",
"441859", "Harris",
"4418472", "Thurso",
"442886", "Cookstown",
"441267", "Carmarthen",
"441977", "Pontefract",
"442879", "Magherafelt",
"441871", "Castlebay",
"441296", "Aylesbury",
"441852", "Kilmelford",
"4413391", "Aboyne\/Ballater",
"441237", "Bideford",
"441880", "Tarbert",
"441883", "Caterham",
"4419752", "Alford\ \(Aberdeen\)",
"441908", "Milton\ Keynes",
"441545", "Llanarth",
"441275", "Clevedon",
"4414234", "Boroughbridge",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"442887", "Dungannon",
"441989", "Ross\-on\-Wye",
"441452", "Gloucester",
"441935", "Yeovil",
"441559", "Llandysul",
"441483", "Guildford",
"441480", "Huntingdon",
"441297", "Axminster",
"441241", "Arbroath",
"441571", "Lochinver",
"441445", "Gairloch",
"441621", "Maldon",
"4419644", "Patrington",
"441583", "Carradale",
"441580", "Cranbrook",
"441982", "Builth\ Wells",
"441301", "Arrochar",
"441953", "Wymondham",
"441236", "Coatbridge",
"441950", "Sandwick",
"441204", "Bolton",
"4418518", "Stornoway",
"441603", "Norwich",
"4417683", "Appleby",
"4414300", "North\ Cave\/Market\ Weighton",
"441600", "Monmouth",
"441491", "Henley\-on\-Thames",
"441320", "Fort\ Augustus",
"441344", "Bracknell",
"442824", "Northern\ Ireland",
"442840", "Banbridge",
"441323", "Eastbourne",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441295", "Banbury",
"441748", "Richmond",
"441937", "Wetherby",
"4414373", "Clynderwen\ \(Clunderwen\)",
"442885", "Ballygawley",
"441967", "Strontian",
"4418900", "Coldstream\/Ayton",
"441277", "Brentwood",
"441547", "Knighton",
"441591", "Llanwrtyd\ Wells",
"441289", "Berwick\-upon\-Tweed",
"441431", "Helmsdale",
"441348", "Fishguard",
"441235", "Abingdon",
"442828", "Larne",
"442892", "Lisburn",
"4418517", "Stornoway",
"441208", "Bodmin",
"441461", "Gretna",
"4412294", "Barrow\-in\-Furness",
"441446", "Barry",
"44291", "Cardiff",
"441282", "Burnley",
"441654", "Machynlleth",
"441250", "Blairgowrie",
"441531", "Ledbury",
"441253", "Blackpool",
"441546", "Lochgilphead",
"441276", "Camberley",
"441723", "Scarborough",
"442899", "Northern\ Ireland",
"441997", "Strathpeffer",
"441744", "St\ Helens",
"441720", "Isles\ of\ Scilly",
"441561", "Laurencekirk",
"441567", "Killin",
"441866", "Kilchrenan",
"441738", "Perth",
"441841", "Newquay\ \(Padstow\)",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"442849", "Northern\ Ireland",
"441947", "Whitby",
"441794", "Romsey",
"441329", "Fareham",
"441768", "Penrith",
"441609", "Northallerton",
"441496", "Port\ Ellen",
"441364", "Ashburton",
"44281", "Northern\ Ireland",
"441875", "Tranent",
"441322", "Dartford",
"442842", "Kircubbin",
"441467", "Inverurie",
"442830", "Newry",
"441334", "St\ Andrews",
"441398", "Dulverton",
"441946", "Whitehaven",
"441896", "Galashiels",
"441271", "Barnstaple",
"44241", "Coventry",
"4419753", "Strathdon",
"441597", "Llandrindod\ Wells",
"441722", "Salisbury",
"441566", "Launceston",
"441764", "Crieff",
"4413395", "Aboyne",
"441475", "Greenock",
"441280", "Buckingham",
"441283", "Burton\-on\-Trent",
"441837", "Okehampton",
"441536", "Kettering",
"441798", "Pulborough",
"441252", "Aldershot",
"441931", "Shap",
"441684", "Malvern",
"441466", "Huntly",
"441729", "Settle",
"441394", "Felixstowe",
"4418473", "Thurso",
"442890", "Belfast",
"441575", "Kirriemuir",
"441245", "Chelmsford",
"442893", "Ballyclare",
"441625", "Macclesfield",
"441497", "Hay\-on\-Wye",
"441436", "Helensburgh",
"441368", "Dunbar",
"441259", "Alloa",
"4415074", "Alford\ \(Lincs\)",
"441305", "Dorchester",
"441307", "Forfar",
"441778", "Bourne",
"441882", "Kinloch\ Rannoch",
"441404", "Honiton",
"441495", "Pontypool",
"4414307", "Market\ Weighton",
"441876", "Lochmaddy",
"441291", "Chepstow",
"441919", "Durham",
"441577", "Kinross",
"441706", "Rochdale",
"4418907", "Ayton",
"441835", "St\ Boswells",
"442881", "Newtownstewart",
"44114708", "Sheffield",
"441889", "Rugeley",
"4413399", "Ballater",
"441477", "Holmes\ Chapel",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441144", "Sheffield",
"441865", "Oxford",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441912", "Tyneside",
"441808", "Tomatin",
"442870", "Coleraine",
"441435", "Heathfield",
"441983", "Isle\ of\ Wight",
"4414308", "Market\ Weighton",
"441582", "Luton",
"441980", "Amesbury",
"441553", "Kings\ Lynn",
"4416864", "Llanidloes",
"441489", "Bishops\ Waltham",
"441550", "Llandovery",
"4418510", "Great\ Bernera\/Stornoway",
"441952", "Telford",
"441306", "Dorking",
"441971", "Scourie",
"441465", "Girvan",
"441576", "Lockerbie",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441877", "Callander",
"441246", "Chesterfield",
"441408", "Golspie",
"441626", "Newton\ Abbot",
"441261", "Banff",
"441453", "Dursley",
"441450", "Hawick",
"4414344", "Bellingham",
"441959", "Westerham",
"441535", "Keighley",
"441707", "Welwyn\ Garden\ City",
"441482", "Kingston\-upon\-Hull",
"4413396", "Ballater",
"4418908", "Coldstream",
"441945", "Wisbech",
"441508", "Brooke",
"441895", "Uxbridge",
"441565", "Knutsford",
"441476", "Grantham",
"441767", "Sandy",
"4415072", "Spilsby\ \(Horncastle\)",
"441864", "Abington\ \(Crawford\)",
"441145", "Sheffield",
"441594", "Lydney",
"441822", "Tavistock",
"441375", "Grays\ Thurrock",
"441796", "Pitlochry",
"441538", "Ipstones",
"441687", "Mallaig",
"441737", "Redhill",
"441505", "Johnstone",
"441948", "Whitchurch",
"441834", "Narberth",
"441568", "Leominster",
"44114703", "Sheffield",
"441494", "High\ Wycombe",
"441366", "Downham\ Market",
"4415395", "Grange\-over\-Sands",
"441438", "Stevenage",
"441829", "Tarporley",
"442821", "Martinstown",
"441397", "Fort\ William",
"441341", "Barmouth",
"4418519", "Great\ Bernera",
"441405", "Goole",
"441522", "Lincoln",
"441797", "Rye",
"441944", "West\ Heslerton",
"441920", "Ware",
"441838", "Dalmally",
"441923", "Watford",
"441564", "Lapworth",
"441429", "Hartlepool",
"441766", "Porthmadog",
"4414233", "Boroughbridge",
"441672", "Marlborough",
"441651", "Oldmeldrum",
"441534", "Jersey",
"441805", "Torrington",
"441598", "Lynton",
"4413390", "Aboyne\/Ballater",
"441736", "Penzance",
"441464", "Insch",
"441775", "Spalding",
"4418516", "Great\ Bernera",
"441529", "Sleaford",
"4419643", "Patrington",
"441422", "Halifax",
"441367", "Faringdon",
"4420", "London",
"441337", "Ladybank",
"441578", "Lauder",
"441335", "Ashbourne",
"441248", "Bangor\ \(Gwynedd\)",
"441389", "Dumbarton",
"441406", "Holbeach",
"441628", "Maidenhead",
"4417684", "Pooley\ Bridge",
"441692", "North\ Walsham",
"44292", "Cardiff",
"4415396", "Sedbergh",
"441874", "Brecon",
"4414342", "Bellingham",
"441308", "Bridport",
"441777", "Retford",
"44114707", "Sheffield",
"441353", "Ely",
"441704", "Southport",
"4413885", "Stanhope\ \(Eastgate\)",
"441350", "Dunkeld",
"441807", "Ballindalloch",
"441506", "Bathgate",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441382", "Dundee",
"4416862", "Llanidloes",
"441146", "Sheffield",
"441376", "Braintree",
"441795", "Sittingbourne",
"441407", "Holyhead",
"441782", "Stoke\-on\-Trent",
"441750", "Selkirk",
"441878", "Lochboisdale",
"441753", "Slough",
"441304", "Dover",
"441395", "Budleigh\ Salterton",
"4418901", "Coldstream\/Ayton",
"4412293", "Millom",
"441776", "Stranraer",
"441223", "Cambridge",
"441244", "Chester",
"441624", "Isle\ of\ Man",
"441643", "Minehead",
"4418515", "Stornoway",
"441789", "Stratford\-upon\-Avon",
"4414301", "North\ Cave\/Market\ Weighton",
"441639", "Neath",
"441806", "Shetland",
"441685", "Merthyr\ Tydfil",
"441377", "Driffield",
"441708", "Romford",
"441669", "Rothbury",
"441765", "Ripon",
"441474", "Gravesend",
"441985", "Warminster",
"441433", "Hathersage",
"442837", "Armagh",
"441939", "Wem",
"441555", "Lanark",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"442896", "Belfast",
"44141", "Glasgow",
"441460", "Chard",
"441549", "Lairg",
"441279", "Bishops\ Stortford",
"441463", "Inverness",
"441442", "Hemel\ Hempstead",
"441969", "Leyburn",
"442867", "Lisnaskea",
"441286", "Caernarfon",
"441455", "Hinckley",
"441530", "Coalville",
"441932", "Weybridge",
"441924", "Wakefield",
"441721", "Peebles",
"441542", "Keith",
"441943", "Guiseley",
"4412299", "Millom",
"441560", "Moscow",
"441962", "Winchester",
"44151", "Liverpool",
"44287", "Northern\ Ireland",
"441563", "Kilmarnock",
"441449", "Stowmarket",
"441855", "Ballachulish",
"4414235", "Harrogate",
"441490", "Corwen",
"442866", "Enniskillen",
"441493", "Great\ Yarmouth",
"44247", "Coventry",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"442841", "Rostrevor",
"442897", "Saintfield",
"441833", "Barnard\ Castle",
"4419645", "Hornsea",
"441830", "Kirkwhelpington",
"441928", "Runcorn",
"4412296", "Barrow\-in\-Furness",
"441287", "Guisborough",
"441863", "Ardgay",
"441992", "Lea\ Valley",
"4418470", "Thurso\/Tongue",
"441590", "Lymington",
"441842", "Thetford",
"441593", "Lybster",
"4419649", "Hornsea",
"442877", "Limavady",
"441358", "Ellon",
"441473", "Ipswich",
"441269", "Ammanford",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"4417687", "Keswick",
"441285", "Cirencester",
"441456", "Glenurquhart",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441239", "Cardigan",
"441481", "Guernsey",
"442895", "Belfast",
"441243", "Chichester",
"441573", "Kelso",
"44286", "Northern\ Ireland",
"441972", "Glenborrodale",
"441224", "Aberdeen",
"441570", "Lampeter",
"4414239", "Boroughbridge",
"4414377", "Haverfordwest",
"441644", "New\ Galloway",
"441620", "North\ Berwick",
"441623", "Mansfield",
"441262", "Bridlington",
"441581", "New\ Luce",
"44283", "Northern\ Ireland",
"441986", "Bungay",
"4416861", "Newtown\/Llanidloes",
"441754", "Skegness",
"441303", "Folkestone",
"441951", "Colonsay",
"441857", "Sanday",
"441300", "Cerne\ Abbas",
"441556", "Castle\ Douglas",
"441911", "Tyneside\/Durham\/Sunderland",
"441299", "Bewdley",
"441700", "Rothesay",
"4419467", "Gosforth",
"4418513", "Stornoway",
"441354", "Chatteris",
"441457", "Glossop",
"4412295", "Barrow\-in\-Furness",
"4418902", "Coldstream",
"442882", "Omagh",
"4419646", "Patrington",
"4414302", "North\ Cave",
"441870", "Isle\ of\ Benbecula",
"441758", "Pwllheli",
"441292", "Ayr",
"441873", "Abergavenny",
"441228", "Carlisle",
"441557", "Kirkcudbright",
"441856", "Orkney",
"4414378", "Haverfordwest",
"4414236", "Harrogate",
"441987", "Ebbsfleet",
"442889", "Fivemiletown",
"441659", "Sanquhar",
"442868", "Kesh",
"442894", "Antrim",
"441749", "Shepton\ Mallet",
"441225", "Bath",
"442838", "Portadown",
"441284", "Bury\ St\ Edmunds",
"441652", "Brigg",
"441683", "Moffat",
"441733", "Peterborough",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441730", "Petersfield",
"4415078", "Alford\ \(Lincs\)",
"441926", "Warwick",
"441763", "Royston",
"441671", "Newton\ Stewart",
"441760", "Swaffham",
"441330", "Banchory",
"441202", "Bournemouth",
"44114700", "Sheffield",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"442898", "Belfast",
"4413393", "Aboyne",
"44280", "Northern\ Ireland",
"4419755", "Alford\ \(Aberdeen\)",
"441360", "Killearn",
"44131", "Edinburgh",
"4414230", "Harrogate\/Boroughbridge",
"441363", "Crediton",
"442822", "Northern\ Ireland",
"441342", "East\ Grinstead",
"441209", "Redruth",
"441355", "East\ Kilbride",
"4418475", "Thurso",
"4419640", "Hornsea\/Patrington",
"441288", "Bude",
"441793", "Swindon",
"441821", "Kinrossie",
"441349", "Dingwall",
"441790", "Spilsby",
"442829", "Kilrea",
"4415077", "Louth",
"441925", "Warrington",
"442310", "Portsmouth",
"4418479", "Tongue",
"4416973", "Wigton",
"4414304", "North\ Cave",
"441454", "Chipping\ Sodbury",
"4416868", "Newtown",
"441357", "Strathaven",
"441803", "Torquay",
"441770", "Isle\ of\ Arran",
"4418904", "Coldstream",
"441661", "Prudhoe",
"441226", "Barnsley",
"441773", "Ripley",
"441858", "Market\ Harborough",
"441646", "Milford\ Haven",
"4419759", "Alford\ \(Aberdeen\)",
"4413873", "Langholm",
"441631", "Oban",
"441984", "Watchet\ \(Williton\)",
"4414348", "Hexham",
"44118", "Reading",
"441756", "Skipton",
"441554", "Llanelli",
"441143", "Sheffield",
"441458", "Glastonbury",
"44239", "Portsmouth",
"441140", "Sheffield",
"4416867", "Llanidloes",
"4412290", "Barrow\-in\-Furness\/Millom",
"441373", "Frome",
"441503", "Looe",
"4418476", "Tongue",
"441902", "Wolverhampton",
"441356", "Brechin",
"441381", "Fortrose",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"44114704", "Sheffield",
"441988", "Wigtown",
"441691", "Oswestry",
"4414347", "Hexham",
"441647", "Moretonhampstead",
"441558", "Llandeilo",
"441227", "Canterbury",
"441909", "Worksop",
"4419756", "Strathdon",
"441854", "Ullapool",
"441757", "Selby",
"441403", "Horsham",
"441400", "Honington",
"441786", "Stirling",
"441636", "Newark\-on\-Trent",
"441584", "Ludlow",
"441954", "Madingley",
"441809", "Tomdoun",
"441751", "Pickering",
"44115", "Nottingham",
"441772", "Preston",
"441666", "Malmesbury",
"4418471", "Thurso\/Tongue",
"4414376", "Haverfordwest",
"4414238", "Harrogate",
"441425", "Ringwood",
"441641", "Strathy",
"441697", "Brampton",
"441888", "Turriff",
"441387", "Dumfries",
"4415394", "Hawkshead",
"441918", "Tyneside",
"441484", "Huddersfield",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441525", "Leighton\ Buzzard",
"441779", "Peterhead",
"441675", "Coleshill",
"4413392", "Aboyne",
"4419648", "Hornsea",
"441509", "Loughborough",
"4414379", "Haverfordwest",
"4414237", "Harrogate",
"441884", "Tiverton",
"441637", "Newquay",
"441787", "Sudbury",
"441588", "Bishops\ Castle",
"441379", "Diss",
"441667", "Nairn",
"441903", "Worthing",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441502", "Lowestoft",
"441900", "Workington",
"441409", "Holsworthy",
"441386", "Evesham",
"4419647", "Patrington",
"441142", "Sheffield",
"441488", "Hungerford",
"441372", "Esher",
"441825", "Uckfield",
"441914", "Tyneside",
"441743", "Shrewsbury",
"441827", "Tamworth",
"441526", "Martin",
"441724", "Scunthorpe",
"441740", "Sedgefield",
"4412298", "Barrow\-in\-Furness",
"441676", "Meriden",
"441653", "Malton",
"441650", "Cemmaes\ Road",
"441254", "Blackburn",
"441732", "Sevenoaks",
"441665", "Alnwick",
"441392", "Exeter",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441769", "South\ Molton",
"441608", "Chipping\ Norton",
"441785", "Stafford",
"44114702", "Sheffield",
"441635", "Newbury",
"441689", "Orpington",
"442848", "Northern\ Ireland",
"441328", "Fakenham",
"441677", "Bedale",
"441369", "Dunoon",
"441527", "Redditch",
"441792", "Swansea",
"441258", "Blandford",
"441728", "Saxmundham",
"4418514", "Great\ Bernera",
"4416860", "Newtown\/Llanidloes",
"4412297", "Millom",
"441362", "Dereham",
"441695", "Skelmersdale",
"441427", "Gainsborough",
"442844", "Downpatrick",
"442820", "Ballycastle",
"441799", "Saffron\ Walden",
"441340", "Craigellachie\ \(Aberlour\)",
"441324", "Falkirk",
"442823", "Northern\ Ireland",
"441343", "Elgin",
"441332", "Derby",
"441200", "Clitheroe",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441604", "Northampton",
"441784", "Staines",
"441634", "Medway",
"441981", "Wormbridge",
"441887", "Aberfeldy",
"441698", "Motherwell",
"441586", "Campbeltown",
"4414349", "Bellingham",
"441233", "Ashford\ \(Kent\)",
"441302", "Doncaster",
"4419758", "Strathdon",
"441664", "Melton\ Mowbray",
"441970", "Aberystwyth",
"441242", "Cheltenham",
"441572", "Oakham",
"441622", "Maidstone",
"441263", "Cromer",
"441479", "Grantown\-on\-Spey",
"44121", "Birmingham",
"441260", "Congleton",
"4419641", "Hornsea\/Patrington",
"441451", "Stow\-on\-the\-Wold",
"4416869", "Newtown",
"441255", "Clacton\-on\-Sea",
"441309", "Forres",
"441917", "Sunderland",
"441579", "Liskeard",
"441249", "Chippenham",
"4418478", "Thurso",
"441725", "Rockbourne",
"4414231", "Harrogate\/Boroughbridge",
"441388", "Bishop\ Auckland",
"441472", "Grimsby",
"441629", "Matlock",
"4419757", "Strathdon",
"4413394", "Ballater",
"441957", "Mid\ Yell",
"44114705", "Sheffield",
"441709", "Rotherham",
"441668", "Bamburgh",
"44114709", "Sheffield",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441694", "Church\ Stretton",
"441788", "Rugby",
"4414346", "Hexham",
"441638", "Newmarket",
"441293", "Crawley",
"442845", "Northern\ Ireland",
"441325", "Darlington",
"441872", "Truro",
"441290", "Cumnock",
"441702", "Southend\-on\-Sea",
"441487", "Warboys",
"4418477", "Tongue",
"4415242", "Hornby",
"442883", "Northern\ Ireland",
"442880", "Carrickmore",
"441384", "Dudley",
"4415075", "Spilsby\ \(Horncastle\)",
"4416866", "Newtown",
"442871", "Londonderry",
"441879", "Scarinish",
"441916", "Tyneside",
"441942", "Wigan",
"441270", "Crewe",
"441540", "Kingussie",
"441524", "Lancaster",
"441726", "St\ Austell",
"441273", "Brighton",
"441469", "Killingholme",
"441892", "Tunbridge\ Wells",
"441543", "Cannock",
"441562", "Kidderminster",
"4416974", "Raughton\ Head",
"441674", "Montrose",
"441963", "Wincanton",
"4415079", "Alford\ \(Lincs\)",
"4414303", "North\ Cave",
"441439", "Helmsley",
"441256", "Basingstoke",
"441828", "Coupar\ Angus",
"441485", "Hunstanton",
"441933", "Wellingborough",
"441899", "Biggar",
"441462", "Hitchin",
"441327", "Daventry",
"442891", "Bangor\ \(Co\.\ Down\)",
"441949", "Whatton",
"4412291", "Barrow\-in\-Furness\/Millom",
"442847", "Northern\ Ireland",
"4418903", "Coldstream",
"441424", "Hastings",
"441440", "Haverhill",
"441443", "Pontypridd",
"4418512", "Stornoway",
"441569", "Stonehaven",
"441432", "Hereford",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441955", "Wick",
"441539", "Kendal",
"4416865", "Newtown",
"441862", "Tain",
"441499", "Inveraray",
"441843", "Thanet",
"441727", "St\ Albans",
"441592", "Kirkcaldy",
"441993", "Witney",
"4415076", "Louth",
"441915", "Sunderland",
"441824", "Ruthin",
"441840", "Camelford",
"4413882", "Stanhope\ \(Eastgate\)",
"441832", "Clopton",
"441528", "Laggan",
"441257", "Coppull",
"441678", "Bala",
"441492", "Colwyn\ Bay",
"441869", "Bicester",
"442846", "Northern\ Ireland",
"4414345", "Haltwhistle",
"441326", "Falmouth",
"441599", "Kyle",
"441885", "Pencombe",
"441428", "Haslemere",
"441606", "Northwich",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-8]\d{5})$|0|180020)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;