/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EpubTypeAttributes;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.MetaUtils;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;

public class OverlayHandler
implements XMLHandler {
    String path;
    XRefChecker xrefChecker;
    Report report;
    HashSet<String> prefixSet;
    XMLParser parser;
    boolean reportedUnsupportedXMLVersion;

    public OverlayHandler(String path, XRefChecker xrefChecker, XMLParser parser, Report report) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.parser = parser;
        this.prefixSet = new HashSet();
        this.reportedUnsupportedXMLVersion = false;
    }

    @Override
    public void startElement() {
        XMLElement e;
        String name;
        if (!this.reportedUnsupportedXMLVersion) {
            this.reportedUnsupportedXMLVersion = HandlerUtil.checkXMLVersion(this.parser);
        }
        if ((name = (e = this.parser.getCurrentElement()).getName()).equals("smil")) {
            HandlerUtil.processPrefixes(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), this.prefixSet, this.report, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber());
        } else if (name.equals("seq")) {
            this.processSeq(e);
        } else if (name.equals("text")) {
            this.processSrc(e);
        } else if (name.equals("audio")) {
            this.processRef(e.getAttribute("src"), 5);
        } else if (name.equals("body") || name.equals("par")) {
            this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
        }
    }

    boolean checkPrefix(String prefix) {
        if (!this.prefixSet.contains(prefix = prefix.trim())) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Undecleared prefix: " + prefix);
            return false;
        }
        return true;
    }

    private void checkType(String type) {
        if (type == null) {
            return;
        }
        MetaUtils.validateProperties(type, EpubTypeAttributes.EpubTypeSet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
    }

    private void processSrc(XMLElement e) {
        this.processRef(e.getAttribute("src"), 1);
    }

    private void processRef(String ref, int type) {
        if (ref != null && this.xrefChecker != null) {
            String mimeType;
            ref = PathUtil.resolveRelativeReference(this.path, ref, null);
            if (type == 5 && (mimeType = this.xrefChecker.getMimeType(ref)) != null && !OPFChecker30.isBlessedAudioType(mimeType)) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Media Overlay audio refernence " + ref + " to non-standard audio type " + mimeType);
            }
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ref, type);
        }
    }

    private void processSeq(XMLElement e) {
        this.processRef(e.getAttributeNS("http://www.idpf.org/2007/ops", "textref"), 1);
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

