/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.jetbrains.annotations.NotNull;

public class RegExpInspectionConfigurationCellRenderer
extends ColoredListCellRenderer<RegExpInspectionConfiguration.InspectionPattern> {
    protected void customizeCellRenderer(@NotNull JList<? extends RegExpInspectionConfiguration.InspectionPattern> list, RegExpInspectionConfiguration.InspectionPattern value, int index, boolean selected, boolean hasFocus) {
        FileType fileType;
        if (list == null) {
            RegExpInspectionConfigurationCellRenderer.$$$reportNull$$$0(0);
        }
        this.setIcon((fileType = value.fileType()) == null ? AllIcons.FileTypes.Any_type : fileType.getIcon());
        String regExp = value.regExp();
        String replacement = value.replacement();
        this.append("/", SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (replacement != null) {
            this.append(StringUtil.shortenTextWithEllipsis((String)regExp, (int)49, (int)0, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append("/ \u21e8 '", SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.append(StringUtil.shortenTextWithEllipsis((String)replacement, (int)49, (int)0, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append("'", SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            this.append(StringUtil.shortenTextWithEllipsis((String)regExp, (int)100, (int)0, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append("/", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (value.flags != 0) {
            boolean hasFlags = false;
            for (RegExpInspectionConfiguration.RegExpFlag flag : RegExpInspectionConfiguration.RegExpFlag.values()) {
                if (flag.mnemonic == null || (value.flags & flag.id) == 0) continue;
                hasFlags = true;
                this.append(flag.mnemonic.toString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            if ((value.flags & RegExpInspectionConfiguration.RegExpFlag.LITERAL.id) != 0) {
                this.append((hasFlags ? ", " : "") + "literal", SimpleTextAttributes.GRAY_ATTRIBUTES);
                hasFlags = true;
            }
            if ((value.flags & RegExpInspectionConfiguration.RegExpFlag.CANONICAL_EQUIVALENCE.id) != 0) {
                this.append((hasFlags ? ", " : "") + " canon_eq", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        this.setEnabled(list.isEnabled());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/lang/regexp/inspection/custom/RegExpInspectionConfigurationCellRenderer", "customizeCellRenderer"));
    }
}

