/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeProcessInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeProcessInfo> {
    private final long id;
    private final boolean mlockall;
    @Nullable
    private final Time refreshInterval;
    private final long refreshIntervalInMillis;
    public static final JsonpDeserializer<NodeProcessInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeProcessInfo::setupNodeProcessInfoDeserializer);

    private NodeProcessInfo(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.mlockall = ApiTypeHelper.requireNonNull(builder.mlockall, this, "mlockall");
        this.refreshInterval = builder.refreshInterval;
        this.refreshIntervalInMillis = ApiTypeHelper.requireNonNull(builder.refreshIntervalInMillis, this, "refreshIntervalInMillis");
    }

    public static NodeProcessInfo of(Function<Builder, ObjectBuilder<NodeProcessInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long id() {
        return this.id;
    }

    public final boolean mlockall() {
        return this.mlockall;
    }

    @Nullable
    public final Time refreshInterval() {
        return this.refreshInterval;
    }

    public final long refreshIntervalInMillis() {
        return this.refreshIntervalInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("mlockall");
        generator.write(this.mlockall);
        if (this.refreshInterval != null) {
            generator.writeKey("refresh_interval");
            this.refreshInterval.serialize(generator, mapper);
        }
        generator.writeKey("refresh_interval_in_millis");
        generator.write(this.refreshIntervalInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeProcessInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::mlockall, JsonpDeserializer.booleanDeserializer(), "mlockall");
        op.add(Builder::refreshInterval, Time._DESERIALIZER, "refresh_interval");
        op.add(Builder::refreshIntervalInMillis, JsonpDeserializer.longDeserializer(), "refresh_interval_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.id);
        result = 31 * result + Boolean.hashCode(this.mlockall);
        result = 31 * result + Objects.hashCode(this.refreshInterval);
        result = 31 * result + Long.hashCode(this.refreshIntervalInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeProcessInfo other = (NodeProcessInfo)o;
        return this.id == other.id && this.mlockall == other.mlockall && Objects.equals(this.refreshInterval, other.refreshInterval) && this.refreshIntervalInMillis == other.refreshIntervalInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeProcessInfo> {
        private Long id;
        private Boolean mlockall;
        @Nullable
        private Time refreshInterval;
        private Long refreshIntervalInMillis;

        public Builder() {
        }

        private Builder(NodeProcessInfo o) {
            this.id = o.id;
            this.mlockall = o.mlockall;
            this.refreshInterval = o.refreshInterval;
            this.refreshIntervalInMillis = o.refreshIntervalInMillis;
        }

        private Builder(Builder o) {
            this.id = o.id;
            this.mlockall = o.mlockall;
            this.refreshInterval = o.refreshInterval;
            this.refreshIntervalInMillis = o.refreshIntervalInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder mlockall(boolean value) {
            this.mlockall = value;
            return this;
        }

        @Nonnull
        public final Builder refreshInterval(@Nullable Time value) {
            this.refreshInterval = value;
            return this;
        }

        @Nonnull
        public final Builder refreshInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.refreshInterval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder refreshIntervalInMillis(long value) {
            this.refreshIntervalInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeProcessInfo build() {
            this._checkSingleUse();
            return new NodeProcessInfo(this);
        }
    }
}

