/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.NeuralStatsInput;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.info.InfoStatName;
import org.opensearch.neuralsearch.stats.metrics.MetricStatName;
import org.opensearch.neuralsearch.transport.NeuralStatsAction;
import org.opensearch.neuralsearch.transport.NeuralStatsRequest;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.transport.client.node.NodeClient;

public class RestNeuralStatsAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestNeuralStatsAction.class);
    public static final String STAT_PARAM = "stat";
    public static final String NODE_ID_PARAM = "nodeId";
    public static final String FLATTEN_PARAM = "flat_stat_paths";
    public static final String INCLUDE_METADATA_PARAM = "include_metadata";
    public static final String INCLUDE_INDIVIDUAL_NODES_PARAM = "include_individual_nodes";
    public static final String INCLUDE_ALL_NODES_PARAM = "include_all_nodes";
    public static final String INCLUDE_INFO_PARAM = "include_info";
    public static final String INCLUDE_METRIC_PARAM = "include_metric";
    public static final String PARAM_REGEX = "^[A-Za-z0-9-_]+$";
    public static final int MAX_PARAM_LENGTH = 255;
    private static final String NAME = "neural_stats_action";
    private static final Set<String> EVENT_STAT_NAMES = EnumSet.allOf(EventStatName.class).stream().map(EventStatName::getNameString).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final Set<String> INFO_STAT_NAMES = EnumSet.allOf(InfoStatName.class).stream().map(InfoStatName::getNameString).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final Set<String> METRIC_STAT_NAMES = EnumSet.allOf(MetricStatName.class).stream().map(MetricStatName::getNameString).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final List<RestHandler.Route> ROUTES = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_neural/{nodeId}/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_neural/{nodeId}/stats/{stat}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_neural/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_neural/stats/{stat}"));
    private static final Set<String> RESPONSE_PARAMS = ImmutableSet.of((Object)"nodeId", (Object)"stat", (Object)"include_metadata", (Object)"flat_stat_paths", (Object)"include_individual_nodes", (Object)"include_all_nodes", (Object[])new String[]{"include_info"});
    private NeuralSearchSettingsAccessor settingsAccessor;
    private NeuralSearchClusterUtil clusterUtil;

    public static boolean isValidParamString(String param) {
        return param.matches(PARAM_REGEX) && param.length() < 255;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!this.settingsAccessor.isStatsEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Stats endpoint is disabled"));
        }
        NeuralStatsRequest neuralStatsRequest = this.createNeuralStatsRequest(request);
        return channel -> client.execute((ActionType)NeuralStatsAction.INSTANCE, (ActionRequest)neuralStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private NeuralStatsRequest createNeuralStatsRequest(RestRequest request) {
        NeuralStatsInput neuralStatsInput = this.createNeuralStatsInputFromRequestParams(request);
        String[] nodeIdsArr = neuralStatsInput.getNodeIds().toArray(new String[0]);
        NeuralStatsRequest neuralStatsRequest = new NeuralStatsRequest(nodeIdsArr, neuralStatsInput);
        neuralStatsRequest.timeout(request.param("timeout"));
        return neuralStatsRequest;
    }

    private NeuralStatsInput createNeuralStatsInputFromRequestParams(RestRequest request) {
        NeuralStatsInput neuralStatsInput = new NeuralStatsInput();
        Optional<String[]> nodeIds = this.splitCommaSeparatedParam(request, NODE_ID_PARAM);
        if (nodeIds.isPresent()) {
            List<String> validFormatNodeIds = Arrays.stream(nodeIds.get()).filter(this::isValidNodeId).toList();
            neuralStatsInput.getNodeIds().addAll(validFormatNodeIds);
        }
        boolean flatten = request.paramAsBoolean(FLATTEN_PARAM, false);
        neuralStatsInput.setFlatten(flatten);
        boolean includeMetadata = request.paramAsBoolean(INCLUDE_METADATA_PARAM, false);
        neuralStatsInput.setIncludeMetadata(includeMetadata);
        boolean includeIndividualNodes = request.paramAsBoolean(INCLUDE_INDIVIDUAL_NODES_PARAM, true);
        neuralStatsInput.setIncludeIndividualNodes(includeIndividualNodes);
        boolean includeAllNodes = request.paramAsBoolean(INCLUDE_ALL_NODES_PARAM, true);
        neuralStatsInput.setIncludeAllNodes(includeAllNodes);
        boolean includeInfo = request.paramAsBoolean(INCLUDE_INFO_PARAM, true);
        neuralStatsInput.setIncludeInfo(includeInfo);
        boolean includeMetrics = request.paramAsBoolean(INCLUDE_METRIC_PARAM, true);
        neuralStatsInput.setIncludeMetrics(includeMetrics);
        this.processStatsRequestParameters(request, neuralStatsInput);
        return neuralStatsInput;
    }

    private void processStatsRequestParameters(RestRequest request, NeuralStatsInput neuralStatsInput) {
        Optional<String[]> optionalStats = this.splitCommaSeparatedParam(request, STAT_PARAM);
        Version minClusterVersion = this.clusterUtil.getClusterMinVersion();
        if (!optionalStats.isPresent() || optionalStats.get().length == 0) {
            this.addAllStats(neuralStatsInput, minClusterVersion);
            return;
        }
        String[] stats = optionalStats.get();
        HashSet<String> invalidStatNames = new HashSet<String>();
        boolean includeEvents = neuralStatsInput.isIncludeEvents();
        boolean includeInfo = neuralStatsInput.isIncludeInfo();
        boolean includeMetrics = neuralStatsInput.isIncludeMetrics();
        for (String stat : stats) {
            MetricStatName metricStatName;
            String normalizedStat = stat.toLowerCase(Locale.ROOT);
            if (!RestNeuralStatsAction.isValidParamString(normalizedStat) || !this.isValidStatName(normalizedStat)) {
                invalidStatNames.add(normalizedStat);
                continue;
            }
            if (includeInfo && InfoStatName.isValidName(normalizedStat)) {
                InfoStatName infoStatName = InfoStatName.from(normalizedStat);
                if (!infoStatName.version().onOrBefore(minClusterVersion)) continue;
                neuralStatsInput.getInfoStatNames().add(InfoStatName.from(normalizedStat));
                continue;
            }
            if (includeEvents && EventStatName.isValidName(normalizedStat)) {
                EventStatName eventStatName = EventStatName.from(normalizedStat);
                if (!eventStatName.version().onOrBefore(minClusterVersion)) continue;
                neuralStatsInput.getEventStatNames().add(EventStatName.from(normalizedStat));
                continue;
            }
            if (!includeMetrics || !MetricStatName.isValidName(normalizedStat) || !(metricStatName = MetricStatName.from(normalizedStat)).version().onOrBefore(minClusterVersion)) continue;
            neuralStatsInput.getMetricStatNames().add(MetricStatName.from(normalizedStat));
        }
        if (!invalidStatNames.isEmpty()) {
            throw new IllegalArgumentException(this.unrecognized(request, invalidStatNames, Sets.union(EVENT_STAT_NAMES, INFO_STAT_NAMES), STAT_PARAM));
        }
    }

    private void addAllStats(NeuralStatsInput neuralStatsInput, Version minVersion) {
        if (minVersion == Version.CURRENT) {
            if (neuralStatsInput.isIncludeInfo()) {
                neuralStatsInput.getInfoStatNames().addAll(EnumSet.allOf(InfoStatName.class));
            }
            if (neuralStatsInput.isIncludeEvents()) {
                neuralStatsInput.getEventStatNames().addAll(EnumSet.allOf(EventStatName.class));
            }
            if (neuralStatsInput.isIncludeMetrics()) {
                neuralStatsInput.getMetricStatNames().addAll(EnumSet.allOf(MetricStatName.class));
            }
        } else {
            if (neuralStatsInput.isIncludeInfo()) {
                neuralStatsInput.getInfoStatNames().addAll(EnumSet.allOf(InfoStatName.class).stream().filter(statName -> statName.version().onOrBefore(minVersion)).collect(Collectors.toCollection(() -> EnumSet.noneOf(InfoStatName.class))));
            }
            if (neuralStatsInput.isIncludeEvents()) {
                neuralStatsInput.getEventStatNames().addAll(EnumSet.allOf(EventStatName.class).stream().filter(statName -> statName.version().onOrBefore(minVersion)).collect(Collectors.toCollection(() -> EnumSet.noneOf(EventStatName.class))));
            }
            if (neuralStatsInput.isIncludeMetrics()) {
                neuralStatsInput.getMetricStatNames().addAll(EnumSet.allOf(MetricStatName.class).stream().filter(statName -> statName.version().onOrBefore(minVersion)).collect(Collectors.toCollection(() -> EnumSet.noneOf(MetricStatName.class))));
            }
        }
    }

    private Optional<String[]> splitCommaSeparatedParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName)).map(s -> s.split(","));
    }

    private boolean isValidNodeId(String nodeId) {
        return RestNeuralStatsAction.isValidParamString(nodeId) && nodeId.length() == 22;
    }

    private boolean isValidStatName(String statName) {
        return InfoStatName.isValidName(statName) || EventStatName.isValidName(statName) || MetricStatName.isValidName(statName);
    }

    @Generated
    public RestNeuralStatsAction(NeuralSearchSettingsAccessor settingsAccessor, NeuralSearchClusterUtil clusterUtil) {
        this.settingsAccessor = settingsAccessor;
        this.clusterUtil = clusterUtil;
    }
}

