/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.TaskExecutor;
import org.opensearch.knn.index.codec.KNN9120Codec.KNN9120BinaryVectorScorer;
import org.opensearch.knn.index.engine.KNNEngine;

public final class KNN9120HnswBinaryVectorsFormat
extends KnnVectorsFormat {
    private final int maxConn;
    private final int beamWidth;
    private static final FlatVectorsFormat flatVectorsFormat = new Lucene99FlatVectorsFormat((FlatVectorsScorer)new KNN9120BinaryVectorScorer());
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;
    private static final String NAME = "KNN990HnswBinaryVectorsFormat";

    public KNN9120HnswBinaryVectorsFormat() {
        this(16, 100, 1, null);
    }

    public KNN9120HnswBinaryVectorsFormat(int maxConn, int beamWidth) {
        this(maxConn, beamWidth, 1, null);
    }

    public KNN9120HnswBinaryVectorsFormat(int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec) {
        super(NAME);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor((Executor)mergeExec) : null;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, flatVectorsFormat.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return KNNEngine.getMaxDimensionByEngine(KNNEngine.LUCENE);
    }

    public String toString() {
        return "KNN990HnswBinaryVectorsFormat(name=KNN990HnswBinaryVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + String.valueOf(flatVectorsFormat) + ")";
    }
}

