/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.cpc;

import com.yahoo.sketches.cpc.IconPolynomialCoefficients;

final class IconEstimator {
    IconEstimator() {
    }

    static double evaluatePolynomial(double[] coefficients, int start, int num, double x) {
        int end = start + num - 1;
        double total = coefficients[end];
        for (int j = end - 1; j >= start; --j) {
            total *= x;
            total += coefficients[j];
        }
        return total;
    }

    static double iconExponentialApproximation(double k, double c) {
        return 0.7940236163830469 * k * Math.pow(2.0, c / k);
    }

    static double getIconEstimate(int lgK, long c) {
        double ratio;
        double term;
        double thresholdFactor;
        assert (lgK >= 4);
        assert (lgK <= 26);
        if (c < 2L) {
            return c == 0L ? 0.0 : 1.0;
        }
        int k = 1 << lgK;
        double doubleK = k;
        double doubleC = c;
        double d = thresholdFactor = lgK < 14 ? 5.7 : 5.6;
        if (doubleC > thresholdFactor * doubleK) {
            return IconEstimator.iconExponentialApproximation(doubleK, doubleC);
        }
        double factor = IconEstimator.evaluatePolynomial(IconPolynomialCoefficients.iconPolynomialCoefficents, 20 * (lgK - 4), 20, doubleC / (2.0 * doubleK));
        double result = doubleC * factor * (term = 1.0 + (ratio = doubleC / doubleK) * ratio * ratio / 66.774757);
        return result >= doubleC ? result : doubleC;
    }
}

