/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import java.util.List;
import java.util.Map;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpChunk;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.channels.TraceableRestChannel;
import org.reactivestreams.Subscriber;

class TraceableStreamingRestChannel
extends TraceableRestChannel<StreamingRestChannel>
implements StreamingRestChannel {
    TraceableStreamingRestChannel(StreamingRestChannel delegate, Span span, Tracer tracer) {
        super(delegate, span, tracer);
    }

    @Override
    public void sendChunk(HttpChunk chunk) {
        try (SpanScope ignored = this.tracer.withSpanInScope(this.span);){
            ((StreamingRestChannel)this.delegate).sendChunk(chunk);
        }
        if (chunk.isLast()) {
            this.span.endSpan();
        }
    }

    @Override
    public void prepareResponse(RestStatus status, Map<String, List<String>> headers) {
        try (SpanScope ignored = this.tracer.withSpanInScope(this.span);){
            ((StreamingRestChannel)this.delegate).prepareResponse(status, headers);
        }
    }

    @Override
    public boolean isReadable() {
        return ((StreamingRestChannel)this.delegate).isReadable();
    }

    @Override
    public boolean isWritable() {
        return ((StreamingRestChannel)this.delegate).isWritable();
    }

    public void subscribe(Subscriber<? super HttpChunk> s) {
        ((StreamingRestChannel)this.delegate).subscribe(s);
    }
}

