/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.util.Arrays;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonBinaryImpl
implements OracleJsonBinary {
    protected static final char[] HEX_UPPER = "0123456789ABCDEF".toCharArray();
    protected static final char[] HEX_LOWER = "0123456789abcdef".toCharArray();
    private byte[] bytes;
    boolean isId;

    public OracleJsonBinaryImpl(byte[] bytes, boolean isId) {
        this.bytes = bytes;
        this.isId = isId;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.BINARY;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OracleJsonBinary)) {
            return false;
        }
        OracleJsonBinary b = (OracleJsonBinary)other;
        byte[] bytes1 = this.getBytes();
        byte[] bytes2 = b.getBytes();
        return Arrays.equals(bytes1, bytes2);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getString() {
        return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
    }

    public static String getString(byte[] bytes, boolean isId) {
        return new String(OracleJsonBinaryImpl.serializeBinary(bytes, isId ? HEX_LOWER : HEX_UPPER));
    }

    @Override
    public RAW getRAW() {
        return new RAW(this.getBytes());
    }

    private static char[] serializeBinary(byte[] bytes, char[] hex) {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            byte b = bytes[i++];
            chars[j++] = hex[b >> 4 & 0xF];
            chars[j++] = hex[b & 0xF];
        }
        return chars;
    }

    @Override
    public <T> T wrap(Class<T> c) {
        if (Jsonp.isJakartaJson(c)) {
            return c.cast(new JakartaPrimitive.JakartaBinaryImpl(this.bytes, this.isId));
        }
        return c.cast(new JsonpPrimitive.JsonpBinaryImpl(this.bytes, this.isId));
    }
}

