/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.type.descriptor.java.CoercionException;

public class CoercionHelper {
    private CoercionHelper() {
    }

    public static Byte toByte(Short value) {
        if (value > 127) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Short value `%s` to Byte : overflow", value));
        }
        if (value < -128) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Short value `%s` to Byte : underflow", value));
        }
        return value.byteValue();
    }

    public static Byte toByte(Integer value) {
        if (value > 127) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Integer value `%s` to Byte : overflow", value));
        }
        if (value < -128) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Integer value `%s` to Byte : underflow", value));
        }
        return value.byteValue();
    }

    public static Byte toByte(Long value) {
        if (value > 127L) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Long value `%s` to Byte : overflow", value));
        }
        if (value < -128L) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Long value `%s` to Byte : underflow", value));
        }
        return value.byteValue();
    }

    public static Byte toByte(Double value) {
        if (!CoercionHelper.isWholeNumber(value)) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Double value `%s` to Byte : not a whole number", value));
        }
        if (value > 127.0) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Double value `%s` to Byte : overflow", value));
        }
        if (value < -128.0) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Double value `%s` to Byte : underflow", value));
        }
        return value.byteValue();
    }

    public static Byte toByte(Float value) {
        if (!CoercionHelper.isWholeNumber(value.floatValue())) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Float value `%s` to Byte : not a whole number", value));
        }
        if (value.floatValue() > 127.0f) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Float value `%s` to Byte : overflow", value));
        }
        if (value.floatValue() < -128.0f) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Float value `%s` to Byte : underflow", value));
        }
        return value.byteValue();
    }

    public static Byte toByte(BigInteger value) {
        return CoercionHelper.coerceWrappingError(value::byteValueExact);
    }

    public static Byte toByte(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::byteValueExact);
    }

    public static Short toShort(Byte value) {
        return value.shortValue();
    }

    public static Short toShort(Integer value) {
        if (value > Short.MAX_VALUE) {
            throw new CoercionException("Cannot coerce Integer value `" + value + "` as Short : overflow");
        }
        if (value < Short.MIN_VALUE) {
            throw new CoercionException("Cannot coerce Integer value `" + value + "` as Short : underflow");
        }
        return value.shortValue();
    }

    public static Short toShort(Long value) {
        if (value > 32767L) {
            throw new CoercionException("Cannot coerce Long value `" + value + "` as Short : overflow");
        }
        if (value < -32768L) {
            throw new CoercionException("Cannot coerce Long value `" + value + "` as Short : underflow");
        }
        return value.shortValue();
    }

    public static Short toShort(Double doubleValue) {
        if (!CoercionHelper.isWholeNumber(doubleValue)) {
            throw new CoercionException("Cannot coerce Double value `" + doubleValue + "` as Short : not a whole number");
        }
        return CoercionHelper.toShort(doubleValue.longValue());
    }

    public static Short toShort(Float floatValue) {
        if (!CoercionHelper.isWholeNumber(floatValue.floatValue())) {
            throw new CoercionException("Cannot coerce Float value `" + floatValue + "` as Short : not a whole number");
        }
        return CoercionHelper.toShort(floatValue.longValue());
    }

    public static Short toShort(BigInteger value) {
        return CoercionHelper.coerceWrappingError(value::shortValueExact);
    }

    public static Short toShort(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::shortValueExact);
    }

    public static Integer toInteger(Byte value) {
        return value.intValue();
    }

    public static Integer toInteger(Short value) {
        return value.intValue();
    }

    public static Integer toInteger(Long value) {
        return CoercionHelper.coerceWrappingError(() -> Math.toIntExact(value));
    }

    public static Integer toInteger(Double doubleValue) {
        if (!CoercionHelper.isWholeNumber(doubleValue)) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Double value `%s` to Integer: not a whole number", doubleValue));
        }
        return CoercionHelper.toInteger(doubleValue.longValue());
    }

    public static Integer toInteger(Float floatValue) {
        if (!CoercionHelper.isWholeNumber(floatValue.floatValue())) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Float value `%s` to Integer: not a whole number", floatValue));
        }
        return CoercionHelper.toInteger(floatValue.longValue());
    }

    public static Integer toInteger(BigInteger value) {
        return CoercionHelper.coerceWrappingError(value::intValueExact);
    }

    public static Integer toInteger(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::intValueExact);
    }

    public static Long toLong(Byte value) {
        return value.longValue();
    }

    public static Long toLong(Short value) {
        return value.longValue();
    }

    public static Long toLong(Integer value) {
        return value.longValue();
    }

    public static Long toLong(Double doubleValue) {
        if (!CoercionHelper.isWholeNumber(doubleValue)) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Double value `%s` as Integer: not a whole number", doubleValue));
        }
        return doubleValue.longValue();
    }

    public static Long toLong(Float floatValue) {
        if (!CoercionHelper.isWholeNumber(floatValue.floatValue())) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Float value `%s` as Integer: not a whole number", floatValue));
        }
        return floatValue.longValue();
    }

    public static Long toLong(BigInteger value) {
        return CoercionHelper.coerceWrappingError(value::longValueExact);
    }

    public static Long toLong(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::longValueExact);
    }

    public static BigInteger toBigInteger(Double doubleValue) {
        if (!CoercionHelper.isWholeNumber(doubleValue)) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Double value `%s` as BigInteger: not a whole number", doubleValue));
        }
        return BigInteger.valueOf(doubleValue.longValue());
    }

    public static BigInteger toBigInteger(Float floatValue) {
        if (!CoercionHelper.isWholeNumber(floatValue.floatValue())) {
            throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce Double Float `%s` as BigInteger: not a whole number", floatValue));
        }
        return BigInteger.valueOf(floatValue.longValue());
    }

    public static BigInteger toBigInteger(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::toBigIntegerExact);
    }

    public static Double toDouble(Float floatValue) {
        if (floatValue.floatValue() > Float.POSITIVE_INFINITY) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Float value `%s` to Double : overflow", floatValue));
        }
        if (floatValue.floatValue() < 0.0f) {
            throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce Float value `%s` to Double : underflow", floatValue));
        }
        return floatValue.floatValue();
    }

    public static Double toDouble(BigInteger value) {
        return CoercionHelper.coerceWrappingError(value::doubleValue);
    }

    public static Double toDouble(BigDecimal value) {
        return CoercionHelper.coerceWrappingError(value::doubleValue);
    }

    public static boolean isWholeNumber(double doubleValue) {
        return doubleValue % 1.0 == 0.0;
    }

    public static boolean isWholeNumber(float floatValue) {
        return floatValue == (float)((long)floatValue);
    }

    public static <T> T coerceWrappingError(Coercer<T> coercer) {
        try {
            return coercer.doCoercion();
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new CoercionException("Error coercing value", e);
        }
    }

    @FunctionalInterface
    public static interface Coercer<T> {
        public T doCoercion();
    }
}

