/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.math.BigInteger;
import org.jruby.api.Convert;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Fixnum
extends ImmutableLiteral {
    public final long value;

    public Fixnum(long val) {
        this.value = val;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FIXNUM;
    }

    public Fixnum(BigInteger val) {
        this(val.longValue());
    }

    public Object createCacheObject(ThreadContext context) {
        return Convert.asFixnum(context, this.value);
    }

    public int hashCode() {
        return 329 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object other) {
        return other instanceof Fixnum && this.value == ((Fixnum)other).value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Fixnum(this);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.value);
    }

    public static Fixnum decode(IRReaderDecoder d) {
        return d.getCurrentScope().getManager().newFixnum(d.decodeLong());
    }

    public String toString() {
        return "Fixnum:" + this.value;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

